/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.generators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.tip.puck.generators.PGraphLink;
import org.tip.puck.generators.PGraphNode;
import org.tip.puck.generators.SiblingMarriageDistribution;
import org.tip.puck.net.Family;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Net;
import org.tip.puck.statistics.StatisticsWorker;
import org.tip.puck.util.RandomGenerator;

public class PGraph1 {
    private Map<String, PGraphNode> marriages;
    private Map<Individual, Set<PGraphNode>> marriagesByIndividual;
    private Vector<PGraphLink> linksVector;
    private int totalLinks;
    private SiblingMarriageDistribution smDistrib;

    private int getProbableNumberOfSpouses(Gender gender, int k) {
        return this.smDistrib.howManySpouses(gender, k);
    }

    public Net toNet() {
        Individual wife;
        Individual husband;
        HashMap<PGraphNode, Family> index = new HashMap<PGraphNode, Family>();
        Net result = new Net();
        for (Individual individual : this.marriagesByIndividual.keySet()) {
            result.individuals().add(individual.clone());
        }
        int id = 1;
        for (PGraphNode marriage : this.marriages.values()) {
            husband = null;
            if (marriage.getHusband() != null) {
                husband = result.get(marriage.getHusband().getId());
            }
            wife = null;
            if (marriage.getWife() != null) {
                wife = result.get(marriage.getWife().getId());
            }
            Family family = new Family(id, husband, wife);
            if (husband != null) {
                husband.addPersonalFamily(family);
            }
            if (wife != null) {
                wife.addPersonalFamily(family);
            }
            if (husband != null && wife != null) {
                family.setMarried(true);
            }
            result.families().add(family);
            index.put(marriage, family);
            ++id;
        }
        for (PGraphNode marriage : this.marriages.values()) {
            husband = null;
            if (marriage.getHusband() != null) {
                husband = result.get(marriage.getHusband().getId());
            }
            wife = null;
            if (marriage.getWife() != null) {
                wife = result.get(marriage.getWife().getId());
            }
            Family husbandsFamily = (Family)index.get(marriage.getHusbandLink());
            Family wifesFamily = (Family)index.get(marriage.getWifeLink());
            if (husband != null && husbandsFamily != null) {
                husband.setOriginFamily(husbandsFamily);
                husbandsFamily.getChildren().add(husband);
            }
            if (wife == null || wifesFamily == null) continue;
            wife.setOriginFamily(wifesFamily);
            wifesFamily.getChildren().add(wife);
        }
        for (Individual individual : result.individuals()) {
            int additionalSpouses = this.getProbableNumberOfSpouses(individual.getGender(), PGraph1.monogamousSameSexSiblings(individual).size());
            while (additionalSpouses > 1 && additionalSpouses > PGraph1.monogamousSameSexSiblings(individual).size()) {
                Individual sibling = PGraph1.randomDraw(PGraph1.monogamousSameSexSiblings(individual));
                Family additionalFamily = (Family)sibling.getPersonalFamilies().toList().get(0);
                if (individual.isMale()) {
                    additionalFamily.setHusband(individual);
                } else if (individual.isFemale()) {
                    additionalFamily.setWife(individual);
                }
                individual.addPersonalFamily(additionalFamily);
                result.individuals().removeById(sibling.getId());
            }
        }
        return result;
    }

    private static Individual randomDraw(Individuals individuals) {
        int randomIndex = (int)(Math.random() * (double)individuals.size());
        return (Individual)individuals.toList().get(randomIndex);
    }

    public static Individuals monogamousSameSexSiblings(Individual individual) {
        Individuals result = new Individuals();
        Family family = individual.getOriginFamily();
        if (family != null) {
            for (Individual sibling : family.getChildren()) {
                if (sibling == individual || sibling.getGender() != individual.getGender() || sibling.spouses().size() != 1) continue;
                result.add(sibling);
            }
        }
        return result;
    }

    public PGraph1(Net net) {
        Individual p2;
        Individual p1;
        Individual husband;
        Individual wife;
        this.smDistrib = new SiblingMarriageDistribution(net);
        this.totalLinks = 0;
        this.marriages = new HashMap<String, PGraphNode>();
        this.marriagesByIndividual = new HashMap<Individual, Set<PGraphNode>>();
        for (Family family : net.families()) {
            PGraphNode newMarriage;
            String key;
            wife = null;
            husband = null;
            p1 = family.getHusband();
            p2 = family.getWife();
            if (p1 != null) {
                if (p1.getGender().isFemale()) {
                    wife = p1;
                } else if (p1.getGender().isMale()) {
                    husband = p1;
                }
            }
            if (p2 != null) {
                if (p2.getGender().isFemale()) {
                    wife = p2;
                } else if (p2.getGender().isMale()) {
                    husband = p2;
                }
            }
            if (this.marriages.containsKey(key = (newMarriage = new PGraphNode(wife, husband)).hashKey())) continue;
            this.marriages.put(key, newMarriage);
            if (wife != null) {
                if (!this.marriagesByIndividual.containsKey(wife)) {
                    this.marriagesByIndividual.put(wife, new HashSet());
                }
                this.marriagesByIndividual.get(wife).add(newMarriage);
            }
            if (husband == null) continue;
            if (!this.marriagesByIndividual.containsKey(husband)) {
                this.marriagesByIndividual.put(husband, new HashSet());
            }
            this.marriagesByIndividual.get(husband).add(newMarriage);
        }
        System.out.println(String.valueOf(this.marriages.size()) + " " + StatisticsWorker.numberOfMarriages(net.families()));
        for (Family family : net.families()) {
            wife = null;
            husband = null;
            p1 = family.getHusband();
            p2 = family.getWife();
            if (p1 != null) {
                if (p1.isFemale()) {
                    wife = p1;
                    ++this.totalLinks;
                } else if (p1.isMale()) {
                    husband = p1;
                    ++this.totalLinks;
                }
            }
            if (p2 != null) {
                if (p2.isFemale()) {
                    wife = p2;
                    ++this.totalLinks;
                } else if (p2.isMale()) {
                    husband = p2;
                    ++this.totalLinks;
                }
            }
            PGraphNode parents = this.marriages.get(new PGraphNode(wife, husband).hashKey());
            for (Individual child : family.getChildren()) {
                Set<PGraphNode> childMarriages = this.marriagesByIndividual.get(child);
                if (childMarriages == null) continue;
                for (PGraphNode m : childMarriages) {
                    if (child.isFemale()) {
                        m.setWifeLink(parents);
                        continue;
                    }
                    if (!child.isMale()) continue;
                    m.setHusbandLink(parents);
                }
            }
        }
        this.linksVector = new Vector();
        for (Map.Entry entry : this.marriages.entrySet()) {
            PGraphLink link;
            PGraphNode marriage = (PGraphNode)entry.getValue();
            PGraphNode wifeLink = marriage.getWifeLink();
            PGraphNode husbandLink = marriage.getHusbandLink();
            if (wifeLink != null) {
                link = new PGraphLink(wifeLink, marriage, true);
                this.linksVector.add(link);
            }
            if (husbandLink == null) continue;
            link = new PGraphLink(husbandLink, marriage, false);
            this.linksVector.add(link);
        }
        this.computeOutDegrees();
        this.computeAncestors();
    }

    public PGraph1(PGraph1 pg) {
        this.smDistrib = pg.smDistrib;
        this.totalLinks = pg.totalLinks;
        this.marriages = new HashMap<String, PGraphNode>();
        this.marriagesByIndividual = new HashMap<Individual, Set<PGraphNode>>();
        for (Map.Entry<String, PGraphNode> entry : pg.marriages.entrySet()) {
            String key = entry.getKey();
            PGraphNode marriage = new PGraphNode(entry.getValue());
            this.marriages.put(key, marriage);
            Individual wife = marriage.getWife();
            Individual husband = marriage.getHusband();
            if (wife != null) {
                if (!this.marriagesByIndividual.containsKey(wife)) {
                    this.marriagesByIndividual.put(wife, new HashSet());
                }
                this.marriagesByIndividual.get(wife).add(marriage);
            }
            if (husband == null) continue;
            if (!this.marriagesByIndividual.containsKey(husband)) {
                this.marriagesByIndividual.put(husband, new HashSet());
            }
            this.marriagesByIndividual.get(husband).add(marriage);
        }
        this.linksVector = new Vector();
        for (Map.Entry<String, PGraphNode> entry : this.marriages.entrySet()) {
            PGraphLink link;
            PGraphNode marriage = entry.getValue();
            PGraphNode wifeLink = marriage.getWifeLink();
            PGraphNode husbandLink = marriage.getHusbandLink();
            if (wifeLink != null) {
                link = new PGraphLink(wifeLink, marriage, true);
                this.linksVector.add(link);
            }
            if (husbandLink == null) continue;
            link = new PGraphLink(husbandLink, marriage, false);
            this.linksVector.add(link);
        }
        this.computeOutDegrees();
        this.computeAncestors();
    }

    private boolean addLink(PGraphLink link, int maxGenDist) {
        PGraphNode targ;
        PGraphNode orig = link.getOrigin();
        if (orig == (targ = link.getTarget())) {
            return false;
        }
        if (targ.hasDescendant(orig)) {
            return false;
        }
        int dist = orig.originalGenerationalDistance(targ);
        if (dist < 0 || dist > maxGenDist) {
            return false;
        }
        if (link.isWifeLink()) {
            link.getTarget().setWifeLink(link.getOrigin());
        } else {
            link.getTarget().setHusbandLink(link.getOrigin());
        }
        this.clearAncestors();
        this.computeAncestors();
        return true;
    }

    public float averageNumberOfDescendants() {
        float avg = 0.0f;
        for (Map.Entry<String, PGraphNode> entry : this.marriages.entrySet()) {
            PGraphNode marriage = entry.getValue();
            avg += (float)marriage.numberOfDescendants();
        }
        return avg /= (float)this.numberOfMarriages();
    }

    public float maxNumberOfDescendants() {
        float max = 0.0f;
        for (Map.Entry<String, PGraphNode> entry : this.marriages.entrySet()) {
            PGraphNode marriage = entry.getValue();
            float descs = marriage.numberOfDescendants();
            if (!(descs > max)) continue;
            max = descs;
        }
        return max;
    }

    private void clearAncestors() {
        for (Map.Entry<String, PGraphNode> entry : this.marriages.entrySet()) {
            PGraphNode marriage = entry.getValue();
            marriage.clearDescendants();
        }
    }

    private void computeAncestors() {
        for (Map.Entry<String, PGraphNode> entry : this.marriages.entrySet()) {
            PGraphNode marriage = entry.getValue();
            marriage.addDescendant(marriage, 0);
        }
    }

    private void computeOutDegrees() {
        for (Map.Entry<String, PGraphNode> entry : this.marriages.entrySet()) {
            PGraphNode marriage = entry.getValue();
            PGraphNode wifeLink = marriage.getWifeLink();
            PGraphNode husbandLink = marriage.getHusbandLink();
            if (wifeLink != null) {
                wifeLink.incOutDegree();
                wifeLink.incOutDegreeF();
            }
            if (husbandLink == null) continue;
            husbandLink.incOutDegree();
            husbandLink.incOutDegreeM();
        }
    }

    public Map<String, PGraphNode> getMarriages() {
        return this.marriages;
    }

    public Map<Individual, Set<PGraphNode>> getMarriagesByIndividual() {
        return this.marriagesByIndividual;
    }

    public int getTotalLinks() {
        return this.totalLinks;
    }

    public int numberOfMarriages() {
        return this.marriages.size();
    }

    private void removeLink(PGraphLink link) {
        if (link.isWifeLink()) {
            link.getTarget().setWifeLink(null);
        } else {
            link.getTarget().setWifeLink(null);
        }
    }

    public void storeOriginalDescendants() {
        for (Map.Entry<String, PGraphNode> entry : this.marriages.entrySet()) {
            PGraphNode marriage = entry.getValue();
            marriage.storeOriginalDescendants();
        }
    }

    public boolean switchLinks(int k, int maxGenDist) {
        HashSet<PGraphLink> linkSet = new HashSet<PGraphLink>();
        PGraphLink link = this.linksVector.get(RandomGenerator.instance().random.nextInt(this.linksVector.size()));
        linkSet.add(link);
        boolean gender = link.isWifeLink();
        while (linkSet.size() < k) {
            link = this.linksVector.get(RandomGenerator.instance().random.nextInt(this.linksVector.size()));
            if (link.isWifeLink() != gender) continue;
            linkSet.add(link);
        }
        ArrayList links = new ArrayList(linkSet);
        ArrayList links2 = new ArrayList(links);
        boolean perfectShuffle = false;
        while (!perfectShuffle) {
            perfectShuffle = true;
            int i = 0;
            while (i < k) {
                if (links.get(i) == links2.get(i)) {
                    perfectShuffle = false;
                }
                ++i;
            }
            Collections.shuffle(links2);
        }
        ArrayList<Object> newLinks = new ArrayList<Object>();
        int i = 0;
        while (i < k) {
            Object newLink = new PGraphLink(((PGraphLink)links.get(i)).getOrigin(), ((PGraphLink)links2.get(i)).getTarget(), ((PGraphLink)links.get(i)).isWifeLink());
            newLinks.add(newLink);
            ++i;
        }
        for (PGraphLink oldLink : links) {
            this.removeLink(oldLink);
        }
        this.clearAncestors();
        this.computeAncestors();
        boolean fail = false;
        for (Object newLink : newLinks) {
            if (this.addLink((PGraphLink)newLink, maxGenDist)) continue;
            fail = true;
            break;
        }
        if (fail) {
            for (Object newLink : newLinks) {
                this.removeLink((PGraphLink)newLink);
            }
            for (PGraphLink oldLink : links) {
                this.addLink(oldLink, maxGenDist);
            }
        } else {
            int i2 = 0;
            while (i2 < k) {
                ((PGraphLink)links.get(i2)).setTarget(((PGraphLink)links2.get(i2)).getTarget());
                ((PGraphLink)links.get(i2)).setShuffled(true);
                ++i2;
            }
        }
        return !fail;
    }

    public double distance(PGraph1 pg) {
        double dist = 0.0;
        double count = 0.0;
        for (Map.Entry<String, PGraphNode> entry : this.marriages.entrySet()) {
            String key = entry.getKey();
            PGraphNode m1 = entry.getValue();
            PGraphNode m2 = pg.getMarriages().get(key);
            dist += m1.distance(m2);
            count += 1.0;
        }
        return dist / count;
    }

    public double percentageShuffledLinks() {
        double shuffled = 0.0;
        double total = 0.0;
        for (PGraphLink link : this.linksVector) {
            if (link.isShuffled()) {
                shuffled += 1.0;
            }
            total += 1.0;
        }
        return shuffled / total * 100.0;
    }

    public String toString() {
        String str = "Number of marriages: " + this.numberOfMarriages() + "\n";
        str = String.valueOf(str) + "Number of links: " + this.getTotalLinks() + "\n";
        str = String.valueOf(str) + "Average number of descendants: " + this.averageNumberOfDescendants() + "\n";
        str = String.valueOf(str) + "Max number of descendants: " + this.maxNumberOfDescendants() + "\n";
        return str;
    }
}

