/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.visualization;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gephi.data.attributes.api.AttributeController;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphFactory;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.project.api.Workspace;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.tip.puck.graphs.Link;
import org.tip.puck.visualization.style.attributes.AttributeMap;
import org.tip.puck.visualization.style.attributes.GraphStyle;

public class GraphImporter {
    private final GraphModel graphModel;
    private final AttributeModel attributeModel;
    private final GraphStyle graphStyle;
    private final GraphFactory factory;
    private final Graph graph;
    private Map<Integer, Node> nodesMap;

    public GraphImporter(Workspace workspace, GraphStyle graphStyle) {
        this.graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel(workspace);
        AttributeController attributeController = (AttributeController)Lookup.getDefault().lookup(AttributeController.class);
        this.attributeModel = attributeController.getModel(workspace);
        this.graphStyle = graphStyle;
        switch (this.graphStyle) {
            case directed: {
                this.graph = this.graphModel.getDirectedGraph();
                break;
            }
            case undirected: {
                this.graph = this.graphModel.getUndirectedGraph();
                break;
            }
            case mixed: {
                this.graph = this.graphModel.getMixedGraph();
                break;
            }
            default: {
                this.graph = null;
            }
        }
        this.factory = this.graphModel.factory();
    }

    public <E> void importGraph(org.tip.puck.graphs.Graph<E> graph, AttributeMap attributeMap) throws Exception {
        attributeMap.registerAttributes(this.attributeModel);
        this.nodesMap = new HashMap<Integer, Node>(graph.nodeCount());
        for (org.tip.puck.graphs.Node<E> node : graph.getNodes()) {
            int nodeId = node.getId();
            Node newNode = this.addNode(nodeId);
            attributeMap.setAttributes(newNode, node);
        }
        for (org.tip.puck.graphs.Node<E> node : graph.getNodes()) {
            Edge gephiEdge;
            int uidTarget;
            int uidSource;
            if (this.graphStyle == GraphStyle.directed || this.graphStyle == GraphStyle.mixed) {
                List<Link<E>> arcs = node.getOutArcs().getLinks();
                for (Link<E> arc : arcs) {
                    uidSource = arc.getSourceNode().getId();
                    uidTarget = arc.getTargetNode().getId();
                    gephiEdge = null;
                    try {
                        gephiEdge = this.addEdge(uidSource, uidTarget, true);
                    }
                    catch (Exception exception) {
                        Exceptions.printStackTrace((Throwable)exception);
                    }
                    attributeMap.setAttributes(gephiEdge, arc);
                }
            }
            if (this.graphStyle != GraphStyle.undirected && this.graphStyle != GraphStyle.mixed) continue;
            List<Link<E>> edges = node.getInferiorEdges().getLinks();
            for (Link<E> edge : edges) {
                uidSource = edge.getSourceNode().getId();
                uidTarget = edge.getTargetNode().getId();
                gephiEdge = null;
                try {
                    gephiEdge = this.addEdge(uidSource, uidTarget, false);
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                }
                attributeMap.setAttributes(gephiEdge, edge);
            }
        }
        this.nodesMap.clear();
        this.nodesMap = null;
    }

    public final Node addNode(int uid) throws Exception {
        Node newNode = this.factory.newNode();
        if (newNode == null) {
            throw new Exception("newNode == null");
        }
        if (!this.graph.addNode(newNode)) {
            throw new Exception("newNode not added");
        }
        Node old = this.nodesMap.put(uid, newNode);
        if (old != null) {
            System.out.println("Possible duplicate node (nodesMap contains " + uid + ")");
        }
        return newNode;
    }

    public final Edge addEdge(int uidSource, int uidTarget, boolean directed) throws Exception {
        Node source = this.nodesMap.get(uidSource);
        if (source == null) {
            throw new Exception("source == null");
        }
        Node target = this.nodesMap.get(uidTarget);
        if (target == null) {
            throw new Exception("target == null");
        }
        Edge newEdge = this.factory.newEdge(source, target, 1.0f, directed);
        if (newEdge == null) {
            throw new Exception("newEdge == null");
        }
        if (!this.graph.contains(newEdge)) {
            this.graph.addEdge(newEdge);
            if (!this.graph.contains(newEdge)) {
                throw new Exception("newEdge not added");
            }
        }
        return newEdge;
    }
}

