/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.spacetime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tip.puck.geo.GeoLevel;
import org.tip.puck.geo.Geography;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.workers.ExpansionMode;

public class SpaceTimeCriteria {
    private String relationModelName;
    private String dateLabel;
    private String startDateLabel;
    private String endDateLabel;
    private String placeLabel;
    private String startPlaceLabel;
    private String endPlaceLabel;
    private String localUnitLabel;
    private String egoRoleName;
    private String defaultReferentRoleName;
    private List<String> roleNames;
    private int maxAge;
    private int minAge;
    private Integer[] dates;
    private Geography geography;
    private GeoLevel level;
    private List<String> minimalPlaceNames;
    private ExpansionMode expansionMode;
    private FiliationType filiationType;
    private CensusType censusType;
    private String pattern;
    private String chainClassification;
    private List<String> relationModelNames;
    private String individualClassificationType;
    private List<RelationClassificationType> relationClassificationTypes;
    private List<RelationClassificationType> mainRelationClassificationTypes;
    private List<String> censusOperationLabels;
    private List<String> networkTitles;
    private Map<String, List<String>> partitionLabels;
    private String alterFilterRoleName;
    private String alterFilterAttributeLabel;
    private String alterFilterAttributeValue;

    private void setDefaultCriteria() {
        this.relationModelName = "MIGEVENT";
        this.dateLabel = "DATE";
        this.startDateLabel = "START_DATE";
        this.endDateLabel = "END_DATE";
        this.placeLabel = "PLACE";
        this.startPlaceLabel = "START_PLACE";
        this.endPlaceLabel = "END_PLACE";
        this.localUnitLabel = "HOUSE";
        this.egoRoleName = "MIG";
        this.alterFilterRoleName = "ALL";
        this.roleNames = new ArrayList<String>();
        this.roleNames.add("ALL");
        this.roleNames.add("HOST");
        this.roleNames.add("MIG");
        this.defaultReferentRoleName = "HOST";
        this.minAge = 0;
        this.maxAge = 1000;
        this.dates = new Integer[]{2004, 2009, 2014};
        this.relationModelNames = new ArrayList<String>();
        this.relationModelNames.add("Apprenticeship");
        this.relationModelNames.add("Housing");
        this.relationModelNames.add("Employment");
        this.relationClassificationTypes = new ArrayList<RelationClassificationType>();
        this.mainRelationClassificationTypes = new ArrayList<RelationClassificationType>();
        for (RelationClassificationType mainEventType : this.mainRelationClassificationTypes) {
            if (this.relationClassificationTypes.contains((Object)mainEventType)) continue;
            this.relationClassificationTypes.add(mainEventType);
        }
        this.geography = Geography.getInstance();
        this.level = GeoLevel.TOWN;
        if (this.censusType == CensusType.GENERAL) {
            this.minimalPlaceNames = Arrays.asList("Afagnan", "Lom\ufffd", "Bas-Mono", "Togo", "B\ufffdnin", "Ghana", "Nig\ufffdria", "C\ufffdte d'Ivoire", "Afrique");
        }
        this.pattern = "3 1";
        this.chainClassification = "LINE";
        this.individualClassificationType = "GENDER";
        this.networkTitles = new ArrayList<String>();
        this.partitionLabels = new HashMap<String, List<String>>();
        for (String networkTitle : this.networkTitles) {
            this.partitionLabels.put(networkTitle, new ArrayList());
        }
        this.censusOperationLabels = new ArrayList<String>();
        this.expansionMode = ExpansionMode.RELATED;
        this.filiationType = FiliationType.COGNATIC;
    }

    public void setRelationClassificationTypes(List<RelationClassificationType> relationClassificationTypes) {
        this.relationClassificationTypes = relationClassificationTypes;
    }

    public List<RelationClassificationType> getRelationClassificationTypes() {
        return this.relationClassificationTypes;
    }

    public SpaceTimeCriteria() {
        this.setDefaultCriteria();
    }

    public SpaceTimeCriteria(CensusType censusType) {
        this.setDefaultCriteria();
        this.censusType = censusType;
        if (censusType == CensusType.PARCOURSNETWORKS) {
            this.alterFilterAttributeLabel = "INTERV";
            this.alterFilterAttributeValue = "Yes";
        }
        switch (censusType) {
            case GENERAL: {
                this.relationClassificationTypes.add(RelationClassificationType.PLACE);
                this.relationClassificationTypes.add(RelationClassificationType.MIGRATIONTYPE);
                this.relationClassificationTypes.add(RelationClassificationType.TREES);
                this.relationClassificationTypes.add(RelationClassificationType.CHILDMIGRATIONTYPE);
                this.relationClassificationTypes.add(RelationClassificationType.DISTANCE);
                this.relationClassificationTypes.add(RelationClassificationType.REGION);
                break;
            }
            case EGONETWORKS: {
                this.relationClassificationTypes.add(RelationClassificationType.PLACE);
                break;
            }
            case PARCOURSNETWORKS: {
                this.relationClassificationTypes.add(RelationClassificationType.PLACE);
                break;
            }
            case PARCOURS: {
                this.relationClassificationTypes.add(RelationClassificationType.PLACE);
            }
        }
        switch (censusType) {
            case GENERAL: {
                break;
            }
            case EGONETWORKS: {
                break;
            }
            case PARCOURSNETWORKS: {
                this.mainRelationClassificationTypes.add(RelationClassificationType.MIGRATIONTYPE);
                this.mainRelationClassificationTypes.add(RelationClassificationType.TYPEDID);
                break;
            }
            case PARCOURS: {
                this.mainRelationClassificationTypes.add(RelationClassificationType.PLACE);
                this.mainRelationClassificationTypes.add(RelationClassificationType.DISTANCE);
                this.mainRelationClassificationTypes.add(RelationClassificationType.TREES);
                this.mainRelationClassificationTypes.add(RelationClassificationType.MIGRATIONTYPE);
            }
        }
        for (RelationClassificationType mainEventType : this.mainRelationClassificationTypes) {
            if (this.relationClassificationTypes.contains((Object)mainEventType)) continue;
            this.relationClassificationTypes.add(mainEventType);
        }
        this.networkTitles = new ArrayList<String>();
        this.partitionLabels = new HashMap<String, List<String>>();
        switch (censusType) {
            case GENERAL: {
                break;
            }
            case EGONETWORKS: {
                this.addNetworkTitle("Ego Network");
                this.addNetworkTitle("Nonmediated Ego Network");
                break;
            }
            case PARCOURSNETWORKS: {
                this.addNetworkTitle("Parcours");
                this.addNetworkTitle("Extended Parcours");
                this.addNetworkTitle("Multiple Parcours");
                for (RelationClassificationType mainEventType : this.mainRelationClassificationTypes) {
                    this.addNetworkTitle("Parcours Network_" + (Object)((Object)mainEventType));
                    this.addNetworkTitle("Parcours Similarity Tree_" + (Object)((Object)mainEventType));
                }
                break;
            }
            case PARCOURS: {
                this.addNetworkTitle("Event Type Network");
                this.addNetworkTitle("Sequence Type Network");
            }
        }
        switch (censusType) {
            case GENERAL: {
                break;
            }
            case EGONETWORKS: {
                this.partitionLabels.get("Ego Network").add("EGO-RELATION");
                this.partitionLabels.get("Ego Network").add("DEGREE");
                this.partitionLabels.get("Nonmediated Ego Network").add("BETWEENNESS");
                this.partitionLabels.get("Nonmediated Ego Network").add("EGO-RELATION");
                this.partitionLabels.get("Nonmediated Ego Network").add("DEGREE");
                this.partitionLabels.get("Nonmediated Ego Network").add("COMPONENT");
                break;
            }
            case PARCOURSNETWORKS: {
                this.partitionLabels.get("Parcours").add("DATE");
                this.partitionLabels.get("Parcours").add("DISTANCE");
                this.partitionLabels.get("Multiple Parcours").add("DATE");
                this.partitionLabels.get("Multiple Parcours").add("DISTANCE");
                this.partitionLabels.get("Extended Parcours").add("ORDER");
                this.partitionLabels.get("Extended Parcours").add("TYPE");
                break;
            }
        }
        if (censusType == CensusType.PARCOURSNETWORKS) {
            for (RelationClassificationType mainEventType : this.mainRelationClassificationTypes) {
                List<String> egoNetworkPartitionLabels = this.partitionLabels.get("Parcours Network_" + (Object)((Object)mainEventType));
                egoNetworkPartitionLabels.add("BETWEENNESS");
                egoNetworkPartitionLabels.add("EGO-RELATION");
                egoNetworkPartitionLabels.add("DEGREE");
                egoNetworkPartitionLabels.add("COMPONENT");
                List<String> treePartitionLabels = this.partitionLabels.get("Parcours Similarity Tree_" + (Object)((Object)mainEventType));
                treePartitionLabels.add("SIZE");
                treePartitionLabels.add("STEP");
                treePartitionLabels.add("EGO-RELATION");
            }
        }
        this.censusOperationLabels = new ArrayList<String>();
        switch (censusType) {
            case GENERAL: {
                this.censusOperationLabels.add("NREVENTS");
                this.censusOperationLabels.add("NREXTERNALMOVES");
                this.censusOperationLabels.add("AGEFIRST");
                this.censusOperationLabels.add("AGEFIRST_CHILDMIGRATIONTYPE_NOPARENTS");
                this.censusOperationLabels.add("AGEFIRST_DISTANCE_TRANSNATIONAL");
                this.censusOperationLabels.add("MAX_DISTANCE");
                this.censusOperationLabels.add("SAMESEXALTERS_ALL");
                this.censusOperationLabels.add("SAMEPLACEALTERS_ALL");
                for (String roleName : this.roleNames) {
                    this.censusOperationLabels.add("NRALTERS_" + roleName);
                    this.censusOperationLabels.add("NRALTERSPEREVENT_" + roleName);
                }
                for (RelationClassificationType type : this.relationClassificationTypes) {
                    this.censusOperationLabels.add("EVENTS_" + (Object)((Object)type));
                }
                this.censusOperationLabels.add("MEAN_COVERAGE");
                this.censusOperationLabels.add("MAX_COVERAGE");
                for (String roleName : this.roleNames) {
                    this.censusOperationLabels.add("RELATIONS_" + roleName);
                }
                this.censusOperationLabels.add("MAIN_ALTERS");
                this.censusOperationLabels.add("MAIN_RELATIONS");
                break;
            }
            case EGONETWORKS: {
                this.censusOperationLabels.add("NREVENTS");
                this.censusOperationLabels.add("NREXTERNALMOVES");
                this.censusOperationLabels.add("SIZE");
                this.censusOperationLabels.add("TIES");
                this.censusOperationLabels.add("EGO-BETWEENNESS");
                this.censusOperationLabels.add("MEAN_BETWEENNESS");
                this.censusOperationLabels.add("MAX_BETWEENNESS");
                this.censusOperationLabels.add("ECCENTRICITY");
                this.censusOperationLabels.add("DENSITY");
                this.censusOperationLabels.add("DENSITY_NOLOOPS");
                this.censusOperationLabels.add("MEANDEGREE");
                this.censusOperationLabels.add("MEANDEGREE_NOLOOPS");
                this.censusOperationLabels.add("MEANDEGREE_NOLOOPS_NORM");
                this.censusOperationLabels.add("NRCOMPONENTS");
                this.censusOperationLabels.add("NRISOLATES");
                this.censusOperationLabels.add("MAXCOMPONENT");
                this.censusOperationLabels.add("NRCOMPONENTS_NORM");
                this.censusOperationLabels.add("NRISOLATES_NORM");
                this.censusOperationLabels.add("MAXCOMPONENT_NORM");
                this.censusOperationLabels.add("CONCENTRATION");
                this.censusOperationLabels.add("BROKERAGE");
                this.censusOperationLabels.add("EFFICIENT_SIZE");
                this.censusOperationLabels.add("EFFICIENCY");
                this.censusOperationLabels.add("NETWORK_RELATIONS");
                this.censusOperationLabels.add("CONNECTED_NETWORK_RELATIONS");
                this.censusOperationLabels.add("CENTRAL_ALTERS");
                this.censusOperationLabels.add("CENTRAL_RELATIONS");
                this.censusOperationLabels.add("SDENSITY_PARENT-CHILD");
                this.censusOperationLabels.add("SDENSITY_SPOUSE");
                this.censusOperationLabels.add("SDENSITY_SIBLING");
                this.censusOperationLabels.add("SDENSITY_RELATIVE");
                this.censusOperationLabels.add("SDENSITY_AFFINE");
                this.censusOperationLabels.add("SDENSITY_EMPLOYMENT");
                this.censusOperationLabels.add("SDENSITY_RENT");
                break;
            }
            case PARCOURSNETWORKS: {
                this.censusOperationLabels.add("NREVENTS");
                this.censusOperationLabels.add("NREXTERNALMOVES");
                for (RelationClassificationType mainEventType : this.mainRelationClassificationTypes) {
                    this.censusOperationLabels.add("SIZE_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("TIES_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("EGO-BETWEENNESS_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("MEAN_BETWEENNESS_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("MAX_BETWEENNESS_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("ECCENTRICITY_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("DENSITY_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("DENSITY_NOLOOPS_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("MEANDEGREE_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("MEANDEGREE_NOLOOPS_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("MEANDEGREE_NOLOOPS_NORM_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("NRCOMPONENTS_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("NRISOLATES_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("MAXCOMPONENT_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("NRCOMPONENTS_NORM_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("NRISOLATES_NORM_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("MAXCOMPONENT_NORM_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("CONCENTRATION_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("BROKERAGE_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("EFFICIENT_SIZE_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("EFFICIENCY_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("NETWORK_RELATIONS_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("CONNECTED_NETWORK_RELATIONS_" + (Object)((Object)mainEventType));
                    this.censusOperationLabels.add("SIMILARITY_" + (Object)((Object)mainEventType));
                }
                break;
            }
            case PARCOURS: {
                this.censusOperationLabels.add("NREVENTS");
                this.censusOperationLabels.add("NREXTERNALMOVES");
                for (RelationClassificationType relationClassificationType : this.mainRelationClassificationTypes) {
                    this.censusOperationLabels.add("PROFILE_" + (Object)((Object)relationClassificationType));
                    this.censusOperationLabels.add("SUPPORT_" + (Object)((Object)relationClassificationType));
                    if (relationClassificationType != RelationClassificationType.PLACE) continue;
                    this.censusOperationLabels.add("CENTERS_" + (Object)((Object)relationClassificationType));
                    this.censusOperationLabels.add("NRINTERNALMOVES_" + (Object)((Object)relationClassificationType));
                    this.censusOperationLabels.add("NRDIRECTRETURNS_" + (Object)((Object)relationClassificationType));
                    this.censusOperationLabels.add("NRCYCLES_" + (Object)((Object)relationClassificationType));
                    this.censusOperationLabels.add("NRDIRECTRETURNS_NORM_" + (Object)((Object)relationClassificationType));
                    this.censusOperationLabels.add("NRCYCLES_NORM_" + (Object)((Object)relationClassificationType));
                }
                break;
            }
        }
    }

    public void addNetworkTitle(String networkTitle) {
        this.networkTitles.add(networkTitle);
        this.partitionLabels.put(networkTitle, new ArrayList());
    }

    public String getEgoRoleName() {
        return this.egoRoleName;
    }

    public void setEgoRoleName(String egoRoleName) {
        this.egoRoleName = egoRoleName;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public int getMinAge() {
        return this.minAge;
    }

    public void setMinAge(int minAge) {
        this.minAge = minAge;
    }

    public String getRelationModelName() {
        return this.relationModelName;
    }

    public void setRelationModelName(String relationModelName) {
        this.relationModelName = relationModelName;
    }

    public GeoLevel getLevel() {
        return this.level;
    }

    public List<String> getCensusOperationLabels() {
        return this.censusOperationLabels;
    }

    public void setLabels(List<String> labels) {
        this.censusOperationLabels = labels;
    }

    public void setLevel(GeoLevel level) {
        this.level = level;
    }

    public String getPartitionLabel() {
        return this.individualClassificationType;
    }

    public void setPartitionLabel(String partitionLabel) {
        this.individualClassificationType = partitionLabel;
    }

    public List<String> getRelationModelNames() {
        return this.relationModelNames;
    }

    public String getAlterFilterRoleName() {
        return this.alterFilterRoleName;
    }

    public void setAlterFilterRoleName(String alterFilterRoleName) {
        this.alterFilterRoleName = alterFilterRoleName;
    }

    public Geography getGeography() {
        return this.geography;
    }

    public List<RelationClassificationType> getMainRelationClassificationTypes() {
        return this.mainRelationClassificationTypes;
    }

    public void setMainEventType(List<RelationClassificationType> mainEventTypes) {
        this.mainRelationClassificationTypes = mainEventTypes;
    }

    public void setGeography(Geography geography) {
        this.geography = geography;
    }

    public void setRelationModelNames(List<String> relationModelNames) {
        this.relationModelNames = relationModelNames;
    }

    public List<String> getRoleNames() {
        return this.roleNames;
    }

    public void setRoleNames(List<String> alterRoleNames) {
        this.roleNames = alterRoleNames;
    }

    public List<RelationClassificationType> getTypes() {
        return this.relationClassificationTypes;
    }

    public void setTypes(List<RelationClassificationType> types) {
        this.relationClassificationTypes = types;
    }

    public List<String> getNetworkTitles() {
        return this.networkTitles;
    }

    public String getAlterFilterAttributeLabel() {
        return this.alterFilterAttributeLabel;
    }

    public void setAlterAttributeLabel(String alterAttributeLabel) {
        this.alterFilterAttributeLabel = alterAttributeLabel;
    }

    public String getAlterFilterAttributeValue() {
        return this.alterFilterAttributeValue;
    }

    public void setAlterAttributeValue(String alterAttributeValue) {
        this.alterFilterAttributeValue = alterAttributeValue;
    }

    public Map<String, List<String>> getPartitionLabels() {
        return this.partitionLabels;
    }

    public List<String> getMinimalPlaceNames() {
        return this.minimalPlaceNames;
    }

    public void setPlaceNames(List<String> placeNames) {
        this.minimalPlaceNames = placeNames;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getDefaultReferentRoleName() {
        return this.defaultReferentRoleName;
    }

    public void setDefaultReferentRoleName(String defaultReferentRoleName) {
        this.defaultReferentRoleName = defaultReferentRoleName;
    }

    public void setCensusType(CensusType censusType) {
        this.censusType = censusType;
    }

    public CensusType getCensusType() {
        return this.censusType;
    }

    public List<RelationClassificationType> getEventTypes() {
        return this.relationClassificationTypes;
    }

    public void setEventTypes(List<RelationClassificationType> relationClassificationTypes) {
        this.relationClassificationTypes = relationClassificationTypes;
    }

    public ExpansionMode getExpansionMode() {
        return this.expansionMode;
    }

    public void setExpansionMode(ExpansionMode expansionMode) {
        this.expansionMode = expansionMode;
    }

    public FiliationType getFiliationType() {
        return this.filiationType;
    }

    public void setFiliationType(FiliationType filiationType) {
        this.filiationType = filiationType;
    }

    public String getDateLabel() {
        return this.dateLabel;
    }

    public void setDateLabel(String dateLabel) {
        this.dateLabel = dateLabel;
    }

    public String getStartPlaceLabel() {
        return this.startPlaceLabel;
    }

    public void setStartPlaceLabel(String startPlaceLabel) {
        this.startPlaceLabel = startPlaceLabel;
    }

    public String getEndPlaceLabel() {
        return this.endPlaceLabel;
    }

    public void setEndPlaceLabel(String endPlaceLabel) {
        this.endPlaceLabel = endPlaceLabel;
    }

    public String getChainClassification() {
        return this.chainClassification;
    }

    public void setChainClassification(String chainClassification) {
        this.chainClassification = chainClassification;
    }

    public Integer[] getDates() {
        return this.dates;
    }

    public void setDates(Integer[] dates) {
        this.dates = dates;
    }

    public String getLocalUnitLabel() {
        return this.localUnitLabel;
    }

    public void setLocalUnitLabel(String constantAttributeFilterLabel) {
        this.localUnitLabel = constantAttributeFilterLabel;
    }

    public String getStartDateLabel() {
        return this.startDateLabel;
    }

    public void setStartDateLabel(String startDateLabel) {
        this.startDateLabel = startDateLabel;
    }

    public String getPlaceLabel() {
        return this.placeLabel;
    }

    public void setPlaceLabel(String placeLabel) {
        this.placeLabel = placeLabel;
    }

    public String getEndDateLabel() {
        return this.endDateLabel;
    }

    public void setEndDateLabel(String endDateLabel) {
        this.endDateLabel = endDateLabel;
    }

    public static enum CensusType {
        GENERAL,
        EGONETWORKS,
        PARCOURSNETWORKS,
        PARCOURS;


        public String toString() {
            String result;
            switch (this) {
                case GENERAL: {
                    result = "General";
                    break;
                }
                case EGONETWORKS: {
                    result = "Ego Networks";
                    break;
                }
                case PARCOURSNETWORKS: {
                    result = "Parcours Networks";
                    break;
                }
                case PARCOURS: {
                    result = "Parcours";
                    break;
                }
                default: {
                    result = null;
                }
            }
            return result;
        }
    }

    public static enum RelationClassificationType {
        TYPEDID,
        HOST,
        MIG,
        HOSTMIG,
        MIGRATIONTYPE,
        CHILDMIGRATIONTYPE,
        TREES,
        DISTANCE,
        PLACE,
        REGION,
        MOVEMENT,
        TURNOVER,
        COMPONENTS;

    }
}

