/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.spacetime;

import fr.devinsy.util.StringList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.tip.puck.PuckException;
import org.tip.puck.geo.GeoLevel;
import org.tip.puck.geo.Geography;
import org.tip.puck.geo.Place;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.GraphProfile;
import org.tip.puck.graphs.Node;
import org.tip.puck.io.paj.PAJFile;
import org.tip.puck.matrix.MatrixStatistics;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportChart;
import org.tip.puck.report.ReportRawData;
import org.tip.puck.report.ReportTable;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.spacetime.CorrelationMatrix;
import org.tip.puck.spacetime.EventTriangle;
import org.tip.puck.spacetime.MissingTestimoniesCriteria;
import org.tip.puck.spacetime.Ordinal;
import org.tip.puck.spacetime.Sequence;
import org.tip.puck.spacetime.SequenceCensus;
import org.tip.puck.spacetime.SequenceMaker;
import org.tip.puck.spacetime.SequenceWorker;
import org.tip.puck.spacetime.Sequences;
import org.tip.puck.spacetime.SequencesCensus;
import org.tip.puck.spacetime.SpaceTimeCriteria;
import org.tip.puck.spacetime.UnknownPlacesCriteria;
import org.tip.puck.statistics.StatisticsReporter;
import org.tip.puck.util.Chronometer;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.NumberedValues;
import org.tip.puck.util.PuckUtils;
import org.tip.puck.util.ToolBox;
import org.tip.puck.util.Value;

public class SequenceReporter {
    private static StringList getStories(Relation event) {
        StringList result = new StringList();
        for (Attribute attribute : event.attributes()) {
            String story = "";
            if (!attribute.getLabel().contains("NOTE")) continue;
            String[] label = attribute.getLabel().split("_");
            if (label.length > 1 && StringUtils.isNumeric((CharSequence)label[1])) {
                int id = Integer.parseInt(label[1]);
                Individual indi = (Individual)event.getIndividuals().getById(id);
                story = String.valueOf(story) + indi.signature() + ": ";
            }
            story = String.valueOf(story) + attribute.getValue();
            result.appendln(story);
        }
        return result;
    }

    public static Report reportDiscontinuousItineraries(Segmentation segmentation, SpaceTimeCriteria criteria, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        int errorCount = 0;
        StringList errors = new StringList();
        Report result = new Report();
        result.setTitle("Discontinuous Itineraries");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        for (Sequence itinerary : SequenceMaker.createPersonalSequences(segmentation, criteria).toSortedList()) {
            Sequences partials = SequenceWorker.split(itinerary);
            if (partials.size() <= 1) continue;
            ++errorCount;
            errors.appendln(itinerary.getEgo().signature());
            int j = 0;
            for (Sequence partial : partials) {
                if (partial.getEvents().size() != 0 && j > 0) {
                    errors.appendln(partial.getFirst() + "\t" + partial.getEvents().get(partial.getFirst()));
                }
                ++j;
            }
            errors.appendln();
        }
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Discontinuous Itineraries") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportMissingTestimonies(Segmentation segmentation, MissingTestimoniesCriteria criteria, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        int errorCount = 0;
        StringList errors = new StringList();
        Report result = new Report();
        result.setTitle("Missing Testimonies");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        for (Relation event : segmentation.getCurrentRelations().getByModelName(criteria.getRelationModelName())) {
            for (Individual witness : event.getIndividuals(criteria.getEgoRoleName())) {
                if (!segmentation.getCurrentIndividuals().contains(witness)) continue;
                boolean missing = true;
                for (Attribute attribute : event.attributes()) {
                    String id;
                    if (!attribute.getLabel().contains("NOTE") || attribute.getLabel().indexOf("_") <= -1 || !NumberUtils.isNumber((String)(id = attribute.getLabel().substring(attribute.getLabel().indexOf("_") + 1))) || Integer.parseInt(id) != witness.getId()) continue;
                    missing = false;
                    break;
                }
                if (!missing) continue;
                ++errorCount;
                errors.appendln(String.valueOf(witness.signature()) + "\t" + event.getTypedId() + "\t" + event.getName());
            }
        }
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Missing Testimonies") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static Report reportSequenceCensus(Segmentation segmentation, SpaceTimeCriteria.CensusType censusType) throws PuckException {
        Chronometer chrono = new Chronometer();
        Report result = new Report(censusType.toString());
        result.setOrigin("Sequence reporter");
        Report overallReport = new Report("Survey");
        Report diagramReport = new Report("Diagrams");
        Report detailReport = new Report("Details");
        Report componentReport = new Report("Components");
        Report treeReport = new Report("Trees");
        ArrayList<Object> charts = new ArrayList<Object>();
        ArrayList<ReportTable> tables = new ArrayList<ReportTable>();
        SpaceTimeCriteria censusCriteria = new SpaceTimeCriteria(censusType);
        Sequences sequences = new Sequences();
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            sequences.addRenumbered(SequenceWorker.getCoherentItinerarySegment(ego, censusCriteria));
        }
        SequencesCensus census = new SequencesCensus(sequences, censusCriteria);
        overallReport.outputs().appendln("Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");
        for (String label : censusCriteria.getCensusOperationLabels()) {
            void var17_30;
            PartitionCriteria partitionCriteria = new PartitionCriteria(label);
            if (label.equals("NREVENTS")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.RAW);
            } else if (label.contains("AGEFIRST")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(0.0);
                partitionCriteria.setSize(5.0);
            } else if (label.equals("ECCENTRICITY")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(-100.0);
                partitionCriteria.setSize(20.0);
            } else if (label.contains("COVERAGE") || label.contains("SAME") || label.contains("NORM") || label.contains("DENSITY") || label.contains("BETWEENNESS") || label.contains("EFFICIENCY") || label.contains("CONCENTRATION")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(0.0);
                partitionCriteria.setSize(20.0);
            } else if (label.contains("MEAN") || label.contains("COVERAGE") || label.contains("PEREVENT") || label.contains("BETWEENNESS") || label.contains("BROKERAGE") || label.contains("EFFICIENT_SIZE")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(0.0);
                partitionCriteria.setSize(1.0);
            } else {
                partitionCriteria.setType(PartitionCriteria.PartitionType.RAW);
            }
            Object var17_31 = null;
            if (label.contains("SIMILARITY")) {
                SpaceTimeCriteria.RelationClassificationType relationClassificationType = SpaceTimeCriteria.RelationClassificationType.valueOf(label.substring(label.lastIndexOf("_") + 1));
                Map<Value, Double[]> similaritiesMap = census.getSimilaritiesMap(relationClassificationType);
                ReportChart reportChart = StatisticsReporter.createMapChart(similaritiesMap, label, new String[]{"HH", "FH", "HF", "FF", "All"}, ReportChart.GraphType.LINES);
                for (Value key : similaritiesMap.keySet()) {
                    overallReport.outputs().appendln(String.valueOf(label) + "_" + key + "\t" + MathUtils.percent(similaritiesMap.get(key)[4], 100.0));
                }
            } else if (!label.contains("ALTERS") && !label.contains("PROFILE")) {
                NumberedValues values = census.getValues(label);
                Partition<Individual> partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), values, partitionCriteria);
                PartitionCriteria splitCriteria = new PartitionCriteria(censusCriteria.getPartitionLabel());
                ReportChart reportChart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, splitCriteria);
                if (label.substring(0, 3).equals("AGE")) {
                    partitionCriteria.setType(PartitionCriteria.PartitionType.RAW);
                    partitionCriteria.setSizeFilter(PartitionCriteria.SizeFilter.HOLES);
                    partitionCriteria.setValueFilter(PartitionCriteria.ValueFilter.NULL);
                    partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), values, partitionCriteria);
                    if (partition.maxValue() != null) {
                        ReportChart survivalChart = StatisticsReporter.createSurvivalChart(partition, splitCriteria);
                        charts.add(survivalChart);
                    } else {
                        System.err.println(String.valueOf(label) + " no max value");
                    }
                }
                NumberedValues[] genderedValues = PuckUtils.getGenderedNumberedValues(values, segmentation.getCurrentIndividuals());
                overallReport.outputs().append(String.valueOf(label) + "\t");
                int gender = 0;
                while (gender < 3) {
                    String sum = "";
                    if (label.startsWith("NR")) {
                        sum = String.valueOf(new Double(genderedValues[gender].sum()).intValue());
                    }
                    overallReport.outputs().append(String.valueOf(MathUtils.round(genderedValues[gender].average(), 2)) + "\t" + MathUtils.round(genderedValues[gender].averagePositives(), 2) + "\t" + values.median() + "\t" + genderedValues[gender].max() + "\t" + sum + "\t");
                    ++gender;
                }
                overallReport.outputs().appendln();
            }
            if (var17_30 == null) continue;
            charts.add(var17_30);
            if (label.equals("SIMILARITY")) {
                tables.add(ReportTable.transpose(var17_30.createReportTable()));
                continue;
            }
            Iterator<String> table = ReportTable.transpose(var17_30.createReportTableWithSum());
            tables.add((ReportTable)((Object)table));
            if (label.contains("EVENTS_") || label.contains("RELATIONS")) continue;
            tables.add(ReportTable.normalize((ReportTable)((Object)table)));
        }
        overallReport.outputs().appendln();
        detailReport.outputs().append("Nr\tEgo\tGender");
        for (String partitionLabel : censusCriteria.getCensusOperationLabels()) {
            if (partitionLabel.contains("SIMILARITY")) {
                SpaceTimeCriteria.RelationClassificationType relationClassificationType = SpaceTimeCriteria.RelationClassificationType.valueOf(partitionLabel.substring(partitionLabel.lastIndexOf("_") + 1));
                detailReport.outputs().append("\tSIMILARITY_PARENT_" + (Object)((Object)relationClassificationType) + "\tSIMILARITY_CHILD_" + (Object)((Object)relationClassificationType) + "\tSIMILARITY_SIBLING_" + (Object)((Object)relationClassificationType) + "\tSIMILARITY_SPOUSE_" + (Object)((Object)relationClassificationType));
                continue;
            }
            detailReport.outputs().append("\t" + partitionLabel);
        }
        TreeMap<String, Map<String, Double>> componentChartMap = new TreeMap<String, Map<String, Double>>();
        detailReport.outputs().appendln();
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            if ((censusType == SpaceTimeCriteria.CensusType.GENERAL || censusType == SpaceTimeCriteria.CensusType.PARCOURS || censusType == SpaceTimeCriteria.CensusType.PARCOURSNETWORKS) && census.getValues("NREVENTS").get(ego.getId()) != null || censusType == SpaceTimeCriteria.CensusType.EGONETWORKS && census.getValues("SIZE").get(ego.getId()) != null) {
                detailReport.outputs().append(String.valueOf(ego.getId()) + "\t" + ego + "\t" + (Object)((Object)ego.getGender()));
                for (String string : censusCriteria.getCensusOperationLabels()) {
                    if (string.contains("SIMILARITY")) {
                        String[] keys;
                        Value value = (Value)census.getValues(string).get(ego.getId());
                        Map indiSimilaritiesMap = value.mapValue();
                        String[] stringArray = keys = new String[]{"PARENT", "CHILD", "SIBLING", "SPOUSE"};
                        int n = keys.length;
                        int sum = 0;
                        while (sum < n) {
                            String key = stringArray[sum];
                            Double[] sim = (Double[])indiSimilaritiesMap.get(new Value(key));
                            if (sim != null) {
                                detailReport.outputs().append("\t" + MathUtils.round(sim[4], 2));
                            }
                            ++sum;
                        }
                        continue;
                    }
                    detailReport.outputs().append("\t" + census.getValues(string).get(ego.getId()));
                }
                detailReport.outputs().appendln();
            }
            if (censusType != SpaceTimeCriteria.CensusType.EGONETWORKS && censusType != SpaceTimeCriteria.CensusType.PARCOURSNETWORKS) continue;
            for (String string : censusCriteria.getNetworkTitles()) {
                Map<Integer, Partition<Node<Individual>>> componentsMap = census.getComponents(string);
                if (componentsMap == null) continue;
                Partition<Node<Individual>> components = componentsMap.get(ego.getId());
                componentReport.outputs().appendln("Components " + string);
                componentReport.outputs().appendln(ego + "\t" + components.size());
                int i = 1;
                for (Cluster<Node<Individual>> cluster : components.getClusters().toListSortedByValue()) {
                    componentReport.outputs().appendln("\t" + i + "\t" + cluster.getValue() + "\t(" + cluster.size() + ")\t" + cluster.getItemsAsString());
                    ++i;
                }
                componentReport.outputs().appendln();
                for (Value value : components.getValues()) {
                    String label = value.toString();
                    TreeMap<String, Double> map = (TreeMap<String, Double>)componentChartMap.get(label);
                    if (map == null) {
                        map = new TreeMap<String, Double>();
                        Gender[] genderArray = Gender.values();
                        int n = genderArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Gender gender = genderArray[n2];
                            map.put(gender.toString(), 0.0);
                            ++n2;
                        }
                        componentChartMap.put(label, map);
                    }
                    map.put(ego.getGender().toString(), (Double)map.get(ego.getGender().toString()) + 1.0);
                }
            }
        }
        if (censusType == SpaceTimeCriteria.CensusType.EGONETWORKS || censusType == SpaceTimeCriteria.CensusType.PARCOURSNETWORKS) {
            ReportChart componentChart = StatisticsReporter.createChart("COMPONENTS", componentChartMap);
            charts.add(componentChart);
            tables.add(ReportTable.transpose(componentChart.createReportTableWithSum()));
            if (census.getRelationConnectionMatrix() != null) {
                for (ReportChart reportChart : census.getRelationConnectionMatrix().getCharts()) {
                    charts.add(reportChart);
                }
                tables.add(census.getRelationConnectionMatrix().getTable("Component Connections"));
            }
        }
        if (censusType == SpaceTimeCriteria.CensusType.PARCOURS) {
            for (SpaceTimeCriteria.RelationClassificationType relationClassificationType : censusCriteria.getMainRelationClassificationTypes()) {
                CorrelationMatrix correlationMatrix;
                if (censusCriteria.getNetworkTitles().contains("Event Type Network")) {
                    CorrelationMatrix correlationMatrix2 = census.getEventSequenceMatrix(relationClassificationType.toString());
                    if (correlationMatrix2 != null) {
                        for (ReportChart chart : correlationMatrix2.getCharts()) {
                            charts.add(chart);
                        }
                        tables.add(correlationMatrix2.getTable("Event Type Sequences"));
                    }
                    overallReport.outputs().appendln();
                    overallReport.outputs().appendln("Sequence Network Statistics " + (Object)((Object)relationClassificationType));
                    overallReport.outputs().appendln("\tDensity\tInertia\t(Divergence)\tConcentration\t(Divergence)\tSymmetry\t(Divergence)\tCentral nodes");
                    Gender[] genderArray = Gender.values();
                    int components = genderArray.length;
                    int componentsMap = 0;
                    while (componentsMap < components) {
                        Gender gender = genderArray[componentsMap];
                        GraphProfile<Cluster<String>> profile = correlationMatrix2.getProfile(gender);
                        String centralReferents = "";
                        for (Cluster<String> centralReferent : profile.getCentralReferents()) {
                            centralReferents = String.valueOf(centralReferents) + centralReferent.getValue() + " ";
                        }
                        double maxBetweenness = profile.getMaxBetweenness();
                        double density = profile.density();
                        double endo = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.LOOPS, MatrixStatistics.Mode.NORMALIZED), 2);
                        double endoExp = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.LOOPS, MatrixStatistics.Mode.DIVERGENCE_NORMALIZED), 2);
                        double conc = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.CONCENTRATION, MatrixStatistics.Mode.SIMPLE), 2);
                        double concExp = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.CONCENTRATION, MatrixStatistics.Mode.DIVERGENCE), 2);
                        double sym = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.SYMMETRY, MatrixStatistics.Mode.SIMPLE), 2);
                        double symExp = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.SYMMETRY, MatrixStatistics.Mode.DIVERGENCE), 2);
                        overallReport.outputs().appendln((Object)((Object)gender) + "\t" + density + "\t" + endo + "\t" + endoExp + "\t" + conc + "\t" + concExp + "\t" + sym + "\t" + symExp + "\t" + centralReferents + "(" + maxBetweenness + ") betweenness centrality");
                        ++componentsMap;
                    }
                    overallReport.outputs().appendln();
                }
                if (!censusCriteria.getNetworkTitles().contains("Sequence Type Network") || (correlationMatrix = census.getSubSequenceMatrix(relationClassificationType.toString())) == null) continue;
                charts.add(correlationMatrix.getRamificationChart());
            }
        }
        int chartIndex = 0;
        while (chartIndex < charts.size()) {
            diagramReport.outputs().append((ReportChart)charts.get(chartIndex));
            if (chartIndex % 4 == 3) {
                diagramReport.outputs().appendln();
            }
            ++chartIndex;
        }
        for (ReportTable table : tables) {
            diagramReport.outputs().appendln(table.getTitle());
            diagramReport.outputs().appendln(table);
        }
        result.outputs().append(overallReport);
        result.outputs().append(diagramReport);
        result.outputs().append(detailReport);
        if (censusType == SpaceTimeCriteria.CensusType.EGONETWORKS || censusType == SpaceTimeCriteria.CensusType.PARCOURSNETWORKS) {
            result.outputs().append(componentReport);
        }
        if (censusType == SpaceTimeCriteria.CensusType.PARCOURS) {
            result.outputs().append(treeReport);
        }
        Map<String, StringList> pajekBuffers = census.getPajekBuffers();
        for (String string : pajekBuffers.keySet()) {
            StringList pajekBuffer = pajekBuffers.get(string);
            if (pajekBuffer.length() == 0) continue;
            File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-" + string), ".paj");
            ReportRawData rawData = new ReportRawData("Export " + string + "s to Pajek", "Pajek", "paj", targetFile);
            rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));
            result.outputs().appendln();
            result.outputs().append(rawData);
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportSequences(Net net, Segmentation segmentation, SpaceTimeCriteria censusCriteria) throws PuckException {
        String spouseFilterLabel = "INTERV";
        Chronometer chrono = new Chronometer();
        Report result = new Report("Itineraries");
        result.setOrigin("Sequence reporter");
        Report surveyReport = new Report("Survey");
        Report detailedReport = new Report("Details");
        Report actorEventTableReport = new Report("Actor-Event tables");
        Report interactionTableReport = new Report("Interaction tables");
        Sequences sequences = new Sequences();
        Geography geography = censusCriteria.getGeography();
        StringList pajekBuffer = new StringList();
        Graph<Individual> graph = NetUtils.createRelationGraph(segmentation, censusCriteria.getRelationModelName());
        ArrayList<String> partitionLabels = new ArrayList<String>();
        pajekBuffer.addAll((Collection)PuckUtils.writePajekNetwork(graph, partitionLabels));
        pajekBuffer.appendln();
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            surveyReport.outputs().appendln(ego.signature());
            surveyReport.outputs().appendln();
            detailedReport.outputs().appendln(ego.signature());
            detailedReport.outputs().appendln();
            Sequence sequence = SequenceMaker.createPersonalSequence(ego, censusCriteria);
            sequences.add(sequence);
            for (Individual spouse : ego.spouses()) {
                spouse.getAttributeValue(spouseFilterLabel);
            }
            actorEventTableReport.outputs().append(sequence.roleTable());
            interactionTableReport.outputs().append(sequence.interactionTable());
            Sequences subSequences = SequenceWorker.split(sequence);
            for (Sequence subSequence : subSequences) {
                if (subSequences.size() > 1) {
                    surveyReport.outputs().appendln(subSequence.getId());
                    detailedReport.outputs().appendln(subSequence.getId());
                }
                for (Ordinal key : subSequence.getEvents().keySet()) {
                    Relation event = subSequence.getEvent(key);
                    Place start = geography.getByHomonym(event.getAttributeValue("START_PLACE"));
                    Place end = geography.getByHomonym(event.getAttributeValue("END_PLACE"));
                    Place ancestor = geography.getCommonAncestor(start, end);
                    GeoLevel commonLevel = null;
                    String commonPlaceName = null;
                    if (ancestor != null) {
                        commonLevel = ancestor.getLevel();
                        commonPlaceName = ancestor.getName();
                    }
                    String order = SequenceWorker.order(event, ego);
                    surveyReport.outputs().appendln(key + "\t" + order + "\t(" + subSequence.getAge(key.getYear()) + ")\t" + event.getTypedId() + "\t" + event.getAttributeValue("START_PLACE") + "\t" + event.getAttributeValue("END_PLACE") + "\t" + (Object)((Object)commonLevel) + "\t(" + commonPlaceName + ")\t");
                    detailedReport.outputs().appendln(key + "\t" + order + "\t(" + subSequence.getAge(key.getYear()) + ")\t" + event.getTypedId() + "\t" + event.getAttributeValue("START_PLACE") + "\t" + event.getAttributeValue("END_PLACE") + "\t" + (Object)((Object)commonLevel) + "\t(" + commonPlaceName + ")\t");
                    detailedReport.outputs().appendln();
                    detailedReport.outputs().appendln(SequenceReporter.getStories(event));
                }
                surveyReport.outputs().appendln();
                detailedReport.outputs().appendln();
                actorEventTableReport.outputs().appendln();
                interactionTableReport.outputs().appendln();
            }
        }
        Report biographyReport = new Report("Biographies");
        for (Sequence biography : SequenceMaker.createBiographies(net, segmentation, censusCriteria).toSortedList()) {
            Individual ego = (Individual)segmentation.getCurrentIndividuals().getById(biography.getId());
            biographyReport.outputs().appendln(ego.signature());
            for (Ordinal key : biography.getEvents().keySet()) {
                Relation event = biography.getEvent(key);
                biographyReport.outputs().appendln(key + "\t" + event.getRoles(ego).toString() + " (" + biography.getAge(key.getYear()) + ")\t" + event.getName() + " " + SequenceCensus.getEgoRolePartners(event, censusCriteria));
            }
            biographyReport.outputs().appendln();
        }
        Report extendedBiographyReport = new Report("Extended biographies");
        for (Sequence extendedBiography : SequenceMaker.createExtendedBiographies(net, segmentation, censusCriteria).toSortedList()) {
            Individual ego = (Individual)segmentation.getCurrentIndividuals().getById(extendedBiography.getId());
            extendedBiographyReport.outputs().appendln(ego.signature());
            for (Ordinal key : extendedBiography.getEvents().keySet()) {
                Relation event = extendedBiography.getEvent(key);
                extendedBiographyReport.outputs().appendln(key + "\t" + event.getRoles(ego).toString() + " (" + extendedBiography.getAge(key.getYear()) + ")\t" + event.getName() + " " + SequenceCensus.getEgoRolePartners(event, censusCriteria));
            }
            extendedBiographyReport.outputs().appendln();
        }
        if (pajekBuffer.length() != 0) {
            File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-Relation Network"), ".paj");
            ReportRawData rawData = new ReportRawData("Export Relation Network to Pajek", "Pajek", "paj", targetFile);
            rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));
            result.outputs().appendln();
            result.outputs().append(rawData);
        }
        result.outputs().append(surveyReport);
        result.outputs().append(detailedReport);
        result.outputs().append(biographyReport);
        result.outputs().append(extendedBiographyReport);
        result.outputs().append(actorEventTableReport);
        result.outputs().append(interactionTableReport);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    private static void reportSequenceTree(Report report, String value, Graph<Cluster<String>> sequenceTypeNetwork) {
        report.outputs().appendln("Sequence Tree " + value);
        Node<Cluster<String>> start = sequenceTypeNetwork.getNode(1);
        Stack stack = new Stack();
        report.outputs().appendln(start.getReferent() + "\t" + start.getReferent().size());
        stack.push(start);
        while (!stack.isEmpty()) {
            Node node = (Node)stack.pop();
            for (Node next : node.getOutNodes().toListSortedByLabel()) {
                report.outputs().appendln(next.getReferent() + "\t" + ((Cluster)next.getReferent()).size());
                stack.push(next);
            }
        }
        report.outputs().appendln();
    }

    private static void reportTriangles(Report report, Segmentation segmentation) throws PuckException {
        HashMap<Integer, Partition<EventTriangle>> trianglesMap = new HashMap<Integer, Partition<EventTriangle>>();
        Partition<EventTriangle> allTriangles = new Partition<EventTriangle>();
        Partition<Individual> triangleTypes = new Partition<Individual>();
        for (Individual ego : segmentation.getCurrentIndividuals()) {
            Individuals individuals = ego.getRelated("Migevent");
            individuals.add(ego);
            Partition<EventTriangle> triangles = SequenceWorker.getTriangles(individuals, "Migevent");
            allTriangles.add(triangles);
            trianglesMap.put(ego.getId(), triangles);
            for (Cluster<EventTriangle> cluster : triangles.getClusters()) {
                triangleTypes.put(ego, cluster.getValue());
            }
        }
        Report trianglesReport = new Report("Triangles");
        trianglesReport.outputs().appendln("Type\tnrTriangles\tnrEgoNetworks");
        for (Cluster cluster : allTriangles.getClusters().toListSortedByValue()) {
            trianglesReport.outputs().appendln(cluster.getValue() + "\t" + cluster.size() + "\t" + triangleTypes.getCluster(cluster.getValue()).size());
        }
        trianglesReport.outputs().appendln();
        PartitionCriteria partitionCriteria = new PartitionCriteria("Triangles");
        ReportChart chart5 = StatisticsReporter.createPartitionChart(allTriangles, partitionCriteria, null);
        trianglesReport.outputs().appendln(chart5);
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            Partition triangles = (Partition)trianglesMap.get(ego.getId());
            trianglesReport.outputs().appendln(ego + "\t" + triangles.size() + " types");
            for (Cluster cluster : triangles.getClusters().toListSortedByValue()) {
                trianglesReport.outputs().appendln(cluster.getValue() + "\t" + cluster.size());
                for (EventTriangle triangle : cluster.getItems()) {
                    trianglesReport.outputs().appendln(triangle.getEventPattern());
                }
                trianglesReport.outputs().appendln();
            }
            trianglesReport.outputs().appendln();
        }
    }

    public static Report reportUnknownPlaces(Segmentation segmentation, ResourceBundle bundle) {
        UnknownPlacesCriteria criteria = new UnknownPlacesCriteria();
        criteria.setIncludedIndividual(true);
        criteria.setIncludedAllRelations(true);
        Report result = SequenceReporter.reportUnknownPlaces(segmentation, criteria, bundle);
        return result;
    }

    public static Report reportUnknownPlaces(Segmentation segmentation, UnknownPlacesCriteria criteria, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        Geography geography = Geography.getInstance();
        Partition<String> unknownPlaces = new Partition<String>();
        int errorCount = 0;
        StringList errors = new StringList();
        if (criteria.isIncludedIndividual()) {
            for (Individual individual : segmentation.getCurrentIndividuals()) {
                for (Attribute attribute : individual.attributes()) {
                    if (!attribute.getLabel().contains("PLAC") || geography.getByHomonym(attribute.getValue()) != null) continue;
                    unknownPlaces.put(attribute.getValue(), new Value(attribute.getLabel()));
                    ++errorCount;
                }
            }
        }
        Relations relations = criteria.isIncludedAllRelations() ? segmentation.getCurrentRelations() : (criteria.getRelationNames().isEmpty() ? new Relations() : segmentation.getCurrentRelations().getByModelNames(criteria.getRelationNames()));
        for (Relation relation : relations) {
            for (Attribute attribute : relation.attributes()) {
                if (!attribute.getLabel().contains("PLAC") || geography.getByHomonym(attribute.getValue()) != null) continue;
                unknownPlaces.put(attribute.getValue(), new Value(attribute.getLabel()));
                ++errorCount;
            }
        }
        for (Cluster cluster : unknownPlaces.getClusters()) {
            errors.appendln(cluster.getValue().toString());
            for (String placeName : cluster.getItems()) {
                errors.appendln("\t" + placeName);
            }
            errors.appendln();
        }
        Report result = new Report();
        result.setTitle("Unknown Places");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Unknown Places") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    private static int sequenceNumber(Cluster<String> cluster) {
        HashSet<String> set = new HashSet<String>();
        for (String string : cluster.getItems()) {
            set.add(string.split("\\s")[0]);
        }
        int result = set.size();
        return result;
    }
}

