/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations.workers;

import fr.devinsy.util.StringList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.tip.puck.graphs.Graph;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Actors;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.workers.AddChildRolesCriteria;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.spacetime.SequenceCensus;
import org.tip.puck.spacetime.SpaceTimeCriteria;
import org.tip.puck.util.ToolBox;

public class RelationWorker {
    public static void addChildRoles(Net net, AddChildRolesCriteria criteria) {
        if (net != null && criteria != null) {
            RelationModel model = net.relationModels().getByName(criteria.getRelationModelName());
            String egoRoleName = criteria.getEgoRoleName();
            StringList roleNames = criteria.getAlterRoleNames();
            int maxAge = criteria.getMaxAge();
            String dateLabel = criteria.getDateLabel();
            if (model != null) {
                model.roles().add(new Role(String.valueOf(egoRoleName) + "_CHILD", 0));
                Relations relations = net.relations().getByModel(model);
                for (Relation event : relations) {
                    Integer eventYear;
                    if (SequenceCensus.isBirth(event) || SequenceCensus.isDeath(event) || (eventYear = IndividualValuator.extractYearAsInt(event.getAttributeValue(dateLabel))) == null) continue;
                    for (Actor actor : event.actors().toList()) {
                        Individual ego;
                        int age;
                        if (!actor.getRole().getName().equals(egoRoleName) || (age = IndividualValuator.ageAtYear(ego = actor.getIndividual(), eventYear).intValue()) <= -1 || age >= maxAge || !event.getRoleNames(ego).contains(egoRoleName) || SequenceCensus.isBirth(event) || SequenceCensus.isDeath(event)) continue;
                        for (String alterRoleName : roleNames) {
                            if (event.getIndividuals(alterRoleName).contains(ego.getFather()) || event.getIndividuals(alterRoleName).contains(ego.getMother())) continue;
                            event.actors().add(new Actor(ego, new Role(String.valueOf(egoRoleName) + "_CHILD")));
                        }
                    }
                }
            }
        }
    }

    public static void addChildRolesOld(Net net, SpaceTimeCriteria criteria) {
        RelationModel model = net.relationModels().getByName(criteria.getRelationModelName());
        String egoRoleName = criteria.getEgoRoleName();
        List<String> roleNames = criteria.getRoleNames();
        int maxAge = criteria.getMaxAge();
        String dateLabel = criteria.getDateLabel();
        if (model != null) {
            model.roles().add(new Role(String.valueOf(egoRoleName) + "_CHILD", 0));
            Relations relations = net.relations().getByModel(model);
            for (Relation event : relations) {
                Integer eventYear;
                if (SequenceCensus.isBirth(event) || SequenceCensus.isDeath(event) || (eventYear = IndividualValuator.extractYearAsInt(event.getAttributeValue(dateLabel))) == null) continue;
                for (Actor actor : event.actors().toList()) {
                    Individual ego;
                    int age;
                    if (!actor.getRole().getName().equals(egoRoleName) || (age = IndividualValuator.ageAtYear(ego = actor.getIndividual(), eventYear).intValue()) <= -1 || age >= maxAge || !event.getRoleNames(ego).contains(egoRoleName) || SequenceCensus.isBirth(event) || SequenceCensus.isDeath(event)) continue;
                    for (String alterRoleName : roleNames) {
                        if (event.getIndividuals(alterRoleName).contains(ego.getFather()) || event.getIndividuals(alterRoleName).contains(ego.getMother())) continue;
                        event.actors().add(new Actor(ego, new Role(String.valueOf(egoRoleName) + "_CHILD")));
                    }
                }
            }
        }
    }

    private static Set<List<String>> getLinkChains(List<String> ancestorList, Actor referent, Actors ascendants, Relation relation, String treeType, int[] maxDegrees) {
        HashSet<List<String>> result = new HashSet<List<String>>();
        Actors dependants = relation.getDependants(referent);
        ascendants.add(referent);
        if (dependants.size() > 0) {
            for (Actor descendant : dependants) {
                if (ascendants.contains(descendant)) {
                    System.err.println("Cyclic referent structure : " + referent + " for " + descendant + " " + referent + " in " + relation);
                    continue;
                }
                ArrayList<String> list = new ArrayList<String>();
                list.addAll(ancestorList);
                Individual individual = descendant.getIndividual();
                if (treeType.equals("GENDER")) {
                    list.add(String.valueOf(individual.getGender().toChar()));
                } else if (treeType.equals("ID")) {
                    list.add(String.valueOf(individual.getId()));
                } else if (treeType.equals("KIN")) {
                    list.add(String.valueOf(individual.getGender().toChar()));
                }
                for (List<String> chain : RelationWorker.getLinkChains(list, descendant, ascendants, relation, treeType, maxDegrees)) {
                    result.add(chain);
                }
            }
        } else {
            result.add(ancestorList);
        }
        return result;
    }

    public static Set<List<String>> getLinkChains(Relation relation, String treeType, String pattern) {
        HashSet<List<String>> result = new HashSet<List<String>>();
        int[] maxDegrees = ToolBox.stringsToInts(pattern);
        for (Actor actor : relation.actors()) {
            Individual referent = actor.getReferent();
            if (referent != null) continue;
            ArrayList<String> ancestorList = new ArrayList<String>();
            Individual individual = actor.getIndividual();
            if (treeType.equals("GENDER")) {
                ancestorList.add(String.valueOf(individual.getGender().toChar()));
            } else if (treeType.equals("ID")) {
                ancestorList.add(String.valueOf(individual.getId()));
            } else if (treeType.equals("KIN")) {
                ancestorList.add(String.valueOf(individual.getGender().toChar()));
            }
            for (List<String> chain : RelationWorker.getLinkChains(ancestorList, actor, new Actors(), relation, treeType, maxDegrees)) {
                result.add(chain);
            }
        }
        return result;
    }

    public static String getLinkChainsAsString(Relation relation, String treeType, String pattern) {
        String result = "";
        Set<List<String>> chains = RelationWorker.getLinkChains(relation, treeType, pattern);
        ArrayList<String> chainsAsStrings = new ArrayList<String>();
        for (List<String> chain : chains) {
            chainsAsStrings.add(chain.toString());
        }
        Collections.sort(chainsAsStrings);
        result = ((Object)chainsAsStrings).toString();
        return result;
    }

    private static String getLinkTree(Actor referent, Actors ascendants, Relation relation, boolean reduced, String treeType, int[] maxDegrees) {
        String result = "";
        Actors dependants = relation.getDependants(referent);
        ascendants.add(referent);
        if (dependants.size() > 0) {
            result = "[";
            ArrayList<String> list = new ArrayList<String>();
            for (Actor descendant : dependants) {
                if (ascendants.contains(descendant)) {
                    System.err.println("Cyclic referent structure : " + referent + " for " + descendant + " " + referent + " in " + relation);
                    continue;
                }
                String item = RelationWorker.getLinkTree(descendant, ascendants, relation, reduced, treeType, maxDegrees);
                if (treeType.equals("GENDER")) {
                    item = String.valueOf(descendant.getIndividual().getGender().toChar()) + item;
                } else if (treeType.equals("ID")) {
                    item = String.valueOf(descendant.getIndividual().getId()) + " " + item;
                } else if (treeType.equals("KIN")) {
                    item = String.valueOf(NetUtils.getAlterRole(descendant.getIndividual(), referent.getIndividual(), maxDegrees, null)) + " " + item;
                }
                if (reduced && list.contains(item)) continue;
                list.add(item);
            }
            Collections.sort(list);
            for (String item : list) {
                result = String.valueOf(result) + item;
            }
            result = String.valueOf(result) + "]";
        }
        return result;
    }

    public static String getLinkTrees(Relation relation, boolean reduced, String treeType, String pattern) {
        String result = "";
        int[] maxDegrees = ToolBox.stringsToInts(pattern);
        ArrayList<String> list = new ArrayList<String>();
        for (Actor actor : relation.actors()) {
            Individual individual = actor.getIndividual();
            Individual referent = actor.getReferent();
            if (referent != null) continue;
            String item = RelationWorker.getLinkTree(actor, new Actors(), relation, reduced, treeType, maxDegrees);
            if (treeType.equals("GENDER")) {
                item = String.valueOf(individual.getGender().toChar()) + item;
            } else if (treeType.equals("ID")) {
                item = String.valueOf(individual.getId()) + " " + item;
            } else if (treeType.equals("KIN")) {
                item = String.valueOf(individual.getGender().toChar()) + " " + item;
            }
            if (reduced && list.contains(item)) continue;
            list.add(item);
        }
        Collections.sort(list);
        for (String item : list) {
            result = String.valueOf(result) + item + " ";
        }
        return result;
    }

    public static Graph<Individual> getReferentGraph(Relation relation) {
        Graph<Individual> result = new Graph<Individual>();
        for (Actor actor : relation.actors()) {
            Individual ego = actor.getIndividual();
            Individual alter = actor.getReferent();
            result.addArc(ego, alter);
        }
        return result;
    }
}

