/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations.workers;

import java.util.ArrayList;
import java.util.List;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.census.workers.CensusCriteria;
import org.tip.puck.census.workers.CensusReporter;
import org.tip.puck.census.workers.CircuitType;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.relations.workers.RelationWorker;
import org.tip.puck.report.Report;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.spacetime.SpaceTimeCriteria;
import org.tip.puck.util.Chronometer;

public class RelationReporter {
    public static Report reportTreeStructure(Segmentation segmentation, SpaceTimeCriteria criteria, Integer time, boolean reducedTrees) throws PuckException {
        if (segmentation == null || criteria.getRelationModelName() == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        Report result = new Report("Cluster Structure " + criteria.getRelationModelName());
        Chronometer chrono = new Chronometer();
        result.setOrigin("Relation reporter");
        Report treeReport = new Report("Link Trees");
        Report chainReport = new Report("Link Chains");
        Relations relations = segmentation.getCurrentRelations().getByModelName(criteria.getRelationModelName()).getByTime(criteria.getDateLabel(), time);
        for (Relation relation : relations.toListSortedByTypeId()) {
            treeReport.outputs().appendln(relation + "\t" + relation.actors().size() + "\t" + RelationWorker.getLinkTrees(relation, reducedTrees, "GENDER", null) + "\t" + RelationWorker.getLinkTrees(relation, reducedTrees, "ID", null) + "\t" + RelationWorker.getLinkTrees(relation, reducedTrees, "KIN", criteria.getPattern()));
            chainReport.outputs().appendln(relation + "\t" + relation.actors().size() + "\t" + RelationWorker.getLinkChainsAsString(relation, "GENDER", null) + "\t" + RelationWorker.getLinkChainsAsString(relation, "ID", null) + "\t" + RelationWorker.getLinkChainsAsString(relation, "KIN", criteria.getPattern()));
        }
        result.outputs().append(treeReport);
        result.outputs().append(chainReport);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static List<Report> reportRelationCensus(Segmentation segmentation, SpaceTimeCriteria criteria) throws PuckException {
        if (segmentation == null || criteria.getRelationModelName() == null || criteria.getEgoRoleName() == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        ArrayList<Report> result = new ArrayList<Report>();
        CensusCriteria censusCriteria = new CensusCriteria();
        censusCriteria.setCircuitType(CircuitType.RING);
        censusCriteria.setClosingRelation(criteria.getRelationModelName());
        censusCriteria.setClosingRelationEgoRole(criteria.getEgoRoleName());
        censusCriteria.setPattern(criteria.getPattern());
        Integer[] times = criteria.getDates();
        for (Relation relation : segmentation.getAllRelations().getByModelName(criteria.getRelationModelName())) {
            relation.updateReferents(criteria.getDefaultReferentRoleName());
        }
        for (String alterRoleName : criteria.getRoleNames()) {
            censusCriteria.setClosingRelationAlterRole(alterRoleName);
            if (times == null) {
                Report report = CensusReporter.reportFindCircuit(segmentation, censusCriteria, null);
                report.setTitle("Relations " + criteria.getEgoRoleName() + " " + alterRoleName);
                result.add(report);
                continue;
            }
            int i = 0;
            while (i < times.length) {
                censusCriteria.setRelationTime(times[i]);
                Report report = CensusReporter.reportFindCircuit(segmentation, censusCriteria, null);
                report.setTitle("Relations " + criteria.getEgoRoleName() + " " + alterRoleName + " " + times[i]);
                result.add(report);
                ++i;
            }
        }
        return result;
    }
}

