/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations.workers;

import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.RoleDefinition;
import org.tip.puck.net.relations.RoleDefinitions;
import org.tip.puck.segmentation.Segmentation;

public class RelationMaker {
    public static void applyModel(Net net, Segmentation segmentation, RelationModel model, int maxDistance) {
        System.out.println("Creating relations " + model.getName());
        for (Individual ego : segmentation.getCurrentIndividuals()) {
            Relation relation = net.createRelation(ego.getId(), "Ego = " + ego.getName() + " " + ego.getId(), model);
            RelationMaker.setPrimaryTerms(ego, relation, model.roleDefinitions());
        }
        int previousActorCount = 0;
        int actorCount = net.relations().getByModel(model).actorCount();
        int distance = 1;
        System.out.println("distance " + distance + " relations added: " + actorCount);
        while (actorCount > previousActorCount && distance < maxDistance) {
            Relation relation;
            for (Individual ego : segmentation.getCurrentIndividuals()) {
                relation = (Relation)ego.relations().getByName(String.valueOf(ego.getId()) + " " + model.getName()).getFirst();
                if (relation == null) continue;
                RelationMaker.setInverseTerms(ego, relation, model.roleDefinitions(), net);
            }
            for (Individual ego : segmentation.getCurrentIndividuals()) {
                relation = (Relation)ego.relations().getByName(String.valueOf(ego.getId()) + " " + model.getName()).getFirst();
                if (relation == null) continue;
                RelationMaker.setCompositeTerms(ego, relation, model.roleDefinitions(), net);
            }
            previousActorCount = actorCount;
            actorCount = net.relations().getByModel(model).actorCount();
            System.out.println("distance " + ++distance + " relations added: " + (actorCount - previousActorCount));
        }
    }

    private static void setPrimaryTerms(Individual ego, Relation relation, RoleDefinitions roleDefinitions) {
        for (RoleDefinition roleDefinition : roleDefinitions) {
            Role role = roleDefinition.role();
            RoleDefinition.Primary primary = roleDefinition.primary();
            if (primary == null || !RelationMaker.genderMatch(roleDefinition.egoGender(), ego.getGender())) continue;
            switch (primary) {
                case PARENT: {
                    if (roleDefinition.alterGender() == Gender.MALE && ego.getFather() != null) {
                        relation.addActor(ego.getFather(), role);
                        break;
                    }
                    if (roleDefinition.alterGender() != Gender.FEMALE || ego.getMother() == null) break;
                    relation.addActor(ego.getMother(), role);
                    break;
                }
                case SIBLING: {
                    for (Individual sibling : ego.siblings()) {
                        if (!RelationMaker.genderMatch(roleDefinition.alterGender(), sibling.getGender())) continue;
                        relation.addActor(sibling, role);
                    }
                    break;
                }
                case SPOUSE: {
                    for (Individual spouse : ego.spouses()) {
                        if (!RelationMaker.genderMatch(roleDefinition.alterGender(), spouse.getGender())) continue;
                        relation.addActor(spouse, role);
                    }
                    break;
                }
            }
            if (relation.actors() == null) continue;
            ego.relations().add(relation);
        }
    }

    private static void setInverseTerms(Individual ego, Relation relation, RoleDefinitions roleDefinitions, Net net) {
        for (RoleDefinition roleDefinition : roleDefinitions) {
            Role role = roleDefinition.role();
            Role inverseRole = roleDefinition.inversion();
            if (inverseRole == null) continue;
            for (Actor alterActor : relation.actors().getByRole(inverseRole.getName())) {
                Relation alterRelation;
                Individual alter = alterActor.getIndividual();
                if (!RelationMaker.genderMatch(roleDefinition.alterGender(), ego.getGender()) || (alterRelation = (Relation)alter.relations().getByName(String.valueOf(alter.getId()) + " " + relation.getModel().getName()).getFirst()).hasActor(ego, role.getName())) continue;
                alterRelation.addActor(ego, role);
            }
        }
    }

    private static void setCompositeTerms(Individual ego, Relation relation, RoleDefinitions roleDefinitions, Net net) {
        for (RoleDefinition roleDefinition : roleDefinitions) {
            Role role = roleDefinition.role();
            if (roleDefinition.composition() == null || roleDefinition.composition().size() != 2) continue;
            Role mediusRole = (Role)roleDefinition.composition().get(0);
            Role alterRole = (Role)roleDefinition.composition().get(1);
            for (Actor mediusActor : relation.actors().getByRole(mediusRole.getName())) {
                Individual medius = mediusActor.getIndividual();
                Relation mediusRelation = (Relation)medius.relations().getByName(String.valueOf(medius.getId()) + " " + relation.getModel().getName()).getFirst();
                for (Actor alterActor : mediusRelation.actors().getByRole(alterRole.getName())) {
                    Individual alter = alterActor.getIndividual();
                    if (!RelationMaker.genderMatch(roleDefinition.alterGender(), alter.getGender()) || relation.hasActor(alter, role.getName())) continue;
                    relation.addActor(alter, role);
                }
            }
        }
    }

    private static boolean genderMatch(Gender alphaGender, Gender betaGender) {
        return alphaGender == null || alphaGender == betaGender;
    }
}

