/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations;

import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.Individual;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.RoleDefinitions;
import org.tip.puck.net.relations.Roles;

public class RelationModel {
    private String name;
    private Roles roles;
    private RoleDefinitions roleDefinitions;
    private String defaultRoleName;

    public RelationModel(RelationModel source) {
        this.name = source.getName();
        this.roles = new Roles(source.roles());
    }

    public RelationModel(String name) {
        this.name = name;
        this.roles = new Roles();
    }

    public String getName() {
        return this.name;
    }

    public Roles roles() {
        return this.roles;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RoleDefinitions roleDefinitions() {
        return this.roleDefinitions;
    }

    public void setRoleDefinitions(RoleDefinitions roleDefinitions) {
        this.roleDefinitions = roleDefinitions;
    }

    public Role role(Individual indi) {
        Role result;
        if (indi == null) {
            result = null;
        } else {
            result = this.roles.getByName(indi.getName());
            if (result == null) {
                result = new Role(indi.getName());
                this.roles.add(result);
            }
        }
        return result;
    }

    public Role role(String item) {
        Role result;
        if (StringUtils.isEmpty((CharSequence)item)) {
            result = null;
        } else {
            result = this.roles.getByName(item);
            if (result == null) {
                result = new Role(item);
                this.roles.add(result);
            }
        }
        return result;
    }

    public String defaultRoleName() {
        return this.defaultRoleName;
    }

    public void setDefaultRoleName(String defaultRoleName) {
        this.defaultRoleName = defaultRoleName;
        if (this.roles.getByName(defaultRoleName) == null) {
            this.roles.add(new Role(defaultRoleName));
        }
    }
}

