/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.paj;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.GraphType;
import org.tip.puck.io.paj.PAJLine;
import org.tip.puck.net.Family;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.util.LogHelper;
import org.tip.puck.util.PuckUtils;

public class PAJFile {
    private static final Logger logger = LoggerFactory.getLogger(PAJFile.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";

    public static String convertToMicrosoftEndOfLine(String source) {
        String result = source.replaceAll("\n", "\r\n");
        return result;
    }

    public static <E> void exportToPajek(Graph<E> source, String fileName, List<String> partitionLabels) throws PuckException {
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(fileName)), DEFAULT_CHARSET_NAME));
                String pajekString = PuckUtils.writePajekNetwork(source, partitionLabels).toString();
                pajekString = PAJFile.convertToMicrosoftEndOfLine(pajekString);
                out.print(pajekString);
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + fileName + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + fileName + "]", new Object[0]);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static void exportToPajek(Net source, String fileName, GraphType graphType, List<String> partitionLabels) throws PuckException {
        PrintWriter out = null;
        try {
            try {
                String pajekString;
                out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(fileName)), DEFAULT_CHARSET_NAME));
                Segmentation segmentation = new Segmentation(source);
                switch (graphType) {
                    case OreGraph: {
                        Graph<Individual> graph = NetUtils.createOreGraph(segmentation);
                        pajekString = PuckUtils.writePajekNetwork(graph, partitionLabels).toString();
                        break;
                    }
                    case PGraph: {
                        Graph<Family> graph = NetUtils.createPGraph(segmentation);
                        pajekString = PuckUtils.writePajekNetwork(graph, partitionLabels).toString();
                        break;
                    }
                    case TipGraph: {
                        Graph<Individual> graph = NetUtils.createTipGraph(segmentation);
                        pajekString = PuckUtils.writePajekNetwork(graph, partitionLabels).toString();
                        break;
                    }
                    default: {
                        throw PuckExceptions.INVALID_PARAMETER.create("Unknown GraphType: [" + (Object)((Object)graphType) + "]", new Object[0]);
                    }
                }
                pajekString = PAJFile.convertToMicrosoftEndOfLine(pajekString);
                out.print(pajekString);
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + fileName + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + fileName + "]", new Object[0]);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static Net load(File file) throws PuckException {
        Net result = PAJFile.load(file, DEFAULT_CHARSET_NAME);
        return result;
    }

    public static Net load(File file, String charsetName) throws PuckException {
        Net result;
        BufferedReader in = null;
        try {
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
                result = PAJFile.read(in);
                result.setLabel(file.getName());
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException exception) {
                logger.warn("Not managed error.");
                exception.printStackTrace();
            }
        }
        return result;
    }

    public static Net read(BufferedReader in) throws PuckException {
        Net result = new Net();
        boolean ended = false;
        Boolean doPermute = null;
        PAJLine.LineType currentHeader = null;
        Integer currentRelationCode = null;
        String currentAttribute = null;
        int currentCardinal = 0;
        int currentDataCount = 0;
        HashMap<Integer, Integer> idTable = new HashMap<Integer, Integer>();
        while (!ended) {
            PAJLine source = PAJFile.readPAJLine(in);
            if (source == null) {
                ended = true;
                continue;
            }
            block0 : switch (source.getType()) {
                case NETWORK_HEADER: {
                    currentHeader = PAJLine.LineType.NETWORK_HEADER;
                    currentRelationCode = null;
                    result.setLabel(source.getLabel());
                    break;
                }
                case PARTITION_HEADER: {
                    currentHeader = PAJLine.LineType.PARTITION_HEADER;
                    currentRelationCode = null;
                    currentAttribute = source.getLabel();
                    break;
                }
                case VECTOR_HEADER: {
                    currentHeader = PAJLine.LineType.VECTOR_HEADER;
                    currentRelationCode = null;
                    currentAttribute = source.getLabel();
                    break;
                }
                case VERTICES_HEADER: {
                    currentHeader = PAJLine.LineType.VERTICES_HEADER;
                    currentRelationCode = null;
                    currentCardinal = source.getCardinal();
                    currentDataCount = 0;
                    break;
                }
                case ARCS_HEADER: {
                    currentHeader = PAJLine.LineType.ARCS_HEADER;
                    currentRelationCode = source.getRelationCode();
                    break;
                }
                case EDGE_HEADER: {
                    currentHeader = PAJLine.LineType.EDGE_HEADER;
                    currentRelationCode = null;
                    break;
                }
                case ARC_EDGE_DATA: {
                    if (currentHeader == PAJLine.LineType.ARCS_HEADER) {
                        if (currentRelationCode == null) {
                            Individual parent = (Individual)result.individuals().getById((Integer)idTable.get(source.getSourceId()));
                            if (parent.isFemale()) {
                                NetUtils.setMotherRelation(result, (Integer)idTable.get(source.getSourceId()), (Integer)idTable.get(source.getTargetId()));
                                break;
                            }
                            NetUtils.setFatherRelation(result, (Integer)idTable.get(source.getSourceId()), (Integer)idTable.get(source.getTargetId()));
                            break;
                        }
                        switch (currentRelationCode) {
                            case 1: {
                                NetUtils.setSpouseRelationAndFixRoles(result, (Integer)idTable.get(source.getSourceId()), (Integer)idTable.get(source.getTargetId()));
                                break block0;
                            }
                            case 2: 
                            case 3: 
                            case 6: {
                                NetUtils.setMotherRelation(result, (Integer)idTable.get(source.getSourceId()), (Integer)idTable.get(source.getTargetId()));
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 7: {
                                NetUtils.setFatherRelation(result, (Integer)idTable.get(source.getSourceId()), (Integer)idTable.get(source.getTargetId()));
                                break block0;
                            }
                        }
                        logger.warn("LINE IGNORED: [" + LogHelper.toString(source) + "]");
                        break;
                    }
                    if (currentHeader == PAJLine.LineType.EDGE_HEADER) {
                        NetUtils.setSpouseRelationAndFixRoles(result, (Integer)idTable.get(source.getSourceId()), (Integer)idTable.get(source.getTargetId()));
                        break;
                    }
                    logger.warn("LINE IGNORED: [" + LogHelper.toString(source) + "]");
                    break;
                }
                case VERTICE_LONG_DATA: {
                    Individual individual;
                    if (doPermute == null) {
                        doPermute = source.getTargetId() == null ? Boolean.valueOf(false) : Boolean.valueOf(true);
                    }
                    if (doPermute.booleanValue() && source.getTargetId() == null) {
                        throw PuckExceptions.BAD_FILE_FORMAT.create("Waiting for numbered names: " + source, new Object[0]);
                    }
                    if (!doPermute.booleanValue()) {
                        source.setTargetId(source.getSourceId());
                    }
                    if ((individual = result.get(source.getTargetId())) == null) {
                        idTable.put(source.getSourceId(), source.getTargetId());
                        individual = new Individual(source.getTargetId());
                        result.individuals().put(individual);
                    }
                    individual.setName(source.getName());
                    switch (source.getShape()) {
                        case ELLIPSE: 
                        case CIRCLE: {
                            individual.setGender(Gender.FEMALE);
                            break block0;
                        }
                        case TRIANGLE: {
                            individual.setGender(Gender.MALE);
                            break block0;
                        }
                    }
                    individual.setGender(Gender.UNKNOWN);
                    break;
                }
                case VERTICE_SHORT_DATA: {
                    ++currentDataCount;
                    if (currentCardinal != result.size()) break;
                    ((Individual)result.individuals().getById((Integer)idTable.get(currentDataCount))).attributes().put(currentAttribute, source.getValue());
                }
            }
        }
        result = NetUtils.buildCleanedNet(result);
        logger.debug("Done.");
        return result;
    }

    public static PAJLine readPAJLine(BufferedReader in) throws PuckException {
        PAJLine result;
        block19: {
            try {
                String line = in.readLine();
                if (line == null) {
                    result = null;
                    break block19;
                }
                if (StringUtils.isBlank((CharSequence)line)) {
                    result = PAJLine.createEmptyLine();
                    break block19;
                }
                if (line.charAt(0) != '*') {
                    if (NumberUtils.isNumber((String)line)) {
                        result = PAJLine.createVertice(line);
                        break block19;
                    }
                    Matcher verticeMatcher = PAJLine.VERTICE_LONG_DATA_PATTERN.matcher(line);
                    if (verticeMatcher.find()) {
                        if (verticeMatcher.groupCount() == 7) {
                            String name;
                            Integer targetId;
                            int sourceId = Integer.parseInt(verticeMatcher.group(1));
                            Matcher nameMatcher = PAJLine.NAME_PATTERN.matcher(verticeMatcher.group(2));
                            if (nameMatcher.find() && nameMatcher.groupCount() == 3) {
                                targetId = Integer.parseInt(nameMatcher.group(3));
                                name = nameMatcher.group(1);
                            } else {
                                targetId = null;
                                name = verticeMatcher.group(2);
                            }
                            PAJLine.Shape shape = verticeMatcher.group(7) == null ? PAJLine.Shape.BOX : PAJLine.Shape.valueOf(verticeMatcher.group(7).toUpperCase());
                            result = PAJLine.createVertice(sourceId, targetId, name, shape);
                            break block19;
                        }
                        throw PuckExceptions.BAD_FILE_FORMAT.create("Vertice data bad format: " + line, new Object[0]);
                    }
                    Matcher arcMatcher = PAJLine.ARC_EDGE_DATA_PATTERN.matcher(line);
                    if (arcMatcher.find() && arcMatcher.groupCount() == 3) {
                        result = PAJLine.createArcEdgeData(Integer.parseInt(arcMatcher.group(1)), Integer.parseInt(arcMatcher.group(2)), Integer.parseInt(arcMatcher.group(3)));
                        break block19;
                    }
                    throw PuckExceptions.BAD_FILE_FORMAT.create("Bad data format: " + line, new Object[0]);
                }
                if (line.startsWith("*Network ") || line.startsWith("*network ")) {
                    result = PAJLine.createNetworkHeader(line.substring(line.indexOf(32) + 1));
                    break block19;
                }
                if (line.startsWith("*Partition ") || line.startsWith("*partition ")) {
                    result = PAJLine.createPartitionHeader(line.substring(line.indexOf(32) + 1));
                    break block19;
                }
                if (line.startsWith("*Vector ") || line.startsWith("*Vector ")) {
                    result = PAJLine.createPartitionHeader(line.substring(line.indexOf(32) + 1));
                    break block19;
                }
                if (line.trim().equals("*Arcs") || line.trim().equals("*arcs")) {
                    result = PAJLine.createArcsHeader();
                    break block19;
                }
                if (line.startsWith("*Arcs") || line.startsWith("*arcs")) {
                    Matcher matcher = PAJLine.ARCS_HEADER_PATTERN.matcher(line);
                    if (matcher.find() && matcher.groupCount() == 2) {
                        result = PAJLine.createArcsHeader(Integer.parseInt(matcher.group(1)), matcher.group(2));
                        break block19;
                    }
                    throw PuckExceptions.BAD_FILE_FORMAT.create("Arcs header bad format: [" + line + "]", new Object[0]);
                }
                if (line.startsWith("*Edges") || line.startsWith("*edges")) {
                    result = PAJLine.createEdgeHeader();
                    break block19;
                }
                if (line.startsWith("*Vertices ") || line.startsWith("*vertices ")) {
                    result = PAJLine.createVerticesHeader(Integer.parseInt(line.substring(line.indexOf(32) + 1)));
                    break block19;
                }
                throw PuckExceptions.BAD_FILE_FORMAT.create("Unknow line type: " + line, new Object[0]);
            }
            catch (IOException exception) {
                throw PuckExceptions.IO_ERROR.create(exception, "Reading line.", new Object[0]);
            }
        }
        return result;
    }
}

