/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.dat;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.net.Family;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;
import org.tip.puck.net.UnionStatus;
import org.tip.puck.util.Numberable;

public class DAT1File {
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final int MAX_LINE_SIZE = 1024;

    public static Net load(File file) throws PuckException {
        Net result = DAT1File.load(file, DEFAULT_CHARSET_NAME);
        return result;
    }

    public static Net load(File file, String charsetName) throws PuckException {
        Net result;
        BufferedReader in = null;
        try {
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
                result = DAT1File.read(in);
                result.setLabel(file.getName());
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        return result;
    }

    public static Net read(BufferedReader in) throws PuckException {
        Numberable source;
        Net result = new Net();
        boolean ended = false;
        while (!ended) {
            source = DAT1File.readIndividualLine(in);
            if (source == null) {
                ended = true;
                continue;
            }
            result.individuals().put(source);
        }
        ended = false;
        while (!ended) {
            source = DAT1File.readFamilyLine(in);
            if (source == null) {
                ended = true;
                continue;
            }
            result.families().put(source);
        }
        return result;
    }

    public static Family readFamilyLine(BufferedReader in) throws PuckException {
        Family result;
        try {
            in.mark(1024);
            String line = DAT1File.readNotEmptyLine(in);
            boolean stop = false;
            while (!stop) {
                in.mark(10000);
                String addLine = DAT1File.readNotEmptyLine(in);
                if (addLine == null || addLine.length() > 1 && addLine.substring(0, 2).equals("M$")) {
                    in.reset();
                    stop = true;
                    continue;
                }
                line = String.valueOf(line) + addLine;
            }
            if (line == "" || line == null) {
                result = null;
            } else {
                String[] tokens = (line = line.replace("S$", "/S$")).split("\\/");
                if (tokens.length > 0) {
                    int id = Integer.parseInt(tokens[0].substring(2));
                    result = new Family(id);
                    result.setUnionStatus(UnionStatus.MARRIED);
                } else {
                    result = null;
                }
                if (tokens.length > 2) {
                    result.setAttribute("MARR_DATE", tokens[1]);
                }
                if (tokens.length > 2) {
                    String pref = "";
                    int i = 2;
                    while (i < tokens.length) {
                        if (tokens[i].length() > 1 && tokens[i].substring(0, 2).equals("S$")) {
                            tokens[i] = tokens[i].substring(2);
                            pref = pref == "" ? "HUSB_" : "WIFE_";
                        }
                        String[] values = tokens[i].split("\\=");
                        result.setAttribute(String.valueOf(pref) + values[0], values[1]);
                        ++i;
                    }
                }
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading individual line.", new Object[0]);
        }
        return result;
    }

    public static Individual readIndividualLine(BufferedReader in) throws PuckException {
        Individual result;
        try {
            in.mark(1024);
            String line = DAT1File.readNotEmptyLine(in);
            boolean stop = false;
            while (!stop) {
                in.mark(10000);
                String addLine = DAT1File.readNotEmptyLine(in);
                if (addLine == null || addLine.length() > 1 && (addLine.substring(0, 2).equals("B$") || addLine.substring(0, 2).equals("M$"))) {
                    in.reset();
                    stop = true;
                    if (addLine.length() <= 1 || !addLine.substring(0, 2).equals("M$")) continue;
                    line = null;
                    continue;
                }
                line = String.valueOf(line) + addLine;
            }
            if (line == "" || line == null) {
                result = null;
            } else {
                String[] tokens = line.split("\\/");
                if (tokens.length > 0) {
                    int id = Integer.parseInt(tokens[0].substring(2));
                    result = new Individual(id);
                } else {
                    result = null;
                }
                if (tokens.length > 1) {
                    result.setAttribute("BIRT_DATE", tokens[1]);
                }
                if (tokens.length > 2) {
                    result.setAttribute("BAP_DATE", tokens[2]);
                }
                if (tokens.length > 3) {
                    int i = 3;
                    while (i < tokens.length) {
                        String[] values = tokens[i].split("\\=");
                        result.setAttribute(values[0], values[1]);
                        if (values[0].equals("prenom")) {
                            result.setName(values[1]);
                        }
                        if (values[0].equals("nomnom")) {
                            result.setName(String.valueOf(result.getName()) + " / " + values[1]);
                        }
                        ++i;
                    }
                }
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading individual line.", new Object[0]);
        }
        return result;
    }

    public static String readNotEmptyLine(BufferedReader in) throws PuckException {
        String result;
        try {
            boolean ended = false;
            result = null;
            while (!ended) {
                String line = in.readLine();
                if (line == null) {
                    ended = true;
                    result = null;
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)line)) continue;
                ended = true;
                result = line;
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading line.", new Object[0]);
        }
        return result;
    }
}

