/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.graphs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.graphs.Link;
import org.tip.puck.graphs.Node;
import org.tip.puck.graphs.NodeComparatorByLabel;

public class Links<E>
extends ArrayList<Link<E>>
implements Iterable<Link<E>> {
    private static final long serialVersionUID = -7834919205208300074L;

    public Links() {
    }

    public Links(int initialCapacity) {
        super(initialCapacity);
    }

    public double averagePositiveWeight() {
        double sum = 0.0;
        int count = 0;
        for (Link link : this) {
            if (link == null || !(link.getWeight() > 0.0)) continue;
            ++count;
            sum += link.getWeight();
        }
        double result = count == 0 ? 0.0 : sum / (double)count;
        return result;
    }

    public double averageWeight() {
        double result = this.size() == 0 ? 0.0 : this.sumWeight() / (double)this.size();
        return result;
    }

    public Link<E> getArc(Node<E> sourceNode, Node<E> targetNode) {
        boolean ended = false;
        Link result = null;
        Iterator iterator = this.iterator();
        while (!ended) {
            if (iterator.hasNext()) {
                Link link = (Link)iterator.next();
                if (link.getType() != Link.LinkType.ARC || link.getSourceNode() != sourceNode || link.getTargetNode() != targetNode) continue;
                ended = true;
                result = link;
                continue;
            }
            ended = true;
            result = null;
        }
        return result;
    }

    public List<Node<E>> getArcs() {
        ArrayList result = new ArrayList();
        for (Link link : this) {
            if (!link.isArc()) continue;
            result.add(link.getSourceNode());
        }
        return result;
    }

    public double getArcWeight(Node<E> sourceNode, Node<E> targetNode) {
        Link<E> link = this.getArc(sourceNode, targetNode);
        double result = link == null ? 0.0 : link.getWeight();
        return result;
    }

    public Links<E> getByTag(String pattern) {
        Links<Link> result = new Links<Link>();
        for (Link link : this) {
            if (!StringUtils.equals((CharSequence)link.getTag(), (CharSequence)pattern)) continue;
            result.add(link);
        }
        return result;
    }

    public Link<E> getEdge(Node<E> sourceNode, Node<E> targetNode) {
        boolean ended = false;
        Link result = null;
        Iterator iterator = this.iterator();
        while (!ended) {
            if (iterator.hasNext()) {
                Link link = (Link)iterator.next();
                if (link.getType() != Link.LinkType.EDGE || link.getSourceNode() != sourceNode || link.getTargetNode() != targetNode) continue;
                ended = true;
                result = link;
                continue;
            }
            ended = true;
            result = null;
        }
        return result;
    }

    public List<Node<E>> getEdges() {
        ArrayList result = new ArrayList();
        for (Link link : this) {
            if (!link.isEdge()) continue;
            result.add(link.getSourceNode());
        }
        return result;
    }

    public double getEdgeWeight(Node<E> sourceNode, Node<E> targetNode) {
        Link<E> link = this.getEdge(sourceNode, targetNode);
        double result = link == null ? 0.0 : link.getWeight();
        return result;
    }

    public Link<E> getLink(Node<E> sourceNode, Node<E> targetNode) {
        boolean ended = false;
        Link result = null;
        Iterator iterator = this.iterator();
        while (!ended) {
            if (iterator.hasNext()) {
                Link link = (Link)iterator.next();
                if (link.getSourceNode() != sourceNode || link.getTargetNode() != targetNode) continue;
                ended = true;
                result = link;
                continue;
            }
            ended = true;
            result = null;
        }
        return result;
    }

    public double getLinkWeight(Node<E> sourceNode, Node<E> targetNode) {
        Link<E> link = this.getLink(sourceNode, targetNode);
        double result = link == null ? 0.0 : link.getWeight();
        return result;
    }

    public List<Node<E>> getSourceNodes() {
        ArrayList result = new ArrayList();
        for (Link link : this) {
            result.add(link.getSourceNode());
        }
        return result;
    }

    public List<Node<E>> getSourceNodesSortedByLabel() {
        List<Node<E>> result = this.getSourceNodes();
        Collections.sort(result, new NodeComparatorByLabel());
        return result;
    }

    public List<String> getTags() {
        ArrayList<String> result = new ArrayList<String>();
        for (Link link : this) {
            if (!StringUtils.isNotBlank((CharSequence)link.getTag()) || result.contains(link.getTag())) continue;
            result.add(link.getTag());
        }
        return result;
    }

    public List<Node<E>> getTargetNodes() {
        ArrayList result = new ArrayList();
        for (Link link : this) {
            result.add(link.getTargetNode());
        }
        return result;
    }

    public List<Node<E>> getTargetNodesSortedByLabel() {
        List<Node<E>> result = this.getTargetNodes();
        Collections.sort(result, new NodeComparatorByLabel());
        return result;
    }

    public boolean isNotEmpty() {
        boolean result = !this.isEmpty();
        return result;
    }

    public double maxWeight() {
        double result;
        if (this.size() == 0) {
            result = 0.0;
        } else {
            result = Double.MIN_VALUE;
            for (Link link : this) {
                if (link == null || !(link.getWeight() > result)) continue;
                result = link.getWeight();
            }
        }
        return result;
    }

    public double minWeight() {
        double result;
        if (this.size() == 0) {
            result = 0.0;
        } else {
            result = Double.MAX_VALUE;
            for (Link link : this) {
                if (link == null || !(link.getWeight() < result)) continue;
                result = link.getWeight();
            }
        }
        return result;
    }

    public double sumWeight() {
        double result = 0.0;
        for (Link link : this) {
            if (link == null) continue;
            result += link.getWeight();
        }
        return result;
    }

    public List<Link<E>> toList() {
        ArrayList<Link<E>> result = new ArrayList<Link<E>>(this);
        return result;
    }
}

