/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.graphs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Link;
import org.tip.puck.graphs.Links;
import org.tip.puck.graphs.Node;
import org.tip.puck.graphs.workers.GraphUtils;
import org.tip.puck.matrix.MatrixStatistics;
import org.tip.puck.net.Individual;
import org.tip.puck.partitions.Partition;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.Value;

public class GraphProfile<E> {
    private Graph<E> mainGraph;
    private List<Node<E>> nodes;
    private Graph<E> graphWithoutEgo;
    private Graph<E> graphWithoutNullValueLines;
    private double[] betweenness;
    private double maxBetweenness;
    private double maxNonEgoBetweenness;
    private double meanBetweenness;
    private Partition<Node<E>> nonEgoComponents;
    private List<E> centralAlters;
    private List<E> centralReferents;
    MatrixStatistics statistics;
    private Node<E> egoNode;
    private int egoNodeId;
    private Map<Value, Double[]> aggregateWeights;
    private Partition<Link<E>> linkPartition;

    public GraphProfile(Graph<E> graph) {
        this.mainGraph = graph;
        this.nodes = graph.getNodes().toListSortedById();
    }

    public GraphProfile(Graph<E> graph, E referent) {
        this.mainGraph = graph;
        this.egoNode = this.mainGraph.getNode(referent);
        this.nodes = graph.getNodes().toListSortedById();
        this.egoNodeId = this.nodes.indexOf(this.egoNode);
    }

    public Graph<E> getGraph() {
        return this.mainGraph;
    }

    public Graph<E> getGraphWithoutEgo() {
        if (this.graphWithoutEgo == null) {
            this.graphWithoutEgo = GraphUtils.cloneWithoutEgo(this.getGraphWithoutNullValueLines(), this.egoNode);
        }
        return this.graphWithoutEgo;
    }

    public int getEgoNodeId() {
        return this.egoNodeId;
    }

    public Graph<E> getGraphWithoutNullValueLines() {
        if (this.graphWithoutNullValueLines == null) {
            this.graphWithoutNullValueLines = GraphUtils.cloneWithoutNullValueLines(this.mainGraph);
        }
        return this.graphWithoutNullValueLines;
    }

    private void setBetweenness() {
        this.betweenness = GraphUtils.betweenness(this.getGraphWithoutNullValueLines());
        this.centralAlters = new ArrayList();
        this.centralReferents = new ArrayList();
        this.maxNonEgoBetweenness = -1.0;
        this.maxBetweenness = -1.0;
        this.meanBetweenness = 0.0;
        int i = 0;
        for (Node<E> node : this.nodes) {
            double nodeBetweenness = this.betweenness[i];
            node.setAttribute("BETWEENNESS", String.valueOf(nodeBetweenness));
            this.meanBetweenness += nodeBetweenness;
            if (i != this.egoNodeId && nodeBetweenness >= this.maxNonEgoBetweenness) {
                if (nodeBetweenness > this.maxNonEgoBetweenness) {
                    this.centralAlters = new ArrayList();
                }
                this.centralAlters.add(node.getReferent());
                this.maxNonEgoBetweenness = nodeBetweenness;
            }
            if (nodeBetweenness >= this.maxBetweenness) {
                if (nodeBetweenness > this.maxBetweenness) {
                    this.centralReferents = new ArrayList();
                }
                this.centralReferents.add(node.getReferent());
                this.maxBetweenness = nodeBetweenness;
            }
            ++i;
        }
        this.meanBetweenness = MathUtils.percent(this.meanBetweenness, (double)(100 * i));
    }

    private void setNonEgoComponents() {
        this.nonEgoComponents = GraphUtils.components(this.getGraphWithoutEgo());
        for (Node<E> item : this.nonEgoComponents.getItems()) {
            Node<E> node = this.mainGraph.getNode(item.getId());
            if (node == null) continue;
            node.setAttribute("COMPONENT", "" + this.nonEgoComponents.getValue(item));
        }
    }

    public double getStatistics(MatrixStatistics.Indicator indicator, MatrixStatistics.Mode mode) {
        if (this.statistics == null) {
            this.statistics = new MatrixStatistics(this.mainGraph);
        }
        double result = this.statistics.get(indicator, mode);
        return result;
    }

    public Partition<Node<E>> getNonEgoComponents() {
        if (this.nonEgoComponents == null) {
            this.setNonEgoComponents();
        }
        return this.nonEgoComponents;
    }

    public double getEgoBetweenness() {
        if (this.betweenness == null) {
            this.setBetweenness();
        }
        return this.betweenness[this.egoNodeId];
    }

    public double getMaxBetweenness() {
        if (this.betweenness == null) {
            this.setBetweenness();
        }
        return this.maxBetweenness;
    }

    public double getMaxNonEgoBetweenness() {
        if (this.betweenness == null) {
            this.setBetweenness();
        }
        return this.maxNonEgoBetweenness;
    }

    public double getMeanBetweenness() {
        if (this.betweenness == null) {
            this.setBetweenness();
        }
        return this.meanBetweenness;
    }

    public double getEccentricity() {
        return MathUtils.jacquard(this.getEgoBetweenness(), this.getMaxNonEgoBetweenness());
    }

    public double nodeCount() {
        return this.mainGraph.nodeCount();
    }

    public double getSizeWithoutEgo() {
        return this.graphWithoutEgo.nodeCount();
    }

    public List<E> getCentralAlters() {
        if (this.betweenness == null) {
            this.setBetweenness();
        }
        return this.centralAlters;
    }

    public List<E> getCentralReferents() {
        if (this.betweenness == null) {
            this.setBetweenness();
        }
        return this.centralReferents;
    }

    public int lineCount() {
        return this.mainGraph.lineCount();
    }

    public int nonNullLineCount() {
        return this.getGraphWithoutNullValueLines().lineCount();
    }

    public double density() {
        return GraphUtils.density(this.mainGraph);
    }

    public double densityWithoutLoops() {
        return GraphUtils.densityWithoutLoops(this.mainGraph);
    }

    public double meanDegree() {
        return GraphUtils.meanDegree(this.mainGraph);
    }

    public double meanDegreeWithoutLoops() {
        return GraphUtils.meanDegreeWithoutLoops(this.mainGraph);
    }

    public double meanDegreeNormalized() {
        return GraphUtils.meanDegreeNormalized(this.mainGraph);
    }

    public double meanDegreeWithoutLoopsNormalized() {
        return GraphUtils.meanDegreeWithoutLoopsNormalized(this.mainGraph);
    }

    public double brokerage() {
        return GraphUtils.unconnectedPairsNormalized(this.graphWithoutEgo);
    }

    public Double efficientSize() {
        return GraphUtils.efficientSize(this.graphWithoutEgo);
    }

    public Double efficiency() {
        return GraphUtils.efficiency(this.graphWithoutEgo);
    }

    public Map<Value, Double[]> aggregateWeights() {
        if (this.aggregateWeights == null) {
            this.aggregateWeights = new HashMap<Value, Double[]>();
            HashMap<Value, Double[]> sumMap = new HashMap<Value, Double[]>();
            Links<E> links = this.mainGraph.getArcs();
            for (Link link : links) {
                int idx;
                double value = link.getWeight();
                Value label = this.linkPartition.getValue(link);
                Double[] values = this.aggregateWeights.get(label);
                Double[] sums = (Double[])sumMap.get(label);
                if (values == null) {
                    values = new Double[]{0.0, 0.0, 0.0, 0.0, 0.0};
                    this.aggregateWeights.put(label, values);
                    sums = new Double[]{0.0, 0.0, 0.0, 0.0, 0.0};
                    sumMap.put(label, sums);
                }
                int egoGender = ((Individual)link.getSourceNode().getReferent()).getGender().toInt();
                int alterGender = ((Individual)link.getTargetNode().getReferent()).getGender().toInt();
                if (egoGender >= 2 || alterGender >= 2) continue;
                int n = idx = egoGender + 2 * alterGender;
                values[n] = values[n] + value;
                values[4] = values[4] + value;
                int n2 = idx;
                sums[n2] = sums[n2] + 1.0;
                sums[4] = sums[4] + 1.0;
            }
            for (Value value : this.aggregateWeights.keySet()) {
                Double[] values = this.aggregateWeights.get(value);
                Double[] sums = (Double[])sumMap.get(value);
                int i = 0;
                while (i < sums.length) {
                    values[i] = MathUtils.percent(values[i], 100.0 * sums[i]);
                    ++i;
                }
                this.aggregateWeights.put(value, values);
            }
        }
        return this.aggregateWeights;
    }

    public Partition<Link<E>> getLinkPartition() {
        return this.linkPartition;
    }

    public void setLinkPartition(Partition<Link<E>> linkPartition) {
        this.linkPartition = linkPartition;
    }
}

