/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.geo;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.List;
import org.tip.puck.geo.GeoLevel;

public class Place {
    String name;
    String geonames1;
    String geonames2;
    String geonames3;
    String countryISO2;
    Integer idGeonames;
    GeoLevel level;
    Place sup;
    Coordinate coordinate;

    public Place(String name) {
        this.name = name;
        this.coordinate = null;
    }

    public Place(GeoLevel level, String name) {
        this(name);
        this.level = level;
    }

    public Place(String name, Coordinate coord) {
        this(name);
        this.coordinate = coord;
    }

    public Place(Integer idGeonames, String name, String geonames1, String geonames2, String geonames3, String countryCode, Coordinate coord) {
        this(name, coord);
        this.geonames1 = geonames1;
        this.geonames2 = geonames2;
        this.geonames3 = geonames3;
        this.countryISO2 = countryCode;
        this.idGeonames = idGeonames;
    }

    public Place getSup() {
        return this.sup;
    }

    public void setSup(Place sup) {
        this.sup = sup;
    }

    public Place getSup(List<String> placenames) {
        Place result = this;
        while (result != null && !placenames.contains(result.getShortName())) {
            result = result.getSup();
        }
        return result;
    }

    public Place atLevel(GeoLevel level) {
        Place result = this;
        while (result != null && result.level != level) {
            result = result.getSup();
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getGeonames1() {
        return this.geonames1;
    }

    public void setGeonames1(String geonames1) {
        this.geonames1 = geonames1;
    }

    public String getGeonames2() {
        return this.geonames2;
    }

    public void setGeonames2(String geonames2) {
        this.geonames2 = geonames2;
    }

    public String getGeonames3() {
        return this.geonames3;
    }

    public void setGeonames3(String geonames3) {
        this.geonames3 = geonames3;
    }

    public String getCountry_ISO2() {
        return this.countryISO2;
    }

    public void setCountry_ISO2(String country_ISO2) {
        this.countryISO2 = country_ISO2;
    }

    public Integer getIdGeonames() {
        return this.idGeonames;
    }

    public void setIdGeonames(Integer idGeonames) {
        this.idGeonames = idGeonames;
    }

    public String getShortName() {
        String result = null;
        if (this.name != null) {
            result = this.name.split("\\/")[0].trim();
        }
        return result;
    }

    public GeoLevel getLevel() {
        return this.level;
    }

    public void setLevel(GeoLevel level) {
        this.level = level;
    }

    public String toString() {
        return this.getId();
    }

    public int compareByLevel(Place place) {
        int result = this.level.compareTo(place.level);
        return result;
    }

    public String getId() {
        String result = this.sup == null ? this.name : String.valueOf(this.name) + " / " + this.sup.name;
        return result;
    }

    public Coordinate getCoordinate() {
        return this.coordinate;
    }

    public void setCoordinate(Coordinate coordinate) {
        this.coordinate = coordinate;
    }
}

