/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.alliancenets;

import org.tip.puck.alliancenets.AllianceGen;
import org.tip.puck.alliancenets.AllianceNet;
import org.tip.puck.alliancenets.TopologicalIndices;
import org.tip.puck.evo.EvoGen;
import org.tip.puck.evo.EvoGenCallbacks;
import org.tip.puck.evo.Generator;

public class EvoAllianceGenNoCLI
implements EvoGenCallbacks {
    private AllianceGen gen;
    private TopologicalIndices targIndices;
    private int targNodeCount;
    private int targEdgeCount;
    private int nodeCount;
    private int edgeCount;
    private int bestCount;

    public EvoAllianceGenNoCLI(AllianceNet targNet) {
        this.targIndices = this.genIndices(targNet);
        this.nodeCount = targNet.getNodeCount();
        this.edgeCount = targNet.getEdgeCount();
        this.targNodeCount = this.nodeCount;
        this.targEdgeCount = this.edgeCount;
        this.gen = new AllianceGen(this.nodeCount, this.edgeCount, this.targIndices);
        this.bestCount = 0;
    }

    @Override
    public Generator baseGenerator() {
        return this.gen;
    }

    @Override
    public double computeFitness(Generator gen) {
        AllianceGen allGen = (AllianceGen)gen;
        allGen.run();
        AllianceNet allianceNet = allGen.getNet();
        TopologicalIndices indices = new TopologicalIndices(allianceNet);
        allGen.setIndices(indices);
        double dist = indices.distance(this.targIndices);
        if (Double.isNaN(dist)) {
            return Double.POSITIVE_INFINITY;
        }
        return dist;
    }

    private TopologicalIndices genIndices(AllianceNet allianceNet) {
        return new TopologicalIndices(allianceNet);
    }

    @Override
    public String infoString() {
        String str = "target net node count: " + this.targNodeCount + "\n";
        str = String.valueOf(str) + "target net edge count: " + this.targEdgeCount + "\n";
        str = String.valueOf(str) + "generated nets node count: " + this.nodeCount + "\n";
        str = String.valueOf(str) + "generated nets edge count: " + this.edgeCount + "\n";
        return str;
    }

    @Override
    public void onGeneration(EvoGen evo) {
        AllianceGen bestGen = (AllianceGen)evo.getBestGenerator();
        System.out.println(this.targIndices);
        System.out.println(evo.getCurgen() + "," + evo.getBestFitness() + "," + evo.getBestGenFitness() + "," + bestGen.getIndices().getEndogamousPercentage() + "," + bestGen.getIndices().getNetworkConcentration() + "," + bestGen.getIndices().getEndogamicNetworkConcentration() + "," + bestGen.getIndices().getNetworkSymmetry() + "," + bestGen.getIndices().getParallels() + "," + bestGen.getIndices().getCrosses() + "," + bestGen.getIndices().getLoopTri() + "," + bestGen.getIndices().getTranTri() + "," + evo.getBestGenerator().genotypeSize() + "," + evo.getMeanGenoSize() + "," + evo.getGenTime() + "," + evo.getSimTime() + "," + evo.getFitTime() + "\n");
    }

    @Override
    public void onNewBest(EvoGen evo) {
        Generator bestGen = evo.getBestGenerator();
        ++this.bestCount;
    }
}

