/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.alliancenets;

import java.io.BufferedWriter;
import java.io.FileWriter;
import org.tip.puck.alliancenets.AllianceGen;
import org.tip.puck.alliancenets.AllianceNet;
import org.tip.puck.alliancenets.TopologicalIndices;
import org.tip.puck.evo.EvoGen;
import org.tip.puck.evo.EvoGenCallbacks;
import org.tip.puck.evo.Generator;

public class EvoAllianceGen
implements EvoGenCallbacks {
    private String outDir;
    private AllianceGen gen;
    private TopologicalIndices targIndices;
    private int targNodeCount;
    private int targEdgeCount;
    private int nodeCount;
    private int edgeCount;
    private int bestCount;

    public EvoAllianceGen(AllianceNet targNet, String outDir) {
        this.outDir = outDir;
        this.targIndices = this.genIndices(targNet);
        System.out.println(this.targIndices);
        this.nodeCount = targNet.getNodeCount();
        this.edgeCount = targNet.getEdgeCount();
        this.targNodeCount = this.nodeCount;
        this.targEdgeCount = this.edgeCount;
        this.gen = new AllianceGen(this.nodeCount, this.edgeCount, this.targIndices);
        this.bestCount = 0;
        try {
            FileWriter fwriter = new FileWriter(String.valueOf(outDir) + "/evo.csv");
            BufferedWriter writer = new BufferedWriter(fwriter);
            writer.write("gen,best_fit,best_gen_fit,best_ep,best_nc,best_enc,best_ns,best_parallels,best_crosses,best_tri_loops,best_tri_trans,best_geno_size,mean_geno_size,gen_comp_time,sim_comp_time,fit_comp_time\n");
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Generator baseGenerator() {
        return this.gen;
    }

    @Override
    public double computeFitness(Generator gen) {
        AllianceGen allGen = (AllianceGen)gen;
        allGen.run();
        AllianceNet allianceNet = allGen.getNet();
        TopologicalIndices indices = new TopologicalIndices(allianceNet);
        allGen.setIndices(indices);
        double dist = indices.distance(this.targIndices);
        if (Double.isNaN(dist)) {
            return Double.POSITIVE_INFINITY;
        }
        return dist;
    }

    @Override
    public void onNewBest(EvoGen evo) {
        String suffix = this.bestCount + "_gen" + evo.getCurgen();
        Generator bestGen = evo.getBestGenerator();
        System.out.println("targ: " + this.targIndices);
        System.out.println("best: " + ((AllianceGen)bestGen).getIndices());
        try {
            FileWriter fwriter = new FileWriter(String.valueOf(this.outDir) + "/newbest.log", true);
            BufferedWriter writer = new BufferedWriter(fwriter);
            writer.write("#gen " + evo.getCurgen() + "\n");
            writer.write("targ: " + this.targIndices + "\n");
            writer.write("best: " + ((AllianceGen)bestGen).getIndices() + "\n");
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ((AllianceGen)bestGen).getNet().save(String.valueOf(this.outDir) + "/bestnet" + suffix + ".txt");
        ((AllianceGen)bestGen).getNet().save(String.valueOf(this.outDir) + "/bestnet" + ".txt");
        bestGen.getProgset().write(String.valueOf(this.outDir) + "/bestprog" + suffix + ".txt");
        bestGen.getProgset().write(String.valueOf(this.outDir) + "/bestprog" + ".txt");
        ++this.bestCount;
    }

    @Override
    public void onGeneration(EvoGen evo) {
        AllianceGen bestGen = (AllianceGen)evo.getBestGenerator();
        try {
            FileWriter fwriter = new FileWriter(String.valueOf(this.outDir) + "/evo.csv", true);
            BufferedWriter writer = new BufferedWriter(fwriter);
            writer.write(evo.getCurgen() + "," + evo.getBestFitness() + "," + evo.getBestGenFitness() + "," + bestGen.getIndices().getEndogamousPercentage() + "," + bestGen.getIndices().getNetworkConcentration() + "," + bestGen.getIndices().getEndogamicNetworkConcentration() + "," + bestGen.getIndices().getNetworkSymmetry() + "," + bestGen.getIndices().getParallels() + "," + bestGen.getIndices().getCrosses() + "," + bestGen.getIndices().getLoopTri() + "," + bestGen.getIndices().getTranTri() + "," + evo.getBestGenerator().genotypeSize() + "," + evo.getMeanGenoSize() + "," + evo.getGenTime() + "," + evo.getSimTime() + "," + evo.getFitTime() + "\n");
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(evo.getCurgen() + "," + evo.getBestFitness() + "," + evo.getBestGenFitness() + "," + bestGen.getIndices().getEndogamousPercentage() + "," + bestGen.getIndices().getNetworkConcentration() + "," + bestGen.getIndices().getEndogamicNetworkConcentration() + "," + bestGen.getIndices().getNetworkSymmetry() + "," + bestGen.getIndices().getParallels() + "," + bestGen.getIndices().getCrosses() + "," + bestGen.getIndices().getLoopTri() + "," + bestGen.getIndices().getTranTri() + "," + evo.getBestGenerator().genotypeSize() + "," + evo.getMeanGenoSize() + "," + evo.getGenTime() + "," + evo.getSimTime() + "," + evo.getFitTime() + "\n");
    }

    private TopologicalIndices genIndices(AllianceNet allianceNet) {
        return new TopologicalIndices(allianceNet);
    }

    @Override
    public String infoString() {
        String str = "target net node count: " + this.targNodeCount + "\n";
        str = String.valueOf(str) + "target net edge count: " + this.targEdgeCount + "\n";
        str = String.valueOf(str) + "generated nets node count: " + this.nodeCount + "\n";
        str = String.valueOf(str) + "generated nets edge count: " + this.edgeCount + "\n";
        return str;
    }
}

