/*
 * Decompiled with CFR 0.152.
 */
package oldcore.calc;

import java.util.Comparator;
import oldcore.util.Mat;
import oldcore.util.Trafo;
import org.tip.puck.net.Individual;

public class VectorComparator
implements Comparator<Object> {
    private int type;

    private static int getLength(int i) {
        int a = Math.abs(i);
        return new Double(Math.floor(Math.log(a + 1) / Math.log(2.0))).intValue() - 1;
    }

    private static int getLength(int[] v) {
        int j = 0;
        int[] nArray = v;
        int n = v.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            j += VectorComparator.getLength(i);
            ++n2;
        }
        return j + v.length / 2 - 1;
    }

    public static int[][] getReducedVector(int[] vec) {
        int[][] c = new int[2][vec.length];
        int i = 0;
        while (i < vec.length) {
            int a = Math.abs(vec[i]);
            int d = new Double(Math.floor(Math.log(a + 1) / Math.log(2.0))).intValue();
            int k = Mat.pow2(d);
            int r = a - k + 1;
            c[1][i] = new Long(Math.round(new Double(r) / new Double(k))).intValue();
            c[0][i] = a - (c[1][i] + 1) * k / 2;
            if (vec[i] < 0) {
                c[1][i] = -1;
            }
            ++i;
        }
        return c;
    }

    private int compare(int[] v1, int[] v2, int mode) {
        if (mode == 0) {
            return Math.abs(v2[0] % 2) - Math.abs(v1[0] % 2);
        }
        if (mode == 1) {
            return Mat.compareAbs(v1.length, v2.length);
        }
        if (mode == 2) {
            return Mat.compareAbs(VectorComparator.getLength(v1), VectorComparator.getLength(v2));
        }
        if (mode == 3) {
            int i = 0;
            while (i < v1.length / 2) {
                int b;
                int a = VectorComparator.getLength(v1[2 * i]);
                if (a != (b = VectorComparator.getLength(v2[2 * i]))) {
                    return Mat.compareAbs(b, a);
                }
                ++i;
            }
            return 0;
        }
        if (mode == 4) {
            return Mat.compare(-Math.abs(Mat.compareAbs(v2[0] % 2, v2[v2.length - 1] % 2)), -Math.abs(Mat.compareAbs(v1[0] % 2, v1[v1.length - 1] % 2)));
        }
        if (mode == 5) {
            return Math.abs(v2[0] % 2) - Math.abs(v1[0] % 2);
        }
        int[][] red1 = VectorComparator.getReducedVector(v1);
        int[][] red2 = VectorComparator.getReducedVector(v2);
        int i = 0;
        while (i < v1.length) {
            int c;
            int j = i + 1 - 2 * (i % 2);
            if (red1[0][j] == 0 || red2[0][j] == 0 ? (c = Mat.compare(v1[i], v2[i])) != 0 : (c = Mat.compare(red1[0][i], red2[0][i])) != 0) {
                return c;
            }
            ++i;
        }
        i = 0;
        while (i < v1.length) {
            int c = Mat.compare(red1[1][i], red2[1][i]);
            if (c != 0) {
                return c;
            }
            ++i;
        }
        return 0;
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (this.type == 0) {
            int i = 0;
            while (i < 3) {
                int c = this.compare(o1, o2, i);
                if (c != 0) {
                    return c;
                }
                ++i;
            }
            return 0;
        }
        if (this.type == -1) {
            return this.compare(((Individual)o1).getId(), ((Individual)o2).getId(), 0);
        }
        if (this.type == -2) {
            int[] a = (int[])o1;
            int[] b = (int[])o2;
            int i = 0;
            while (i < a.length) {
                if (a[i] > b[i]) {
                    return 1;
                }
                if (b[i] > a[i]) {
                    return -1;
                }
                ++i;
            }
            return 0;
        }
        return this.compare((int[])o1, (int[])o2, this.type == 7);
    }

    public int compare(int[] o1, int[] o2, boolean maleEgoFirst) {
        int k = 0;
        if (!maleEgoFirst) {
            k = 1;
        }
        int i = k;
        while (i < 7) {
            int c;
            if (!(!maleEgoFirst && i == 5 || this.type == 4 && i == 4 || (c = this.compare(o1, o2, i)) == 0)) {
                return c;
            }
            ++i;
        }
        return 0;
    }

    private int compare(Object o1, Object o2, int mode) {
        if (mode == 0) {
            try {
                return Trafo.asInt(o1).compareTo(Trafo.asInt(o2));
            }
            catch (ClassCastException cce) {
                return 0;
            }
            catch (NumberFormatException nfe1) {
                return Trafo.asString(o1).compareTo(Trafo.asString(o2));
            }
        }
        if (mode == 1) {
            try {
                return this.getFirstInt(o1).compareTo(this.getFirstInt(o2));
            }
            catch (NumberFormatException nfe) {
                return 0;
            }
        }
        return Trafo.asString(o1).compareTo(Trafo.asString(o2));
    }

    private Integer getFirstInt(Object o) {
        return Integer.parseInt(Trafo.asString(o).split(" ")[0]);
    }
}

