package org.tip.puckgui;

import org.tip.puck.census.workers.CensusCriteria;
import org.tip.puck.graphs.random.RandomCriteria;
import org.tip.puck.partitions.graphs.RandomAllianceNetworkByAgentSimulationVariationsCriteria;
import org.tip.puck.partitions.graphs.RandomAllianceNetworkByRandomDistributionCriteria;
import org.tip.puck.partitions.graphs.VirtualFieldworkVariationsCriteria;
import org.tip.puckgui.views.GenerateRulesCriteria;
import org.tip.puckgui.views.RandomCorpusCriteria;
import org.tip.puckgui.views.RandomPermutationCriteria;
import org.tip.puckgui.views.ReshufflingCriteria;

/**
 * 
 * @author TIP
 * 
 */
public class Preferences {

	private Language language;
	private boolean autoLoadLastFile;
	private CensusCriteria censusCriteria;
	private CensusCriteria differentialCensusCriteria;
	private RandomCriteria agentSimulationCriteria;
	private RandomCriteria virtualFieldworkCriteria;
	private RandomAllianceNetworkByAgentSimulationVariationsCriteria agentSimulationVariationsCriteria;
	private VirtualFieldworkVariationsCriteria virtualFieldworkVariationsCriteria;
	private RandomPermutationCriteria randomPermutationCriteria;
	private ReshufflingCriteria reshufflingCriteria;
	private RandomAllianceNetworkByRandomDistributionCriteria randomDistributionCriteria;
	private GenerateRulesCriteria generateRulesCriteria;
	private RandomCorpusCriteria randomCorpusCriteria;
	private InputSettings inputSettings;

	/**
	 * Sets the default preferences.
	 */
	public Preferences() {
		this.language = Language.ENGLISH;
		this.autoLoadLastFile = false;
		this.censusCriteria = new CensusCriteria();
		this.differentialCensusCriteria = new CensusCriteria();
		this.agentSimulationCriteria = new RandomCriteria();
		this.virtualFieldworkCriteria = new RandomCriteria();
		this.agentSimulationVariationsCriteria = new RandomAllianceNetworkByAgentSimulationVariationsCriteria();
		this.virtualFieldworkVariationsCriteria = new VirtualFieldworkVariationsCriteria();
		this.randomPermutationCriteria = new RandomPermutationCriteria();
		this.reshufflingCriteria = new ReshufflingCriteria();
		this.randomDistributionCriteria = new RandomAllianceNetworkByRandomDistributionCriteria();
		this.generateRulesCriteria = new GenerateRulesCriteria();
		this.randomCorpusCriteria = new RandomCorpusCriteria();
		this.inputSettings = new InputSettings();
	}

	public RandomCriteria getAgentSimulationCriteria() {
		return agentSimulationCriteria;
	}

	public RandomAllianceNetworkByAgentSimulationVariationsCriteria getAgentSimulationVariationsCriteria() {
		return agentSimulationVariationsCriteria;
	}

	public CensusCriteria getCensusCriteria() {
		return censusCriteria;
	}

	public CensusCriteria getDifferentialCensusCriteria() {
		return differentialCensusCriteria;
	}

	public GenerateRulesCriteria getGenerateRulesCriteria() {
		return generateRulesCriteria;
	}

	public InputSettings getInputSettings() {
		return inputSettings;
	}

	public Language getLanguage() {
		return language;
	}

	public RandomCorpusCriteria getRandomCorpusMASCriteria() {
		return randomCorpusCriteria;
	}

	public RandomAllianceNetworkByRandomDistributionCriteria getRandomDistributionCriteria() {
		return randomDistributionCriteria;
	}

	public RandomPermutationCriteria getRandomPermutationCriteria() {
		return randomPermutationCriteria;
	}

	public ReshufflingCriteria getReshufflingCriteria() {
		return reshufflingCriteria;
	}

	public RandomCriteria getVirtualFieldworkCriteria() {
		return virtualFieldworkCriteria;
	}

	public VirtualFieldworkVariationsCriteria getVirtualFieldworkVariationsCriteria() {
		return virtualFieldworkVariationsCriteria;
	}

	public boolean isAutoLoadLastFile() {
		return autoLoadLastFile;
	}

	public void setAgentSimulationCriteria(final RandomCriteria agentSimulationCriteria) {
		this.agentSimulationCriteria = agentSimulationCriteria;
	}

	public void setAgentSimulationVariationsCriteria(final RandomAllianceNetworkByAgentSimulationVariationsCriteria agentSimulationVariationsCriteria) {
		this.agentSimulationVariationsCriteria = agentSimulationVariationsCriteria;
	}

	public void setAutoLoadLastFile(final boolean autoLoadLastFile) {
		this.autoLoadLastFile = autoLoadLastFile;
	}

	public void setCensusCriteria(final CensusCriteria censusCriteria) {
		this.censusCriteria = censusCriteria;
	}

	public void setDifferentialCensusCriteria(final CensusCriteria differentialCensusCriteria) {
		this.differentialCensusCriteria = differentialCensusCriteria;
	}

	public void setGenerateRulesCriteria(final GenerateRulesCriteria generateRulesCriteria) {
		this.generateRulesCriteria = generateRulesCriteria;
	}

	public void setInputSettings(final InputSettings inputSettings) {
		this.inputSettings = inputSettings;
	}

	public void setLanguage(final Language language) {
		this.language = language;
	}

	public void setRandomCorpusCriteria(final RandomCorpusCriteria randomCorpusCriteria) {
		this.randomCorpusCriteria = randomCorpusCriteria;
	}

	public void setRandomDistributionCriteria(final RandomAllianceNetworkByRandomDistributionCriteria randomDistributionCriteria) {
		this.randomDistributionCriteria = randomDistributionCriteria;
	}

	public void setRandomPermutationCriteria(final RandomPermutationCriteria randomPermutationCriteria) {
		this.randomPermutationCriteria = randomPermutationCriteria;
	}

	public void setReshufflingCriteria(final ReshufflingCriteria reshufflingCriteria) {
		this.reshufflingCriteria = reshufflingCriteria;
	}

	public void setVirtualFieldworkCriteria(final RandomCriteria virtualFieldworkCriteria) {
		this.virtualFieldworkCriteria = virtualFieldworkCriteria;
	}

	public void setVirtualFieldworkVariationsCriteria(final VirtualFieldworkVariationsCriteria virtualFieldworkVariationsCriteria) {
		this.virtualFieldworkVariationsCriteria = virtualFieldworkVariationsCriteria;
	}
}
