package org.tip.puck.statistics;

import java.util.ArrayList;
import java.util.List;

import org.tip.puck.partitions.PartitionCriteria;

/**
 * 
 * @author TIP
 */
public class StatisticsCriteria {
	private boolean genderBIASWeight;
	private boolean genderBIASNetWeight;
	private boolean components;
	private boolean differentialDensity;
	private boolean genealogicalCompleteness;
	private boolean fratryDistribution;
	private boolean meanClusterValues;
	private boolean fourCousinMarriages;
	private boolean ancestorTypes;
	private boolean consanguineChains;
	private int ancestorTypesDegree;
	private int consanguineDegree;
	private List<PartitionCriteria> partitionCriterias;
	private PartitionCriteria splitCriteria;
	private String placeParameter;

	/**
	 * 
	 */
	public StatisticsCriteria() {
		this.ancestorTypesDegree = 3;
		this.consanguineDegree = 3;
		this.partitionCriterias = new ArrayList<PartitionCriteria>();
		this.partitionCriterias.add(PartitionCriteria.createRaw("GENDER"));
		this.splitCriteria = PartitionCriteria.createRaw("GENDER");
	}

	public int getAncestorTypesDegree() {
		return ancestorTypesDegree;
	}

	public int getConsanguineDegree() {
		return consanguineDegree;
	}

	public List<PartitionCriteria> getPartitionCriterias() {
		return partitionCriterias;
	}

	public PartitionCriteria getSplitCriteria() {
		return splitCriteria;
	}

	public boolean isAncestorTypes() {
		return ancestorTypes;
	}

	public boolean isComponents() {
		return components;
	}

	public boolean isConsanguineChains() {
		return consanguineChains;
	}

	public boolean isDifferentialDensity() {
		return differentialDensity;
	}

	public boolean isFourCousinMarriages() {
		return fourCousinMarriages;
	}

	public boolean isFratryDistribution() {
		return fratryDistribution;
	}

	public boolean isGenderBIASNetWeight() {
		return genderBIASNetWeight;
	}

	public boolean isGenderBIASWeight() {
		return genderBIASWeight;
	}

	public boolean isGenealogicalCompleteness() {
		return genealogicalCompleteness;
	}

	public boolean isMeanClusterValues() {
		return meanClusterValues;
	}

	public void setAncestorTypes(final boolean value) {
		this.ancestorTypes = value;
	}

	public void setAncestorTypesDegree(final int value) {
		this.ancestorTypesDegree = value;
	}

	public void setComponents(final boolean components) {
		this.components = components;
	}

	public void setConsanguineChains(final boolean consanguineChains) {
		this.consanguineChains = consanguineChains;
	}

	public void setConsanguineDegree(final int consanguineDegree) {
		this.consanguineDegree = consanguineDegree;
	}

	public void setDifferentialDensity(final boolean differentialDensity) {
		this.differentialDensity = differentialDensity;
	}

	public void setFourCousinMarriages(final boolean fourCousinRelations) {
		this.fourCousinMarriages = fourCousinRelations;
	}

	public void setFratryDistribution(final boolean fratryDistribution) {
		this.fratryDistribution = fratryDistribution;
	}

	public void setGenderBIASNetWeight(final boolean genderBIASNetWeight) {
		this.genderBIASNetWeight = genderBIASNetWeight;
	}

	public void setGenderBIASWeight(final boolean genderBIASWeight) {
		this.genderBIASWeight = genderBIASWeight;
	}

	public void setGenealogicalCompleteness(final boolean genealogicalCompleteness) {
		this.genealogicalCompleteness = genealogicalCompleteness;
	}

	public void setMeanClusterValues(final boolean meanClusterValues) {
		this.meanClusterValues = meanClusterValues;
	}

	public void setSplitCriteria(final PartitionCriteria splitPartitionCriteria) {
		this.splitCriteria = splitPartitionCriteria;
	}

	public String getPlaceParameter() {
		return placeParameter;
	}

	public void setPlaceParameter(String placeParameter) {
		this.placeParameter = placeParameter;
	}
	
	
}
