package org.tip.puck.spaces;

import java.util.HashMap;
import java.util.Map;

import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.RelationValuator;
import org.tip.puck.util.Numberable;

public class Space implements Numberable {
	
	int time;
	Map<Individual,Relation> states;
	String label;
	Individuals population;
	
	public Space (int time, String relationModelName){
		this.time = time;
		population = new Individuals();
		states = new HashMap<Individual,Relation>();
		label = relationModelName+" "+time;
	}
	
	public int getId(){
		return time;
	}
	
	public Relation getState (Individual ego){
		return states.get(ego);
	}
	
	public void setId(int time){
		this.time = time;
	}
	
	@Override
	public String hashKey() {
		return time + "";
	}
	
	public void put(Individual ego, Relation state){
		population.put(ego);
		states.put(ego, state);
	}

	public Individuals population() {
		return population;
	}
	
	public Relations states(){
		Relations result;
		
		result = new Relations();
		for (Relation state : states.values()){
			result.put(state);
		}
		//
		return result;
	}
	
	public String getLabel(){
		return label;
	}
	
	public boolean isIndividualLabel(String label){
		
		return IndividualValuator.getAttributeLabels(population).contains(label);

	}
	
	public boolean isStateLabel(String label){
		
		return RelationValuator.getAttributeLabels(states()).contains(label);

	}
	

	
	


}
