package org.tip.puck.net.relations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.tip.puck.graphs.Graph;
import org.tip.puck.net.Individual;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.util.ToolBox;

public class RelationWorker {
	
	public static String getLinkTrees (Relation relation, boolean reduced, String treeType, String pattern){
		String result;

		result = "";
		
		int[] maxDegrees = ToolBox.stringsToInts(pattern);
		
		List<String> list = new ArrayList<String>();
		for (Actor actor : relation.actors()){
			Individual individual = actor.getIndividual();
			Individual referent = actor.getReferent();
			if (referent == null){
				String item = getLinkTree(actor, new Actors(), relation, reduced, treeType, maxDegrees);
				if (treeType.equals("GENDER")){
					item = individual.getGender().toChar()+item;
				} else if (treeType.equals("ID")){
					item = individual.getId()+" "+item;
				} else if (treeType.equals("KIN")){
					item = individual.getGender().toChar()+" "+item;
				}
				if (!reduced || !list.contains(item)){
					list.add(item);
				}
			}
		}
		Collections.sort(list);
		for (String item : list){
			result+=item+" ";
		}
		
		//
		return result;
	}
	
	public static Graph<Individual> getReferentGraph(Relation relation){
		Graph<Individual> result;
		
		result = new Graph<Individual>();
		for (Actor actor : relation.actors()){
			Individual ego = actor.getIndividual();
			Individual alter = actor.getReferent();
			result.addArc(ego, alter);
		}
		//
		return result;
	}
	
	private static String getLinkTree(Actor referent, Actors ascendants, Relation relation, boolean reduced, String treeType, int[] maxDegrees){
		String result;
		
		result = "";
		
		Actors dependants = relation.getDependants(referent);
		ascendants.add(referent);
		
		if (dependants.size()>0){
			result = "[";
			List<String> list = new ArrayList<String>();
			for (Actor descendant : dependants){
				if (ascendants.contains(descendant)){
					System.err.println("Cyclic referent structure : "+referent+" for "+descendant+" "+referent+" in "+relation);
				} else {
					String item = getLinkTree(descendant, ascendants, relation, reduced, treeType, maxDegrees); 
					if (treeType.equals("GENDER")){
						item = descendant.getIndividual().getGender().toChar()+item;
					} else if (treeType.equals("ID")){
						item = descendant.getIndividual().getId()+" "+item;
					} else if (treeType.equals("KIN")){
						item = NetUtils.getAlterRole(descendant.getIndividual(), referent.getIndividual(), maxDegrees, null)+" "+item;
					}
					if (!reduced || !list.contains(item)){
						list.add(item);
					}
				}
			}
			Collections.sort(list);
			for (String item : list){
				result+=item;
			}
			result += "]";
		}
		//
		return result;
	}
	
	
/*	public static String getLinkTrees (Individuals individuals, String relationModelName, String egoRoleName, String alterRoleName, String attributeLabel, Integer time, boolean reduced){
		String result;

		result = "";
		
		List<String> list = new ArrayList<String>();
		for (Individual individual : individuals){
			Individuals ascendants = individual.getRelated(relationModelName, egoRoleName, alterRoleName, attributeLabel, time);
			if (ascendants.size() == 0){
				String item = individual.getGender().toChar()+getLinkTree(individual, relationModelName, alterRoleName, egoRoleName, attributeLabel, time, reduced);
				if (!reduced || !list.contains(item)){
					list.add(item);
				}
			}
		}
		Collections.sort(list);
		for (String item : list){
			result+=item+" ";
		}
		
		
		//
		return result;
	}
	
	private static String getLinkTree(Individual individual, String relationModelName, String egoRoleName, String alterRoleName, String attributeLabel, Integer time, boolean reduced){
		String result;
		
		result = "";
		
		Individuals descendants = individual.getRelated(relationModelName, egoRoleName, alterRoleName, attributeLabel, time);
		
		if (descendants.size()>0){
			result = "[";
			List<String> list = new ArrayList<String>();
			for (Individual descendant : descendants){
				String item = descendant.getGender().toChar()+getLinkTree(descendant, relationModelName, egoRoleName, alterRoleName, attributeLabel, time, reduced); 
				if (!reduced || !list.contains(item)){
					list.add(item);
				}
			}
			Collections.sort(list);
			for (String item : list){
				result+=item;
			}
			result += "]";
		}
		//
		return result;
	}*/

}
