package org.tip.puck.net.relations;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import org.apache.commons.lang3.StringUtils;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.census.workers.CensusCriteria;
import org.tip.puck.census.workers.CensusReporter;
import org.tip.puck.census.workers.CircuitType;
import org.tip.puck.graphs.GraphProfile;
import org.tip.puck.graphs.Node;
import org.tip.puck.io.paj.PAJFile;
import org.tip.puck.matrix.MatrixStatistics.Indicator;
import org.tip.puck.matrix.MatrixStatistics.Mode;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.RelationValuator;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.partitions.PartitionCriteria.PartitionType;
import org.tip.puck.partitions.PartitionCriteria.SizeFilter;
import org.tip.puck.partitions.PartitionCriteria.ValueFilter;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportChart;
import org.tip.puck.report.ReportRawData;
import org.tip.puck.report.ReportTable;
import org.tip.puck.report.ReportChart.GraphType;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.sequences.CorrelationMatrix;
import org.tip.puck.sequences.SequenceCensusCriteria;
import org.tip.puck.sequences.SequenceWorker;
import org.tip.puck.sequences.Sequences;
import org.tip.puck.sequences.SequenceCensusCriteria.CensusType;
import org.tip.puck.sequences.SequencesCensus;
import org.tip.puck.sequences.SequenceCensusCriteria.RelationAttributeType;
import org.tip.puck.statistics.StatisticsCriteria;
import org.tip.puck.statistics.StatisticsReporter;
import org.tip.puck.util.Chronometer;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.NumberedValues;
import org.tip.puck.util.PuckUtils;
import org.tip.puck.util.ToolBox;
import org.tip.puck.util.Value;

import fr.devinsy.util.StringList;

public class RelationReporter {

	public static Report reportTreeStructure(final Segmentation segmentation, final String relationModelName, Integer time, boolean reducedTrees, String pattern) throws PuckException{
		Report result;
		
		if ((segmentation == null) || (relationModelName == null)) {
			throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.");
		} else {
			result = new Report("Cluster Structure "+relationModelName);
			Chronometer chrono = new Chronometer();
			
			result.setOrigin("Relation reporter");
			
			Relations relations = segmentation.getCurrentRelations().getByModelName(relationModelName).getByTime(time);

			for (Relation relation : relations.toListSortedByTypeId()){

				result.outputs().appendln(relation+"\t"+relation.actors().size()+"\t"+RelationWorker.getLinkTrees(relation, reducedTrees, "GENDER", null)+"\t"+RelationWorker.getLinkTrees(relation, reducedTrees, "ID", null)+"\t"+RelationWorker.getLinkTrees(relation, reducedTrees, "KIN", pattern));

			}
	
/*			Partition<Individual> partition = PartitionMaker.create(partitionLabel, segmentation.getCurrentIndividuals(), criteria);
			
			for (Cluster<Individual> cluster : partition.getClusters().toListSortedByValue()){
				result.outputs().appendln(cluster.getValue()+"\t"+cluster.size()+"\t"+SpaceWorker.getLinkTrees(new Individuals(cluster.getItems()), relationModelName, egoRoleName, alterRoleName, criteria.getLabel(), criteria.getTime(), reducedTrees));
			}*/
			
			
			result.setTimeSpent(chrono.stop().interval());
		}
	
		//
		return result;
	}

	public static Report reportIndividualStatics(final RelationCensus slices, final StatisticsCriteria criteria) throws PuckException{
			Report result;
			
			if (criteria == null) {
				throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.");
			} else {
				result = new Report("Population Statics "+slices.relationModelName());
				Chronometer chrono = new Chronometer();
	
				result.setOrigin("Relation reporter");
	//			result.setTarget(spaces.getLabel());
	
				// Compute charts and tables.
				for (PartitionCriteria partitionCriteria : criteria.getPartitionCriterias()) {
	
					if (StringUtils.isEmpty(partitionCriteria.getLabel())) {
						continue;
					}
	
					List<ReportChart> charts = new ArrayList<ReportChart>(20);
					List<ReportTable> tables = new ArrayList<ReportTable>(20);
	
					for (Integer time : slices.times()){
						
						if (partitionCriteria.getLabel().equals("AGE") || partitionCriteria.getLabel().equals("MATRISTATUS")){
							partitionCriteria.setLabelParameter(time+"");
						}
						
						Relations relations = slices.getRelations(time);
						String label = slices.relationModelName()+" "+time;
	
						//
						Partition<Individual> partition = PartitionMaker.create(label, relations.getIndividuals(), relations, partitionCriteria);
	
						ReportChart chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, criteria.getSplitCriteria());
						charts.add(chart);
						
						ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
						tables.add(table);
	
					}
					
					int nr = Math.min(4, slices.size());
					
					// Manage the number of chart by line.
					for (int chartIndex = 0; chartIndex < charts.size(); chartIndex++) {
						result.outputs().append(charts.get(chartIndex));
						if (chartIndex % nr == nr-1) {
							result.outputs().appendln();
						}
					}
	
					// Add chart tables.
					for (ReportTable table : tables) {
						result.outputs().appendln(table);
					}
				}
	
				result.setTimeSpent(chrono.stop().interval());
			}
	
			//
			return result;
		}

	public static Report reportIndividualDynamics(final RelationCensus slices, final StatisticsCriteria criteria) throws PuckException{
			Report result;
			
			if ((slices == null) || (criteria == null)) {
				throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.");
			} else {
				result = new Report("Population Dynamics "+slices.relationModelName());
				Chronometer chrono = new Chronometer();
	
				result.setOrigin("Space reporter");
				
				Integer[] times = slices.times();
				
				List<ReportChart> charts = new ArrayList<ReportChart>(20);
				List<ReportTable> tables = new ArrayList<ReportTable>(20);
	
				for (int i=0;i<times.length-1;i++){
					
					int startTime = times[i];
					int endTime = times[i+1];
					
					Relations totalStartSpace = slices.getAllRelations(startTime);
					Relations totalEndSpace = slices.getAllRelations(endTime);
					Relations filteredStartSpace = slices.getRelations(startTime);
					Relations filteredEndSpace = slices.getRelations(endTime);
					
					Partition<Individual> partition = new Partition<Individual>();
					partition.setLabel(slices.relationModelName()+" "+startTime+"-"+endTime);
					
					PartitionCriteria partitionCriteria = new PartitionCriteria();
					partitionCriteria.setLabel(partition.getLabel());
					
					Individuals totalStartPopulation = totalStartSpace.getIndividuals();
					Individuals totalEndPopulation = totalEndSpace.getIndividuals();
					Individuals filteredStartPopulation = filteredStartSpace.getIndividuals();
					Individuals filteredEndPopulation = filteredEndSpace.getIndividuals();
					
					// Forward 
					
					Partition<Individual> destinations = new Partition<Individual>();
					destinations.setLabel("Destinations "+startTime+"/"+endTime);
					
					for (Individual individual : filteredStartSpace.getIndividuals().toSortedList()){
						if (IndividualValuator.lifeStatusAtYear(individual, endTime).equals("DEAD")){
							partition.put(individual, new Value("DIED"));
						} else if (!totalEndPopulation.contains(individual)){
							partition.put(individual, new Value("UNKNOWN DESTINATION"));
						} else if (!filteredEndPopulation.contains(individual)){
							partition.put(individual, new Value("LEFT"));
							for (Relation destination : totalEndSpace.getByIndividual(individual)){
								destinations.put(individual,RelationValuator.get(destination,"PLACE",criteria.getPlaceParameter()));
							}
						} else if (!filteredEndSpace.getByIndividual(individual).equals(filteredStartSpace.getByIndividual(individual))){
							partition.put(individual, new Value("INTERNAL CHANGE"));
						} else {
							partition.put(individual, new Value("UNCHANGED"));
						}
					}
					
					// Backward 
					
					Partition<Individual> origins = new Partition<Individual>();
					origins.setLabel("Origins "+startTime+"/"+endTime);
	
					for (Individual individual : filteredEndSpace.getIndividuals().toSortedList()){
						if (IndividualValuator.lifeStatusAtYear(individual, startTime).equals("UNBORN")){
							partition.put(individual, new Value("NEWBORN"));
						} else if (!totalStartPopulation.contains(individual)){
							partition.put(individual, new Value("UNKNOWN ORIGIN"));
						} else if (!filteredStartPopulation.contains(individual)){
							partition.put(individual, new Value("ENTERED"));
							for (Relation origin : totalStartSpace.getByIndividual(individual)){
								origins.put(individual,RelationValuator.get(origin,"PLACE",criteria.getPlaceParameter()));
							}
						} else if (!filteredStartSpace.getByIndividual(individual).equals(filteredEndSpace.getByIndividual(individual))){
	//						partition.put(individual, new Value("INTERNAL CHANGE2"));
						} else {
	//						partition.put(individual, new Value("UNCHANGED2"));
						}
					}
	
					ReportChart chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, criteria.getSplitCriteria());
					charts.add(chart);
					
					ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
					tables.add(table);
					
					ReportChart chartDestinations = StatisticsReporter.createPartitionChart(destinations, partitionCriteria, criteria.getSplitCriteria());
					charts.add(chartDestinations);
					
					ReportTable tableDestinations = ReportTable.transpose(chartDestinations.createReportTableWithSum());
					tables.add(tableDestinations);
					
					ReportChart chartOrigins = StatisticsReporter.createPartitionChart(origins, partitionCriteria, criteria.getSplitCriteria());
					charts.add(chartOrigins);
					
					ReportTable tableOrigins = ReportTable.transpose(chartOrigins.createReportTableWithSum());
					tables.add(tableOrigins);
	
				}
				
				int nr = Math.min(4, 2*times.length);
				
				// Manage the number of chart by line.
				for (int chartIndex = 0; chartIndex < charts.size(); chartIndex++) {
					result.outputs().append(charts.get(chartIndex));
					if (chartIndex % nr == nr-1) {
						result.outputs().appendln();
					}
				}
	
				// Add chart tables.
				for (ReportTable table : tables) {
					result.outputs().appendln(table);
	
				}
				
				result.setTimeSpent(chrono.stop().interval());
			}
	
			//
			return result;
		}
	
	public static List<Report> reportRelationCensus (final Segmentation segmentation, final String relationModelName, final String egoRoleName, String alterRoleName, final Integer[] times, final String pattern) throws PuckException{
		List<Report> result;
		
		if ((segmentation == null) || (relationModelName == null) || (egoRoleName == null)) {
			throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.");
		} else {
			result = new ArrayList<Report>();

			CensusCriteria censusCriteria = new CensusCriteria();
			censusCriteria.setClosingRelation(relationModelName);
			censusCriteria.setClosingRelationEgoRole(egoRoleName);
			censusCriteria.setClosingRelationAlterRole(alterRoleName);
			censusCriteria.setCircuitType(CircuitType.RING);
			censusCriteria.setPattern(pattern);

			if (times==null){

				Report report = CensusReporter.reportFindCircuit(segmentation, censusCriteria, null);
				report.setTitle("Relations "+egoRoleName+" "+alterRoleName);
				result.add(report);

			} else {
				
				for (int i=0;i<times.length;i++){
					
					censusCriteria.setRelationTime(times[i]);

					Report report = CensusReporter.reportFindCircuit(segmentation, censusCriteria, null);
					report.setTitle("Relations "+egoRoleName+" "+alterRoleName+" "+times[i]);
					result.add(report);
				}
			}
		}
		
		//
		return result;
	}
	
	public static Report reportDevelopmentCycles(final RelationCensus slices, final StatisticsCriteria criteria) throws PuckException{
		Report result;
		
		if ((slices == null) || (criteria == null)) {
			throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.");
		} else {
			result = new Report("Development Cycles "+slices.relationModelName());
			Chronometer chrono = new Chronometer();

			result.setOrigin("Space reporter");
			
			SequenceCensusCriteria censusCriteria = new SequenceCensusCriteria();
			
			censusCriteria.setCensusType(CensusType.PARCOURS);
			censusCriteria.addNetworkTitle("Event Type Network");
			censusCriteria.getMainRelationAttributeTypes().add(RelationAttributeType.TREES);
			censusCriteria.getEventTypes().add(RelationAttributeType.TREES);
			
			for (RelationAttributeType relationAttributeType : censusCriteria.getMainRelationAttributeTypes()){
				censusCriteria.getLabels().add("PROFILE_"+relationAttributeType);
				censusCriteria.getLabels().add("SUPPORT_"+relationAttributeType);
			}

			SequencesCensus census = new SequencesCensus(slices.getSequences(), censusCriteria);
			CensusType censusType = censusCriteria.getCensusType();
			
			// Create Reports
			Report overallReport = new Report("Survey");
			Report diagramReport = new Report("Diagrams");
			Report detailReport = new Report("Details");
			Report componentReport = new Report("Components");
			Report treeReport = new Report("Trees");
					
			// Create Partition charts and tables
			List<ReportChart> charts = new ArrayList<ReportChart>();
			List<ReportTable> tables = new ArrayList<ReportTable>();
				
			// Make overall report and diagrams
			overallReport.outputs().appendln("Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");

			// Set partition criteria 
			for (String label : censusCriteria.getLabels()){
				
				PartitionCriteria partitionCriteria = new PartitionCriteria(label);
				
				ReportChart chart = null;
				
				if (!label.contains("ALTERS") && !label.contains("PROFILE")){
					NumberedValues values = census.getValues(label);
					
					Partition<Relation> partition = PartitionMaker.create(label, slices.getRelations(slices.times()[0]), values, partitionCriteria);
				
					PartitionCriteria splitCriteria = new PartitionCriteria(censusCriteria.getPartitionLabel());
					chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, splitCriteria);

					overallReport.outputs().append(label+"\t");
						String sum = "";
						if (label.startsWith("NR")){
							sum = new Double(values.sum()).intValue()+"";
						}
						overallReport.outputs().append(MathUtils.round(values.average(),2)+"\t"+MathUtils.round(values.averagePositives(),2)+"\t"+values.median()+"\t"+values.max()+"\t"+sum+"\t");
					overallReport.outputs().appendln();
					
				}
			
				if (chart != null) {
					charts.add(chart);
						ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
						tables.add(table);
						if (!label.contains("EVENTS_") && !label.contains("RELATIONS")){
							tables.add(ReportTable.normalize(table));
						}

				}
			
			}
			overallReport.outputs().appendln();
			
			// Create detailed report
			detailReport.outputs().append("Nr\tEgo\tGender");
			for (String partitionLabel : censusCriteria.getLabels()){
					detailReport.outputs().append("\t"+partitionLabel);
			}
			
			detailReport.outputs().appendln();
			for (Relation ego : slices.getRelations(slices.times()[0])){
				
				if ((((censusType==CensusType.GENERAL) || (censusType==CensusType.PARCOURS)))) {
					detailReport.outputs().append(ego.getId()+"\t"+ego);
					for (String label : censusCriteria.getLabels()){
						if (label.contains("SIMILARITY")){
							Value value = census.getValues(label).get(ego.getId());
							Map<Value,Double[]> indiSimilaritiesMap = (Map<Value,Double[]>)value.mapValue();
							String[] keys = new String[]{"PARENT","CHILD","SIBLING","SPOUSE"};
							for (String key : keys){
								Double[] sim = indiSimilaritiesMap.get(new Value(key));
								if (sim!=null){
									detailReport.outputs().append("\t"+MathUtils.round(sim[4], 2));
								}
							}
						} else {
							detailReport.outputs().append("\t"+census.getValues(label).get(ego.getId()));
						}
					}
					detailReport.outputs().appendln();
				}
				
			}
			
			
			// SequenceAnalysis
			
			if (censusType == CensusType.PARCOURS){
				
				for (RelationAttributeType relationAttributeType : censusCriteria.getMainRelationAttributeTypes()){
					
					if (censusCriteria.getNetworkTitles().contains("Event Type Network")){

						CorrelationMatrix eventSequenceMatrix = census.getEventSequenceMatrix(relationAttributeType.toString());
						
						if (eventSequenceMatrix!=null){
							for (ReportChart chart : eventSequenceMatrix.getCharts()){
								charts.add(chart);
							}
							tables.add(eventSequenceMatrix.getTable("Event Type Sequences"));
						}
						
						overallReport.outputs().appendln();
						overallReport.outputs().appendln("Sequence Network Statistics "+relationAttributeType);
						overallReport.outputs().appendln("\tDensity\tInertia\t(Divergence)\tConcentration\t(Divergence)\tSymmetry\t(Divergence)\tCentral nodes");
						
						for (Gender gender : Gender.values()){
							GraphProfile<Cluster<String>> profile = eventSequenceMatrix.getProfile(gender);

							String centralReferents = "";
							for (Cluster<String> centralReferent : profile.getCentralReferents()){
								centralReferents+=centralReferent.getValue()+" ";
							}
							double maxBetweenness = profile.getMaxBetweenness();
							double density = profile.density();
							double endo = MathUtils.round(profile.getStatistics(Indicator.LOOPS, Mode.NORMALIZED),2);
							double endoExp = MathUtils.round(profile.getStatistics(Indicator.LOOPS, Mode.DIVERGENCE_NORMALIZED),2);
							double conc = MathUtils.round(profile.getStatistics(Indicator.CONCENTRATION, Mode.SIMPLE),2);
							double concExp = MathUtils.round(profile.getStatistics(Indicator.CONCENTRATION, Mode.DIVERGENCE),2);
							double sym = MathUtils.round(profile.getStatistics(Indicator.SYMMETRY, Mode.SIMPLE),2);
							double symExp = MathUtils.round(profile.getStatistics(Indicator.SYMMETRY, Mode.DIVERGENCE),2);

							overallReport.outputs().appendln(gender+"\t"+density+"\t"+endo+"\t"+endoExp+"\t"+conc+"\t"+concExp+"\t"+sym+"\t"+symExp+"\t"+centralReferents +"("+maxBetweenness+") betweenness centrality");
						}
						overallReport.outputs().appendln();

					}
					
					if (censusCriteria.getNetworkTitles().contains("Sequence Type Network")){

						CorrelationMatrix subSequenceMatrix = census.getSubSequenceMatrix(relationAttributeType.toString());
						
						if (subSequenceMatrix!=null){
							charts.add(subSequenceMatrix.getRamificationChart());
						}
					}
					
					
//					reportSequencePartition(overallReport,"",census.getEventPartition(eventTypeName),census.getEventPairPartition(eventTypeName),census.nrSequences(),census.nrEvents());
//					reportSequenceTree(treeReport,"",census.getSequenceTypeNetwork(eventTypeName));
					
	/*				int maxPositions = census.getNrValues(eventType,eventType.toString());
							
					ReportChart diversityChart = StatisticsReporter.createDiversityChart(census.getDepthPartition(eventType.toString()), maxPositions);
					charts.add(diversityChart);*/
				}
			}
			
			// Manage the number of chart by line.
			for (int chartIndex = 0; chartIndex < charts.size(); chartIndex++) {
				diagramReport.outputs().append(charts.get(chartIndex));
				if (chartIndex % 4 == 3) {
					diagramReport.outputs().appendln();
				}
			}
			
			// Add chart tables.
			for (ReportTable table : tables) {
				diagramReport.outputs().appendln(table.getTitle());
				diagramReport.outputs().appendln(table);
			}
			
			// Finalize reports
			result.outputs().append(overallReport);
			result.outputs().append(diagramReport);
			result.outputs().append(detailReport);
			
			if (censusType == CensusType.EGONETWORKS || censusType ==CensusType.PARCOURSNETWORKS){
				result.outputs().append(componentReport);
			}
			if (censusType == CensusType.PARCOURS) {
				result.outputs().append(treeReport);
			}
			
			//addPajekData
			
			Map<String,StringList> pajekBuffers = census.getPajekBuffers();
			
			for (String title : pajekBuffers.keySet()){
				
				StringList pajekBuffer = pajekBuffers.get(title);
				if (pajekBuffer.length() != 0) {
					File targetFile = ToolBox.setExtension(ToolBox.addToName(new File("Test"), "-"+title), ".paj");
					ReportRawData rawData = new ReportRawData("Export "+title+"s to Pajek", "Pajek", "paj", targetFile);
					rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));

					result.outputs().appendln();
					result.outputs().append(rawData);
				}
			}

						
			
			result.setTimeSpent(chrono.stop().interval());

		}
			

		
		//
		return result;
	}


}
