package org.tip.puck.net.relations;

import org.tip.puck.report.Report;

public class RelationModelReporter {

	RelationModelStatistics statistics;
	RelationModel model;
	
	public RelationModelReporter (RelationModel model){
		
		this.model = model;
		statistics = new RelationModelStatistics(model);
		
	}
	
	public Report reportModel(){
		Report result;
		
		result = new Report("Model "+model.getName());
		
		result.outputs().append(reportDefinitions());
		result.outputs().append(reportStatistics());
		result.outputs().append(reportReciprocals());
		result.outputs().append(reportCompositions());
		result.outputs().append(reportProblems());

		//
		return result;
	}
	
	public Report reportDefinitions(){
		Report result;
		
		result = new Report("Definitions");
		
		result.outputs().appendln("Relation Model "+model.getName());
		result.outputs().appendln();
		
		for (RoleDefinition definition : model.roleDefinitions().neutralize().toSortedList()){
			result.outputs().appendln(definition);
		}
		
		//
		return result;
		
	}
	
/*	public Report reportNetwork(){
		Report result;
		
		result = new Report("Network");
		
		result.outputs().appendln("Relation Model "+model.getName());
		result.outputs().appendln();
		
		//
		return result;
		
	}*/
	
	public Report reportProblems(){
		Report result;
		
		result = new Report("Problems");
		
		result.outputs().appendln("Relation Model "+model.getName());
		result.outputs().appendln();
		
		boolean noProblems = true;
		
		Roles undefinedRoles = statistics.undefinedRoles();
		
		if (undefinedRoles.size()>0){
			noProblems = false;
			result.outputs().appendln("Undefined roles: ");
			for (Role role : undefinedRoles){
				result.outputs().appendln(role);
			}
			result.outputs().appendln();
		}
		
		RoleDefinitions recursiveDefinitions = statistics.recursiveDefinitions();
		
		if (recursiveDefinitions.size()>0){
			noProblems = false;
			result.outputs().appendln("Recursively defined roles: ");
			for (RoleDefinition definition : recursiveDefinitions.toSortedList()){
				result.outputs().appendln(definition);
			}
			result.outputs().appendln();
		}
		
		if (noProblems){
			result.outputs().appendln("No problems found");
		}
		
		//
		return result;
		
	}
	

	
	public Report reportStatistics (){
		Report result;
		
		result = new Report("Statistics");
		
		result.outputs().appendln("Relation Model "+model.getName());
		result.outputs().appendln();
		result.outputs().appendln("Nr of Terms: "+statistics.termCount());
		result.outputs().appendln("Cousin Classification: "+statistics.cousinClassification());
		
		result.outputs().appendln();
		result.outputs().appendln();
		for (Role role : statistics.sortedRoles()){
			result.outputs().appendln(role.getName()+"\t"+statistics.generations(role)+"\t"+statistics.genders(role)+"\t"+statistics.links(role));
		}
		
		//
		return result;
	}
	
	
	public Report reportCompositions (){
		Report result;
		
		result = new Report("Compositions");
		
		result.outputs().appendln("Compositions: Relation Model "+model.getName());
		result.outputs().appendln();
		
		for (Role alpha : statistics.roles){
			for (Role beta : statistics.roles){
				Roles alphaBeta = statistics.roleDefinitions.getCompositeRoles(alpha,beta);
				if (alphaBeta.size()>0){
					String composition = alpha+"  "+beta+" = ";
					for (Role gamma : alphaBeta){
						composition+=gamma+", ";
					}
					result.outputs().appendln(composition);
				}
			}
		}
		//
		return result;
	}
	
	public Report reportReciprocals (){
		Report result;
		
		result = new Report("Reciprocals");
		
		result.outputs().appendln("Reciprocals: Relation Model "+model.getName());
		result.outputs().appendln();
		
		for (Role alpha : statistics.roles){
			Roles inverseAlpha = statistics.roleDefinitions.getReciprocalRoles(alpha);
			if (inverseAlpha.size()>0){
				String reciprocal = alpha+" = -";
				for (Role beta : inverseAlpha){
					reciprocal+=beta+", ";
				}
				result.outputs().appendln(reciprocal);
			}
		}
		//
		return result;
	}
	
	
}
