package org.tip.puck.net.relations;

import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.Individual;

/**
 * 
 * @author TIP
 */
public class RelationModel {

	private String name;
	private Roles roles;
	private RoleDefinitions roleDefinitions;
	private String defaultRoleName;

	/**
	 * 
	 * @param source
	 */
	public RelationModel(final RelationModel source) {
		//
		this.name = source.getName();
		this.roles = new Roles(source.roles());
	}

	/**
	 * 
	 * @param name
	 * @param role
	 */
	public RelationModel(final String name) {
		//
		this.name = name;
		this.roles = new Roles();
	}

	public String getName() {
		return this.name;
	}

	public Roles roles() {
		return this.roles;
	}

	public void setName(final String name) {
		this.name = name;
	}

	public RoleDefinitions roleDefinitions() {
		return roleDefinitions;
	}

	public void setRoleDefinitions(RoleDefinitions roleDefinitions) {
		this.roleDefinitions = roleDefinitions;
	}

	
	public Role role(Individual indi){
		Role result;
		
		if (indi==null){
			result = null;
		} else {
			result = roles.getByName(indi.getName());
			if (result == null){
				result = new Role(indi.getName());
				roles.add(result);
			}
		}
		//
		return result;
	}
	
	public Role role(String item){
		Role result;
		
		if (StringUtils.isEmpty(item)){
			result = null;
		} else {
			result = roles.getByName(item);
			if (result == null){
				result = new Role(item);
				roles.add(result);
			}
		}
		//
		return result;
	}

	public String defaultRoleName() {
		return defaultRoleName;
	}

	public void setDefaultRoleName(String defaultRoleName) {
		this.defaultRoleName = defaultRoleName;
		if (roles.getByName(defaultRoleName)==null){
			roles.add(new Role(defaultRoleName));
		}
	}
	
	
	
}
