package org.tip.puck.geo.io;

import javax.swing.JProgressBar;

import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.tip.puck.geo.Place;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Link;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;

public class BuildingGeoLinks {

	DefaultFeatureCollection featureLinesCollection;
	SimpleFeatureBuilder featureBuilder;

	GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);

	SimpleFeatureType lineFeatureType;

	public BuildingGeoLinks() {
		SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();

		//set the name
		b.setName( "SCHEMA_LINES" );

		//Add attributes
		b.add( "name", String.class);
		//add a geometry property
		b.setCRS( DefaultGeographicCRS.WGS84 ); // set crs first
		b.add( "the_geom", LineString.class ); // then add geometry

		//build the type
		this.lineFeatureType = b.buildFeatureType();

		featureLinesCollection = new DefaultFeatureCollection("internal",this.lineFeatureType);

		this.featureBuilder = new SimpleFeatureBuilder(this.lineFeatureType);
	}

	public DefaultFeatureCollection getFeatureLinesCollection() {
		return featureLinesCollection;
	}

	public void setFeatureLinesCollection(
			DefaultFeatureCollection featureLinesCollection) {
		this.featureLinesCollection = featureLinesCollection;
	}

	public SimpleFeatureBuilder getFeatureBuilder() {
		return featureBuilder;
	}

	public void setFeatureBuilder(SimpleFeatureBuilder featureBuilder) {
		this.featureBuilder = featureBuilder;
	}

	public GeometryFactory getGeometryFactory() {
		return geometryFactory;
	}

	public void setGeometryFactory(GeometryFactory geometryFactory) {
		this.geometryFactory = geometryFactory;
	}

	public SimpleFeatureType getLineFeatureType() {
		return lineFeatureType;
	}

	public void setLineFeatureType(SimpleFeatureType lineFeatureType) {
		this.lineFeatureType = lineFeatureType;
	}

	public DefaultFeatureCollection buildLinkGeometry(JProgressBar progressBar, Graph<Place>  graphPlaces) {

		for (Link<Place> link : graphPlaces.getArcs()) {

			if( link.getSourceNode().getReferent().getCoordinate() != null & link.getTargetNode().getReferent().getCoordinate() != null) {

				Coordinate[] tabCoord = new Coordinate[]{
						link.getSourceNode().getReferent().getCoordinate(),
						link.getTargetNode().getReferent().getCoordinate() };

				LineString line = this.geometryFactory.createLineString(tabCoord);

				SimpleFeature f = SimpleFeatureBuilder.build( 
						this.lineFeatureType, new Object[]{	link.getSourceNode().getReferent().getName() + " -- " +  link.getTargetNode().getReferent().getName(),
								line}, null );

				this.featureLinesCollection.add(f);

			}
			int i = progressBar.getValue();
			progressBar.setValue(i++);
		}
		return this.featureLinesCollection;

	}

}