package org.tip.puck.geo.graphs;

import org.tip.puck.geo.GeoLevel;
import org.tip.puck.geo.Geography;
import org.tip.puck.geo.Place;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Node;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.partitions.Cluster;

public class GeoNetworkUtils {

	
	public static <E> Graph<Place> createGeoNetwork (Graph<Cluster<E>> clusterNetwork, GeoLevel level){
		Graph<Place> result;
		
		result = new Graph<Place>();
		for (Node<Cluster<E>> node : clusterNetwork.getNodes()){
			result.addNode(node.getId(),Geography.getInstance().getPlace(node.getReferent().getLabel(), level));
		}
		result.addLinksByIds(clusterNetwork.getLinks());
		
		//
		return result;
	}

	public static <E> Graph<Place> createGeoNetwork (Relations events, GeoLevel level){
		Graph<Place> result;
		
		result = new Graph<Place>();
		
		for (Relation event : events){
			Place startPlace = Geography.getInstance().getPlace(event.getAttributeValue("START_PLACE"), level);
			Place endPlace = Geography.getInstance().getPlace(event.getAttributeValue("END_PLACE"), level);
			result.addArc(startPlace,endPlace);
		}
		
		//
		return result;
	}
	
	public static void writeGeoNetwork (Graph<Place> geoNetwork){
		/**
		 * to be filled...
		 */
	}



}
