package org.tip.puck.geo;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class Places {

	Map<String,Place> places;
	
	public Places (){
		places = new TreeMap<String,Place>();
	}
	
	public Place get (String id){
		return places.get(id);
	}
	
	public void put (String id, Place place){
		places.put(id, place);
	}
	
	public void putUnique (String id, Place place){
		if (!places.containsValue(place)){
			places.put(id, place);
		}
	}
	
	public Collection<Place> getPlaces(){
		return places.values();
	}
	
	public int size(){
		return places.size();
	}
	
	public String toString(){
		String result;
		
		result = "";
		for (Place place : places.values()){
			if (place!=null){
				result+=place.getShortName()+" ";
			} else {
				result+="?";
			}
		}
		//
		return result;
	}

}