package oldcore.calc.network;

import java.util.Arrays;

import org.tip.puck.net.Individual;
import org.tip.puck.net.KinType;

//rename (FullArc?)
/**
 * This class defines edges in the sense of graph theory. 
 * It is similar to the class puck#Arc, but ego and alter are defined as vertices, not as numbers. </p> 
 * @author Klaus Hamberger
 * @since Version 0.6
 * @see Net#getBicomponent(Stack<Edge>, Edge, boolean)
 */
public class Edge {

	/**
	 * the alter Individual
	 */
	private Individual alter;
	/**
	 * the ego Individual
	 */
	private Individual ego;
	
	private KinType type;
	
	/**
	 * The default constructor
	 */
	private Edge() {};

	/**
	 * The standard constructor
	 * @param v the first Individual
	 * @param w the second Individual
	 * @param i the edge type
	 */
	public Edge (Individual v, Individual w, KinType i){
		ego = v;
		alter = w;
		type = i;
	}
	
	/**
	 * The constructor for symetrical ungendered edges
	 * Puck uses this edge type only for computing bicomponents 
	 * @param v the first Individual
	 * @param w the second Individual
	 * @param i the (ungendered) kin type
	 */
	public Edge (Individual v, Individual w, int i, boolean sym){
		if (sym || v.getId() < w.getId()){
			ego = v;
			alter = w;
			type = type(i,1);
		} else {
			ego = w;
			alter = v;
			type = type(i,-1);
		}
	}
	
	public Edge (Individual v, Individual w, KinType kinType, boolean sym){
		if (sym || v.getId() < w.getId()){
			ego = v;
			alter = w;
			type = kinType;
		} else {
			ego = w;
			alter = v;
			type = kinType.inverse();
		}
		System.out.println(ego.signature()+" "+alter.signature()+" "+type);
	}

	/**
	 * checks whether two edges are equal
	 * @param o the edge to be compared
	 * @return true if the edges are equal
	 */
	@Override
	public boolean equals (Object o){
		return Arrays.equals(getKey(),((Edge)o).getKey());
	}
	
	/**
	 * returns the alter Individual
	 * @return the alter Individual
	 */
	public Individual getAlter(){
		return alter;
	}
	
	/**
	 * returns the ego Individual
	 * @return the ego Individual
	 */
	public Individual getEgo(){
		return ego;
	}
	
	/**
	 * returns the ID numbers of ego and alter
	 * @return an array consisting of the ID numbers of ego and alter
	 */
	private int[] getKey (){
		int[] key = {ego.getId(),alter.getId()};
		return key;
	}
	
	//refer to general static kin mode function? 
	/**
	 * returns the kin mode
	 * @return the kin mode (0 alliance, 1 filiation)
	 */
	public int getMode(){
		if (type==KinType.SPOUSE) {
			return 0;
		} else {
			return 1;
		}
	}
	
	/**
	 * gets a new hashCode
	 * @return the new hashCode
	 */
	@Override
	public int hashCode (){
		return Arrays.hashCode(getKey());
	}
	
	/**
	 * inverts the arc (permutes ego and alter and changes the line value accordingly)
	 * @return the edge in inverse representation
	 */
	private Edge inverse (){
		Edge e = new Edge();
		e.ego = alter;
		e.alter = ego;
		e.type = invType();
		return e;
	}
	
/*	public int getType(){
		return type;
	}*/
	
	/**
	 * inverts the arc if alter coincides with a given Individual
	 * @param v the Individual to be checked
	 * @return the inverse arc if v is equal to alter, the same arc else  
	 */
	public Edge inverse (Individual v){
		if (v==alter) return inverse();
		return this;
	}

	/**
	 * returns the (gendered) kin type of the inverse edge
	 * @return the (gendered) kin type of the inverse edge
	 */
	private KinType invType (){
		KinType result;
		
		switch (type){
			case SPOUSE: {
				result = KinType.SPOUSE;
				break;
			}
			case CHILD: {
				result = KinType.PARENT;
				break; //ego.getGender().toInt();
			}
			case PARENT: {
				result = KinType.CHILD;
				break;
			}
			default: {
				result = null;
			}
		}
		//
		return result;
	}
	
	

	//render static and more general?
	/**
	 * transforms the ungendered kin type into the gendered kin type
	 * @param i the ungendered kin type
	 * @param k a parameter of arc direction (1 ego to alter, -1 alter to ego)
	 * @return the gendered kin type (-1 child, 0 father, 1 mother, 2 spouse)
	 */
	private KinType type (int i, int k){
		if (i==0) return KinType.SPOUSE;
		if (i==k) {
			if (alter.isMale()) return KinType.FATHER;
			if (alter.isFemale()) return KinType.MOTHER;
		}
		return KinType.CHILD;
	}

	public KinType getType() {
		return type;
	}

	
}
