/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import org.tip.puck.PuckManager;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.views.MainWindow;

public class OpenRecentFolderMenuItem
extends JMenuItem {
    private static final long serialVersionUID = -2068397343657608721L;
    private static final int FOLDER_DISPLAY_LENGTH = 40;

    public OpenRecentFolderMenuItem(final JFrame window, final NetGUI netGUI, final File folder) {
        this.setText(this.endString(folder.getAbsolutePath(), 40));
        if (!folder.exists()) {
            this.setEnabled(false);
        }
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = MainWindow.selectFile(window, folder);
                MainWindow.openSelectedFile(netGUI, window, file, PuckManager.DEFAULT_CHARSET_NAME);
            }
        });
    }

    public String endString(String source, int length) {
        String result = source.length() < length + 3 ? source : "\u201a\u00c4\u00b6" + source.substring(source.length() - length);
        return result;
    }
}

