/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.spaces;

import java.util.HashMap;
import java.util.Map;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.RelationValuator;
import org.tip.puck.util.Numberable;

public class Space
implements Numberable {
    int time;
    Map<Individual, Relation> states;
    String label;
    Individuals population;

    public Space(int time, String relationModelName) {
        this.time = time;
        this.population = new Individuals();
        this.states = new HashMap<Individual, Relation>();
        this.label = String.valueOf(relationModelName) + " " + time;
    }

    @Override
    public int getId() {
        return this.time;
    }

    public Relation getState(Individual ego) {
        return this.states.get(ego);
    }

    @Override
    public void setId(int time) {
        this.time = time;
    }

    @Override
    public String hashKey() {
        return String.valueOf(this.time);
    }

    public void put(Individual ego, Relation state) {
        this.population.put(ego);
        this.states.put(ego, state);
    }

    public Individuals population() {
        return this.population;
    }

    public Relations states() {
        Relations result = new Relations();
        for (Relation state : this.states.values()) {
            result.put(state);
        }
        return result;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isIndividualLabel(String label) {
        return IndividualValuator.getAttributeLabels(this.population).contains(label);
    }

    public boolean isStateLabel(String label) {
        return RelationValuator.getAttributeLabels(this.states()).contains(label);
    }
}

