/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.sequences;

import java.util.ArrayList;
import java.util.Collections;
import org.tip.puck.PuckException;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.workers.ExpansionMode;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.sequences.EventComparator;
import org.tip.puck.sequences.Sequence;
import org.tip.puck.sequences.SequenceCensusCriteria;
import org.tip.puck.sequences.Sequences;

public class SequenceMaker {
    public static Sequence createSequence(Individual ego) {
        Sequence result = new Sequence(ego.getId());
        result.setEgo(ego);
        for (Relation relation : ego.relations()) {
            result.putInOrder(relation);
        }
        return result;
    }

    public static Sequence createPersonalSequence(Individual ego, SequenceCensusCriteria criteria) {
        String egoRoleName = criteria.getEgoRoleName();
        Sequence result = new Sequence(ego.getId());
        result.setEgo(ego);
        result.setEgoRoleName(egoRoleName);
        ArrayList<Relation> list = new ArrayList<Relation>();
        for (Relation relation : ego.relations()) {
            if (!relation.getRoleNames(ego).contains(egoRoleName)) continue;
            list.add(relation);
        }
        Collections.sort(list, new EventComparator());
        for (Relation event : list) {
            result.putInOrder(event);
        }
        return result;
    }

    public static Sequences createPersonalSequences(Segmentation segmentation, SequenceCensusCriteria criteria) {
        Sequences result = new Sequences();
        for (Individual individual : segmentation.getCurrentIndividuals().toSortedList()) {
            result.add(SequenceMaker.createPersonalSequence(individual, criteria));
        }
        return result;
    }

    public static Sequences createBiographies(Net net, Segmentation segmentation) throws PuckException {
        Sequences result = new Sequences();
        net.getFamilyEvents(segmentation);
        for (Individual individual : segmentation.getCurrentIndividuals()) {
            result.add(SequenceMaker.createSequence(individual));
        }
        net.removeFamilyEvents();
        return result;
    }

    public static Sequence createExtendedSequence(Individual individual, SequenceCensusCriteria criteria) {
        Sequence result = new Sequence(individual.getId());
        result.setEgo(individual);
        for (Relation relation : individual.relations()) {
            result.putInOrder(relation);
        }
        ExpansionMode expansionMode = criteria.getExpansionMode();
        FiliationType filiationType = criteria.getFiliationType();
        for (Individual relative : NetUtils.neighbors(individual, expansionMode, filiationType)) {
            for (Relation relation : relative.relations()) {
                result.putInOrder(relation);
            }
        }
        return result;
    }

    public static Sequences createExtendedBiographies(Net net, Segmentation segmentation, SequenceCensusCriteria criteria) throws PuckException {
        Sequences result = new Sequences();
        net.getFamilyEvents(segmentation);
        for (Individual individual : segmentation.getCurrentIndividuals()) {
            result.add(SequenceMaker.createExtendedSequence(individual, criteria));
        }
        net.removeFamilyEvents();
        return result;
    }
}

