/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.workers;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.math.NumberUtils;
import org.tip.puck.geo.GeoLevel;
import org.tip.puck.geo.Geography;
import org.tip.puck.geo.Place;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Families;
import org.tip.puck.net.Family;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.Individual;
import org.tip.puck.net.IndividualComparator;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.KinType;
import org.tip.puck.net.UnionStatus;
import org.tip.puck.net.workers.FamilyValuator;
import org.tip.puck.statistics.StatisticsWorker;
import org.tip.puck.util.NumberedIntegers;
import org.tip.puck.util.NumberedValues;
import org.tip.puck.util.Value;

public class IndividualValuator {
    public static final Pattern YEAR_PATTERN = Pattern.compile("(\\d\\d\\d\\d)");

    public static Integer ageAtYear(Individual source, int year) {
        Integer birtYear = IndividualValuator.getBirthYear(source);
        Integer deatYear = IndividualValuator.getDeathYear(source);
        int result = -1;
        if (birtYear != null && birtYear > year) {
            result = -1;
        } else if (deatYear != null && deatYear < year) {
            result = -1;
        } else if (birtYear != null) {
            result = year - birtYear;
        }
        return result;
    }

    public static boolean aliveAtYear(Individual source, int year) {
        boolean result = false;
        Integer birtYear = IndividualValuator.getBirthYear(source);
        Integer deatYear = IndividualValuator.getDeathYear(source);
        if (birtYear != null && birtYear <= year && (deatYear == null || deatYear >= year)) {
            result = true;
        }
        return result;
    }

    public static Individuals extract(Individuals source, String label, Object parameter, Value value) {
        Individuals result = new Individuals();
        for (Individual individual : source) {
            Value thisValue = IndividualValuator.get(individual, label, parameter);
            if (thisValue == null || !thisValue.equals(value)) continue;
            result.put(individual);
        }
        return result;
    }

    public static String extractYear(String source) {
        String result;
        if (source == null) {
            result = null;
        } else {
            try {
                result = String.valueOf(Integer.parseInt(source));
            }
            catch (NumberFormatException nfe) {
                Matcher matcher = YEAR_PATTERN.matcher(source);
                result = matcher.find() && matcher.groupCount() > 0 ? matcher.group(1) : null;
            }
        }
        return result;
    }

    public static Integer extractYearAsInt(String source) {
        String year = IndividualValuator.extractYear(source);
        Integer result = year == null ? null : Integer.valueOf(Integer.parseInt(year));
        return result;
    }

    public static Value get(Individual source, String label) {
        Value result = IndividualValuator.get(source, label, null);
        return result;
    }

    public static Value get(Individual source, String label, Object parameter) {
        Object result;
        EndogenousLabel enogenousLabel;
        try {
            enogenousLabel = EndogenousLabel.valueOf(label.replace(" ", "_"));
        }
        catch (IllegalArgumentException exception) {
            enogenousLabel = null;
        }
        if (enogenousLabel == null) {
            String attributeValue = source.getAttributeValue(label);
            if (attributeValue == null) {
                if (label.toUpperCase().contains("FIRST_CHILD")) {
                    String firstChildLabel = label.replaceFirst("FIRST_CHILD_", "");
                    result = IndividualValuator.getFirstChildAttribute(source, firstChildLabel);
                } else {
                    result = null;
                }
            } else if (IndividualValuator.valueOf(GeoLevel.class, attributeValue) != null) {
                result = new Value(GeoLevel.valueOf(attributeValue));
            } else if (label.toUpperCase().contains("YEAR")) {
                String dateLabel = label.replaceAll("YEAR", "DATE");
                String year = IndividualValuator.extractYear(source.getAttributeValue(dateLabel));
                result = year == null ? null : new Value(Integer.parseInt(year));
            } else if (label.toUpperCase().contains("PLACE")) {
                Place place;
                String level = parameter == null ? "LOCAL" : (String)parameter;
                String homonym = source.getAttributeValue(label);
                result = Geography.getInstance() != null ? ((place = Geography.getInstance().getPlace(homonym, level)) == null || place.getName() == null ? null : new Value(place.getName())) : new Value(attributeValue);
            } else {
                result = new Value(attributeValue);
            }
        } else {
            switch (enogenousLabel) {
                case BIRTH_ORDER: {
                    if (source.getBirthOrder() == null) {
                        result = null;
                        break;
                    }
                    result = new Value(source.getBirthOrder());
                    break;
                }
                case DEPTH: {
                    result = new Value(StatisticsWorker.depth(source));
                    break;
                }
                case FIRSTN: {
                    if (source.getFirstName() == null) {
                        result = null;
                        break;
                    }
                    result = new Value(source.getFirstName());
                    break;
                }
                case FRATM: {
                    Individual parent = source.getMother();
                    if (parent == null) {
                        result = new Value(-source.getId());
                        break;
                    }
                    result = new Value(parent.getId());
                    break;
                }
                case FRATP: {
                    Individual parent = source.getFather();
                    if (parent == null) {
                        result = new Value(-source.getId());
                        break;
                    }
                    result = new Value(parent.getId());
                    break;
                }
                case ID: {
                    result = new Value(source.getId());
                    break;
                }
                case LASTN: {
                    if (source.getLastName() == null) {
                        result = null;
                        break;
                    }
                    result = new Value(source.getLastName());
                    break;
                }
                case PARTN: {
                    result = new Value(source.getPartners().size());
                    break;
                }
                case MATRIC: {
                    result = new Value(StatisticsWorker.ancestor(source, FiliationType.UTERINE));
                    break;
                }
                case MATRID: {
                    result = new Value(StatisticsWorker.depth(source, FiliationType.UTERINE));
                    break;
                }
                case MDEPTH: {
                    result = new Value(StatisticsWorker.meanDepth(source));
                    break;
                }
                case PATRIC: {
                    result = new Value(StatisticsWorker.ancestor(source, FiliationType.AGNATIC));
                    break;
                }
                case PATRID: {
                    result = new Value(StatisticsWorker.depth(source, FiliationType.AGNATIC));
                    break;
                }
                case PEDG: {
                    if (parameter == null || !(parameter instanceof String) || !NumberUtils.isNumber((String)((String)parameter))) {
                        result = null;
                        break;
                    }
                    result = new Value(StatisticsWorker.numberOfLinearKin(source, Integer.parseInt((String)parameter)));
                    break;
                }
                case PROG: {
                    if (parameter == null || !(parameter instanceof String) || !NumberUtils.isNumber((String)((String)parameter))) {
                        result = null;
                        break;
                    }
                    result = new Value(StatisticsWorker.numberOfLinearKin(source, -1 * Integer.parseInt((String)parameter)));
                    break;
                }
                case GENDER: {
                    result = new Value(source.getGender());
                    break;
                }
                case SPOU: {
                    result = new Value(source.spouses().size());
                    break;
                }
                case SIMPLE: {
                    result = new Value(source.getName());
                    break;
                }
                case LIFESTATUS: {
                    if (parameter == null) {
                        result = new Value(IndividualValuator.lifeStatusAtYear(source, Calendar.getInstance().get(1)));
                        break;
                    }
                    if (!(parameter instanceof String) || !NumberUtils.isNumber((String)((String)parameter))) {
                        result = null;
                        break;
                    }
                    result = new Value(IndividualValuator.lifeStatusAtYear(source, Integer.parseInt((String)parameter)));
                    break;
                }
                case MATRISTATUS: {
                    if (parameter == null) {
                        result = new Value(IndividualValuator.matrimonialStatusAtYear(source, Calendar.getInstance().get(1)));
                        break;
                    }
                    if (!(parameter instanceof String) || !NumberUtils.isNumber((String)((String)parameter))) {
                        result = null;
                        break;
                    }
                    result = new Value(IndividualValuator.matrimonialStatusAtYear(source, Integer.parseInt((String)parameter)));
                    break;
                }
                case AGE: {
                    if (parameter == null) {
                        result = new Value(IndividualValuator.ageAtYear(source, Calendar.getInstance().get(1)));
                        break;
                    }
                    if (!(parameter instanceof String) || !NumberUtils.isNumber((String)((String)parameter))) {
                        result = null;
                        break;
                    }
                    result = new Value(IndividualValuator.ageAtYear(source, Integer.parseInt((String)parameter)));
                    break;
                }
                case UNIONSTATUS: {
                    result = new Value(IndividualValuator.getMatrimonialStatus(source));
                    break;
                }
                case FIRST_MARR_DATE: {
                    result = null;
                    if (source.isSingle()) break;
                    Integer firstMarrYear = null;
                    for (Family family : source.getPersonalFamilies()) {
                        String marrDate = family.getAttributeValue("MARR_DATE");
                        Integer marrYear = IndividualValuator.extractYearAsInt(marrDate);
                        if (marrDate == null || firstMarrYear != null && marrYear >= firstMarrYear) continue;
                        firstMarrYear = marrYear;
                        result = new Value(marrDate);
                    }
                    break;
                }
                default: {
                    result = null;
                }
            }
        }
        return result;
    }

    public static NumberedValues get(Individuals source, String label) {
        NumberedValues result = IndividualValuator.get(source, label, null);
        return result;
    }

    public static NumberedValues get(Individuals source, String label, Object parameter) {
        NumberedValues result = new NumberedValues();
        if (label.equals("GEN")) {
            NumberedIntegers data = StatisticsWorker.genData(source);
            for (Integer key : data.keySet()) {
                result.addValue((int)key, (Integer)data.get(key));
            }
        } else if (label.equals("DEPTH")) {
            NumberedIntegers data = StatisticsWorker.depthData(source, FiliationType.COGNATIC);
            for (Integer key : data.keySet()) {
                result.addValue((int)key, (Integer)data.get(key));
            }
        } else if (label.equals("MATRIC")) {
            HashMap<Individual, Individual> ancestors = StatisticsWorker.ancestors(source, FiliationType.UTERINE);
            for (Individual ego : ancestors.keySet()) {
                result.addValue(ego.getId(), ancestors.get(ego));
            }
        } else if (label.equals("MATRID")) {
            NumberedIntegers depths = StatisticsWorker.depthData(source, FiliationType.UTERINE);
            for (Integer individualId : depths.keySet()) {
                result.addValue((int)individualId, (Integer)depths.get(individualId));
            }
        } else if (label.equals("PATRIC")) {
            HashMap<Individual, Individual> ancestors = StatisticsWorker.ancestors(source, FiliationType.AGNATIC);
            for (Individual ego : ancestors.keySet()) {
                result.addValue(ego.getId(), ancestors.get(ego));
            }
        } else if (label.equals("PATRID")) {
            NumberedIntegers depths = StatisticsWorker.depthData(source, FiliationType.AGNATIC);
            for (Integer individualId : depths.keySet()) {
                result.addValue((int)individualId, (Integer)depths.get(individualId));
            }
        } else {
            for (Individual individual : source) {
                result.put(individual.getId(), IndividualValuator.get(individual, label, parameter));
            }
        }
        return result;
    }

    public static List<String> getAttributeLabels(Individuals individuals) {
        List<String> result = IndividualValuator.getAttributeLabels(individuals, null);
        return result;
    }

    public static List<String> getAttributeLabels(Individuals individuals, Integer limit) {
        ArrayList<String> result = new ArrayList<String>(20);
        EndogenousLabel[] endogenousLabelArray = EndogenousLabel.values();
        int n = endogenousLabelArray.length;
        int n2 = 0;
        while (n2 < n) {
            EndogenousLabel label = endogenousLabelArray[n2];
            result.add(label.toString());
            ++n2;
        }
        result.addAll(IndividualValuator.getExogenousAttributeLabels(individuals, limit));
        Collections.sort(result);
        return result;
    }

    public static List<String> getAttributeLabelSample(Individuals individuals) {
        List<String> result = IndividualValuator.getAttributeLabels(individuals, 10000);
        return result;
    }

    public static Integer getBirthYear(Individual individual) {
        String birtYear;
        Integer result = individual == null ? null : ((birtYear = IndividualValuator.extractYear(individual.getAttributeValue("BIRT_DATE"))) == null ? null : Integer.valueOf(Integer.parseInt(birtYear)));
        return result;
    }

    public static Integer getDeathYear(Individual individual) {
        String deatYear;
        Integer result = individual == null ? null : ((deatYear = IndividualValuator.extractYear(individual.getAttributeValue("DEAT_DATE"))) == null ? null : Integer.valueOf(Integer.parseInt(deatYear)));
        return result;
    }

    public static List<String> getEndogenousAttributeLabels() {
        ArrayList<String> result = new ArrayList<String>(20);
        EndogenousLabel[] endogenousLabelArray = EndogenousLabel.values();
        int n = endogenousLabelArray.length;
        int n2 = 0;
        while (n2 < n) {
            EndogenousLabel label = endogenousLabelArray[n2];
            result.add(label.toString());
            ++n2;
        }
        Collections.sort(result);
        return result;
    }

    public static List<String> getExogenousAttributeLabels(Individuals individuals) {
        List<String> result = IndividualValuator.getExogenousAttributeLabels(individuals, null);
        return result;
    }

    public static List<String> getExogenousAttributeLabels(Individuals individuals, Integer limit) {
        ArrayList<String> result = new ArrayList<String>(20);
        HashSet<String> buffer = new HashSet<String>();
        if (individuals != null) {
            int index = 0;
            Iterator iterator = individuals.iterator();
            while (iterator.hasNext() && (limit == null || index < limit)) {
                Individual individual = (Individual)iterator.next();
                for (Attribute attribute : individual.attributes()) {
                    buffer.add(attribute.getLabel());
                }
                ++index;
            }
        }
        for (String string : buffer) {
            result.add(string);
        }
        Collections.sort(result);
        return result;
    }

    public static Individual getFirstChild(Individual individual) {
        Individual result = individual.getKin(KinType.CHILD, IndividualComparator.Sorting.BIRT_YEAR, 1);
        return result;
    }

    public static Value getFirstChildAttribute(Individual individual, String label) {
        Value result = null;
        Individual firstChild = IndividualValuator.getFirstChild(individual);
        if (firstChild != null) {
            result = IndividualValuator.get(firstChild, label);
        }
        return result;
    }

    public static Integer getMarriageYear(Family family) {
        String year;
        Integer result = null;
        if (family != null && (year = IndividualValuator.extractYear(family.getAttributeValue("MARR_DATE"))) != null) {
            result = Integer.parseInt(year);
        }
        return result;
    }

    public static Integer getMarriageYear(Individual ego, Individual alter) {
        String year;
        Integer result = null;
        Family family = IndividualValuator.getUnion(ego, alter);
        if (family != null && (year = IndividualValuator.extractYear(family.getAttributeValue("MARR_DATE"))) != null) {
            result = Integer.parseInt(year);
        }
        return result;
    }

    public static String getMatrimonialStatus(Individual source) {
        String result = "SINGLE";
        if (source.getPersonalFamilies() != null) {
            for (Family family : source.getPersonalFamilies()) {
                result = "NOT_SINGLE";
                if (family.getUnionStatus().equals((Object)UnionStatus.MARRIED)) {
                    if (result.equals("MARRIED")) {
                        result = "REMARRIED";
                        continue;
                    }
                    result = "MARRIED";
                    continue;
                }
                if (!family.getUnionStatus().equals((Object)UnionStatus.DIVORCED)) continue;
                result = "DIVORCED";
            }
        }
        return result;
    }

    public static Family getUnion(Individual ego, Individual alter) {
        Family result = null;
        Families families = ego.getPersonalFamilies();
        if (families != null) {
            for (Family family : families) {
                if (family.getOtherParent(ego) == alter) continue;
                result = family;
                break;
            }
        }
        return result;
    }

    public static String lifeStatusAtYear(Individual source, int year) {
        Integer birtYear = IndividualValuator.getBirthYear(source);
        Integer deatYear = IndividualValuator.getDeathYear(source);
        String result = "UNKNOWN";
        if (birtYear != null && birtYear > year) {
            result = "UNBORN";
        } else if (deatYear != null && deatYear < year) {
            result = "DEAD";
        } else if (birtYear != null) {
            result = String.valueOf(year - birtYear);
        }
        return result;
    }

    public static String matrimonialStatusAtYear(Individual source, int year) {
        Integer birtYear = IndividualValuator.getBirthYear(source);
        Integer deatYear = IndividualValuator.getDeathYear(source);
        String result = "UNKNOWN";
        if (birtYear != null && birtYear > year) {
            result = "UNBORN";
        } else if (deatYear != null && deatYear < year) {
            result = "DEAD";
        } else {
            Families families = source.getPersonalFamilies();
            int nrSpouses = families.size();
            if (nrSpouses == 0) {
                result = "CELIBATARY";
            } else {
                int divorced = 0;
                int widowed = 0;
                int married = 0;
                for (Family family : families) {
                    Integer marrYear = FamilyValuator.getMarrYear(family);
                    Integer divYear = FamilyValuator.getMarrYear(family);
                    Integer spouseDeathYear = IndividualValuator.getDeathYear(family.getOtherParent(source));
                    if (family.getOtherParent(source) == null || marrYear != null && marrYear > year) continue;
                    if (family.getUnionStatus() == UnionStatus.DIVORCED && (divYear == null || divYear <= year)) {
                        ++divorced;
                        continue;
                    }
                    if (spouseDeathYear != null && spouseDeathYear <= year) {
                        ++widowed;
                        continue;
                    }
                    ++married;
                }
                result = divorced == nrSpouses ? "DIVORCED" : (widowed == nrSpouses ? "WIDOWED" : (married == nrSpouses ? "MARRIED" : (married == 0 ? "DIVORCED-WIDOWED" : (divorced == 0 ? "WIDOWED-(RE)MARRIED" : (widowed == 0 ? "DIVORCED-(RE)MARRIED" : "DIVORCED-WIDOWED-(RE)MARRIED")))));
                if (married > 1) {
                    result = String.valueOf(result) + "-POLYGAMOUS";
                }
            }
        }
        return result;
    }

    public static <T extends Enum<T>> T valueOf(Class<T> cls, String name) {
        T result = null;
        try {
            result = Enum.valueOf(cls, name);
        }
        catch (IllegalArgumentException iae) {
            result = null;
        }
        return result;
    }

    public static enum EndogenousLabel {
        AGE,
        BIRTH_ORDER,
        DEPTH,
        FIRST_MARR_DATE,
        FIRSTN,
        FRATM,
        FRATP,
        GEN,
        GENDER,
        ID,
        LASTN,
        LIFESTATUS,
        MATRISTATUS,
        MDEPTH,
        MATRIC,
        MATRID,
        PARTN,
        PATRIC,
        PATRID,
        PEDG,
        PROG,
        SIMPLE,
        SPOU,
        UNIONSTATUS;

    }
}

