/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.paj;

import java.util.regex.Pattern;

public class PAJLine {
    public static final Pattern NETWORK_HEADER_PATTERN = Pattern.compile("^\\*[Nn]etwork (.+)$");
    public static final Pattern VERTICES_HEADER_PATTERN = Pattern.compile("^\\*[Vv]ertices (\\d+)$");
    public static final Pattern ARCS_HEADER_PATTERN = Pattern.compile("^\\*[Aa]rcs\\s*:+\\s*(\\d+)\\s['\"](.+)['\"]$");
    public static final Pattern PARTITION_HEADER_PATTERN = Pattern.compile("^\\*[Pp]artition (.+)$");
    public static final Pattern VECTOR_HEADER_PATTERN = Pattern.compile("^\\*[Vv]ector (.+)$");
    public static final Pattern ARC_EDGE_DATA_PATTERN = Pattern.compile("^\\s*(\\d+)\\s+(\\d+)\\s+(-?\\d+).*$");
    public static final Pattern VERTICE_LONG_DATA_PATTERN = Pattern.compile("^\\s*(\\d+) ['\"](.*)['\"](\\s+([\\d\\.]+)\\s+([\\d\\.]+)\\s+([\\d\\.]+)){0,1}\\s*(box|diamond|circle|ellipse|square|triangle){0,1}$");
    public static final Pattern VERTICE_SHORT_DATA_PATTERN = Pattern.compile("^\\s*(\\d+)$");
    public static final Pattern NAME_PATTERN = Pattern.compile("^(.*)\\s*(\\((\\d+)\\))\\s*$");
    private LineType type = LineType.VOID;
    private String label;
    private String name;
    private Integer cardinal;
    private Integer relationCode;
    private Shape shape;
    private Integer sourceId;
    private Integer targetId;
    private String value;
    private Integer weight;

    public Integer getCardinal() {
        return this.cardinal;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public Integer getRelationCode() {
        return this.relationCode;
    }

    public Shape getShape() {
        return this.shape;
    }

    public Integer getSourceId() {
        return this.sourceId;
    }

    public Integer getTargetId() {
        return this.targetId;
    }

    public LineType getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public void setCardinal(Integer cardinal) {
        this.cardinal = cardinal;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRelationCode(Integer relationCode) {
        this.relationCode = relationCode;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public void setSourceId(Integer sourceId) {
        this.sourceId = sourceId;
    }

    public void setTargetId(Integer targetId) {
        this.targetId = targetId;
    }

    public void setType(LineType type) {
        this.type = type;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    public static PAJLine createArcEdgeData(int sourceId, int targetId, int weight) {
        PAJLine result = new PAJLine();
        result.setType(LineType.ARC_EDGE_DATA);
        result.setSourceId(sourceId);
        result.setTargetId(targetId);
        result.setWeight(weight);
        return result;
    }

    public static PAJLine createArcsHeader() {
        PAJLine result = new PAJLine();
        result.setType(LineType.ARCS_HEADER);
        result.setRelationCode(null);
        result.setLabel(null);
        return result;
    }

    public static PAJLine createArcsHeader(int relationCode, String label) {
        PAJLine result = new PAJLine();
        result.setType(LineType.ARCS_HEADER);
        result.setRelationCode(relationCode);
        result.setLabel(label);
        return result;
    }

    public static PAJLine createEdgeHeader() {
        PAJLine result = new PAJLine();
        result.setType(LineType.EDGE_HEADER);
        result.setRelationCode(null);
        return result;
    }

    public static PAJLine createEmptyLine() {
        PAJLine result = new PAJLine();
        result.setType(LineType.VOID);
        return result;
    }

    public static PAJLine createNetworkHeader(String label) {
        PAJLine result = new PAJLine();
        result.setType(LineType.NETWORK_HEADER);
        result.setLabel(label);
        return result;
    }

    public static PAJLine createPartitionHeader(String label) {
        PAJLine result = new PAJLine();
        result.setType(LineType.PARTITION_HEADER);
        result.setLabel(label);
        return result;
    }

    public static PAJLine createVectorHeader(String label) {
        PAJLine result = new PAJLine();
        result.setType(LineType.VECTOR_HEADER);
        result.setLabel(label);
        return result;
    }

    public static PAJLine createVertice(int sourceId, Integer targetId, String name, Shape shape) {
        PAJLine result = new PAJLine();
        result.setType(LineType.VERTICE_LONG_DATA);
        result.setSourceId(sourceId);
        result.setTargetId(targetId);
        result.setName(name);
        result.setShape(shape);
        return result;
    }

    public static PAJLine createVertice(String value) {
        PAJLine result = new PAJLine();
        result.setType(LineType.VERTICE_SHORT_DATA);
        result.setValue(value);
        return result;
    }

    public static PAJLine createVerticesHeader(int cardinal) {
        PAJLine result = new PAJLine();
        result.setType(LineType.VERTICES_HEADER);
        result.setCardinal(cardinal);
        return result;
    }

    public static enum LineType {
        VOID,
        NETWORK_HEADER,
        VERTICES_HEADER,
        ARCS_HEADER,
        PARTITION_HEADER,
        VECTOR_HEADER,
        ARC_EDGE_DATA,
        VERTICE_LONG_DATA,
        VERTICE_SHORT_DATA,
        EDGE_HEADER;

    }

    public static enum Shape {
        TRIANGLE,
        SQUARE,
        ELLIPSE,
        CIRCLE,
        BOX,
        DIAMOND;

    }
}

