/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.graphs.workers;

import fr.devinsy.util.StringList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Link;
import org.tip.puck.graphs.Links;
import org.tip.puck.graphs.Node;
import org.tip.puck.graphs.Nodes;
import org.tip.puck.matrix.Matrix;
import org.tip.puck.net.Individual;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.Numberable;
import org.tip.puck.util.Value;

public class GraphUtils {
    private static final Logger logger = LoggerFactory.getLogger(GraphUtils.class);

    public static <E> Graph<E> createGraphFromMatrix(Nodes<E> nodes, Matrix matrix) {
        Graph<E> result = new Graph<E>(0, nodes.size());
        result.addNodesWithId(nodes);
        result.addArcs(matrix);
        return result;
    }

    public static <E> Graph<E> cloneWithoutNullValueLines(Graph<E> source) {
        Graph result = new Graph(source.getLabel());
        for (Node<E> node : source.getNodes()) {
            result.addNode(node.getReferent());
        }
        for (Link link : source.getLinks()) {
            if (link.getWeight() == 0.0) continue;
            Node newSourceNode = result.getNode(link.getSourceNode().getReferent());
            Node newTargetNode = result.getNode(link.getTargetNode().getReferent());
            if (link.isArc()) {
                result.addArc(newSourceNode, newTargetNode, link.getWeight());
                continue;
            }
            if (!link.isEdge()) continue;
            result.addEdge(newSourceNode, newTargetNode, link.getWeight());
        }
        return result;
    }

    public static <E> Graph<E> createEgoNetwork(Graph<E> source, Node<E> ego) {
        logger.debug("create ego network for " + ego);
        Graph<E> result = new Graph<E>(source.getLabel());
        result.addNode(ego.getReferent());
        for (Node<E> node : ego.getOtherNodes()) {
            result.addNode(node.getReferent());
        }
        for (Node<E> newSourceNode : result.getNodes()) {
            Node newTargetNode;
            Node<E> oldTargetNode;
            Node<E> oldSourceNode = source.getNode(newSourceNode.getReferent());
            for (Link<E> oldLink : oldSourceNode.getOutArcs()) {
                oldTargetNode = oldLink.getTargetNode();
                newTargetNode = result.getNode(oldTargetNode.getReferent());
                if (newTargetNode == null) continue;
                result.addArc(newSourceNode, newTargetNode, oldLink.getWeight());
            }
            for (Link<E> oldLink : oldSourceNode.getEdges()) {
                oldTargetNode = oldLink.getTargetNode();
                newTargetNode = result.getNode(oldTargetNode.getReferent());
                if (newTargetNode == null) continue;
                result.addEdge(newSourceNode, newTargetNode, oldLink.getWeight());
            }
        }
        return result;
    }

    private static <E> void putComponentItem(Partition<Node<E>> components, Node<E> node, Value value) {
        if (!components.getItems().contains(node)) {
            components.put(node, value);
            for (Node<E> neighbor : node.getDirectNeighbors()) {
                GraphUtils.putComponentItem(components, neighbor, value);
            }
        }
    }

    private static <E> int unconnectedPairs(Graph<E> source) {
        int result = 0;
        List<Node<E>> nodes = source.getNodes().toListSortedById();
        block0: for (Node<E> firstNode : nodes) {
            for (Node<E> secondNode : source.getNodes()) {
                if (firstNode.getId() <= secondNode.getId()) continue block0;
                if (firstNode.getDirectNeighbors().contains(secondNode)) continue;
                ++result;
            }
        }
        return result;
    }

    public static <E> double unconnectedPairsNormalized(Graph<E> source) {
        double result = MathUtils.percent(GraphUtils.unconnectedPairs(source), source.nodeCount() * (source.nodeCount() - 1));
        return result;
    }

    public static <E> Graph<E> fuse(List<Graph<E>> source) {
        Graph<E> result = new Graph<E>();
        for (Graph<E> graph : source) {
            result.addNodes(graph.getNodes());
            result.addLinks(graph.getLinks());
        }
        return result;
    }

    public static <E> Graph<E> cloneWithoutEgo(Graph<E> source, Node<E> ego) {
        Graph<E> result = new Graph<E>();
        result.setLabel(String.valueOf(source.getLabel()) + " Without Ego");
        for (Node<E> node : source.getNodes()) {
            if (node.equals(ego)) continue;
            result.addNode(node.getId(), node.getReferent());
        }
        for (Link link : source.getArcs()) {
            if (link.getSourceNode().equals(ego) || link.getTargetNode().equals(ego)) continue;
            result.addArc(link.getSourceNode().getId(), link.getTargetNode().getId(), link.getWeight());
        }
        for (Link link : source.getEdges()) {
            if (link.getSourceNode().equals(ego) || link.getTargetNode().equals(ego)) continue;
            result.addEdge(link.getSourceNode().getId(), link.getTargetNode().getId(), link.getWeight());
        }
        return result;
    }

    public static <E> int nrComponents(Graph<E> source) {
        int result = GraphUtils.components(source).size();
        return result;
    }

    public static <E> Cluster<Node<E>> maxComponent(Graph<E> source) {
        Cluster<Node<E>> result = GraphUtils.components(source).maxCluster();
        return result;
    }

    public static <E> Partition<Node<E>> components(Graph<E> source) {
        Partition<Node<E>> result = new Partition<Node<E>>();
        int i = 1;
        for (Node<E> node : source.getNodes()) {
            GraphUtils.putComponentItem(result, node, new Value(i));
            ++i;
        }
        return result;
    }

    private static <E> Node<E> maxStrengthNode(List<Node<E>> source, Cluster<Node<E>> cluster1, Cluster<Node<E>> cluster2) {
        Node<E> result = null;
        double maxStrength = 1.0;
        for (Node<E> node : source) {
            double strength = GraphUtils.strengthRate(node, cluster1, cluster2);
            if (!(strength >= maxStrength)) continue;
            maxStrength = strength;
            result = node;
        }
        return result;
    }

    public static <E> Graph<E> reduce(Graph<E> source, int minimalNumberOfLinks, double minimalNodeStrength, double minimalLinkWeight) {
        Graph<E> result;
        logger.debug("reduce starting... [minimalNumberOfLinks={}][minimalNodeStrength={}][minimalLinkWeight={}]", new Object[]{minimalNumberOfLinks, minimalNodeStrength, minimalLinkWeight});
        if (minimalNumberOfLinks == 0 && minimalLinkWeight == 0.0 && minimalNodeStrength == 0.0) {
            result = source;
        } else {
            result = new Graph<E>(source.getLabel());
            for (Node<E> node : source.getNodes()) {
                if (minimalNumberOfLinks != 0 && node.getDegree() < minimalNumberOfLinks || minimalNodeStrength != 0.0 && !(node.getForce() >= minimalNodeStrength) || minimalLinkWeight != 0.0 && MathUtils.compare(node.getMaxLinkWeight(), minimalLinkWeight) < 0) continue;
                result.addNode(node.getReferent());
            }
            for (Node<E> newSourceNode : result.getNodes()) {
                Node newTargetNode;
                Node<E> oldTargetNode;
                Node<E> oldSourceNode = source.getNode(newSourceNode.getReferent());
                for (Link<E> oldLink : oldSourceNode.getOutArcs()) {
                    oldTargetNode = oldLink.getTargetNode();
                    newTargetNode = result.getNode(oldTargetNode.getReferent());
                    if (newTargetNode == null || !(oldLink.getWeight() >= minimalLinkWeight)) continue;
                    result.addArc(newSourceNode, newTargetNode, oldLink.getWeight());
                }
                for (Link<E> oldLink : oldSourceNode.getEdges()) {
                    oldTargetNode = oldLink.getTargetNode();
                    newTargetNode = result.getNode(oldTargetNode.getReferent());
                    if (newTargetNode == null || !(oldLink.getWeight() >= minimalLinkWeight)) continue;
                    result.addEdge(newSourceNode, newTargetNode, oldLink.getWeight());
                }
            }
        }
        logger.debug("reduce done.");
        return result;
    }

    public static <E> Graph<E> reduceArcToEdge(Graph<E> source) {
        Graph<E> result;
        if (source == null) {
            result = null;
        } else {
            result = new Graph<E>(source.getLabel());
            for (Node<E> node : source.getNodes()) {
                result.addNode(node.getReferent());
            }
            for (Node<E> newSourceNode : result.getNodes()) {
                Node<E> oldSourceNode = source.getNode(newSourceNode.getReferent());
                for (Link<E> oldLink : oldSourceNode.getOutArcs()) {
                    Link<E> oldReverseLink;
                    Node<E> oldTargetNode = oldLink.getTargetNode();
                    Node newTargetNode = result.getNode(oldTargetNode.getReferent());
                    if (result.getEdge(newSourceNode, newTargetNode) != null) continue;
                    double newWeight = oldLink.getWeight();
                    if (newSourceNode != newTargetNode && (oldReverseLink = oldTargetNode.getArcWith(oldSourceNode)) != null) {
                        newWeight += oldReverseLink.getWeight();
                    }
                    result.addEdge(newSourceNode, newTargetNode, newWeight);
                }
            }
        }
        return result;
    }

    public static <E> double sidedness(Graph<E> source, Partition<Node<E>> sides) {
        double exoWeight = 0.0;
        double totalWeight = 0.0;
        for (Link link : source.getLinks()) {
            if (sides.getCluster(link.getSourceNode()) != sides.getCluster(link.getTargetNode())) {
                exoWeight += link.getWeight();
            }
            totalWeight += link.getWeight();
        }
        double result = exoWeight / totalWeight;
        return result;
    }

    public static <E> Partition<Node<E>> sides(Graph<E> source) {
        Partition<Node<Node<E>>> result = new Partition<Node<Node<E>>>();
        Cluster<Node<E>> side1 = new Cluster<Node<E>>(new Value(1));
        Cluster<Node<E>> side2 = new Cluster<Node<E>>(new Value(2));
        Cluster<Node<Node<E>>> side3 = new Cluster<Node<Node<E>>>(new Value(3));
        result.getClusters().put(side1);
        result.getClusters().put(side2);
        double maxStrength = 0.0;
        Node<E> maxStrengthNode = null;
        for (Node<E> node : source.getNodes()) {
            double strength = node.getForce();
            if (!(strength > 0.0)) continue;
            side3.put(node);
            if (!(strength > maxStrength)) continue;
            maxStrength = strength;
            maxStrengthNode = node;
        }
        result.swap(maxStrengthNode, side3, side1);
        result.swap(GraphUtils.maxStrengthNode(side3.getItems(), side1, side3), side3, side2);
        int count = side3.count() + 1;
        while (side3.count() < count) {
            count = side3.count();
            result.swap(GraphUtils.maxStrengthNode(side3.getItems(), side1, side2), side3, side2);
            result.swap(GraphUtils.maxStrengthNode(side3.getItems(), side2, side1), side3, side1);
        }
        double sidedness = GraphUtils.sidedness(source, result) - 1.0;
        while (sidedness < GraphUtils.sidedness(source, result)) {
            sidedness = GraphUtils.sidedness(source, result);
            result.swap(GraphUtils.maxStrengthNode(side1.getItems(), side1, side2), side1, side2);
            result.swap(GraphUtils.maxStrengthNode(side2.getItems(), side2, side1), side2, side1);
        }
        return result;
    }

    private static <E> double strengthRate(Node<E> node, Cluster<Node<E>> cluster1, Cluster<Node<E>> cluster2) {
        double strength1 = 0.0;
        double strength2 = 0.0;
        for (Link link : node.getLinks()) {
            Node<E> other = link.getOtherNode(node);
            if (cluster1.getItems().contains(other)) {
                strength1 = link.getWeight();
                continue;
            }
            if (!cluster2.getItems().contains(other)) continue;
            strength2 = link.getWeight();
        }
        double result = strength1 / strength2;
        return result;
    }

    public static <E> Map<Integer, Integer> getIds(Graph<E> source) {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        for (Node<E> node : source.getNodes().toList()) {
            result.put(((Numberable)node.getReferent()).getId(), node.getId());
        }
        return result;
    }

    public static Partition<Link<Individual>> getLinkPartitionByKinship(Graph<Individual> source) {
        Partition<Link<Individual>> result = new Partition<Link<Individual>>();
        for (Link link : source.getLinks()) {
            Individual ego = (Individual)link.getSourceNode().getReferent();
            Individual alter = (Individual)link.getTargetNode().getReferent();
            String label = null;
            if (ego.isChildOf(alter)) {
                label = "PARENT";
            } else if (alter.isChildOf(ego)) {
                label = "CHILD";
            } else if (ego.isPartnerWith(alter)) {
                label = "SPOUSE";
            } else if (ego.siblings().contains(alter)) {
                label = "SIBLING";
            }
            if (label != null) {
                result.put(link, new Value(label));
                continue;
            }
            result.put(link, null);
        }
        return result;
    }

    public static <E> double[] betweenness(Graph<E> source) {
        int n = source.nodeCount();
        double[] result = new double[n];
        HashMap<Node<E>, Integer> id = new HashMap<Node<E>, Integer>();
        int k = 0;
        for (Node<E> node : source.getNodes().toListSortedById()) {
            id.put(node, k);
            ++k;
        }
        for (Node<E> s : source.getNodes().toListSortedById()) {
            int si = (Integer)id.get(s);
            Stack<Node> stack = new Stack<Node>();
            Partition<Node> predecessors = new Partition<Node>();
            double[] nrShortestPathsThrough = new double[n];
            double[] distance = new double[n];
            int i = 0;
            while (i < n) {
                nrShortestPathsThrough[i] = 0.0;
                distance[i] = -1.0;
                predecessors.putCluster(new Value(i + 1));
                ++i;
            }
            nrShortestPathsThrough[si] = 1.0;
            distance[si] = 0.0;
            LinkedList queue = new LinkedList();
            queue.add(s);
            while (!queue.isEmpty()) {
                Node v = (Node)queue.remove();
                stack.push(v);
                int vi = (Integer)id.get(v);
                for (Node w : v.getDirectNeighbors()) {
                    int wi = (Integer)id.get(w);
                    if (distance[wi] < 0.0) {
                        queue.add(w);
                        distance[wi] = distance[vi] + 1.0;
                    }
                    if (distance[wi] != distance[vi] + 1.0) continue;
                    int n2 = wi;
                    nrShortestPathsThrough[n2] = nrShortestPathsThrough[n2] + nrShortestPathsThrough[vi];
                    predecessors.put(v, new Value(w.getId()));
                }
            }
            double[] pairDepencency = new double[n];
            int i2 = 0;
            while (i2 < n) {
                pairDepencency[i2] = 0.0;
                ++i2;
            }
            while (!stack.isEmpty()) {
                Node w = (Node)stack.pop();
                int wi = (Integer)id.get(w);
                for (Node v : predecessors.getCluster(new Value(w.getId())).getItems()) {
                    int vi;
                    int n3 = vi = ((Integer)id.get(v)).intValue();
                    pairDepencency[n3] = pairDepencency[n3] + nrShortestPathsThrough[vi] / nrShortestPathsThrough[wi] * (1.0 + pairDepencency[wi]);
                }
                if (w == s) continue;
                result[wi] = result[wi] + pairDepencency[wi];
            }
        }
        int i = 0;
        while (i < n) {
            if (n > 1) {
                result[i] = MathUtils.percent(result[i], (double)((n - 1) * (n - 2)));
            }
            ++i;
        }
        return result;
    }

    public static <E> void setNodeLabelsFromPartition(Graph<E> source, String partitionLabel) {
        for (Node<E> node : source.getNodes().toListSortedById()) {
            String label = node.getAttributeValue(partitionLabel);
            if (label == null) continue;
            node.setLabel(label);
        }
    }

    public static <E> void addNodeLabelsFromPartition(Graph<E> source, String partitionLabel) {
        for (Node<E> node : source.getNodes().toListSortedById()) {
            String label = node.getAttributeValue(partitionLabel);
            if (label == null) continue;
            node.setLabel(String.valueOf(node.getLabel()) + " " + label);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <E> StringList writePajekNetwork(Graph<E> source, List<String> partitionLabels, Map<String, Map<Value, Integer>> partitionNumbersMaps) throws PuckException {
        Links<E> edges;
        StringList result = new StringList(100);
        result.appendln("*Network " + source.getLabel());
        result.appendln();
        HashMap<Integer, Integer> idToIndex = new HashMap<Integer, Integer>();
        result.appendln("*vertices " + source.nodeCount());
        int nodeIndex = 1;
        while (nodeIndex <= source.nodeCount()) {
            Node<E> node = source.getNodes().toListSortedById().get(nodeIndex - 1);
            idToIndex.put(node.getId(), nodeIndex);
            if (StringUtils.isBlank((CharSequence)node.getTag())) {
                result.appendln(String.valueOf(nodeIndex) + " '" + node.getLabel() + "'");
            } else {
                result.appendln(String.valueOf(nodeIndex) + " '" + node.getLabel() + "' " + node.getTag());
            }
            ++nodeIndex;
        }
        Links<E> arcs = source.getArcs();
        if (arcs.isNotEmpty()) {
            List<String> tags = arcs.getTags();
            if (tags.isEmpty()) {
                result.appendln("*arcs");
                for (Link link : arcs) {
                    result.appendln(idToIndex.get(link.getSourceNode().getId()) + " " + idToIndex.get(link.getTargetNode().getId()) + " " + link.getWeightAsInt());
                }
            } else {
                Collections.sort(tags);
                for (String string : tags) {
                    result.appendln("*arcs :" + string);
                    for (Link link : arcs.getByTag(string)) {
                        result.appendln(idToIndex.get(link.getSourceNode().getId()) + " " + idToIndex.get(link.getTargetNode().getId()) + " " + link.getWeightAsInt());
                    }
                }
            }
        }
        if ((edges = source.getEdges()).isNotEmpty()) {
            result.appendln("*edges");
            List<String> list = edges.getTags();
            if (list.isEmpty()) {
                for (Link link : edges) {
                    result.appendln(idToIndex.get(link.getSourceNode().getId()) + " " + idToIndex.get(link.getTargetNode().getId()) + " " + link.getWeightAsInt());
                }
            } else {
                Collections.sort(list);
                for (String string : list) {
                    result.appendln("*edges " + string);
                    for (Link link : edges.getByTag(string)) {
                        result.appendln(idToIndex.get(link.getSourceNode().getId()) + " " + idToIndex.get(link.getTargetNode().getId()) + " " + link.getWeightAsInt());
                    }
                }
            }
        }
        for (String string : partitionLabels) {
            void var9_32;
            void var10_39;
            result.appendln();
            Partition<Node<E>> partition = PartitionMaker.create(string, source, PartitionCriteria.createRaw(string));
            if (partition.isNumeric()) {
                String string2 = "Vector";
            } else {
                String string3 = "Partition";
                if (partitionNumbersMaps != null) {
                    Partition<Node<E>> partition2 = PartitionMaker.createNumerized(partition, partitionNumbersMaps.get(string));
                } else {
                    Partition<Node<E>> partition3 = PartitionMaker.createNumerized(partition, null);
                }
            }
            result.appendln("*" + (String)var10_39 + " " + var9_32.getLabel() + " " + source.getLabel());
            result.appendln("*vertices " + source.nodeCount());
            int nodeIndex2 = 1;
            while (nodeIndex2 <= source.nodeCount()) {
                Node<E> node = source.getNodes().toListSortedById().get(nodeIndex2 - 1);
                if (var9_32.isNumeric()) {
                    result.appendln(var9_32.getValue(node).doubleValue());
                } else {
                    result.appendln(var9_32.getValue(node).intValue());
                }
                ++nodeIndex2;
            }
        }
        return result;
    }

    public static <E> int cyclomaticNumber(Graph<E> graph) {
        int result = 0;
        return result;
    }

    public static <E> double density(Graph<E> graph) {
        int nodeCount = graph.nodeCount();
        double result = MathUtils.percent(graph.tieCount(), nodeCount * nodeCount);
        return result;
    }

    public static <E> double densityWithoutLoops(Graph<E> graph) {
        int nodeCount = graph.nodeCount();
        double result = MathUtils.percent(graph.tieCountWithoutLoops(), nodeCount * (nodeCount - 1));
        return result;
    }

    public static <E> double meanDegreeWithoutLoopsAndDoubleLines(Graph<E> graph) {
        int nodeCount = graph.nodeCount();
        int degreeSum = 0;
        for (Node<E> node : graph.getNodes()) {
            degreeSum += node.getDirectNeighbors().size();
        }
        double result = MathUtils.percent(degreeSum, 100 * nodeCount);
        return result;
    }

    public static <E> double meanDegreeWithoutLoops(Graph<E> graph) {
        int nodeCount = graph.nodeCount();
        int degreeSum = 0;
        for (Node<E> node : graph.getNodes()) {
            degreeSum += node.getDegreeWithoutLoops();
        }
        double result = MathUtils.percent(degreeSum, 100 * nodeCount);
        return result;
    }

    public static <E> double meanDegree(Graph<E> graph) {
        int nodeCount = graph.nodeCount();
        int degreeSum = 0;
        for (Node<E> node : graph.getNodes()) {
            degreeSum += node.getDegree();
        }
        double result = MathUtils.percent(degreeSum, 100 * nodeCount);
        return result;
    }

    public static <E> double meanDegreeNormalized(Graph<E> graph) {
        double result = MathUtils.percent(GraphUtils.meanDegree(graph), (double)(100 * graph.nodeCount()));
        return result;
    }

    public static <E> double meanDegreeWithoutLoopsNormalized(Graph<E> graph) {
        double result = MathUtils.percent(GraphUtils.meanDegreeWithoutLoops(graph), (double)(100 * (graph.nodeCount() - 1)));
        return result;
    }

    public static <E> Double efficientSize(Graph<E> graph) {
        Double result;
        if (graph.nodeCount() < 3) {
            result = null;
        } else {
            int nodeCount = graph.nodeCount();
            int neighborSum = 0;
            for (Node<E> node : graph.getNodes()) {
                neighborSum += node.getDirectNeighbors().size();
            }
            result = new Double(nodeCount) - MathUtils.percent(neighborSum, 100 * nodeCount);
        }
        return result;
    }

    public static <E> Double efficiency(Graph<E> graph) {
        Double result = graph.nodeCount() < 3 ? null : Double.valueOf(MathUtils.percent(GraphUtils.efficientSize(graph), (double)graph.nodeCount()));
        return result;
    }

    public static <E> Graph<Set<E>> createPhylogeneticTree(Individual ego, String title, List<E> referents, double[][] distanceMatrix) {
        Graph result = new Graph(title);
        ArrayList items = new ArrayList();
        for (E referent : referents) {
            HashSet<E> set = new HashSet<E>();
            set.add(referent);
            items.add(set);
            result.addNode(set);
            result.getNode(set).setLabel(referent.toString());
        }
        int step = 0;
        while (distanceMatrix.length > 1) {
            distanceMatrix = GraphUtils.updateMatrix(ego, step, distanceMatrix, items, result);
            ++step;
        }
        for (Node node : result.getNodes().toList()) {
            node.setAttribute("SIZE", String.valueOf(((Set)node.getReferent()).size()));
        }
        return result;
    }

    private static <E> double[][] updateMatrix(Individual ego, int step, double[][] distanceMatrix, List<Set<E>> items, Graph<Set<E>> graph) {
        int j;
        int j2;
        int n = distanceMatrix.length;
        double[][] auxMatrix = new double[n][n];
        double[] r = new double[n];
        int i = 0;
        while (i < n) {
            r[i] = 0.0;
            j2 = 0;
            while (j2 < n) {
                int n2 = i;
                r[n2] = r[n2] + distanceMatrix[i][j2];
                ++j2;
            }
            ++i;
        }
        i = 0;
        while (i < n) {
            j2 = 0;
            while (j2 < n) {
                auxMatrix[i][j2] = distanceMatrix[i][j2] - new Double(r[j2] + r[i]) / new Double(n - 2);
                ++j2;
            }
            ++i;
        }
        int[] minIndexPair = new int[2];
        Double minDistance = null;
        int i2 = 0;
        while (i2 < n) {
            j = 0;
            while (j < i2) {
                if (minDistance == null || auxMatrix[i2][j] < minDistance) {
                    minIndexPair = new int[]{i2, j};
                    minDistance = auxMatrix[i2][j];
                }
                ++j;
            }
            ++i2;
        }
        i2 = minIndexPair[0];
        j = minIndexPair[1];
        Set<E> first = items.get(i2);
        Set<E> second = items.get(j);
        HashSet<E> third = new HashSet<E>();
        third.addAll(first);
        third.addAll(second);
        double firstDistance = new Double(distanceMatrix[i2][j]) / new Double(2.0) + new Double(r[i2] - r[j]) / new Double(2 * (n - 2));
        double secondDistance = new Double(distanceMatrix[i2][j]) - firstDistance;
        Link<Set<E>> firstLink = graph.addArc(third, first, 1.0);
        firstLink.setTag(String.valueOf(firstDistance));
        Link<Set<E>> secondLink = graph.addArc(third, second, 1.0);
        secondLink.setTag(String.valueOf(secondDistance));
        Node thirdNode = graph.getNode(third);
        thirdNode.setLabel(String.valueOf(distanceMatrix[i2][j]));
        HashMap<Set<E>, Integer> indexMap = new HashMap<Set<E>, Integer>();
        int k = 0;
        while (k < n) {
            indexMap.put(items.get(k), k);
            ++k;
        }
        items.remove(first);
        items.remove(second);
        items.add(third);
        double[][] result = new double[n - 1][n - 1];
        int u = 0;
        while (u < n - 1) {
            int uold = -1;
            if (u < n - 2) {
                uold = (Integer)indexMap.get(items.get(u));
            }
            int v = 0;
            while (v < u) {
                int vold = (Integer)indexMap.get(items.get(v));
                result[u][v] = u < n - 2 ? distanceMatrix[uold][vold] : (distanceMatrix[i2][vold] == 100.0 && distanceMatrix[j][vold] == 100.0 ? 100.0 : (distanceMatrix[i2][vold] + distanceMatrix[j][vold] - distanceMatrix[i2][j]) / 2.0);
                result[v][u] = result[u][v];
                ++v;
            }
            ++u;
        }
        return result;
    }

    public static <E> Partition<Node<E>> getDepthPartition(Graph<E> source) {
        Partition result = new Partition();
        result.setLabel(source.getLabel());
        Nodes<E> roots = new Nodes<E>();
        for (Node<E> node : source.getNodes()) {
            if (node.getInDegree() != 0) continue;
            roots.add(node);
        }
        for (Node<E> root : roots) {
            Stack stack = new Stack();
            int step = 0;
            stack.push(root);
            result.put(root, new Value(step));
            root.setAttribute("STEP", String.valueOf(step));
            while (!stack.isEmpty()) {
                Node parent = (Node)stack.pop();
                step = Integer.parseInt(parent.getAttributeValue("STEP")) + 1;
                for (Node child : parent.getOutNodes()) {
                    if (result.getItems().contains(child)) continue;
                    stack.push(child);
                    result.put(child, new Value(step));
                    child.setAttribute("STEP", String.valueOf(step));
                }
            }
        }
        return result;
    }
}

