/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.graphs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.graphs.Node;
import org.tip.puck.graphs.NodeComparatorById;
import org.tip.puck.graphs.NodeComparatorByLabel;

public class Nodes<E>
implements Iterable<Node<E>> {
    private HashMap<Integer, Node<E>> idToNode;
    private HashMap<E, Node<E>> referentToNode;

    public Nodes() {
        this.idToNode = new HashMap();
        this.referentToNode = new HashMap();
    }

    public Nodes(int initialCapacity) {
        this.idToNode = new HashMap(initialCapacity);
        this.referentToNode = new HashMap(initialCapacity);
    }

    public Node<E> add(E referent) {
        Node<E> result = new Node<E>(this.size() + 1, referent);
        this.idToNode.put(result.getId(), result);
        this.referentToNode.put(result.getReferent(), result);
        return result;
    }

    public Node<E> add(int id, E referent) {
        Node<E> result = new Node<E>(id, referent);
        this.idToNode.put(result.getId(), result);
        this.referentToNode.put(result.getReferent(), result);
        return result;
    }

    public void add(Node<E> node) {
        this.idToNode.put(node.getId(), node);
        this.referentToNode.put(node.getReferent(), node);
    }

    public void addAll(Nodes<E> nodes) {
        for (Node<E> node : nodes) {
            this.add(node);
        }
    }

    public void clear() {
        this.referentToNode.clear();
        this.idToNode.clear();
    }

    public boolean contains(Node<E> node) {
        boolean result = this.idToNode.get(node.getId()) != null;
        return result;
    }

    public Node<E> get(E referent) {
        Node<E> result = this.referentToNode.get(referent);
        return result;
    }

    public Node<E> get(int id) {
        Node<E> result = this.idToNode.get(id);
        return result;
    }

    public Nodes<E> getDirectNeighbors() {
        Nodes<E> result = new Nodes<E>();
        for (Node<E> node : this) {
            result.addAll(node.getDirectNeighbors());
        }
        return result;
    }

    public Nodes<E> getNodesByTag(String tag) {
        Nodes<E> result = new Nodes<E>();
        for (Node<E> node : this) {
            if (!StringUtils.equals((CharSequence)node.getTag(), (CharSequence)tag)) continue;
            result.add(node);
        }
        return result;
    }

    @Override
    public Iterator<Node<E>> iterator() {
        Iterator<Node<E>> result = this.idToNode.values().iterator();
        return result;
    }

    public int size() {
        int result = this.idToNode.size();
        return result;
    }

    public List<Node<E>> toList() {
        ArrayList<Node<E>> result = new ArrayList<Node<E>>(this.idToNode.values());
        return result;
    }

    public List<Node<E>> toListSortedById() {
        List<Node<E>> result = this.toList();
        Collections.sort(result, new NodeComparatorById());
        return result;
    }

    public List<Node<E>> toListSortedByLabel() {
        List<Node<E>> result = this.toList();
        Collections.sort(result, new NodeComparatorByLabel());
        return result;
    }

    public boolean removeNode(Node<E> node) {
        boolean result;
        if (node == null) {
            result = false;
        } else {
            this.idToNode.remove(node.getId());
            this.referentToNode.remove(node.getReferent());
            result = true;
        }
        return result;
    }
}

