/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.spaces;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.census.workers.CensusCriteria;
import org.tip.puck.census.workers.CensusReporter;
import org.tip.puck.census.workers.CircuitType;
import org.tip.puck.net.Individual;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.RelationValuator;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportChart;
import org.tip.puck.report.ReportTable;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.spaces.Space;
import org.tip.puck.spaces.Spaces;
import org.tip.puck.statistics.StatisticsCriteria;
import org.tip.puck.statistics.StatisticsReporter;
import org.tip.puck.util.Chronometer;
import org.tip.puck.util.Value;

public class SpaceReporter {
    public static Report reportStatics(Segmentation segmentation, String relationModelName, String egoRoleName, List<Integer> times, String filterLabel, StatisticsCriteria criteria) throws PuckException {
        if (segmentation == null || relationModelName == null || egoRoleName == null || times == null || criteria == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        Report result = new Report("Statics " + filterLabel);
        Chronometer chrono = new Chronometer();
        result.setOrigin("Space reporter");
        Spaces spaces = new Spaces(segmentation, relationModelName, egoRoleName, times, filterLabel);
        for (PartitionCriteria partitionCriteria : criteria.getPartitionCriterias()) {
            if (StringUtils.isEmpty((CharSequence)partitionCriteria.getLabel())) continue;
            ArrayList<ReportChart> charts = new ArrayList<ReportChart>(20);
            ArrayList<ReportTable> tables = new ArrayList<ReportTable>(20);
            for (Space space : spaces) {
                if (partitionCriteria.getLabel().equals("AGE") || partitionCriteria.getLabel().equals("MATRISTATUS")) {
                    partitionCriteria.setLabelParameter(String.valueOf(space.getId()));
                }
                Partition<Individual> partition = PartitionMaker.create(space.getLabel(), space, partitionCriteria);
                ReportChart chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, criteria.getSplitCriteria());
                charts.add(chart);
                ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
                tables.add(table);
            }
            int nr = Math.min(4, spaces.size());
            int chartIndex = 0;
            while (chartIndex < charts.size()) {
                result.outputs().append((ReportChart)charts.get(chartIndex));
                if (chartIndex % nr == nr - 1) {
                    result.outputs().appendln();
                }
                ++chartIndex;
            }
            for (ReportTable table : tables) {
                result.outputs().appendln(table);
            }
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportDynamics(Segmentation segmentation, String relationModelName, String egoRoleName, List<Integer> times, String filterLabel, StatisticsCriteria criteria) throws PuckException {
        if (segmentation == null || relationModelName == null || egoRoleName == null || times == null || criteria == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        Report result = new Report("Dynamics " + filterLabel);
        Chronometer chrono = new Chronometer();
        result.setOrigin("Space reporter");
        Spaces filteredSpaces = new Spaces(segmentation, relationModelName, egoRoleName, times, filterLabel);
        Spaces totalSpaces = new Spaces(segmentation, relationModelName, egoRoleName, times, null);
        Collections.sort(times);
        ArrayList<ReportChart> charts = new ArrayList<ReportChart>(20);
        ArrayList<ReportTable> tables = new ArrayList<ReportTable>(20);
        String placeParameter = "DEPARTMENT";
        int i = 0;
        while (i < times.size() - 1) {
            int startTime = times.get(i);
            int endTime = times.get(i + 1);
            Space totalStartSpace = (Space)totalSpaces.getById(startTime);
            Space totalEndSpace = (Space)totalSpaces.getById(endTime);
            Space filteredStartSpace = (Space)filteredSpaces.getById(startTime);
            Space filteredEndSpace = (Space)filteredSpaces.getById(endTime);
            Partition<Individual> partition = new Partition<Individual>();
            partition.setLabel(String.valueOf(filterLabel) + " " + startTime + "-" + endTime);
            PartitionCriteria partitionCriteria = new PartitionCriteria();
            partitionCriteria.setLabel(partition.getLabel());
            Partition<Individual> destinations = new Partition<Individual>();
            destinations.setLabel("Destinations " + startTime + "/" + endTime);
            for (Individual individual : filteredStartSpace.population().toSortedList()) {
                if (IndividualValuator.lifeStatusAtYear(individual, endTime).equals("DEAD")) {
                    partition.put(individual, new Value("DIED"));
                    continue;
                }
                if (!totalEndSpace.population().contains(individual)) {
                    partition.put(individual, new Value("UNKNOWN DESTINATION"));
                    continue;
                }
                if (!filteredEndSpace.population().contains(individual)) {
                    partition.put(individual, new Value("LEFT"));
                    destinations.put(individual, RelationValuator.get(totalEndSpace.getState(individual), "PLACE", (Object)placeParameter));
                    continue;
                }
                if (!filteredEndSpace.getState(individual).getAttributeValue(filterLabel).equals(filteredStartSpace.getState(individual).getAttributeValue(filterLabel))) {
                    partition.put(individual, new Value("INTERNAL CHANGE"));
                    continue;
                }
                partition.put(individual, new Value("UNCHANGED"));
            }
            Partition<Individual> origins = new Partition<Individual>();
            destinations.setLabel("Origins " + startTime + "/" + endTime);
            for (Individual individual : filteredEndSpace.population().toSortedList()) {
                if (IndividualValuator.lifeStatusAtYear(individual, startTime).equals("UNBORN")) {
                    partition.put(individual, new Value("NEWBORN"));
                    continue;
                }
                if (!totalStartSpace.population().contains(individual)) {
                    partition.put(individual, new Value("UNKNOWN ORIGIN"));
                    continue;
                }
                if (!filteredStartSpace.population().contains(individual)) {
                    partition.put(individual, new Value("ENTERED"));
                    origins.put(individual, RelationValuator.get(totalStartSpace.getState(individual), "PLACE", (Object)placeParameter));
                    continue;
                }
                filteredStartSpace.getState(individual).getAttributeValue(filterLabel).equals(filteredEndSpace.getState(individual).getAttributeValue(filterLabel));
            }
            ReportChart chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, criteria.getSplitCriteria());
            charts.add(chart);
            ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
            tables.add(table);
            ReportChart chartDestinations = StatisticsReporter.createPartitionChart(destinations, partitionCriteria, criteria.getSplitCriteria());
            charts.add(chartDestinations);
            ReportTable tableDestinations = ReportTable.transpose(chartDestinations.createReportTableWithSum());
            tables.add(tableDestinations);
            ReportChart chartOrigins = StatisticsReporter.createPartitionChart(origins, partitionCriteria, criteria.getSplitCriteria());
            charts.add(chartOrigins);
            ReportTable tableOrigins = ReportTable.transpose(chartOrigins.createReportTableWithSum());
            tables.add(tableOrigins);
            ++i;
        }
        int nr = Math.min(4, 2 * totalSpaces.size());
        int chartIndex = 0;
        while (chartIndex < charts.size()) {
            result.outputs().append((ReportChart)charts.get(chartIndex));
            if (chartIndex % nr == nr - 1) {
                result.outputs().appendln();
            }
            ++chartIndex;
        }
        for (ReportTable table : tables) {
            result.outputs().appendln(table);
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static List<Report> reportRelationCensus(Segmentation segmentation, String relationModelName, String egoRoleName, String alterRoleName, Integer[] times, String filterLabel, StatisticsCriteria criteria, String pattern) throws PuckException {
        if (segmentation == null || relationModelName == null || egoRoleName == null || times == null || criteria == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        ArrayList<Report> result = new ArrayList<Report>();
        int i = 0;
        while (i < times.length) {
            int startTime = times[i];
            CensusCriteria censusCriteria = new CensusCriteria();
            censusCriteria.setClosingRelation(relationModelName);
            censusCriteria.setClosingRelationEgoRole(egoRoleName);
            censusCriteria.setClosingRelationAlterRole("REFERENT");
            censusCriteria.setRelationAttributeValue(filterLabel);
            censusCriteria.setRelationTime(startTime);
            censusCriteria.setCircuitType(CircuitType.RING);
            censusCriteria.setPattern(pattern);
            Report report = CensusReporter.reportFindCircuit(segmentation, censusCriteria, null);
            report.setTitle("Relations " + egoRoleName + " " + alterRoleName + " " + startTime);
            result.add(report);
            ++i;
        }
        return result;
    }
}

