/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.sequences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tip.puck.PuckException;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.GraphProfile;
import org.tip.puck.graphs.Node;
import org.tip.puck.graphs.workers.GraphUtils;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.report.ReportChart;
import org.tip.puck.report.ReportTable;
import org.tip.puck.statistics.StatisticsReporter;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.Value;

public class CorrelationMatrix {
    String type;
    String eventTypeName;
    Map<Individual, List<String>> singles;
    Map<Individual, List<String[]>> pairs;
    Map<Value, Double[]> singleProbas;
    Map<Value, Double[]> pairProbas;
    Map<Value, Double[]> confidence;
    Map<Value, Double[]> lift;
    Partition<String>[] partitions;
    Graph<Cluster<String>>[] sequenceNetworks;
    Partition<Node<Cluster<String>>>[] depthPartitions;
    GraphProfile<Cluster<String>>[] sequenceNetworkProfiles;
    List<String> names;
    int maxDepth;

    public CorrelationMatrix(String type, String eventTypeName, Map<Individual, List<String>> singles, Map<Individual, List<String[]>> pairs) {
        int i;
        this.type = type;
        this.eventTypeName = eventTypeName;
        this.singles = singles;
        this.pairs = pairs;
        this.singleProbas = new TreeMap<Value, Double[]>();
        this.pairProbas = new TreeMap<Value, Double[]>();
        this.maxDepth = 0;
        Double[] sums = new Double[]{0.0, 0.0, 0.0};
        this.partitions = new Partition[3];
        int i2 = 0;
        while (i2 < this.partitions.length) {
            this.partitions[i2] = new Partition();
            ++i2;
        }
        HashSet<String> nameSet = new HashSet<String>();
        for (Individual ego : singles.keySet()) {
            int gender = ego.getGender().toInt();
            List<String> singleList = singles.get(ego);
            if (singleList.size() > this.maxDepth) {
                this.maxDepth = singleList.size();
            }
            int i3 = 1;
            for (String single : singleList) {
                nameSet.add(single);
                Value singleValue = new Value(single);
                Double[] singleProba = this.singleProbas.get(singleValue);
                if (singleProba == null) {
                    singleProba = new Double[]{0.0, 0.0, 0.0};
                    this.singleProbas.put(singleValue, singleProba);
                }
                if (gender < 2) {
                    int n = gender;
                    singleProba[n] = singleProba[n] + 1.0;
                    int n2 = gender;
                    sums[n2] = sums[n2] + 1.0;
                    this.partitions[gender].put(String.valueOf(ego.getId()) + "-" + i3, singleValue);
                }
                singleProba[2] = singleProba[2] + 1.0;
                sums[2] = sums[2] + 1.0;
                this.partitions[2].put(String.valueOf(ego.getId()) + "-" + i3, singleValue);
                ++i3;
            }
            List<String[]> pairList = pairs.get(ego);
            for (String[] pair : pairList) {
                Value pairValue = new Value(pair);
                Double[] pairProba = this.pairProbas.get(pairValue);
                if (pairProba == null) {
                    pairProba = new Double[]{0.0, 0.0, 0.0};
                    this.pairProbas.put(pairValue, pairProba);
                }
                if (gender < 2) {
                    int n = gender;
                    pairProba[n] = pairProba[n] + 1.0;
                }
                pairProba[2] = pairProba[2] + 1.0;
            }
        }
        for (Double[] singleProba : this.singleProbas.values()) {
            i = 0;
            while (i < singleProba.length) {
                singleProba[i] = MathUtils.percent(singleProba[i], sums[i]);
                ++i;
            }
        }
        for (Double[] pairProba : this.pairProbas.values()) {
            i = 0;
            while (i < pairProba.length) {
                pairProba[i] = MathUtils.percent(pairProba[i], sums[i]);
                ++i;
            }
        }
        this.names = new ArrayList<String>(nameSet);
        Collections.sort(this.names);
    }

    public Graph<Cluster<String>>[] getSequenceNetworks() {
        if (this.sequenceNetworks == null) {
            this.sequenceNetworks = new Graph[3];
            this.sequenceNetworkProfiles = new GraphProfile[3];
            Gender[] genderArray = Gender.values();
            int n = genderArray.length;
            int n2 = 0;
            while (n2 < n) {
                Gender gender = genderArray[n2];
                this.sequenceNetworks[gender.toInt()] = this.getSequenceNetwork(this.type, gender);
                this.sequenceNetworkProfiles[gender.toInt()] = new GraphProfile<Cluster<String>>(this.sequenceNetworks[gender.toInt()]);
                ++n2;
            }
        }
        return this.sequenceNetworks;
    }

    public Partition<Node<Cluster<String>>>[] getDepthPartitions() {
        if (this.depthPartitions == null) {
            if (this.sequenceNetworks == null) {
                this.getSequenceNetworks();
            }
            this.depthPartitions = new Partition[3];
            Gender[] genderArray = Gender.values();
            int n = genderArray.length;
            int n2 = 0;
            while (n2 < n) {
                Gender gender = genderArray[n2];
                this.depthPartitions[gender.toInt()] = GraphUtils.getDepthPartition(this.sequenceNetworks[gender.toInt()]);
                ++n2;
            }
        }
        return this.depthPartitions;
    }

    public Graph<Cluster<String>> getSequenceNetwork(String type, Gender gender) {
        String genderName = "ALL";
        if (gender != Gender.UNKNOWN) {
            genderName = gender.toString();
        }
        Graph<Cluster<String>> result = new Graph<Cluster<String>>(String.valueOf(type) + "_" + this.eventTypeName + "_" + genderName);
        Partition<String> partition = this.partitions[gender.toInt()];
        for (String name : this.names) {
            Cluster<String> cluster = partition.getCluster(new Value(name));
            if (cluster != null) {
                result.addNode(cluster);
                continue;
            }
            if (!type.equals("Event Type Network")) continue;
            result.addNode(new Cluster(new Value(name)));
        }
        for (Individual ego : this.pairs.keySet()) {
            if (!gender.isUnknown() && (gender.isUnknown() || gender != ego.getGender())) continue;
            for (String[] pair : this.pairs.get(ego)) {
                Cluster<String> previous = partition.getCluster(new Value(pair[0]));
                Cluster<String> next = partition.getCluster(new Value(pair[1]));
                result.incArcWeight(previous, next);
            }
        }
        HashSet values = new HashSet();
        for (Node node : result.getNodes()) {
            Value clusterValue;
            Cluster referent = (Cluster)node.getReferent();
            if (referent == null || (clusterValue = referent.getValue()) == null) continue;
            String value = clusterValue.toString();
            if (value.lastIndexOf("-") > -1) {
                value = value.substring(value.lastIndexOf("-") + 1);
            }
            node.setAttribute(this.eventTypeName, value);
        }
        return result;
    }

    public Double getConfidence(String[] pairLabel, int gender) {
        Double result = MathUtils.percent(this.pairProbas.get(new Value(pairLabel))[gender], this.singleProbas.get(new Value(pairLabel[0]))[gender]);
        return result;
    }

    public Double getLift(String[] pairLabel, int gender) {
        Double result = MathUtils.percent(this.pairProbas.get(new Value(pairLabel))[gender], this.singleProbas.get(new Value(pairLabel[0]))[gender] * this.singleProbas.get(new Value(pairLabel[1]))[gender]);
        return result;
    }

    public Double getPairProba(String[] pairLabel, int gender) {
        Double result = pairLabel == null ? null : this.pairProbas.get(new Value(pairLabel))[gender];
        return result;
    }

    public Double getSingleProba(String singleLabel, int gender) {
        Double result = singleLabel == null ? null : this.singleProbas.get(new Value(singleLabel))[gender];
        return result;
    }

    public ReportChart getSingleProbaChart() throws PuckException {
        ReportChart result = StatisticsReporter.createMapChart(this.singleProbas, String.valueOf(this.type) + " " + this.eventTypeName + " (Single Frequencies)", new String[]{"MALE", "FEMALE"}, ReportChart.GraphType.STACKED_BARS);
        return result;
    }

    public ReportChart getPairProbaChart() throws PuckException {
        ReportChart result = StatisticsReporter.createMapChart(this.pairProbas, String.valueOf(this.type) + " " + this.eventTypeName + " (Connected Frequencies)", new String[]{"MALE", "FEMALE"}, ReportChart.GraphType.STACKED_BARS);
        return result;
    }

    public ReportChart getConfidenceChart() throws PuckException {
        ReportChart result = StatisticsReporter.createMapChart(this.pairProbas, String.valueOf(this.type) + " " + this.eventTypeName + " (Confidence)", new String[]{"MALE", "FEMALE"}, ReportChart.GraphType.STACKED_BARS);
        return result;
    }

    public ReportChart getLiftChart() throws PuckException {
        ReportChart result = StatisticsReporter.createMapChart(this.pairProbas, String.valueOf(this.type) + " " + this.eventTypeName + " (Lift)", new String[]{"MALE", "FEMALE"}, ReportChart.GraphType.STACKED_BARS);
        return result;
    }

    public ReportChart getRamificationChart() throws PuckException {
        ReportChart result = StatisticsReporter.createRamificationChart(this.depthPartitions, this.totalSums(), this.eventTypeName);
        return result;
    }

    public List<ReportChart> getCharts() throws PuckException {
        ArrayList<ReportChart> result = new ArrayList<ReportChart>();
        result.add(this.getSingleProbaChart());
        result.add(this.getPairProbaChart());
        result.add(this.getConfidenceChart());
        result.add(this.getLiftChart());
        if (this.depthPartitions != null) {
            result.add(this.getRamificationChart());
        }
        return result;
    }

    public ReportTable getTable(String title) {
        int rowCount = this.pairProbas.size() + 1;
        int columnCount = 18;
        ReportTable result = new ReportTable(rowCount, columnCount);
        result.setTitle(title);
        String[] headers = new String[]{"Pair Proba", "First Proba", "Second Proba", "Confidence", "Lift"};
        String[] genders = new String[]{"Male", "Female", "All"};
        int columnIndex = 1;
        String[] stringArray = genders;
        int n = genders.length;
        int n2 = 0;
        while (n2 < n) {
            String gender = stringArray[n2];
            String[] stringArray2 = headers;
            int n3 = headers.length;
            int n4 = 0;
            while (n4 < n3) {
                String header = stringArray2[n4];
                result.set(0, columnIndex, String.valueOf(header) + " (" + gender + ")");
                ++columnIndex;
                ++n4;
            }
            ++n2;
        }
        int rowIndex = 1;
        for (Value value : this.pairProbas.keySet()) {
            String[] pairLabel = value.stringArrayValue();
            columnIndex = 0;
            result.set(rowIndex, columnIndex, value);
            ++columnIndex;
            int i = 0;
            while (i < 3) {
                result.set(rowIndex, columnIndex, this.getPairProba(pairLabel, i));
                result.set(rowIndex, ++columnIndex, this.getSingleProba(pairLabel[0], i));
                result.set(rowIndex, ++columnIndex, this.getSingleProba(pairLabel[1], i));
                result.set(rowIndex, ++columnIndex, this.getConfidence(pairLabel, i));
                result.set(rowIndex, ++columnIndex, this.getLift(pairLabel, i));
                ++columnIndex;
                ++i;
            }
            ++rowIndex;
        }
        return result;
    }

    private int[][] totalSums() {
        int[][] result = new int[this.maxDepth][3];
        for (Individual ego : this.singles.keySet()) {
            List<String> list = this.singles.get(ego);
            int i = 0;
            while (i < list.size()) {
                int[] nArray = result[i];
                int n = ego.getGender().toInt();
                nArray[n] = nArray[n] + 1;
                int[] nArray2 = result[i];
                nArray2[2] = nArray2[2] + 1;
                ++i;
            }
        }
        return result;
    }

    public double getDensity(Gender gender) {
        double result = GraphUtils.density(this.getSequenceNetworks()[gender.toInt()]);
        return result;
    }

    public GraphProfile<Cluster<String>> getProfile(Gender gender) {
        return this.sequenceNetworkProfiles[gender.toInt()];
    }
}

