/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.workers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Families;
import org.tip.puck.net.Family;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.util.NumberedValues;
import org.tip.puck.util.Value;

public class FamilyValuator {
    public static final Pattern YEAR_PATTERN = Pattern.compile("(\\d\\d\\d\\d)");

    public static String extractYear(String source) {
        String result;
        if (source == null) {
            result = null;
        } else {
            try {
                result = String.valueOf(Integer.parseInt(source));
            }
            catch (NumberFormatException nfe) {
                Matcher matcher = YEAR_PATTERN.matcher(source);
                result = matcher.find() && matcher.groupCount() > 0 ? matcher.group(1) : null;
            }
        }
        return result;
    }

    public static NumberedValues get(Families source, String label) {
        NumberedValues result = FamilyValuator.get(source, label, null);
        return result;
    }

    public static NumberedValues get(Families source, String label, Object parameter) {
        NumberedValues result = new NumberedValues();
        for (Family family : source) {
            result.put(family.getId(), FamilyValuator.get(family, label, parameter));
        }
        return result;
    }

    public static Value get(Family source, String label) {
        Value result = FamilyValuator.get(source, label, null);
        return result;
    }

    public static Value get(Family source, String label, Object parameter) {
        Object result;
        EndogenousLabel enogenousLabel;
        try {
            enogenousLabel = EndogenousLabel.valueOf(label.replace(" ", "_"));
        }
        catch (IllegalArgumentException exception) {
            enogenousLabel = null;
        }
        if (enogenousLabel == null) {
            String year;
            String attributeValue = source.getAttributeValue(label);
            result = attributeValue == null ? null : (label.toUpperCase().contains("YEAR") ? ((year = FamilyValuator.extractYear(attributeValue = source.getAttributeValue(label.replaceAll("DATE", "YEAR")))) == null ? null : new Value(Integer.parseInt(year))) : new Value(attributeValue));
        } else {
            switch (enogenousLabel) {
                case CHILDCOUNT: {
                    result = new Value(source.getChildren().size());
                    break;
                }
                case FATHERNAME: {
                    if (source.getFather() == null) {
                        result = null;
                        break;
                    }
                    result = new Value(source.getFather().getName());
                    break;
                }
                case HASFATHER: {
                    if (source.getFather() == null) {
                        result = new Value("WITH FATHER");
                        break;
                    }
                    result = new Value("WITHOUT FATHER");
                    break;
                }
                case HASMOTHER: {
                    if (source.getMother() == null) {
                        result = new Value("WITH MOTHER");
                        break;
                    }
                    result = new Value("WITHOUT MOTHER");
                    break;
                }
                case HUSBAND_ORDER: {
                    if (source.getHusbandOrder() == null) {
                        result = null;
                        break;
                    }
                    result = new Value(source.getHusbandOrder());
                    break;
                }
                case ID: {
                    result = new Value(source.getId());
                    break;
                }
                case ISFERTILE: {
                    if (source.isFertile()) {
                        result = new Value("FERTILE");
                        break;
                    }
                    result = new Value("INFERTILE");
                    break;
                }
                case ISDIVORCED: {
                    if (source.isMarried()) {
                        result = new Value("DIVORCED");
                        break;
                    }
                    result = new Value("NOT DIVORCED");
                    break;
                }
                case ISMARRIED: {
                    if (source.isMarried()) {
                        result = new Value("MARRIED");
                        break;
                    }
                    result = new Value("NOT MARRIED");
                    break;
                }
                case MOTHERNAME: {
                    if (source.getMother() == null) {
                        result = null;
                        break;
                    }
                    result = new Value(source.getMother().getName());
                    break;
                }
                case PARENTCOUNT: {
                    int count = 0;
                    if (source.getFather() != null) {
                        ++count;
                    }
                    if (source.getMother() != null) {
                        ++count;
                    }
                    result = new Value(count);
                    break;
                }
                case UNIONSTATUS: {
                    result = new Value(source.getUnionStatus());
                    break;
                }
                case WIFE_ORDER: {
                    result = source.getWifeOrder() == null ? null : new Value(source.getWifeOrder());
                }
                default: {
                    result = null;
                }
            }
        }
        return result;
    }

    public static List<String> getAttributeLabels(Families source) {
        List<String> result = FamilyValuator.getAttributeLabels(source, null);
        return result;
    }

    public static List<String> getAttributeLabels(Families source, Integer limit) {
        ArrayList<String> result = new ArrayList<String>(20);
        EndogenousLabel[] endogenousLabelArray = EndogenousLabel.values();
        int n = endogenousLabelArray.length;
        int n2 = 0;
        while (n2 < n) {
            EndogenousLabel label = endogenousLabelArray[n2];
            result.add(label.toString());
            ++n2;
        }
        result.addAll(FamilyValuator.getExogenousAttributeLabels(source, limit));
        Collections.sort(result);
        return result;
    }

    public static List<String> getAttributeLabelSample(Families source) {
        List<String> result = FamilyValuator.getAttributeLabels(source, 10000);
        return result;
    }

    public static List<String> getExogenousAttributeLabels(Families source) {
        List<String> result = FamilyValuator.getExogenousAttributeLabels(source, null);
        return result;
    }

    public static List<String> getExogenousAttributeLabels(Families source, Integer limit) {
        ArrayList<String> result = new ArrayList<String>(20);
        if (source != null) {
            HashSet<String> buffer = new HashSet<String>();
            int index = 0;
            Iterator iterator = source.iterator();
            while (iterator.hasNext() && (limit == null || index < limit)) {
                Family family = (Family)iterator.next();
                for (Attribute attribute : family.attributes()) {
                    buffer.add(attribute.getLabel());
                }
                ++index;
            }
            for (String string : buffer) {
                result.add(string);
            }
            Collections.sort(result);
        }
        return result;
    }

    public static Integer getMarrYear(Family family) {
        String marrYear;
        Integer result = family == null ? null : ((marrYear = FamilyValuator.extractYear(family.getAttributeValue("MARR_DATE"))) == null ? null : Integer.valueOf(Integer.parseInt(marrYear)));
        return result;
    }

    public static Integer getDivYear(Family family) {
        String divYear;
        Integer result = family == null ? null : ((divYear = FamilyValuator.extractYear(family.getAttributeValue("DIV_DATE"))) == null ? null : Integer.valueOf(Integer.parseInt(divYear)));
        return result;
    }

    public static Double getSpouseDistance(Family family, NumberedValues data) {
        Double result = null;
        if (family.getHusband() != null && family.getWife() != null) {
            Value husbandValue = (Value)data.get(family.getHusband().getId());
            Value wifeValue = (Value)data.get(family.getWife().getId());
            if (husbandValue != null && wifeValue != null && husbandValue.isNumber() && wifeValue.isNumber()) {
                result = husbandValue.doubleValue() - wifeValue.doubleValue();
            }
        }
        return result;
    }

    public static Double getSpouseDistance(Family family, String label) {
        Double result = null;
        if (family.getHusband() != null && family.getWife() != null) {
            Value husbandValue = IndividualValuator.get(family.getHusband(), label);
            Value wifeValue = IndividualValuator.get(family.getWife(), label);
            if (husbandValue != null && wifeValue != null && husbandValue.isNumber() && wifeValue.isNumber()) {
                result = husbandValue.doubleValue() - wifeValue.doubleValue();
            }
        }
        return result;
    }

    public static enum EndogenousLabel {
        CHILDCOUNT,
        FATHERNAME,
        HASFATHER,
        HASMOTHER,
        HUSBAND_ORDER,
        ID,
        ISFERTILE,
        ISDIVORCED,
        ISMARRIED,
        MOTHERNAME,
        PARENTCOUNT,
        UNIONSTATUS,
        WIFE_ORDER;

    }
}

