/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tip.puck.net.Gender;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.RoleDefinition;
import org.tip.puck.net.relations.RoleDefinitionComparator;
import org.tip.puck.net.relations.Roles;
import org.tip.puck.util.NumberablesHashMap;

public class RoleDefinitions
extends NumberablesHashMap<RoleDefinition> {
    boolean egoGenderDistinction;
    RoleDefinitions recursiveDefinitions;
    Map<Role, Roles> factors;

    public RoleDefinitions() {
    }

    public RoleDefinitions(RoleDefinitions roleDefinitions) {
        for (RoleDefinition roleDefinition : roleDefinitions) {
            this.add(roleDefinition.clone());
        }
    }

    public RoleDefinitions get(RoleDefinition.Primary primary, Role inversion, Roles composition, Gender alterGender, RoleDefinition.AlterAge alterAge, Gender egoGender) {
        RoleDefinitions result = new RoleDefinitions();
        for (RoleDefinition def : this) {
            if (def.primary() != primary || def.inversion() != inversion || def.composition() != composition || def.alterGender() != alterGender && def.alterGender() != null && alterGender != null || def.alterAge() != alterAge && def.alterAge() != null && alterAge != null || def.egoGender() != egoGender && def.egoGender() != null && egoGender != null) continue;
            result.add(def);
        }
        return result;
    }

    public boolean isPrimaryParent(RoleDefinition roleDefinition) {
        return roleDefinition.primary() == RoleDefinition.Primary.PARENT;
    }

    public boolean isPrimarySibling(RoleDefinition roleDefinition) {
        return roleDefinition.primary() == RoleDefinition.Primary.SIBLING;
    }

    public boolean isPrimarySpouse(RoleDefinition roleDefinition) {
        return roleDefinition.primary() == RoleDefinition.Primary.SPOUSE;
    }

    public boolean isPrimaryChild(RoleDefinition roleDefinition) {
        boolean result = false;
        for (RoleDefinition inverseDefinition : this.getDefinitions(roleDefinition.inversion())) {
            if (!this.isPrimaryParent(inverseDefinition)) continue;
            result = true;
        }
        return result;
    }

    public Roles getCompositeRoles(Role alpha, Role beta) {
        Roles result = new Roles();
        for (RoleDefinition alphaDef : this.getDefinitions(alpha)) {
            for (RoleDefinition betaDef : this.getDefinitions(beta)) {
                Role deltaBeta;
                Object delta;
                Role gamma;
                if (this.isPrimaryChild(betaDef)) {
                    if (this.isPrimaryParent(alphaDef)) {
                        for (RoleDefinition siblingDef : this.get(RoleDefinition.Primary.SIBLING, null, null, betaDef.alterGender(), betaDef.alterAge(), alphaDef.egoGender())) {
                            if (result.contains(siblingDef.role())) continue;
                            result.add(siblingDef.role());
                        }
                        continue;
                    }
                    if (alphaDef.composition() == null) continue;
                    gamma = (Role)alphaDef.composition().get(0);
                    delta = (Role)alphaDef.composition().get(1);
                    for (RoleDefinition deltaDef : this.getDefinitions((Role)delta)) {
                        if (!this.isPrimaryParent(deltaDef)) continue;
                        for (RoleDefinition siblingDef : this.get(RoleDefinition.Primary.SIBLING, null, null, betaDef.alterGender(), betaDef.alterAge(), deltaDef.egoGender())) {
                            deltaBeta = siblingDef.role();
                            for (Role gammaDeltaBeta : this.getCompositeRoles(gamma, deltaBeta)) {
                                if (result.contains(gammaDeltaBeta)) continue;
                                result.add(gammaDeltaBeta);
                            }
                        }
                    }
                    continue;
                }
                if (!this.isPrimaryParent(betaDef)) continue;
                if (this.isPrimaryChild(alphaDef)) {
                    for (RoleDefinition spouseDef : this.get(RoleDefinition.Primary.SPOUSE, null, null, betaDef.alterGender(), betaDef.alterAge(), alphaDef.egoGender())) {
                        if (result.contains(spouseDef.role())) continue;
                        result.add(spouseDef.role());
                    }
                    continue;
                }
                if (alphaDef.composition() == null) continue;
                gamma = (Role)alphaDef.composition().get(0);
                delta = (Role)alphaDef.composition().get(1);
                for (RoleDefinition deltaDef : this.getDefinitions((Role)delta)) {
                    if (!this.isPrimaryChild(deltaDef)) continue;
                    for (RoleDefinition spouseDef : this.get(RoleDefinition.Primary.SPOUSE, null, null, betaDef.alterGender(), betaDef.alterAge(), deltaDef.egoGender())) {
                        deltaBeta = spouseDef.role();
                        for (Role gammaDeltaBeta : this.getCompositeRoles(gamma, deltaBeta)) {
                            if (result.contains(gammaDeltaBeta)) continue;
                            result.add(gammaDeltaBeta);
                        }
                    }
                }
            }
        }
        if (!this.isComposite(beta)) {
            for (RoleDefinition def : this) {
                if (def.composition() == null || !((Role)def.composition().get(0)).equals(alpha) || !((Role)def.composition().get(1)).equals(beta) || result.contains(def.role())) continue;
                result.add(def.role());
            }
        } else {
            for (RoleDefinition compositeDefinition : this.getCompositeDefinitions(beta)) {
                if (this.isRecursive(compositeDefinition)) continue;
                Role gamma = (Role)compositeDefinition.composition().get(0);
                Role delta = (Role)compositeDefinition.composition().get(1);
                for (Role alphaGamma : this.getCompositeRoles(alpha, gamma)) {
                    for (Role alphaGammaDelta : this.getCompositeRoles(alphaGamma, delta)) {
                        if (result.contains(alphaGammaDelta)) continue;
                        result.add(alphaGammaDelta);
                    }
                }
            }
        }
        Collections.sort(result);
        return result;
    }

    private static RoleDefinition.AlterAge inverse(RoleDefinition.AlterAge age) {
        RoleDefinition.AlterAge result = null;
        if (age != null) {
            result = age.invert();
        }
        return result;
    }

    public boolean isRecursive(RoleDefinition roleDefinition) {
        boolean result = this.recursiveDefinitions().contains(roleDefinition);
        return result;
    }

    public Roles getReciprocalRoles(Role role) {
        Roles result = new Roles();
        for (RoleDefinition def : this.getDefinitions(role)) {
            if (this.isPrimarySibling(def)) {
                for (RoleDefinition siblingDef : this.get(RoleDefinition.Primary.SIBLING, null, null, def.egoGender(), RoleDefinitions.inverse(def.alterAge()), def.alterGender())) {
                    if (siblingDef == null || result.contains(siblingDef.role())) continue;
                    result.add(siblingDef.role());
                }
                continue;
            }
            if (this.isPrimarySpouse(def)) {
                for (RoleDefinition spouseDef : this.get(RoleDefinition.Primary.SPOUSE, null, null, def.egoGender(), RoleDefinitions.inverse(def.alterAge()), def.alterGender())) {
                    if (spouseDef == null || result.contains(spouseDef.role())) continue;
                    result.add(spouseDef.role());
                }
                continue;
            }
            if (def.inversion() != null) {
                result.add(def.inversion());
                continue;
            }
            for (RoleDefinition inverseDefinition : this.getInverseDefinitions(role)) {
                if (inverseDefinition.inversion() == null || result.contains(inverseDefinition.role())) continue;
                result.add(inverseDefinition.role());
            }
            for (RoleDefinition compositeDefinition : this.getCompositeDefinitions(role)) {
                if (this.isRecursive(compositeDefinition)) continue;
                for (Role alpha : this.getReciprocalRoles((Role)compositeDefinition.composition().get(0))) {
                    for (Role beta : this.getReciprocalRoles((Role)compositeDefinition.composition().get(1))) {
                        for (Role betaAlpha : this.getCompositeRoles(beta, alpha)) {
                            if (result.contains(betaAlpha)) continue;
                            result.add(betaAlpha);
                        }
                    }
                }
            }
        }
        return result;
    }

    public boolean isPrimary(Role role) {
        boolean result = this.getPrimaryDefinitions(role).size() > 0;
        return result;
    }

    public boolean isInverse(Role role) {
        boolean result = this.getInverseDefinitions(role).size() > 0;
        return result;
    }

    public boolean isComposite(Role role) {
        boolean result = this.getCompositeDefinitions(role).size() > 0;
        return result;
    }

    public RoleDefinitions getPrimaryDefinitions(Role role) {
        RoleDefinitions result = new RoleDefinitions();
        for (RoleDefinition definition : this.getDefinitions(role)) {
            if (definition.primary() == null) continue;
            result.add(definition);
        }
        return result;
    }

    public RoleDefinitions getInverseDefinitions(Role role) {
        RoleDefinitions result = new RoleDefinitions();
        for (RoleDefinition definition : this.getDefinitions(role)) {
            if (definition.inversion() != null) {
                result.add(definition);
                continue;
            }
            for (RoleDefinition otherDefinition : this) {
                if (otherDefinition.inversion() == null || !otherDefinition.inversion().equals(role) || result.contains(otherDefinition)) continue;
                result.add(otherDefinition);
            }
        }
        return result;
    }

    public RoleDefinitions getCompositeDefinitions(Role role) {
        RoleDefinitions result = new RoleDefinitions();
        for (RoleDefinition definition : this.getDefinitions(role)) {
            if (definition.composition() == null) continue;
            result.add(definition);
        }
        return result;
    }

    public RoleDefinitions getDefinitions(Role role) {
        RoleDefinitions result = new RoleDefinitions();
        for (RoleDefinition roleDefinition : this) {
            if (!roleDefinition.role().equals(role)) continue;
            result.add(roleDefinition);
        }
        return result;
    }

    public RoleDefinition getEgoGenderComplement(RoleDefinition source) {
        RoleDefinition result = null;
        for (RoleDefinition def : this) {
            if (def.primary() != source.primary() || !Role.equalOrBothNull(def.inversion(), source.inversion()) || !Roles.equalOrBothNull(def.composition(), source.composition()) || def.alterGender() != source.alterGender() || def.alterAge() != source.alterAge() || source.egoGender() == null || def.egoGender() != source.egoGender().invert()) continue;
            result = def;
            break;
        }
        return result;
    }

    public RoleDefinition getAlterGenderComplement(RoleDefinition source) {
        RoleDefinition result = null;
        for (RoleDefinition def : this) {
            if (def.primary() != source.primary() || !Role.equalOrBothNull(def.inversion(), source.inversion()) || !Roles.equalOrBothNull(def.composition(), source.composition()) || source.alterGender() == null || def.alterGender() != source.alterGender().invert() || def.alterAge() != source.alterAge() || def.egoGender() != source.egoGender()) continue;
            result = def;
            break;
        }
        return result;
    }

    public RoleDefinition getAlterAgeComplement(RoleDefinition source) {
        RoleDefinition result = null;
        for (RoleDefinition def : this) {
            if (def.primary() != source.primary() || !Role.equalOrBothNull(def.inversion(), source.inversion()) || !Roles.equalOrBothNull(def.composition(), source.composition()) || def.alterGender() != source.alterGender() || source.alterAge() == null || def.alterAge() != source.alterAge().invert() || def.egoGender() != source.egoGender()) continue;
            result = def;
            break;
        }
        return result;
    }

    public Roles getRoles(RoleDefinition.Primary primary, Gender alterGender, RoleDefinition.AlterAge alterAge, Gender egoGender) {
        Roles result = new Roles();
        for (RoleDefinition def : this) {
            if (def.primary() != primary || def.alterGender() != null && alterGender != null && alterGender != def.alterGender() || def.egoGender() != null && egoGender != null && egoGender != def.egoGender() || def.alterAge() != alterAge && def.alterAge() != null && alterAge != null || result.contains(def.role())) continue;
            result.add(def.role());
        }
        return result;
    }

    public Role getRoleByName(String name) {
        Role result = null;
        for (RoleDefinition def : this) {
            if (def.role() == null || !def.role().getName().equals(name)) continue;
            result = def.role();
            break;
        }
        return result;
    }

    public Roles getInverseRoles(Role role) {
        Roles result = new Roles();
        for (RoleDefinition def : this) {
            if (def.inversion() == null || !def.inversion().equals(role)) continue;
            result.add(def.role());
        }
        return result;
    }

    public Role getInverseRole(Role role, Gender egoGender, Gender alterGender) {
        Role result = null;
        for (RoleDefinition def : this) {
            if (def.inversion() != null && def.inversion().equals(role) && RoleDefinitions.genderMatch(egoGender, def.alterGender()) && RoleDefinitions.genderMatch(def.egoGender(), alterGender)) {
                result = def.role();
                break;
            }
            if (def.inversion() == null || !def.role().equals(role) || !RoleDefinitions.genderMatch(def.egoGender(), egoGender) || !RoleDefinitions.genderMatch(def.alterGender(), alterGender)) continue;
            result = def.inversion();
            break;
        }
        return result;
    }

    @Override
    public List<RoleDefinition> toSortedList() {
        List<RoleDefinition> result = this.toList();
        Collections.sort(result, new RoleDefinitionComparator());
        return result;
    }

    private static boolean genderMatch(Gender alphaGender, Gender betaGender) {
        return alphaGender == null || alphaGender == betaGender;
    }

    public boolean egoGenderDistinction() {
        return this.egoGenderDistinction;
    }

    public void setEgoGenderDistinction(boolean egoGenderDistinction) {
        this.egoGenderDistinction = egoGenderDistinction;
    }

    public List<Gender> getAlterGenders(Role role) {
        ArrayList<Gender> result = new ArrayList<Gender>();
        for (RoleDefinition def : this.getDefinitions(role)) {
            if (result.contains((Object)def.alterGender())) continue;
            result.add(def.alterGender());
        }
        return result;
    }

    public List<Gender> getMediusGenders(Role role) {
        ArrayList<Gender> result = new ArrayList<Gender>();
        for (RoleDefinition def : this.getDefinitions(role)) {
            if (def.composition() == null) continue;
            for (RoleDefinition mediusDef : this.getDefinitions((Role)def.composition().get(0))) {
                if (result.contains((Object)mediusDef.alterGender())) continue;
                result.add(mediusDef.alterGender());
            }
        }
        return result;
    }

    public RoleDefinitions neutralize() {
        RoleDefinitions result = new RoleDefinitions(this);
        for (RoleDefinition def : this) {
            if (result.getById(def.getId()) == null) continue;
            RoleDefinition egoGenderComplement = result.getEgoGenderComplement((RoleDefinition)result.getById(def.getId()));
            if (egoGenderComplement == null) {
                ((RoleDefinition)result.getById(def.getId())).setEgoGender(null);
                continue;
            }
            if (!egoGenderComplement.role().equals(def.role())) continue;
            ((RoleDefinition)result.getById(def.getId())).setEgoGender(null);
            result.removeById(egoGenderComplement.getId());
        }
        for (RoleDefinition def : this) {
            RoleDefinition alterGenderComplement;
            if (result.getById(def.getId()) == null || (alterGenderComplement = result.getAlterGenderComplement((RoleDefinition)result.getById(def.getId()))) == null || !alterGenderComplement.role().equals(def.role())) continue;
            ((RoleDefinition)result.getById(def.getId())).setAlterGender(null);
            result.removeById(alterGenderComplement.getId());
        }
        return result;
    }

    private Roles roles() {
        Roles result = new Roles();
        for (RoleDefinition definition : this) {
            if (definition.role() == null || result.contains(definition.role())) continue;
            result.add(definition.role());
        }
        return result;
    }

    public Map<Role, Roles> factors() {
        if (this.factors == null) {
            this.factors = new TreeMap<Role, Roles>();
            this.recursiveDefinitions = new RoleDefinitions();
            for (Role role : this.roles()) {
                this.factors.put(role, this.factors(role));
            }
        }
        return this.factors;
    }

    public RoleDefinitions recursiveDefinitions() {
        if (this.recursiveDefinitions == null) {
            this.factors();
        }
        return this.recursiveDefinitions;
    }

    private Roles factors(Role role) {
        Roles result = new Roles();
        LinkedList<Role> queue = new LinkedList<Role>();
        Roles visited = new Roles();
        queue.add(role);
        visited.add(role);
        while (!queue.isEmpty()) {
            Role factor = (Role)queue.remove();
            for (RoleDefinition definition : this.getDefinitions(factor)) {
                if (definition.primary() != null && !result.contains(factor)) {
                    result.add(factor);
                    continue;
                }
                if (definition.inversion() != null) {
                    Role inv = definition.inversion();
                    if (inv.equals(role)) {
                        this.recursiveDefinitions.add(definition);
                        continue;
                    }
                    if (visited.contains(inv)) continue;
                    queue.add(inv);
                    visited.add(inv);
                    continue;
                }
                if (definition.composition() == null) continue;
                for (Role comp : definition.composition()) {
                    if (comp.equals(role)) {
                        this.recursiveDefinitions.add(definition);
                        continue;
                    }
                    if (visited.contains(comp)) continue;
                    queue.add(comp);
                    visited.add(comp);
                }
            }
        }
        return result;
    }
}

