/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations;

import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.RelationModelStatistics;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.RoleDefinition;
import org.tip.puck.net.relations.RoleDefinitions;
import org.tip.puck.net.relations.Roles;
import org.tip.puck.report.Report;

public class RelationModelReporter {
    RelationModelStatistics statistics;
    RelationModel model;

    public RelationModelReporter(RelationModel model) {
        this.model = model;
        this.statistics = new RelationModelStatistics(model);
    }

    public Report reportModel() {
        Report result = new Report("Model " + this.model.getName());
        result.outputs().append(this.reportDefinitions());
        result.outputs().append(this.reportStatistics());
        result.outputs().append(this.reportReciprocals());
        result.outputs().append(this.reportCompositions());
        result.outputs().append(this.reportProblems());
        return result;
    }

    public Report reportDefinitions() {
        Report result = new Report("Definitions");
        result.outputs().appendln("Relation Model " + this.model.getName());
        result.outputs().appendln();
        for (RoleDefinition definition : this.model.roleDefinitions().neutralize().toSortedList()) {
            result.outputs().appendln(definition);
        }
        return result;
    }

    public Report reportProblems() {
        RoleDefinitions recursiveDefinitions;
        Report result = new Report("Problems");
        result.outputs().appendln("Relation Model " + this.model.getName());
        result.outputs().appendln();
        boolean noProblems = true;
        Roles undefinedRoles = this.statistics.undefinedRoles();
        if (undefinedRoles.size() > 0) {
            noProblems = false;
            result.outputs().appendln("Undefined roles: ");
            for (Role role : undefinedRoles) {
                result.outputs().appendln(role);
            }
            result.outputs().appendln();
        }
        if ((recursiveDefinitions = this.statistics.recursiveDefinitions()).size() > 0) {
            noProblems = false;
            result.outputs().appendln("Recursively defined roles: ");
            for (RoleDefinition definition : recursiveDefinitions.toSortedList()) {
                result.outputs().appendln(definition);
            }
            result.outputs().appendln();
        }
        if (noProblems) {
            result.outputs().appendln("No problems found");
        }
        return result;
    }

    public Report reportStatistics() {
        Report result = new Report("Statistics");
        result.outputs().appendln("Relation Model " + this.model.getName());
        result.outputs().appendln();
        result.outputs().appendln("Nr of Terms: " + this.statistics.termCount());
        result.outputs().appendln("Cousin Classification: " + this.statistics.cousinClassification());
        result.outputs().appendln();
        result.outputs().appendln();
        for (Role role : this.statistics.sortedRoles()) {
            result.outputs().appendln(String.valueOf(role.getName()) + "\t" + this.statistics.generations(role) + "\t" + this.statistics.genders(role) + "\t" + this.statistics.links(role));
        }
        return result;
    }

    public Report reportCompositions() {
        Report result = new Report("Compositions");
        result.outputs().appendln("Compositions: Relation Model " + this.model.getName());
        result.outputs().appendln();
        for (Role alpha : this.statistics.roles) {
            for (Role beta : this.statistics.roles) {
                Roles alphaBeta = this.statistics.roleDefinitions.getCompositeRoles(alpha, beta);
                if (alphaBeta.size() <= 0) continue;
                String composition = alpha + " \u221e " + beta + " = ";
                for (Role gamma : alphaBeta) {
                    composition = String.valueOf(composition) + gamma + ", ";
                }
                result.outputs().appendln(composition);
            }
        }
        return result;
    }

    public Report reportReciprocals() {
        Report result = new Report("Reciprocals");
        result.outputs().appendln("Reciprocals: Relation Model " + this.model.getName());
        result.outputs().appendln();
        for (Role alpha : this.statistics.roles) {
            Roles inverseAlpha = this.statistics.roleDefinitions.getReciprocalRoles(alpha);
            if (inverseAlpha.size() <= 0) continue;
            String reciprocal = alpha + " = -";
            for (Role beta : inverseAlpha) {
                reciprocal = String.valueOf(reciprocal) + beta + ", ";
            }
            result.outputs().appendln(reciprocal);
        }
        return result;
    }
}

