/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.gis;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.map.Layer;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.tip.puck.PuckException;
import org.tip.puck.geo.Place;
import org.tip.puck.graphs.Graph;
import org.tip.puckgui.GroupNetGUI;
import org.tip.puckgui.views.geo.MapPanel;

public class SIGFile {
    public static <E> void exportToGIS(Graph<Place> source, String fileName) throws PuckException {
    }

    public static void exportToShapefile(GroupNetGUI gui, File file) {
        MapPanel mapPanel = (MapPanel)gui.getWindow().getSelectedTab();
        List layersList = mapPanel.getLayers();
        DefaultTransaction t = null;
        try {
            for (Layer layer : layersList) {
                t = new DefaultTransaction();
                SimpleFeatureSource featureSource = (SimpleFeatureSource)layer.getFeatureSource();
                SimpleFeatureType ft = (SimpleFeatureType)featureSource.getSchema();
                String name = String.valueOf(file.toString()) + "_" + ft.getTypeName();
                String schemaName = name.substring(name.lastIndexOf("/") + 1, name.length());
                File shapeFile = new File(String.valueOf(name) + ".shp");
                URL shapeURL = shapeFile.toURI().toURL();
                HashMap<String, URL> creationParams = new HashMap<String, URL>();
                creationParams.put("url", shapeURL);
                FileDataStoreFactorySpi factory = FileDataStoreFinder.getDataStoreFactory((String)"shp");
                DataStore dataStore = factory.createNewDataStore(creationParams);
                dataStore.createSchema((FeatureType)ft);
                SimpleFeatureStore featureStore = (SimpleFeatureStore)dataStore.getFeatureSource(schemaName);
                SimpleFeatureCollection collection = featureSource.getFeatures();
                featureStore.addFeatures((FeatureCollection)collection);
                t.commit();
                t.close();
            }
        }
        catch (Exception eek) {
            eek.printStackTrace();
            try {
                t.rollback();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

