/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.graphs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tip.puck.graphs.Link;
import org.tip.puck.graphs.Links;
import org.tip.puck.graphs.Node;
import org.tip.puck.graphs.Nodes;
import org.tip.puck.matrix.Matrix;
import org.tip.puck.matrix.SparseMatrix;
import org.tip.puck.net.Attributes;

public class Graph<E> {
    private String label;
    private Nodes<E> nodes;
    private Attributes attributes;

    public Graph() {
        this.nodes = new Nodes();
        this.attributes = new Attributes();
    }

    public Graph(int initialNodeCount) {
        this.nodes = new Nodes(initialNodeCount);
        int nodeIndex = 1;
        while (nodeIndex <= initialNodeCount) {
            this.addNode(nodeIndex, null);
            ++nodeIndex;
        }
        this.attributes = new Attributes();
    }

    public Graph(int initialNodeCount, int initialCapacity) {
        this.nodes = new Nodes(initialCapacity);
        int nodeIndex = 1;
        while (nodeIndex <= initialNodeCount) {
            this.addNode(nodeIndex, null);
            ++nodeIndex;
        }
        this.attributes = new Attributes();
    }

    public Graph(String label) {
        this.setLabel(label);
        this.nodes = new Nodes();
        this.attributes = new Attributes();
    }

    public Link<E> addArc(E sourceReferent, E targetReferent) {
        Link<E> result = this.addArc(sourceReferent, targetReferent, 0.0);
        return result;
    }

    public Link<E> addArc(E source, E target, double weight) {
        Node<E> targetNode;
        Node<E> sourceNode = this.nodes.get(source);
        if (sourceNode == null) {
            sourceNode = this.nodes.add(source);
        }
        if ((targetNode = this.nodes.get(target)) == null) {
            targetNode = this.nodes.add(target);
        }
        Link<E> result = this.addArc(sourceNode, targetNode, weight);
        return result;
    }

    public Link<E> addArc(int sourceId, int targetId) {
        Link<E> result = this.addArc(sourceId, targetId, 0.0);
        return result;
    }

    public Link<E> addArc(int sourceId, int targetId, double weight) {
        Node<Object> targetNode;
        Node<Object> sourceNode = this.nodes.get(sourceId);
        if (sourceNode == null) {
            sourceNode = this.addNode(sourceId, null);
        }
        if ((targetNode = this.nodes.get(targetId)) == null) {
            targetNode = this.addNode(targetId, null);
        }
        Link<E> result = this.addArc(sourceNode, targetNode, weight);
        return result;
    }

    public Link<E> addArc(Node<E> sourceNode, Node<E> targetNode) {
        Link<E> result = sourceNode.addArcWith(targetNode);
        return result;
    }

    public Link<E> addArc(Node<E> sourceNode, Node<E> targetNode, double weight) {
        Link<E> result = sourceNode.addArcWith(targetNode, weight);
        return result;
    }

    public void addArcs(Matrix matrix) {
        int i = 0;
        while (i < matrix.getRowDim()) {
            int j = 0;
            while (j < matrix.getColDim()) {
                this.incArcWeight(i, j);
                ++i;
            }
            ++i;
        }
    }

    public double addArcWeight(E source, E target, double weight) {
        Node<E> targetNode;
        Node<E> sourceNode = this.nodes.get(source);
        if (sourceNode == null) {
            sourceNode = this.nodes.add(source);
        }
        if ((targetNode = this.nodes.get(target)) == null) {
            targetNode = this.nodes.add(target);
        }
        double result = this.addArcWeight(sourceNode, targetNode, weight);
        return result;
    }

    public double addArcWeight(int sourceId, int targetId, double value) {
        Node<E> sourceNode = this.nodes.get(sourceId);
        Node<E> targetNode = this.nodes.get(targetId);
        double result = this.addArcWeight(sourceNode, targetNode, value);
        return result;
    }

    public double addArcWeight(Node<E> sourceNode, Node<E> targetNode, double value) {
        double result = sourceNode.addArcWeight(targetNode, value);
        return result;
    }

    public Link<E> addEdge(E sourceReferent, E targetReferent) {
        Link<E> result = this.addEdge(sourceReferent, targetReferent, 0.0);
        return result;
    }

    public Link<E> addEdge(E source, E target, double weight) {
        Node<E> targetNode;
        Node<E> sourceNode = this.nodes.get(source);
        if (sourceNode == null) {
            sourceNode = this.nodes.add(source);
        }
        if ((targetNode = this.nodes.get(target)) == null) {
            targetNode = this.nodes.add(target);
        }
        Link<E> result = this.addEdge(sourceNode, targetNode, weight);
        return result;
    }

    public Link<E> addEdge(int sourceId, int targetId) {
        Link<E> result = this.addEdge(sourceId, targetId, 0.0);
        return result;
    }

    public Link<E> addEdge(int sourceId, int targetId, double weight) {
        Node<Object> targetNode;
        Node<Object> sourceNode = this.nodes.get(sourceId);
        if (sourceNode == null) {
            sourceNode = this.addNode(sourceId, null);
        }
        if ((targetNode = this.nodes.get(targetId)) == null) {
            targetNode = this.addNode(targetId, null);
        }
        Link<E> result = this.addEdge(sourceNode, targetNode, weight);
        return result;
    }

    public Link<E> addEdge(Node<E> node, Node<E> otherNode) {
        Link<E> result = this.addEdge(node, otherNode, 0.0);
        return result;
    }

    public Link<E> addEdge(Node<E> node, Node<E> otherNode, double weight) {
        Link<E> result = node.addEdgeWith(otherNode, weight);
        return result;
    }

    public double addEdgeWeight(E source, E target, double weight) {
        Node<E> targetNode;
        Node<E> sourceNode = this.nodes.get(source);
        if (sourceNode == null) {
            sourceNode = this.nodes.add(source);
        }
        if ((targetNode = this.nodes.get(target)) == null) {
            targetNode = this.nodes.add(target);
        }
        double result = this.addEdgeWeight(sourceNode, targetNode, weight);
        return result;
    }

    public double addEdgeWeight(int sourceId, int targetId, double value) {
        Node<Object> targetNode;
        Node<Object> sourceNode = this.nodes.get(sourceId);
        if (sourceNode == null) {
            sourceNode = this.addNode(sourceId, null);
        }
        if ((targetNode = this.nodes.get(targetId)) == null) {
            targetNode = this.addNode(targetId, null);
        }
        double result = this.addEdgeWeight(sourceNode, targetNode, value);
        return result;
    }

    public double addEdgeWeight(Node<E> sourceNode, Node<E> targetNode, double value) {
        double result = sourceNode.addEdgeWeight(targetNode, value);
        return result;
    }

    public Node<E> addNode(E referent) {
        if (referent == null) {
            throw new NullPointerException("Node cannot have a null referent.");
        }
        Node<E> result = this.nodes.get(referent);
        if (result == null) {
            result = this.nodes.add(referent);
        }
        return result;
    }

    public Node<E> addNode(int id, E referent) {
        Node<E> result = this.nodes.get(id);
        if (result == null) {
            result = this.nodes.add(id, referent);
        }
        return result;
    }

    public void addNodesWithId(Nodes<E> nodes) {
        for (Node<E> node : nodes) {
            this.addNode(node.getId(), node.getReferent());
        }
    }

    public void addNodes(Nodes<E> nodes) {
        for (Node<E> node : nodes) {
            this.addNode(node.getReferent());
        }
    }

    public void addLinks(Links<E> links) {
        for (Link link : links) {
            if (link.isArc()) {
                Link arc = this.addArc(link.getSourceNode().getReferent(), link.getTargetNode().getReferent(), link.getWeight());
                arc.setTag(link.getTag());
                continue;
            }
            if (!link.isEdge()) continue;
            Link edge = this.addEdge(link.getSourceNode().getReferent(), link.getTargetNode().getReferent(), link.getWeight());
            edge.setTag(link.getTag());
        }
    }

    public <T> void addLinksByIds(Links<T> links) {
        for (Link link : links) {
            if (link.isArc()) {
                Link<E> arc = this.addArc(link.getSourceId(), link.getTargetId(), link.getWeight());
                arc.setTag(link.getTag());
                continue;
            }
            if (!link.isEdge()) continue;
            Link<E> edge = this.addEdge(link.getSourceId(), link.getTargetId(), link.getWeight());
            edge.setTag(link.getTag());
        }
    }

    public int arcCount() {
        return this.getArcs().size();
    }

    public Attributes attributes() {
        Attributes result = this.attributes;
        return result;
    }

    public int edgeCount() {
        return this.getEdges().size();
    }

    public Link<E> getArc(E source, E target) {
        Node<E> targetNode;
        Node<E> sourceNode = this.nodes.get(source);
        if (sourceNode == null) {
            sourceNode = this.nodes.add(source);
        }
        if ((targetNode = this.nodes.get(target)) == null) {
            targetNode = this.nodes.add(target);
        }
        Link<E> result = this.getArc(sourceNode, targetNode);
        return result;
    }

    public Link<E> getArc(Node<E> node, Node<E> otherNode) {
        Link<E> result = node.getArcWith(otherNode);
        return result;
    }

    public Links<E> getArcs() {
        Links<Link<E>> result = new Links<Link<E>>();
        for (Node<E> node : this.getNodes()) {
            result.addAll(node.getOutArcs().getLinks());
        }
        return result;
    }

    public double getArcWeight(int nodeId, int otherNodeId) {
        Node<E> node = this.nodes.get(nodeId);
        Node<E> otherNode = this.nodes.get(otherNodeId);
        double result = this.getArcWeight(node, otherNode);
        return result;
    }

    public double getArcWeight(Node<E> node, Node<E> otherNode) {
        Link<E> link = this.getArc(node, otherNode);
        double result = link == null ? 0.0 : link.getWeight();
        return result;
    }

    public double getArcWeightSum() {
        double result = 0.0;
        for (Node<E> node : this.getNodes()) {
            for (Link<E> link : node.getOutArcs().getLinks()) {
                result += link.getWeight();
            }
        }
        return result;
    }

    public int getDegree(int id) {
        return this.getNode(id).getDegree();
    }

    public Link<E> getEdge(E source, E target) {
        Node<E> targetNode;
        Node<E> sourceNode = this.nodes.get(source);
        if (sourceNode == null) {
            sourceNode = this.nodes.add(source);
        }
        if ((targetNode = this.nodes.get(target)) == null) {
            targetNode = this.nodes.add(target);
        }
        Link<E> result = this.getEdge(sourceNode, targetNode);
        return result;
    }

    public Link<E> getEdge(Node<E> node, Node<E> otherNode) {
        Link<E> result = node.getEdgeWith(otherNode);
        return result;
    }

    public int getEdgeDegree(int id) {
        int result = this.getNode(id).getEdgeDegree();
        return result;
    }

    public double getEdgeForce(int id) {
        double result = this.getNode(id).getEdgeForce();
        return result;
    }

    public Links<E> getEdges() {
        Links<Link<E>> result = new Links<Link<E>>();
        for (Node<E> node : this.getNodes()) {
            result.addAll(node.getInferiorEdges().getLinks());
        }
        return result;
    }

    public double getEdgeWeight(int nodeId, int otherNodeId) {
        Node<E> node = this.nodes.get(nodeId);
        Node<E> otherNode = this.nodes.get(otherNodeId);
        double result = this.getEdgeWeight(node, otherNode);
        return result;
    }

    public double getEdgeWeight(Node<E> node, Node<E> otherNode) {
        Link<E> link = this.getEdge(node, otherNode);
        double result = link == null ? 0.0 : link.getWeight();
        return result;
    }

    public double getForce(int id) {
        return this.getNode(id).getForce();
    }

    public int getInDegree(int id) {
        int result = this.getNode(id).getInDegree();
        return result;
    }

    public double getInForce(int id) {
        double result = 0.0;
        for (Link<E> arc : this.getNode(id).getInArcs()) {
            result += arc.getWeight();
        }
        return result;
    }

    public Map<Integer, Double> getInForces() {
        TreeMap<Integer, Double> result = new TreeMap<Integer, Double>();
        for (Node<E> node : this.nodes) {
            result.put(node.getId(), node.getInForce());
        }
        return result;
    }

    public String getLabel() {
        return this.label;
    }

    public Links<E> getLinks() {
        Links<E> result = new Links<E>();
        for (Node<E> node : this.getNodes()) {
            result.addAll(node.getInLinks());
        }
        return result;
    }

    public SparseMatrix getMatrix() {
        Nodes<E> sourceNodes = this.getSourceNodes();
        Nodes<E> targetNodes = this.getTargetNodes();
        SparseMatrix result = new SparseMatrix(sourceNodes.size(), targetNodes.size());
        for (Node<E> node : targetNodes.toListSortedByLabel()) {
            result.addTarget(node.getId());
        }
        for (Node<E> node : sourceNodes.toListSortedByLabel()) {
            for (Link<E> link : node.getOutArcs()) {
                result.add(link.getSourceNode().getId(), link.getTargetNode().getId(), link.getWeight());
            }
        }
        return result;
    }

    public Node<E> getNode(E referent) {
        Node<E> result = referent == null ? null : this.nodes.get(referent);
        return result;
    }

    public Node<E> getNode(int id) {
        Node<E> result = this.nodes.get(id);
        return result;
    }

    public int getNodeId(E referent) {
        Node<E> node;
        int result = referent == null ? -1 : ((node = this.nodes.get(referent)) == null ? -1 : node.getId());
        return result;
    }

    public Nodes<E> getNodes() {
        return this.nodes;
    }

    public Nodes<E> getNodesByTag(String tag) {
        Nodes<E> result = this.nodes.getNodesByTag(tag);
        return result;
    }

    public int getOutDegree(int nodeId) {
        int result = this.getNode(nodeId).getOutDegree();
        return result;
    }

    public double getOutForce(int nodeId) {
        double result = 0.0;
        for (Link<E> arc : this.getNode(nodeId).getOutArcs()) {
            result += arc.getWeight();
        }
        return result;
    }

    public Map<Integer, Double> getOutForces() {
        TreeMap<Integer, Double> result = new TreeMap<Integer, Double>();
        for (Node<E> node : this.nodes) {
            result.put(node.getId(), node.getOutForce());
        }
        return result;
    }

    public List<E> getReferents() {
        ArrayList<E> result = new ArrayList<E>(this.nodeCount());
        for (Node<E> node : this.nodes) {
            result.add(node.getReferent());
        }
        return result;
    }

    public Nodes<E> getSourceNodes() {
        Nodes<E> result = new Nodes<E>();
        for (Node<E> node : this.nodes) {
            if (node.getOutArcs().size() <= 0) continue;
            result.add(node);
        }
        return result;
    }

    public SparseMatrix getSquareMatrix() {
        SparseMatrix result = new SparseMatrix(this.nodes.size(), this.nodes.size());
        for (Node<E> node : this.nodes.toListSortedByLabel()) {
            result.addSource(node.getId());
            result.addTarget(node.getId());
        }
        for (Node<E> node : this.nodes) {
            for (Link<E> link : node.getOutArcs()) {
                result.add(link.getSourceNode().getId(), link.getTargetNode().getId(), link.getWeight());
            }
            for (Link<E> link : node.getEdges()) {
                if (link.getSourceNode() != node) continue;
                result.add(link.getSourceNode().getId(), link.getTargetNode().getId(), link.getWeight());
                if (link.getSourceNode() == link.getTargetNode()) continue;
                result.add(link.getTargetNode().getId(), link.getSourceNode().getId(), link.getWeight());
            }
        }
        return result;
    }

    public Nodes<E> getTargetNodes() {
        Nodes<E> result = new Nodes<E>();
        for (Node<E> node : this.nodes) {
            if (node.getInArcs().size() <= 0) continue;
            result.add(node);
        }
        return result;
    }

    public double incArcWeight(E source, E target) {
        Node<E> targetNode;
        Node<E> sourceNode = this.nodes.get(source);
        if (sourceNode == null) {
            sourceNode = this.nodes.add(source);
        }
        if ((targetNode = this.nodes.get(target)) == null) {
            targetNode = this.nodes.add(target);
        }
        double result = this.incArcWeight(sourceNode, targetNode);
        return result;
    }

    public double incArcWeight(int sourceId, int targetId) {
        Node<Object> targetNode;
        Node<Object> sourceNode = this.nodes.get(sourceId);
        if (sourceNode == null) {
            sourceNode = this.addNode(sourceId, null);
        }
        if ((targetNode = this.nodes.get(targetId)) == null) {
            targetNode = this.addNode(targetId, null);
        }
        double result = this.incArcWeight(sourceNode, targetNode);
        return result;
    }

    public double incArcWeight(Node<E> sourceNode, Node<E> targetNode) {
        double result = sourceNode.incArcWeight(targetNode);
        return result;
    }

    public double incEdgeWeight(E source, E target) {
        Node<E> targetNode;
        Node<E> sourceNode = this.nodes.get(source);
        if (sourceNode == null) {
            sourceNode = this.nodes.add(source);
        }
        if ((targetNode = this.nodes.get(target)) == null) {
            targetNode = this.nodes.add(target);
        }
        double result = this.incEdgeWeight(sourceNode, targetNode);
        return result;
    }

    public double incEdgeWeight(int sourceId, int targetId) {
        Node<Object> targetNode;
        Node<Object> sourceNode = this.nodes.get(sourceId);
        if (sourceNode == null) {
            sourceNode = this.addNode(sourceId, null);
        }
        if ((targetNode = this.nodes.get(targetId)) == null) {
            targetNode = this.addNode(targetId, null);
        }
        double result = this.incEdgeWeight(sourceNode, targetNode);
        return result;
    }

    public double incEdgeWeight(Node<E> sourceNode, Node<E> targetNode) {
        double result = sourceNode.incEdgeWeight(targetNode);
        return result;
    }

    public int lineCount() {
        int result = this.getLinks().size();
        return result;
    }

    public int lineCountWithoutLoops() {
        int result = 0;
        for (Link link : this.getLinks()) {
            if (link.isLoop()) continue;
            ++result;
        }
        return result;
    }

    public int tieCount() {
        int result = 0;
        int nrLoops = 0;
        for (Node<E> node : this.getNodes()) {
            result += node.tieCount();
            nrLoops += node.getLoopDegree();
        }
        result = (result + nrLoops) / 2;
        return result;
    }

    public int tieCountWithoutLoops() {
        int result = 0;
        for (Node<E> node : this.getNodes()) {
            result += node.tieCount();
        }
        return result /= 2;
    }

    public int nodeCount() {
        int result = this.nodes.size();
        return result;
    }

    public void setArcWeight(E source, E target, double weight) {
        Node<E> targetNode;
        Node<E> sourceNode = this.nodes.get(source);
        if (sourceNode == null) {
            sourceNode = this.nodes.add(source);
        }
        if ((targetNode = this.nodes.get(target)) == null) {
            targetNode = this.nodes.add(target);
        }
        this.setArcWeight(sourceNode, targetNode, weight);
    }

    public void setArcWeight(int sourceId, int targetId, double value) {
        Node<Object> targetNode;
        Node<Object> sourceNode = this.nodes.get(sourceId);
        if (sourceNode == null) {
            sourceNode = this.addNode(sourceId, null);
        }
        if ((targetNode = this.nodes.get(targetId)) == null) {
            targetNode = this.addNode(targetId, null);
        }
        this.setArcWeight(sourceNode, targetNode, value);
    }

    public void setArcWeight(Node<E> sourceNode, Node<E> targetNode, double value) {
        sourceNode.setArcWeight(targetNode, value);
    }

    public void setEdgeWeight(E source, E target, double weight) {
        Node<E> targetNode;
        Node<E> sourceNode = this.nodes.get(source);
        if (sourceNode == null) {
            sourceNode = this.nodes.add(source);
        }
        if ((targetNode = this.nodes.get(target)) == null) {
            targetNode = this.nodes.add(target);
        }
        this.setEdgeWeight(sourceNode, targetNode, weight);
    }

    public void setEdgeWeight(int sourceId, int targetId, double value) {
        Node<Object> targetNode;
        Node<Object> sourceNode = this.nodes.get(sourceId);
        if (sourceNode == null) {
            sourceNode = this.addNode(sourceId, null);
        }
        if ((targetNode = this.nodes.get(targetId)) == null) {
            targetNode = this.addNode(targetId, null);
        }
        this.setEdgeWeight(sourceNode, targetNode, value);
    }

    public void setEdgeWeight(Node<E> sourceNode, Node<E> targetNode, double value) {
        sourceNode.setEdgeWeight(targetNode, value);
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void removeNode(Node<E> node) {
        for (Node<E> otherNode : this.nodes) {
            otherNode.removeLinksToNode(node);
        }
        this.nodes.removeNode(node);
    }
}

