/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.geo.io;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JProgressBar;
import org.geonames.Toponym;
import org.geonames.ToponymSearchCriteria;
import org.geonames.ToponymSearchResult;
import org.geonames.WebService;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.tip.puck.geo.Place;
import org.tip.puck.geo.ToponymGeom;
import org.tip.puck.geo.io.BuildingGeoLinks;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Node;

public class GeoNamesWebService {
    ArrayList<DefaultFeatureCollection> collectionsPointsAndLines = new ArrayList();
    DefaultFeatureCollection featurePointsCollection;
    DefaultFeatureCollection featureLinesCollection;
    SimpleFeatureBuilder featureBuilder;
    GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
    SimpleFeatureType pointFeatureType;
    JProgressBar progressBar;

    public GeoNamesWebService(JProgressBar progressBar) {
        this.progressBar = progressBar;
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("SCHEMA_POINT");
        b.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        b.add("name", String.class);
        b.add("the_geom", Point.class);
        this.pointFeatureType = b.buildFeatureType();
        this.featurePointsCollection = new DefaultFeatureCollection("internal", this.pointFeatureType);
        this.featureBuilder = new SimpleFeatureBuilder(this.pointFeatureType);
    }

    public DefaultFeatureCollection getFeaturePointsCollection() {
        return this.featurePointsCollection;
    }

    public void setFeaturePointsCollection(DefaultFeatureCollection featurePointsCollection) {
        this.featurePointsCollection = featurePointsCollection;
    }

    public SimpleFeatureBuilder getFeatureBuilder() {
        return this.featureBuilder;
    }

    public void setFeatureBuilder(SimpleFeatureBuilder featureBuilder) {
        this.featureBuilder = featureBuilder;
    }

    public GeometryFactory getGeometryFactory() {
        return this.geometryFactory;
    }

    public void setGeometryFactory(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
    }

    public SimpleFeatureType getPointFeatureType() {
        return this.pointFeatureType;
    }

    public void setPointFeatureType(SimpleFeatureType pointFeatureType) {
        this.pointFeatureType = pointFeatureType;
    }

    public ArrayList<DefaultFeatureCollection> getCoordForNodesPlaces(Graph<?> geoNetwork) {
        Graph<Place> graphPlaces = new Graph<Place>("GraphPlaces");
        HashSet<Place> placesList = new HashSet<Place>();
        ArrayList<Place> placesListDuplicate = new ArrayList<Place>();
        int nbTreatments = 0;
        int nbTreatmentsMax = geoNetwork.nodeCount();
        this.progressBar.setMaximum(nbTreatmentsMax);
        this.progressBar.setString("Processing ...");
        this.progressBar.setStringPainted(true);
        for (Node<?> node : geoNetwork.getNodes()) {
            Place p;
            SimpleFeature f = this.getCoordForToponym(node.getLabel());
            if (f != null) {
                this.featurePointsCollection.add(f);
                Geometry g = (Geometry)f.getAttribute("the_geom");
                p = new Place(node.getLabel(), g.getCoordinate());
            } else {
                p = new Place(node.getLabel());
            }
            graphPlaces.addNode(node.getId(), p);
            this.progressBar.setValue(nbTreatments++);
            placesList.add(p);
            placesListDuplicate.add(p);
        }
        this.collectionsPointsAndLines.add(this.featurePointsCollection);
        graphPlaces.addLinksByIds(geoNetwork.getLinks());
        BuildingGeoLinks linksFactory = new BuildingGeoLinks();
        this.featureLinesCollection = linksFactory.buildLinkGeometry(this.progressBar, graphPlaces);
        this.collectionsPointsAndLines.add(this.featureLinesCollection);
        return this.collectionsPointsAndLines;
    }

    public DefaultFeatureCollection getCoordForToponym(List<String> listToponymTexts) {
        for (String toponymText : listToponymTexts) {
            this.featurePointsCollection.add(this.getCoordForToponym(toponymText));
        }
        return this.featurePointsCollection;
    }

    public SimpleFeature getCoordForToponym(String text) {
        WebService.setUserName((String)"puck");
        if (text.indexOf("?") > 0) {
            text = text.substring(0, text.indexOf("?"));
        }
        ToponymSearchCriteria searchCriteria = new ToponymSearchCriteria();
        searchCriteria.setQ(text);
        ToponymSearchResult searchResult = null;
        try {
            searchResult = WebService.search((ToponymSearchCriteria)searchCriteria);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Integer i = 0;
        Iterator iterator = searchResult.getToponyms().iterator();
        if (iterator.hasNext()) {
            Toponym iterToponym = (Toponym)iterator.next();
            Coordinate pointCoord = new Coordinate(iterToponym.getLongitude(), iterToponym.getLatitude());
            Point point = this.geometryFactory.createPoint(pointCoord);
            ToponymGeom tpGeom = new ToponymGeom(iterToponym, point);
            SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)this.pointFeatureType, (Object[])new Object[]{tpGeom.getToponym().getName(), point}, null);
            i = i + 1;
            System.out.println(String.valueOf(iterToponym.getName()) + " " + iterToponym.getCountryName() + " " + pointCoord);
            return feature;
        }
        return null;
    }
}

