/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.geo.io;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import javax.swing.JProgressBar;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.tip.puck.geo.Place;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Link;

public class BuildingGeoLinks {
    DefaultFeatureCollection featureLinesCollection;
    SimpleFeatureBuilder featureBuilder;
    GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
    SimpleFeatureType lineFeatureType;

    public BuildingGeoLinks() {
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("SCHEMA_LINES");
        b.add("name", String.class);
        b.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        b.add("the_geom", LineString.class);
        this.lineFeatureType = b.buildFeatureType();
        this.featureLinesCollection = new DefaultFeatureCollection("internal", this.lineFeatureType);
        this.featureBuilder = new SimpleFeatureBuilder(this.lineFeatureType);
    }

    public DefaultFeatureCollection getFeatureLinesCollection() {
        return this.featureLinesCollection;
    }

    public void setFeatureLinesCollection(DefaultFeatureCollection featureLinesCollection) {
        this.featureLinesCollection = featureLinesCollection;
    }

    public SimpleFeatureBuilder getFeatureBuilder() {
        return this.featureBuilder;
    }

    public void setFeatureBuilder(SimpleFeatureBuilder featureBuilder) {
        this.featureBuilder = featureBuilder;
    }

    public GeometryFactory getGeometryFactory() {
        return this.geometryFactory;
    }

    public void setGeometryFactory(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
    }

    public SimpleFeatureType getLineFeatureType() {
        return this.lineFeatureType;
    }

    public void setLineFeatureType(SimpleFeatureType lineFeatureType) {
        this.lineFeatureType = lineFeatureType;
    }

    public DefaultFeatureCollection buildLinkGeometry(JProgressBar progressBar, Graph<Place> graphPlaces) {
        for (Link link : graphPlaces.getArcs()) {
            if (((Place)link.getSourceNode().getReferent()).getCoordinate() != null & ((Place)link.getTargetNode().getReferent()).getCoordinate() != null) {
                Coordinate[] tabCoord = new Coordinate[]{((Place)link.getSourceNode().getReferent()).getCoordinate(), ((Place)link.getTargetNode().getReferent()).getCoordinate()};
                LineString line = this.geometryFactory.createLineString(tabCoord);
                SimpleFeature f = SimpleFeatureBuilder.build((SimpleFeatureType)this.lineFeatureType, (Object[])new Object[]{String.valueOf(((Place)link.getSourceNode().getReferent()).getName()) + " -- " + ((Place)link.getTargetNode().getReferent()).getName(), line}, null);
                this.featureLinesCollection.add(f);
            }
            int i = progressBar.getValue();
            progressBar.setValue(i++);
        }
        return this.featureLinesCollection;
    }
}

