/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.geo;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tip.puck.PuckException;
import org.tip.puck.geo.GeoLevel;
import org.tip.puck.geo.Place;
import org.tip.puck.geo.io.PlaceFile;

public class Geography {
    private static Geography geography;
    Map<GeoLevel, Map<String, Place>> levels = new HashMap<GeoLevel, Map<String, Place>>();
    Map<String, String> homonyms;
    Map<String, Map<GeoLevel, Place>> sups = new HashMap<String, Map<GeoLevel, Place>>();

    public Geography() {
        GeoLevel[] geoLevelArray = GeoLevel.values();
        int n = geoLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            GeoLevel level = geoLevelArray[n2];
            this.levels.put(level, new HashMap());
            ++n2;
        }
        this.homonyms = new HashMap<String, String>();
    }

    public void reportGeography() {
        GeoLevel[] geoLevelArray = GeoLevel.values();
        int n = geoLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            GeoLevel level = geoLevelArray[n2];
            System.out.println((Object)level);
            for (Place place : this.levels.get((Object)level).values()) {
                System.out.println("\t" + place.getId());
            }
            ++n2;
        }
    }

    public Place get(GeoLevel level, String id) {
        return this.levels.get((Object)level).get(id);
    }

    public Place get(String id) {
        Place result = null;
        GeoLevel[] geoLevelArray = GeoLevel.values();
        int n = geoLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            GeoLevel level = geoLevelArray[n2];
            result = this.levels.get((Object)level).get(id);
            if (result != null) break;
            ++n2;
        }
        return result;
    }

    public Place get(String homonym, GeoLevel minLevel) {
        Place result = this.getByHomonym(homonym);
        if (result != null && minLevel != null && minLevel.compareTo(result.level) < 0) {
            result = this.getPlace(homonym, minLevel);
        }
        return result;
    }

    public Place getByHomonym(String homonym) {
        Place result = this.get(this.homonyms.get(homonym));
        if (homonym != null && result == null) {
            System.err.println("missing geography entry:\t" + homonym);
        }
        return result;
    }

    public void put(String homonym, Place place) {
        this.homonyms.put(homonym, place.getId());
    }

    public void put(Place place) {
        this.levels.get((Object)place.getLevel()).put(place.getId(), place);
    }

    public Place getCommonAncestor(Place first, Place second) {
        Place result = null;
        if (first == second) {
            result = first;
        } else if (first != null && second != null) {
            int comp = first.compareByLevel(second);
            if (comp == 0) {
                result = this.getCommonAncestor(first.getSup(), second.getSup());
            } else if (comp < 0) {
                result = this.getCommonAncestor(first, second.getSup());
            } else if (comp > 0) {
                result = this.getCommonAncestor(first.getSup(), second);
            }
        }
        return result;
    }

    public static Geography getInstance() {
        if (geography == null) {
            try {
                geography = PlaceFile.loadGeoData(new File("src/org/tip/puck/geo/data/togo.txt"));
            }
            catch (PuckException e) {
                e.printStackTrace();
            }
        }
        return geography;
    }

    public Place getPlaceByCenter(String homonym, String center) {
        Place result = null;
        if (homonym.equals(center)) {
            result = this.getByHomonym(homonym);
        } else {
            GeoLevel[] geoLevelArray = GeoLevel.values();
            int n = geoLevelArray.length;
            int n2 = 0;
            while (n2 < n) {
                GeoLevel level = geoLevelArray[n2];
                result = this.getPlace(homonym, level);
                if (level == GeoLevel.HOMONYM || result != null && !result.equals(this.getPlace(center, level))) break;
                ++n2;
            }
        }
        return result;
    }

    public Place getPlace(String homonym, String parameter) {
        Place result;
        try {
            result = this.getPlace(homonym, GeoLevel.valueOf(parameter));
        }
        catch (IllegalArgumentException iae) {
            result = this.getPlaceByCenter(homonym, parameter);
        }
        return result;
    }

    public Place getPlace(String homonym, GeoLevel level) {
        Place result;
        if (this.getByHomonym(homonym) == null) {
            result = null;
            System.err.println("Place not known: " + homonym);
        } else {
            result = this.getByHomonym(homonym).atLevel(level);
        }
        return result;
    }

    public Place getSup(String homonym, List<String> placenames) {
        Place result = this.getByHomonym(homonym) == null ? null : this.getByHomonym(homonym).getSup(placenames);
        return result;
    }
}

