/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.census.workers;

import java.util.Arrays;
import java.util.List;
import org.tip.puck.census.chains.Chain;
import org.tip.puck.census.chains.ChainMaker;
import org.tip.puck.census.chains.Chains;
import org.tip.puck.census.chains.Couple;
import org.tip.puck.census.chains.Notation;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.NumberedValues;
import org.tip.puck.util.Value;

public class ChainValuator {
    public static boolean hasLineValue(Chain source, String label, Value value) {
        String[] valueStrings;
        boolean result = true;
        String[] stringArray = valueStrings = ChainValuator.get(source, label).toString().split("\\s");
        int n = valueStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String valueString = stringArray[n2];
            if (!(valueString.equals("IDENTITY") || valueString.equals("BILINEAR") || valueString.equals(value.toString()))) {
                result = false;
                break;
            }
            ++n2;
        }
        return result;
    }

    public static boolean hasValue(Chain source, String label, Value value) {
        return ChainValuator.get(source, label).equals(value);
    }

    public static Value get(Chain source, String label) {
        Value result = ChainValuator.get(source, label, null);
        return result;
    }

    public static NumberedValues get(Chains source, String label, Object parameter) {
        NumberedValues result = new NumberedValues();
        for (Chain chain : source) {
            result.put(chain.getId(), ChainValuator.get(chain, label, parameter));
        }
        return result;
    }

    public static Value get(Chain source, String label, Object parameter) {
        Value result;
        if (label == null || source == null) {
            result = null;
        } else {
            ChainProperty enogenousLabel;
            String[] labels = label.split("AND");
            if (labels.length > 1) {
                Value value1 = ChainValuator.get(source, labels[0], parameter);
                Value value2 = ChainValuator.get(source, labels[1], parameter);
                Value result2 = new Value(String.valueOf(value1.toString()) + " AND " + value2.toString());
                return result2;
            }
            try {
                enogenousLabel = ChainProperty.valueOf(label.replace(" ", "_"));
            }
            catch (IllegalArgumentException exception) {
                enogenousLabel = null;
            }
            switch (enogenousLabel) {
                case SIMPLE: {
                    result = new Value(source.getCharacteristicVector());
                    break;
                }
                case POSITIONAL: {
                    result = new Value(source.signature(Notation.POSITIONAL));
                    break;
                }
                case POSITIONAL_NEUTRAL: {
                    result = new Value(source.signature(Notation.POSITIONAL_NEUTRAL));
                    break;
                }
                case CLASSIC: {
                    result = new Value(source.signature(Notation.CLASSIC));
                    break;
                }
                case CLASSIC_GENDERED: {
                    result = new Value(source.signature(Notation.CLASSIC_GENDERED));
                    break;
                }
                case LENGTH: {
                    result = new Value(source.length());
                    break;
                }
                case DEPTH: {
                    result = new Value(source.depth());
                    break;
                }
                case ORDER: {
                    result = new Value(source.dim());
                    break;
                }
                case SYM: {
                    result = new Value(source.sym());
                    break;
                }
                case HETERO: {
                    result = new Value(source.isHetero());
                    break;
                }
                case EGOGENDER: {
                    result = new Value(source.getFirst().getGender());
                    break;
                }
                case ALTERNAME: {
                    result = new Value(source.getLast().getName());
                    break;
                }
                case SUBCHAINS: {
                    String string = "";
                    int k = 1;
                    for (Chain subchain : source.subchains) {
                        string = String.valueOf(string) + k + ". " + subchain.signature(Notation.POSITIONAL) + "\t";
                        ++k;
                    }
                    result = new Value(string);
                    break;
                }
                case PERMUTATIONS: {
                    result = new Value(ChainMaker.getPermutations(source).size());
                    break;
                }
                case SKEWSUM: {
                    int sum = 0;
                    int i = 0;
                    while (i < source.dim()) {
                        sum += ChainValuator.get(source, ChainProperty.SKEW, i).intValue();
                        ++i;
                    }
                    result = new Value(sum);
                    break;
                }
                default: {
                    String s = "";
                    int i = 0;
                    while (i < source.dim()) {
                        s = String.valueOf(s) + ChainValuator.get(source, enogenousLabel, i) + " ";
                        ++i;
                    }
                    result = new Value(s.trim());
                }
            }
        }
        return result;
    }

    private static Value get(Chain source, ChainProperty label, int i) {
        Value result = null;
        Chain left = source.subchains.get(2 * i);
        Chain right = source.subchains.get(2 * i + 1);
        switch (label) {
            case DEGREE_ROM: {
                result = new Value(left.length() + right.length());
                break;
            }
            case DEGREE_GER: {
                result = new Value(Math.max(left.length(), right.length()));
                break;
            }
            case ENDS: {
                result = new Value(String.valueOf(left.getFirst().getGender().toChar()) + right.getFirst().getGender().toChar());
                break;
            }
            case APICES: {
                if (left.getLast() instanceof Couple) {
                    result = new Value('X');
                    break;
                }
                result = new Value(left.getLast().getGender().toChar());
                break;
            }
            case APEXID: {
                if (left.getLast() instanceof Couple) {
                    result = new Value(0);
                    break;
                }
                result = new Value(left.getLast().getId());
                break;
            }
            case SIDE: {
                if (left.length() > 1) {
                    if (((Individual)left.get(1)).isMale()) {
                        result = new Value("PATERNAL");
                        break;
                    }
                    if (((Individual)left.get(1)).isFemale()) {
                        result = new Value("MATERNAL");
                        break;
                    }
                    if (left.get(1) instanceof Couple) {
                        result = new Value("BILATERAL");
                        break;
                    }
                    result = new Value("UNKNOWN");
                    break;
                }
                result = new Value("NONE");
                break;
            }
            case SKEW: {
                result = new Value(left.length() - right.length());
                break;
            }
            case SKEWTYPE: {
                int skew = ChainValuator.get(source, ChainProperty.SKEW, i).intValue();
                if (skew == 0) {
                    result = new Value("H");
                    break;
                }
                if (Math.abs(skew) == 1) {
                    result = new Value("O");
                    break;
                }
                if (Math.abs(skew) == 2) {
                    result = new Value("A");
                    break;
                }
                result = new Value("X");
                break;
            }
            case LINE: {
                if (ChainValuator.get(source, ChainProperty.DEGREE_ROM, 0).intValue() == 0 && ChainValuator.get(source, ChainProperty.DEGREE_ROM, 1).intValue() == 0) {
                    result = new Value(FiliationType.SPOUSE);
                    break;
                }
                if (ChainValuator.get(source, ChainProperty.DEGREE_ROM, i).intValue() == 0) {
                    result = new Value(FiliationType.IDENTITY);
                    break;
                }
                if (ChainValuator.get(source, ChainProperty.SWITCHES, i).intValue() > 0) {
                    result = new Value(FiliationType.COGNATIC);
                    break;
                }
                if (left.getLast() instanceof Couple) {
                    if (left.length() == 1 && right.length() == 1) {
                        result = new Value(FiliationType.BILINEAR);
                        break;
                    }
                    Gender gender = left.length() > 1 ? ((Individual)left.get(left.length() - 1)).getGender() : ((Individual)right.get(right.length() - 1)).getGender();
                    if (gender.isMale()) {
                        result = new Value(FiliationType.AGNATIC);
                        break;
                    }
                    if (!gender.isFemale()) break;
                    result = new Value(FiliationType.UTERINE);
                    break;
                }
                if (left.getLast().getGender().isMale()) {
                    result = new Value(FiliationType.AGNATIC);
                    break;
                }
                if (!left.getLast().getGender().isFemale()) break;
                result = new Value(FiliationType.UTERINE);
                break;
            }
            case AGNA: {
                result = new Value(MathUtils.percent(ChainValuator.filiationCount(left, Gender.MALE) + ChainValuator.filiationCount(right, Gender.MALE), left.length() + right.length()));
                break;
            }
            case UTER: {
                result = new Value(MathUtils.percent(ChainValuator.filiationCount(left, Gender.FEMALE) + ChainValuator.filiationCount(right, Gender.FEMALE), left.length() + right.length()));
                break;
            }
            case DRAV: {
                result = new Value(ChainValuator.dravidian(left, right).toString());
                break;
            }
            case DRAV_H: {
                String skewtype = ChainValuator.get(source, ChainProperty.SKEWTYPE, i).stringValue();
                String drav = ChainValuator.get(source, ChainProperty.DRAV, i).stringValue();
                if (skewtype.equals("H") && drav.equals("#")) {
                    result = new Value("ok");
                    break;
                }
                if (skewtype.equals("O") || drav.equals("=")) {
                    result = new Value("no");
                    break;
                }
                result = new Value("?");
                break;
            }
            case DRAV_O: {
                if (ChainValuator.parakana(left, right) == -1) {
                    result = new Value(" ");
                    break;
                }
                if (ChainValuator.parakana(left, right) == 1) {
                    result = new Value(" ");
                    break;
                }
                if (ChainValuator.parakana(left, right) == 2) {
                    result = new Value(" ");
                    break;
                }
                result = new Value(" ");
                break;
            }
            case SWITCHES: {
                int j;
                int switches = 0;
                if (left.length() > 0) {
                    j = 1;
                    while (j < left.length()) {
                        if (ChainValuator.differentGender((Individual)left.get(j), (Individual)left.get(j + 1))) {
                            ++switches;
                        }
                        ++j;
                    }
                }
                if (left.getLast() instanceof Couple && left.length() > 1 && right.length() > 1 && ChainValuator.differentGender((Individual)left.get(left.length() - 1), (Individual)right.get(right.length() - 1))) {
                    ++switches;
                }
                if (right.length() > 0) {
                    j = 1;
                    while (j < right.length()) {
                        if (ChainValuator.differentGender((Individual)right.get(j), (Individual)right.get(j + 1))) {
                            ++switches;
                        }
                        ++j;
                    }
                }
                result = new Value(switches);
                break;
            }
            case ARCH: {
                if (left.length() == 0 || right.length() == 0) {
                    result = new Value("-");
                    break;
                }
                result = new Value(String.valueOf(((Individual)left.get(left.size() - 2)).getGender().toChar()) + ((Individual)right.get(right.size() - 2)).getGender().toChar());
                break;
            }
            case FIRSTBRANCH: {
                result = new Value(left.signature(Notation.POSITIONAL));
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    private static boolean differentGender(Individual first, Individual second) {
        boolean result = first instanceof Couple || second instanceof Couple ? false : !first.getGender().matchs(second.getGender());
        return result;
    }

    public static String getValueString(Chain source, List<String> labels, Object parameter) {
        String result = "";
        for (String label : labels) {
            result = String.valueOf(result) + ChainValuator.get(source, label, parameter).toString() + "\t";
        }
        return result;
    }

    private static int filiationCount(Chain chain, Gender gender) {
        int result = 0;
        if (chain.length() > 0) {
            int i = 1;
            while (i < chain.size()) {
                if (((Individual)chain.get(i)).getGender().matchs(gender)) {
                    ++result;
                }
                ++i;
            }
        }
        return result;
    }

    private static Dravidian dravidian(Chain left, Chain right) {
        int skew = Math.abs(left.size() - right.size());
        Dravidian result = skew > 1 ? Dravidian.NEUTRAL : ChainValuator.dravidian(left, right, Math.min(left.length(), right.length()));
        return result;
    }

    private static Dravidian dravidian(Chain left, Chain right, int fromTop) {
        Gender rightGender;
        Gender leftGender;
        Dravidian result = fromTop <= 1 ? Dravidian.PARALLEL : ((leftGender = ((Individual)left.get(left.length() - fromTop + 1)).getGender()) == (rightGender = ((Individual)right.get(right.length() - fromTop + 1)).getGender()) ? ChainValuator.dravidian(left, right, fromTop - 1) : ChainValuator.dravidian(left, right, fromTop - 1).inverse());
        return result;
    }

    private static int getDravidianCrossness(Chain left, Chain right, int i) {
        if (i <= 1) {
            return 1;
        }
        return ChainValuator.getDravidianCrossness(left, right, i - 1) * (1 - 2 * Math.abs(left.getGenderInt(left.size() - i) - right.getGenderInt(right.size() - i)));
    }

    private static int parakana(Chain left, Chain right) {
        int d = left.size() - right.size();
        if (Math.abs(d) > 1) {
            return 2;
        }
        if (d == 0) {
            return ChainValuator.getDravidianCrossness(left, right, left.size() - 1);
        }
        int n = Math.min(left.size(), right.size()) - 1;
        int x = ChainValuator.getDravidianCrossness(left, right, n);
        int y = Math.abs(left.getGenderInt(left.size() - n - 1) - right.getGenderInt(right.size() - n - 1));
        if (d > 0) {
            if (y == 0 || x == 1) {
                if (n < 3) {
                    return 1;
                }
                if (Math.abs(left.getGenderInt(left.size() - 2) - right.getGenderInt(right.size() - 2)) == 0) {
                    return 1;
                }
            }
            return -1;
        }
        if (y == 1 && x == 1) {
            if (n == 1) {
                return 0;
            }
            if (Math.abs(left.getGenderInt(left.size() - 2) - right.getGenderInt(right.size() - 2)) == 0) {
                return 0;
            }
        }
        if (y == 1 && x == -1 || y == 0 && x == 1) {
            return 1;
        }
        return -1;
    }

    public static String[] getEndogenousLabels() {
        ChainProperty[] labels = ChainProperty.values();
        Object[] result = new String[ChainProperty.values().length];
        int labelIndex = 0;
        while (labelIndex < labels.length) {
            result[labelIndex] = labels[labelIndex].name();
            ++labelIndex;
        }
        Arrays.sort(result);
        return result;
    }

    public static enum ChainProperty {
        SIMPLE,
        POSITIONAL,
        POSITIONAL_NEUTRAL,
        CLASSIC,
        CLASSIC_GENDERED,
        LENGTH,
        DEPTH,
        ORDER,
        HETERO,
        DEGREE_ROM,
        DEGREE_GER,
        ENDS,
        APICES,
        SIDE,
        SKEW,
        SKEWSUM,
        SYM,
        LINE,
        AGNA,
        UTER,
        DRAV,
        DRAV_H,
        DRAV_O,
        SWITCHES,
        ARCH,
        SKEWTYPE,
        EGOGENDER,
        APEXID,
        FIRSTBRANCH,
        SUBCHAINS,
        PERMUTATIONS,
        ALTERNAME;

    }

    public static enum Dravidian {
        PARALLEL,
        CROSS,
        NEUTRAL;


        private Dravidian inverse() {
            Dravidian result;
            switch (this) {
                case PARALLEL: {
                    result = CROSS;
                    break;
                }
                case CROSS: {
                    result = PARALLEL;
                    break;
                }
                case NEUTRAL: {
                    result = NEUTRAL;
                    break;
                }
                default: {
                    result = null;
                }
            }
            return result;
        }

        public String toString() {
            String result;
            switch (this) {
                case PARALLEL: {
                    result = "=";
                    break;
                }
                case CROSS: {
                    result = "#";
                    break;
                }
                case NEUTRAL: {
                    result = "2";
                    break;
                }
                default: {
                    result = null;
                }
            }
            return result;
        }
    }
}

