package org.tip.puckgui.views.geo;

import java.awt.BorderLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListSelectionModel;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.commons.io.FilenameUtils;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.swing.JMapPane;
import org.geotools.swing.MapPane;
import org.geotools.swing.event.MapMouseAdapter;
import org.geotools.swing.event.MapMouseEvent;
import org.geotools.swing.styling.JSimpleStyleDialog;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory;
import org.tip.puck.geo.tools.GeotoolsUtils;
import org.tip.puck.geo2.Place2;
import org.tip.puck.graphs.Graph;
import org.tip.puck.io.gis.SIGFile;
import org.tip.puckgui.util.GenericFileFilter;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;

public class MapPanel2 extends JPanel {
	private enum Tools {
		DRAG,
		SELECT,
		ZOOMIN,
		ZOOMOUT
	}

	/**
	 * 
	 */
	private static final long serialVersionUID = -2451122245332109771L;

	private JTextField txtFile;
	StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();

	FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory();
	public MapContent mapContent = new MapContent();
	private JTable table;
	JList listLayers = null;

	DefaultListModel listModel = new DefaultListModel();
	public double lastDraggedX = 0;

	public double lastDraggedY = 0;

	Tools selectedTool = Tools.DRAG;

	List<JToggleButton> listToggleButtons = new ArrayList<JToggleButton>();

	/**
	 * Create the panel.
	 */
	public MapPanel2(final Graph<Place2> source) {
		setLayout(new BorderLayout(0, 0));

		final JMapPane mapPane = new JMapPane();

		JTabbedPane tabbedPane = new JTabbedPane(JTabbedPane.TOP);
		add(tabbedPane, BorderLayout.CENTER);

		JPanel pMap = new JPanel();
		tabbedPane.addTab("Cartography", null, pMap, null);
		pMap.setLayout(new BorderLayout(0, 0));

		JSplitPane splitPane = new JSplitPane();
		pMap.add(splitPane);

		JPanel panelRightMap = new JPanel();
		splitPane.setRightComponent(panelRightMap);
		panelRightMap.setLayout(new BorderLayout(0, 0));

		JMenuBar menuBarMap = new JMenuBar();
		panelRightMap.add(menuBarMap, BorderLayout.NORTH);

		final JToggleButton tglbtnDrag = new JToggleButton("");
		this.listToggleButtons.add(tglbtnDrag);
		tglbtnDrag.setIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/gis/mActionPan.png")));
		tglbtnDrag.setSelectedIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/gis/mActionPan_selected.png")));
		menuBarMap.add(tglbtnDrag);
		tglbtnDrag.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				MapPanel2.this.selectedTool = Tools.DRAG;
				MapPanel2.this.unselectToggleButtonsExcept(tglbtnDrag);
			}
		});

		final JToggleButton tglbtnSelect = new JToggleButton("");
		this.listToggleButtons.add(tglbtnSelect);
		tglbtnSelect.setIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/gis/mActionSelect.png")));
		tglbtnSelect.setSelectedIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/gis/mActionSelect_selected.png")));
		menuBarMap.add(tglbtnSelect);
		tglbtnSelect.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				MapPanel2.this.selectedTool = Tools.SELECT;
				MapPanel2.this.unselectToggleButtonsExcept(tglbtnSelect);
			}
		});

		final JToggleButton tglbtnZoomIn = new JToggleButton("");
		this.listToggleButtons.add(tglbtnZoomIn);
		tglbtnZoomIn.setIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/gis/mActionZoomIn.png")));
		tglbtnZoomIn.setSelectedIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/gis/mActionZoomIn_selected.png")));
		menuBarMap.add(tglbtnZoomIn);
		tglbtnZoomIn.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				MapPanel2.this.selectedTool = Tools.ZOOMIN;
				MapPanel2.this.unselectToggleButtonsExcept(tglbtnZoomIn);
			}
		});

		final JToggleButton tglbtnZoomOut = new JToggleButton("");
		this.listToggleButtons.add(tglbtnZoomOut);
		tglbtnZoomOut.setIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/gis/mActionZoomOut.png")));
		tglbtnZoomOut.setSelectedIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/gis/mActionZoomOut_selected.png")));
		menuBarMap.add(tglbtnZoomOut);
		tglbtnZoomOut.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				MapPanel2.this.selectedTool = Tools.ZOOMOUT;
				MapPanel2.this.unselectToggleButtonsExcept(tglbtnZoomOut);
			}
		});

		JButton tglbtnCenterView = new JButton("");
		tglbtnCenterView.setIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/gis/mActionZoomFullExtent.png")));
		menuBarMap.add(tglbtnCenterView);
		tglbtnCenterView.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(final ActionEvent arg0) {
				ReferencedEnvelope env = maximiseBoundsForLayers();
				mapPane.setDisplayArea(env);
				mapPane.repaint();
			}
		});

		JButton btExportShapefile = new JButton("");
		btExportShapefile.setIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/gis/mSaveShapefile.png")));
		menuBarMap.add(btExportShapefile);
		btExportShapefile.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Export Shapefile
				prepareExportShapeFile();
			}
		});

		JButton btExportSVG = new JButton("");
		btExportSVG.setIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/gis/mSaveSVG.png")));
		menuBarMap.add(btExportSVG);
		btExportSVG.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Export SVG
				prepareExportSVG();
			}
		});

		JLabel statusBar = new JLabel("Status bar");
		panelRightMap.add(statusBar, BorderLayout.SOUTH);

		mapPane.addMouseListener(new MapMouseAdapter() {

			@Override
			public void onMouseClicked(final MapMouseEvent ev) {

				DirectPosition2D pos = ev.getWorldPos();
				Coordinate coord = new Coordinate(pos.x, pos.y);

				ReferencedEnvelope env = mapPane.getDisplayArea();

				// ev.getButton() == MouseEvent.

				switch (ev.getButton()) {

					case MouseEvent.BUTTON1:

						switch (MapPanel2.this.selectedTool) {
							case DRAG:

								env = MapPanel2.this.centerOn(env, coord);
							break;

							case ZOOMIN:

								env = MapPanel2.this.centerOn(env, coord);

								double dh_zi = Math.abs(env.getHeight() - env.getHeight() * 1.03);
								double dw_zi = Math.abs(env.getWidth() - env.getWidth() * 1.03);

								env.expandBy(-Math.max(dh_zi, dw_zi));
							break;

							case ZOOMOUT:

								// System.out.println("zoomout");

								env = MapPanel2.this.centerOn(env, coord);

								double dh_zo = Math.abs(env.getHeight() - env.getHeight() * 1.03);
								double dw_zo = Math.abs(env.getWidth() - env.getWidth() * 1.03);

								env.expandBy(Math.max(dh_zo, dw_zo));
							break;

							default:
							break;
						}

					break;

					case MouseEvent.BUTTON2:

						env = MapPanel2.this.centerOn(env, coord);

					break;

					case MouseEvent.BUTTON3:

					break;

				}

				mapPane.setDisplayArea(env);
				mapPane.repaint();
			}

			@Override
			public void onMouseEntered(final MapMouseEvent ev) {
				// System.out.println("mouse entered map pane");
			}

			@Override
			public void onMouseExited(final MapMouseEvent ev) {
				// System.out.println("mouse left map pane");
			}

		});

		mapPane.addMouseMotionListener(new MouseMotionListener() {

			@Override
			public void mouseDragged(final MouseEvent ev) {

				switch (ev.getModifiers()) {

					case 8:

						System.out.println(ev.getX() + " " + ev.getY());

						Rectangle bounds = ev.getComponent().getBounds();
						ReferencedEnvelope mapArea = mapPane.getDisplayArea();
						double x = (ev.getX());
						double y = (ev.getY());
						double width = mapArea.getWidth();
						double height = mapArea.getHeight();

						double mapX = ((x * width) / bounds.width) + mapArea.getMinX();
						double mapY = (((bounds.getHeight() - y) * height) / bounds.height) + mapArea.getMinY();

						if ((MapPanel2.this.lastDraggedX > 0) && (MapPanel2.this.lastDraggedY > 0)) {

							double dx = MapPanel2.this.lastDraggedX - mapX;
							double dy = MapPanel2.this.lastDraggedY - mapY;

							System.out.println(mapX + " " + mapY);
							System.out.println(dx + " " + dy);
							System.out.println();

							Coordinate coord = new Coordinate(mapX + dx, mapY + dy);

							ReferencedEnvelope env = MapPanel2.this.centerOn(mapArea, coord);

							mapPane.setDisplayArea(env);
							mapPane.repaint();

						}

						MapPanel2.this.lastDraggedX = mapX;
						MapPanel2.this.lastDraggedY = mapY;

				}

			}

			@Override
			public void mouseMoved(final MouseEvent e) {
				// TODO Auto-generated method stub
			}
		});

		mapPane.addMouseWheelListener(new MouseWheelListener() {

			@Override
			public void mouseWheelMoved(final MouseWheelEvent arg0) {

				ReferencedEnvelope env = mapPane.getDisplayArea();

				double clickToZoom = 0.03;
				int clicks = arg0.getWheelRotation();
				// -ve means wheel moved up, +ve means down
				int sign = (clicks < 0 ? -1 : 1);

				double width = env.getWidth();
				double delta = width * clickToZoom * sign;

				env.expandBy(delta, delta);
				mapPane.setDisplayArea(env);
				mapPane.repaint();
			}
		});

		panelRightMap.add(mapPane, BorderLayout.CENTER);

		JPanel panelLeftList = new JPanel();
		splitPane.setLeftComponent(panelLeftList);
		panelLeftList.setLayout(new BorderLayout(0, 0));

		JMenuBar menuBarLayers = new JMenuBar();
		panelLeftList.add(menuBarLayers, BorderLayout.SOUTH);

		JButton btnAddShapeLayer = new JButton("");
		btnAddShapeLayer.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {

				JFileChooser inFileDlg = new JFileChooser("user.dir"); //$NON-NLS-1$

				inFileDlg.setFileFilter(new FileNameExtensionFilter("Shapefile (*.shp)", "shp")); //$NON-NLS-1$ //$NON-NLS-2$
				int returnVal = inFileDlg.showOpenDialog(MapPanel2.this);

				if (returnVal == JFileChooser.APPROVE_OPTION) {
					String browseDir = inFileDlg.getCurrentDirectory().toString();

					String inFile = null;
					inFile = inFileDlg.getSelectedFile().toString();
					inFileDlg.setCurrentDirectory(new File(inFile));

					try {

						displaysShapefile(new File(inFile));

					} catch (IOException e2) {
						// TODO Auto-generated catch block
						e2.printStackTrace();
					}

				}

			}
		});
		btnAddShapeLayer.setIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/add-16x16.png")));
		menuBarLayers.add(btnAddShapeLayer);

		JButton btnRemoveShapeLayer = new JButton("");
		btnRemoveShapeLayer.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {

				String selectedLayerTitle = (String) MapPanel2.this.listLayers.getSelectedValue();

				Layer selectedLayer = null;
				// Get selected layer
				for (Layer iterLayer : MapPanel2.this.mapContent.layers()) {
					if (iterLayer.getTitle().compareTo(selectedLayerTitle) == 0) {
						selectedLayer = iterLayer;
						break;
					}
				}

				MapPanel2.this.mapContent.removeLayer(selectedLayer);
				MapPanel2.this.listModel.removeElement(selectedLayerTitle);

				mapPane.repaint();
			}
		});
		btnRemoveShapeLayer.setIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/remove-16x16.png")));
		menuBarLayers.add(btnRemoveShapeLayer);

		JButton btnLayerProperties = new JButton("");
		btnLayerProperties.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {

				String selectedLayerTitle = (String) MapPanel2.this.listLayers.getSelectedValue();

				Layer selectedLayer = null;
				// Get selected layer
				for (Layer iterLayer : MapPanel2.this.mapContent.layers()) {
					if (iterLayer.getTitle().compareTo(selectedLayerTitle) == 0) {
						selectedLayer = iterLayer;
						break;
					}
				}

				if (selectedLayer != null) {
					// Open style dialog
					Style newStyle = JSimpleStyleDialog.showDialog(null, (SimpleFeatureType) selectedLayer.getFeatureSource().getSchema());
					((FeatureLayer) selectedLayer).setStyle(newStyle);
					mapPane.repaint();

				}
			}
		});
		btnLayerProperties.setIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/gis/mParametersLayer.png")));
		menuBarLayers.add(btnLayerProperties);

		JButton btnLayerUp = new JButton("");
		btnLayerUp.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {

				String selectedLayerTitle = (String) MapPanel2.this.listLayers.getSelectedValue();
				int selectedIndex = MapPanel2.this.listLayers.getSelectedIndex();

				Layer selectedLayer = null;
				// Get selected layer
				int count = 0;
				for (Layer iterLayer : MapPanel2.this.mapContent.layers()) {
					if (iterLayer.getTitle().compareTo(selectedLayerTitle) == 0) {
						selectedLayer = iterLayer;
						break;
					}
					count++;
				}

				// Calc new position
				int newPosition = count + 1;
				System.out.println(MapPanel2.this.mapContent.layers().size());
				System.out.println(MapPanel2.this.listModel.getSize());
				if (newPosition < MapPanel2.this.listModel.getSize()) {

					MapPanel2.this.mapContent.moveLayer(count, newPosition);
					MapPanel2.this.listModel.remove(selectedIndex);
					if (selectedIndex - 1 < 0) {
						selectedIndex = 0;
					}
					MapPanel2.this.listModel.insertElementAt(selectedLayerTitle, selectedIndex - 1);

					MapPanel2.this.listLayers.setSelectedIndex(selectedIndex - 1);

					mapPane.repaint();

				}

			}
		});
		btnLayerUp.setIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/up-16x16.png")));
		menuBarLayers.add(btnLayerUp);

		JButton btnLayerDown = new JButton("");
		btnLayerDown.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {

				String selectedLayerTitle = (String) MapPanel2.this.listLayers.getSelectedValue();
				int selectedIndex = MapPanel2.this.listLayers.getSelectedIndex();

				Layer selectedLayer = null;
				// Get selected layer
				int count = 0;
				for (Layer iterLayer : MapPanel2.this.mapContent.layers()) {
					if (iterLayer.getTitle().compareTo(selectedLayerTitle) == 0) {
						selectedLayer = iterLayer;
						break;
					}
					count++;
				}

				// Calc new position
				int newPosition = count - 1;
				if (newPosition > -1) {
					// newPosition = listModel.getSize()-1;

					MapPanel2.this.mapContent.moveLayer(count, newPosition);
					MapPanel2.this.listModel.remove(selectedIndex);
					if (selectedIndex + 1 > MapPanel2.this.listModel.getSize()) {
						selectedIndex = MapPanel2.this.listModel.getSize() - 1;
					}
					MapPanel2.this.listModel.insertElementAt(selectedLayerTitle, selectedIndex + 1);

					mapPane.repaint();

					MapPanel2.this.listLayers.setSelectedIndex(selectedIndex + 1);

				}
			}
		});
		btnLayerDown.setIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/down-16x16.png")));
		menuBarLayers.add(btnLayerDown);

		this.listLayers = new JList(this.listModel);
		panelLeftList.add(this.listLayers, BorderLayout.CENTER);

		JPanel pConfig = new JPanel();
		tabbedPane.addTab("Parameters", null, pConfig, null);
		pConfig.setLayout(null);

		JCheckBox chckbxGeonames = new JCheckBox("Geonames");
		chckbxGeonames.setSelected(true);
		chckbxGeonames.setBounds(8, 8, 129, 23);
		pConfig.add(chckbxGeonames);

		JCheckBox chckbxPersonnalDatabase = new JCheckBox("Personnal Database");
		chckbxPersonnalDatabase.setBounds(8, 35, 175, 23);
		pConfig.add(chckbxPersonnalDatabase);

		this.txtFile = new JTextField();
		this.txtFile.setEnabled(false);
		this.txtFile.setText("File");
		this.txtFile.setBounds(23, 66, 114, 19);
		pConfig.add(this.txtFile);
		this.txtFile.setColumns(10);

		JButton btnNewButton = new JButton("Browse");
		btnNewButton.setEnabled(false);
		btnNewButton.setBounds(149, 63, 87, 25);
		pConfig.add(btnNewButton);

		JButton btnGeocode = new JButton("Geocode");
		btnGeocode.setBounds(316, 236, 117, 25);
		pConfig.add(btnGeocode);

		// Map content
		mapPane.setRenderer(new StreamingRenderer());
		// GTRenderer renderer = new StreamingRenderer();

		mapPane.setMapContent(this.mapContent);

		JPanel pTableGeoView = new JPanel();
		tabbedPane.addTab("Attributes table", null, pTableGeoView, null);
		pTableGeoView.setLayout(new BorderLayout(0, 0));

		// JLabel lblStatus = new JLabel("Statusbar");
		// pTableGeoView.add(lblStatus, BorderLayout.SOUTH);

		JMenuBar menuBar = new JMenuBar();
		pTableGeoView.add(menuBar, BorderLayout.NORTH);

		JButton btnAddPoint = new JButton("");
		btnAddPoint.setIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/add-16x16.png")));
		menuBar.add(btnAddPoint);

		JButton btnDelPoint = new JButton("");
		btnDelPoint.setIcon(new ImageIcon(MapPanel2.class.getResource("/org/tip/puckgui/images/remove-16x16.png")));
		menuBar.add(btnDelPoint);

		this.table = new JTable();
		this.table.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);

		String[] colName = { "id", "Name", "Country", "Long", "Lat" };

		DefaultTableModel modelAttributesTable = (DefaultTableModel) this.table.getModel();
		modelAttributesTable.setColumnIdentifiers(colName);

		this.table.setModel(modelAttributesTable);

		pTableGeoView.add(this.table, BorderLayout.CENTER);

		try {
			displayWorldBorderShapefile();
		} catch (Exception e) {
			e.printStackTrace();
		}

		// //////////////////////////////////
		ArrayList<DefaultFeatureCollection> collectionfeaturesReadyToBeDisplayed = GeotoolsUtils.getFeaturesForNodesPlaces(source);
		diplayCollectionsPointsAndLines(collectionfeaturesReadyToBeDisplayed);
	}

	private DirectPosition2D calculateWorldPos(final MapPane pane, final MouseEvent event) {
		AffineTransform tr = pane.getScreenToWorldTransform();
		DirectPosition2D pos = new DirectPosition2D(event.getX(), event.getY());
		tr.transform(pos, pos);
		pos.setCoordinateReferenceSystem(pane.getMapContent().getCoordinateReferenceSystem());
		return pos;
	}

	private ReferencedEnvelope centerOn(final ReferencedEnvelope env, final Coordinate coordClicked) {
		Coordinate pEnv = env.centre();
		double dX = -(pEnv.x - coordClicked.x);
		double dY = -(pEnv.y - coordClicked.y);
		env.translate(dX, dY);

		return env;

	}

	/**
	 * Create a Style object from a definition in a SLD document
	 */
	private Style createFromSLD(final File sld) {
		try {
			SLDParser stylereader = new SLDParser(this.styleFactory, sld.toURI().toURL());
			Style[] style = stylereader.readXML();
			return style[0];

		} catch (Exception e) {
			// ExceptionMonitor.show(null, e, "Problem creating style");
		}
		return null;
	}

	/**
	 * Create a Style to display the features. If an SLD file is in the same
	 * directory as the shapefile then we will create the Style by processing
	 * this. Otherwise we display a JSimpleStyleDialog to prompt the user for
	 * preferences.
	 */
	private Style createStyle(final File file, final FeatureSource<?, ?> featureSource) {
		File sld = toSLDFile(file);
		if (sld != null) {
			return createFromSLD(sld);
		}

		SimpleFeatureType schema = (SimpleFeatureType) featureSource.getSchema();
		return JSimpleStyleDialog.showDialog(null, schema);
	}

	public void diplayCollectionsPointsAndLines(final ArrayList<DefaultFeatureCollection> collectionfeaturesReadyToBeDisplayed) {

		// Display points
		FeatureSource<?, ?> featureSourcePoints = DataUtilities.source(collectionfeaturesReadyToBeDisplayed.get(0));
		Style stylePoints = createFromSLD(new File(MapPanel2.class.getResource("/org/tip/puckgui/views/geo/data/SCHEMA_POINTS.sld").getFile()));
		FeatureLayer layerPoints = new FeatureLayer(featureSourcePoints, stylePoints);

		setUpTableData(featureSourcePoints);

		ReferencedEnvelope bounds = layerPoints.getBounds();
		double dh = Math.abs(bounds.getHeight() - bounds.getHeight() * 1.1);
		double dw = Math.abs(bounds.getWidth() - bounds.getWidth() * 1.1);

		bounds.expandBy(Math.max(dh, dw));

		// Display points
		FeatureSource<?, ?> featureSourceLines = DataUtilities.source(collectionfeaturesReadyToBeDisplayed.get(1));
		Style styleLines = createFromSLD(new File(MapPanel2.class.getResource("/org/tip/puckgui/views/geo/data/SCHEMA_LINES.sld").getFile()));
		FeatureLayer layerLines = new FeatureLayer(featureSourceLines, styleLines);

		this.mapContent.addLayer(layerPoints);

		layerPoints.setTitle("Points Layer");
		this.listModel.add(this.listModel.getSize() - 1, layerPoints.getTitle());
		this.mapContent.addLayer(layerLines);
		layerLines.setTitle("Links Layer");
		this.listModel.add(this.listModel.getSize() - 1, layerLines.getTitle());

		this.mapContent.getViewport().setBounds(bounds);
	}

	public void displayFeatureCollectionLayer(final String title, final FeatureCollection<?, ?> featureCollection, final Style style) {

		FeatureLayer layer = new FeatureLayer(featureCollection, style);
		this.mapContent.addLayer(layer);
		layer.setTitle(title);
		this.listModel.addElement(title);
	}

	public void displayFeatureSourceLayer(final String title, final FeatureSource<?, ?> featureSource, final Style style) {

		FeatureLayer layer = new FeatureLayer(featureSource, style);
		this.mapContent.addLayer(layer);
		layer.setTitle(title);
		this.listModel.addElement(title);

	}

	private void displaysShapefile(final File file) throws IOException {

		FileDataStore store = FileDataStoreFinder.getDataStore(file);
		FeatureSource<?, ?> featureSource = store.getFeatureSource();

		// Create a basic Style to render the features
		Style style = createStyle(file, featureSource);

		// Add the features and the associated Style object to
		// the MapContext as a new MapLayer
		displayFeatureSourceLayer(file.getName(), featureSource, style);

	}

	private void displaysShapefile(final URL urlSHP, final URL urlStyle) throws IOException {

		// File file = new File(url.getPath());

		System.out.println("create style");
		System.out.println(urlStyle.getPath());
		Style style = createFromSLD(new File(urlStyle.getPath()));
		System.out.println(style.toString());

		FileDataStore store = FileDataStoreFinder.getDataStore(urlSHP);
		FeatureSource<?, ?> featureSource = store.getFeatureSource();

		// Create a basic Style to render the features
		// Style style = createStyle(file, featureSource);

		// Add the features and the associated Style object to
		// the MapContext as a new MapLayer
		displayFeatureSourceLayer("test", featureSource, style);

	}

	private void displayWorldBorderShapefile() throws IOException {

		// 06/05/2015: temporary fix for Eclipse under Microsoft Windows,
		// because %20 is not available in path.
		// URL fileWorldBorders =
		// MapPanel.class.getResource("/org/tip/puckgui/views/geo/data/TM_WORLD_BORDERS-0.3.shp");
		//
		// File file = new File(fileWorldBorders.getFile());

		// Convert path to separators / \ to system compliance
		String fileName = FilenameUtils.separatorsToSystem(MapPanel2.class.getResource("/org/tip/puckgui/views/geo/data/TM_WORLD_BORDERS-0.3.shp").getFile());

		// With URL
		URL urlShapeFile = MapPanel2.class.getResource("/org/tip/puckgui/views/geo/data/TM_WORLD_BORDERS-0.3.shp");
		URL urlStyle = MapPanel2.class.getResource("/org/tip/puckgui/views/geo/data/TM_WORLD_BORDERS-0.3.sld");
		System.out.println(urlShapeFile);
		displaysShapefile(urlShapeFile, urlStyle);

		// With File
		// File file = new File(fileName);
		// displaysShapefile(file);

		// With Stream
		// InputStream isSHP =
		// this.getClass().getClassLoader().getResourceAsStream(fileName);

	}

	public List<Layer> getLayers() {

		return this.mapContent.layers();

	}

	public ReferencedEnvelope maximiseBoundsForLayers() {

		double minX = Double.MAX_VALUE, minY = Double.MAX_VALUE;
		double maxX = Double.MIN_VALUE, maxY = Double.MIN_VALUE;

		for (Layer iterLayer : getLayers()) {

			if (iterLayer.getTitle().compareTo("TM_WORLD_BORDERS-0.3.shp") != 0) {

				ReferencedEnvelope bounds = iterLayer.getBounds();

				double minXTemp = bounds.getMinX();
				minX = Math.min(minX, minXTemp);
				double maxXTemp = bounds.getMaxX();
				maxX = Math.max(maxX, maxXTemp);

				double minYTemp = bounds.getMinY();
				minY = Math.min(minY, minYTemp);
				double maxYTemp = bounds.getMaxY();
				maxY = Math.max(maxY, maxYTemp);
			}
		}

		ReferencedEnvelope env = new ReferencedEnvelope();
		env.init(minX, maxX, minY, maxY);

		double dh = Math.abs(env.getHeight() - env.getHeight() * 1.1);
		double dw = Math.abs(env.getWidth() - env.getWidth() * 1.1);

		env.expandBy(Math.max(dh, dw));

		return env;

	}

	private void prepareExportShapeFile() {
		File targetFile = new File("exportPuck.shp");
		boolean ended = false;
		while (!ended) {
			JFileChooser chooser = new JFileChooser();
			chooser.setSelectedFile(targetFile);

			chooser.setDialogTitle(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.saveAsFileChooser.text"));
			chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
			chooser.setAcceptAllFileFilterUsed(false);
			GenericFileFilter defaultFileFilter = new GenericFileFilter("Shapefile (*.shp)", "shp");
			chooser.addChoosableFileFilter(defaultFileFilter);
			chooser.setFileFilter(defaultFileFilter);

			//
			if (chooser.showSaveDialog(MapPanel2.this) == JFileChooser.APPROVE_OPTION) {
				targetFile = chooser.getSelectedFile();

				boolean doSave;
				if (targetFile.exists()) {
					// Manage confirmation dialog.
					String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.title");
					String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.text");

					int response = JOptionPane.showConfirmDialog(MapPanel2.this, message, title, JOptionPane.YES_NO_CANCEL_OPTION);

					if (response == JOptionPane.YES_OPTION) {
						doSave = true;
						ended = true;
					} else if (response == JOptionPane.NO_OPTION) {
						doSave = false;
						ended = false;
					} else {
						doSave = false;
						ended = true;
					}
				} else {
					doSave = true;
					ended = true;
				}

				if (doSave) {

					SIGFile.exportToShapefile(MapPanel2.this.getLayers(), targetFile);
				}

			} else {
				// Nothing to do.
				System.out.println("No Selection ");
				ended = true;
			}
		}
	}

	private void prepareExportSVG() {

		OutputStream output;
		File targetFile = new File("exportPuck.svg");

		boolean ended = false;
		while (!ended) {
			JFileChooser chooser = new JFileChooser();
			chooser.setSelectedFile(targetFile);

			chooser.setDialogTitle(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.saveAsFileChooser.text"));
			chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
			chooser.setAcceptAllFileFilterUsed(false);
			GenericFileFilter defaultFileFilter = new GenericFileFilter("Shapefile (*.shp)", "shp");
			chooser.addChoosableFileFilter(defaultFileFilter);
			chooser.setFileFilter(defaultFileFilter);

			if (chooser.showSaveDialog(MapPanel2.this) == JFileChooser.APPROVE_OPTION) {
				targetFile = chooser.getSelectedFile();

				boolean doSave;
				if (targetFile.exists()) {
					// Manage confirmation dialog.
					String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.title");
					String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.text");

					int response = JOptionPane.showConfirmDialog(MapPanel2.this, message, title, JOptionPane.YES_NO_CANCEL_OPTION);

					if (response == JOptionPane.YES_OPTION) {
						doSave = true;
						ended = true;
					} else if (response == JOptionPane.NO_OPTION) {
						doSave = false;
						ended = false;
					} else {
						doSave = false;
						ended = true;
					}
				} else {
					doSave = true;
					ended = true;
				}

				if (doSave) {

					try {

						output = new FileOutputStream(targetFile);

						ReferencedEnvelope env = maximiseBoundsForLayers();

						// Dimension dim = new Dimension(4*new
						// Double(env.getWidth()).intValue(), 4*new
						// Double(env.getHeight()).intValue());

						SIGFile.exportSVG(this.mapContent, env, output, null);

					} catch (FileNotFoundException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} catch (ParserConfigurationException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}

				}

			} else {
				// Nothing to do.
				System.out.println("No Selection ");
				ended = true;
			}
		}
	}

	public void setUpTableData(final FeatureSource<?, ?> featureSourcePoints) {
		DefaultTableModel tableModel = (DefaultTableModel) this.table.getModel();
		ArrayList<SimpleFeature> list = new ArrayList<SimpleFeature>();

		SimpleFeatureIterator iterator = null;
		try {
			iterator = (SimpleFeatureIterator) featureSourcePoints.getFeatures().features();

			while (iterator.hasNext()) {
				SimpleFeature feature = iterator.next();
				list.add(feature);
			}

		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			iterator.close();
		};

		for (int index = 0; index < list.size(); index++) {

			SimpleFeature feature = list.get(index);

			Object[] data = new Object[5];

			data[0] = feature.getAttribute(0); // GeonameId
			data[1] = feature.getAttribute(1); // Name

			// data[?] = list.get(i).getGeonames1();
			// data[?] = list.get(i).getGeonames2();
			// data[?] = list.get(i).getGeonames3();
			data[2] = feature.getAttribute(2); // ISO

			Geometry g = (Geometry) feature.getAttribute("the_geom");
			data[3] = new Double(g.getCoordinate().x);
			data[4] = new Double(g.getCoordinate().y);

			tableModel.addRow(data);
		}
		this.table.setModel(tableModel);
		tableModel.fireTableDataChanged();
		this.table.repaint();
	}

	/**
	 * Figure out if a valid SLD file is available.
	 */
	public File toSLDFile(final File file) {
		String path = file.getAbsolutePath();
		String base = path.substring(0, path.length() - 4);
		String newPath = base + ".sld";
		File sld = new File(newPath);
		if (sld.exists()) {
			return sld;
		}
		newPath = base + ".SLD";
		sld = new File(newPath);
		if (sld.exists()) {
			return sld;
		}
		return null;
	}

	private void unselectToggleButtonsExcept(final JToggleButton tglbSelected) {
		for (JToggleButton iterTglb : this.listToggleButtons) {
			iterTglb.setSelected(false);
		}
		tglbSelected.setSelected(true);
	}

}