package org.tip.puckgui.views;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

import oldcore.trash.TransformWorker;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.PuckManager;
import org.tip.puck.census.workers.CensusCriteria;
import org.tip.puck.census.workers.CensusReporter;
import org.tip.puck.census.workers.KinshipChainsCriteria;
import org.tip.puck.geo.Geography;
import org.tip.puck.geo2.Place2;
import org.tip.puck.geo2.io.GEOXLSFile;
import org.tip.puck.geo2.workers.GeocodingWorker;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.workers.GraphReporter;
import org.tip.puck.io.bar.BARFile;
import org.tip.puck.io.dat.DAT1File;
import org.tip.puck.io.ged.IdShrinker;
import org.tip.puck.io.iur.IURFile;
import org.tip.puck.io.kinsources.CatalogItem;
import org.tip.puck.io.kinsources.KinsourcesFile;
import org.tip.puck.io.paj.PAJFile;
import org.tip.puck.io.selz.SELZFile;
import org.tip.puck.kinoath.ComponentWorker;
import org.tip.puck.kinoath.IndividualGroups;
import org.tip.puck.kinoath.SegmentationWorker;
import org.tip.puck.net.Family;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.Individual;
import org.tip.puck.net.IndividualComparator.Sorting;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.KinType;
import org.tip.puck.net.Net;
import org.tip.puck.net.random.RandomNetReporter;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.relations.workers.AddChildRolesCriteria;
import org.tip.puck.net.relations.workers.RelationModelMaker;
import org.tip.puck.net.relations.workers.RelationModelReporter;
import org.tip.puck.net.relations.workers.RelationModelTXTFile;
import org.tip.puck.net.relations.workers.RelationReporter;
import org.tip.puck.net.relations.workers.RelationWorker;
import org.tip.puck.net.workers.AttributeDescriptors;
import org.tip.puck.net.workers.AttributeFilter;
import org.tip.puck.net.workers.AttributeRenameCriteria;
import org.tip.puck.net.workers.AttributeReplaceValueCriteria;
import org.tip.puck.net.workers.AttributeSetValueCriteria;
import org.tip.puck.net.workers.AttributeWorker;
import org.tip.puck.net.workers.BicomponentWorker;
import org.tip.puck.net.workers.ControlReporter;
import org.tip.puck.net.workers.DistanceAttributeCriteria;
import org.tip.puck.net.workers.ExpandCriteria;
import org.tip.puck.net.workers.ExpansionMode;
import org.tip.puck.net.workers.GeneaQuiltConvert;
import org.tip.puck.net.workers.GeoPlaceNetCriteria;
import org.tip.puck.net.workers.HairCutWorker;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.NetReporter;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.net.workers.SnowballCriteria;
import org.tip.puck.net.workers.TransmitAttributeValueCriteria;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportList;
import org.tip.puck.segmentation.Segment;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.spacetime.Slices;
import org.tip.puck.spacetime.workers.MissingTestimoniesCriteria;
import org.tip.puck.spacetime.workers.SequenceReporter;
import org.tip.puck.spacetime.workers.SliceMaker;
import org.tip.puck.spacetime.workers.SliceReporter;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria.CensusType;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria.TrajectoriesOperation;
import org.tip.puck.spacetime.workers.SpaceTimeReporter;
import org.tip.puck.spacetime.workers.UnknownPlacesCriteria;
import org.tip.puck.statistics.StatisticsCriteria;
import org.tip.puck.statistics.StatisticsReporter;
import org.tip.puck.statistics.StatisticsWorker;
import org.tip.puck.util.Chronometer;
import org.tip.puck.util.ToolBox;
import org.tip.puck.visualization.VisualizationController;
import org.tip.puck.visualization.style.implementations.OreGraph;
import org.tip.puck.visualization.style.implementations.PGraph;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.PuckGUI;
import org.tip.puckgui.WindowGUI;
import org.tip.puckgui.util.ButtonTabComponent;
import org.tip.puckgui.util.GenericFileFilter;
import org.tip.puckgui.views.geneaquilt.IndividualGroupEventQuiltsPanel;
import org.tip.puckgui.views.geneaquilt.IndividualGroupQuiltsPanel;
import org.tip.puckgui.views.geo.MapPanel2;
import org.tip.puckgui.views.geographyEditor.GeographyEditorPanel;
import org.tip.puckgui.views.geographyEditor.GeographyExportFileSelector;
import org.tip.puckgui.views.kinoath.GlobalDiagramPanel;
import org.tip.puckgui.views.kinoath.IndividualDiagramsPanel;
import org.tip.puckgui.views.kinoath.IndividualGroupDiagramsPanel;
import org.tip.puckgui.views.visualization.VisualizationPanel;

import fr.devinsy.flatdb4geonames.swing.FlatDB4GeoNamesRequestPanel;
import fr.devinsy.flatdb4geonames.swing.downloaddatabase.DownloadDatabaseDialog;
import fr.devinsy.util.StringList;
import fr.devinsy.util.StringSet;
import fr.inria.aviz.geneaquilt.gui.quiltview.GeneaQuiltPanel;
import fr.inria.aviz.geneaquilt.model.Network;
import fr.inria.aviz.geneaquilt.model.VertexComparator;

/**
 * 
 * @author TIP
 */
public class MainWindow {

	private static final Logger logger = LoggerFactory.getLogger(MainWindow.class);

	private int reportCounter = 0;
	private JFrame frmPuck;
	private NetGUI netGUI;
	private JMenuItem mntmSave;
	private JMenuItem mntmRevert;
	private JMenu mntmRecent;
	private JTabbedPane tabbedPaneCorpus;
	private CorpusPanel corpusTab;
	private FamiliesPanel familiesTab;
	private IndividualsPanel individualsTab;
	private SegmentationPanel segmentationPanel;

	/**
	 * Create the application.
	 */
	public MainWindow(final NetGUI guiManager) {
		//
		this.netGUI = guiManager;
		initialize();
		this.frmPuck.setVisible(true);

		//
		updateMenuItems();
		updateTitle();
		getCorpusTab().update();
		getIndividualsTab().update();
		getFamiliesTab().update();
		getIndividualsTab().select(null);
		getFamiliesTab().select(null);
		for (RelationModel relationModel : this.netGUI.getNet().relationModels()) {
			//
			addRawTab(relationModel.getName(), new RelationsPanel(this.netGUI, relationModel));
		}
	}

	/**
	 * 
	 * @param report
	 */
	public void addRawTab(final String title, final JPanel panel) {
		//
		this.tabbedPaneCorpus.addTab(title, null, panel, null);
		this.tabbedPaneCorpus.setSelectedComponent(panel);
	}

	/**
	 * 
	 * @param report
	 */
	public void addRelationTab(final RelationModel relationModel) {
		//
		if (relationModel != null) {
			//
			JPanel relationPanel = new RelationsPanel(this.netGUI, relationModel);

			//
			addRawTab(relationModel.getName(), relationPanel);
		}
	}

	/**
	 * 
	 * @param report
	 */
	public void addReportTab(final Report report) {
		//
		JPanel reportPanel;
		if (report.containsSubReport()) {
			//
			reportPanel = new ReportsPanel(this.netGUI, report);

		} else {
			//
			reportPanel = new ReportPanel(this.netGUI, report);
		}

		addReportTab(report.title(), reportPanel);
	}

	/**
	 * 
	 * @param report
	 */
	public void addReportTab(final String title, final JPanel reportPanel) {
		//
		this.reportCounter += 1;

		addTab(title + " (" + this.reportCounter + ")", reportPanel);
	}

	/**
	 * 
	 * @param report
	 */
	public void addTab(final String title, final JPanel panel) {
		//
		this.tabbedPaneCorpus.addTab(title, null, panel, null);
		this.tabbedPaneCorpus.setSelectedComponent(panel);
		this.tabbedPaneCorpus.setTabComponentAt(this.tabbedPaneCorpus.getSelectedIndex(), new ButtonTabComponent(this.tabbedPaneCorpus));
	}

	/**
	 * 
	 */
	public void closeCurrentTab() {
		//
		this.tabbedPaneCorpus.remove(this.tabbedPaneCorpus.getSelectedIndex());
	}

	/**
	 * 
	 */
	public void closeRelationTabs() {

		for (RelationsPanel tab : getRelationTabs()) {
			//
			this.tabbedPaneCorpus.remove(tab);
		}
	}

	/**
	 * 
	 */
	public void closeVolatilTabs() {
		//
		for (int tabIndex = this.tabbedPaneCorpus.getTabCount() - 1; tabIndex >= 3; tabIndex--) {
			//
			this.tabbedPaneCorpus.remove(tabIndex);
		}
	}

	/**
	 * 
	 */
	public void dispose() {
		//
		this.frmPuck.dispose();
	}

	/**
	 * 
	 * @return
	 */
	public CorpusPanel getCorpusTab() {
		return this.corpusTab;
	}

	/**
	 * 
	 * @return
	 */
	public int getCurrentTabIndex() {
		int result;

		result = this.tabbedPaneCorpus.getSelectedIndex();

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public FamiliesPanel getFamiliesTab() {
		return this.familiesTab;
	}

	/**
	 * 
	 * @return
	 */
	public IndividualsPanel getIndividualsTab() {
		return this.individualsTab;
	}

	/**
	 * 
	 * @return
	 */
	public JFrame getJFrame() {
		JFrame result;

		result = this.frmPuck;

		//
		return result;
	}

	/**
	 * 
	 * @param relationModel
	 * @return
	 */
	public RelationsPanel getRelationTab(final RelationModel relationModel) {
		RelationsPanel result;

		int tabIndex = this.getRelationTabIndex(relationModel);
		if (tabIndex == -1) {
			result = null;
		} else {
			result = (RelationsPanel) this.tabbedPaneCorpus.getComponent(tabIndex);
		}

		//
		return result;
	}

	/**
	 * 
	 * @param relationModel
	 * @return
	 */
	public int getRelationTabIndex(final RelationModel relationModel) {
		int result;

		result = -1;
		boolean ended = false;
		int tabIndex = 0;
		while (!ended) {
			if (tabIndex < this.tabbedPaneCorpus.getComponentCount()) {
				Component tab = this.tabbedPaneCorpus.getComponent(tabIndex);
				if ((tab.getClass() == RelationsPanel.class) && (((RelationsPanel) tab).getRelationModel() == relationModel)) {
					ended = true;
					result = tabIndex;
				} else {
					tabIndex += 1;
				}
			} else {
				ended = true;
				result = -1;
			}
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public List<RelationsPanel> getRelationTabs() {
		List<RelationsPanel> result;

		result = new ArrayList<RelationsPanel>();

		for (Component tab : this.tabbedPaneCorpus.getComponents()) {
			if (tab.getClass() == RelationsPanel.class) {
				result.add((RelationsPanel) tab);
			}
		}

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public SegmentationPanel getSegmentationPanel() {
		return this.segmentationPanel;
	}

	/**
	 * Initialize the contents of the frame.
	 */
	private void initialize() {
		this.frmPuck = new JFrame();
		this.frmPuck.addWindowListener(new WindowAdapter() {
			@Override
			public void windowClosing(final WindowEvent event) {
				System.out.println("Closing event.");
				performCloseWindow();
			}
		});
		this.frmPuck.setIconImage(Toolkit.getDefaultToolkit().getImage(MainWindow.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
		this.frmPuck.setTitle(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.frmPuck.title")); //$NON-NLS-1$ //$NON-NLS-2$
		this.frmPuck.setBounds(50, 0, 1020, getDesktopHeight());

		this.frmPuck.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);

		JMenuBar menuBar = new JMenuBar();
		this.frmPuck.setJMenuBar(menuBar);

		JMenu mnFile = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnFile.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnFile.setMnemonic('F');
		menuBar.add(mnFile);

		JMenu mnNew = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnNew.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnFile.add(mnNew);

		JMenuItem mntmBlankCorpus = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmBlankCorpus.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmBlankCorpus.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// New Blank Corpus.
				PuckGUI.instance().createNetGUI();
			}
		});
		mnNew.add(mntmBlankCorpus);

		JMenu mnRandomnetwork = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnRandomnetwork.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnNew.add(mnRandomnetwork);

		JMenuItem mntmClassic = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmClassic.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmClassic.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// New Random Corpus.
				try {
					//
					RandomCorpusInputWindow window = new RandomCorpusInputWindow(MainWindow.this.netGUI);

					//
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);

					//
					window.setVisible(true);
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnRandomnetwork.add(mntmClassic);

		JMenuItem mntmTelmo = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmTelmo.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmTelmo.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// New Random Corpus.
				try {
					//
					RandomCorpusMASInputWindow window = new RandomCorpusMASInputWindow(MainWindow.this.netGUI);

					//
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);

					//
					window.setVisible(true);
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnRandomnetwork.add(mntmTelmo);

		JMenuItem mntmVariationsbc = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmVariationsbc.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmVariationsbc.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				try {
					Report report = RandomNetReporter.ReportMASVariation();
					MainWindow.this.netGUI.addReportTab(report);
				} catch (PuckException exception) {
					// TODO Auto-generated catch block
					exception.printStackTrace();
				}
			}
		});
		mnRandomnetwork.add(mntmVariationsbc);

		JMenuItem mntmEmptyAllianceNetwork = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmEmptyAllianceNetwork.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmEmptyAllianceNetwork.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_N, InputEvent.CTRL_MASK));
		mntmEmptyAllianceNetwork.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// New Alliance Network.
				try {
					//
					PuckGUI.instance().createGroupNetGUI(
							new Graph<Cluster<Individual>>(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("puckgui.defaultFileName")));

				} catch (PuckException exception) {
					exception.printStackTrace();
				}
			}
		});
		mnNew.add(mntmEmptyAllianceNetwork);

		JMenuItem mntmOpen = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmOpen.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmOpen.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmOpen.toolTipText")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmOpen.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_O, InputEvent.CTRL_MASK));
		mntmOpen.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Open...
				//
				File file = selectFile(MainWindow.this.frmPuck, MainWindow.this.netGUI.getFile().getParentFile());

				//
				openSelectedFile(MainWindow.this.netGUI, MainWindow.this.frmPuck, file, PuckManager.DEFAULT_CHARSET_NAME);
			}
		});
		mnFile.add(mntmOpen);

		this.mntmRecent = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnNewMenu.text"));
		this.mntmRecent.addMenuListener(new MenuListener() {
			@Override
			public void menuCanceled(final MenuEvent e) {
			}

			@Override
			public void menuDeselected(final MenuEvent event) {
				// OpenRecent menu cleaning.
				JMenu openRecentMenu = (JMenu) event.getSource();
				openRecentMenu.removeAll();
			}

			@Override
			public void menuSelected(final MenuEvent event) {
				// OpenRecent menu updating.
				JMenu openRecentMenu = (JMenu) event.getSource();
				for (File file : PuckGUI.instance().recentFiles()) {
					openRecentMenu.add(new OpenRecentMenuItem(MainWindow.this.frmPuck, MainWindow.this.netGUI, file));
				}
			}
		});
		mnFile.add(this.mntmRecent);

		JMenu mnOpenRecentFolder = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnOpenFolder.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnOpenRecentFolder.addMenuListener(new MenuListener() {
			@Override
			public void menuCanceled(final MenuEvent event) {
			}

			@Override
			public void menuDeselected(final MenuEvent event) {
				// OpenRecentFolder menu cleaning.
				JMenu openRecentFolderMenu = (JMenu) event.getSource();
				openRecentFolderMenu.removeAll();
			}

			@Override
			public void menuSelected(final MenuEvent event) {
				// OpenRecentFodler menu updating.
				JMenu openRecentFolderMenu = (JMenu) event.getSource();
				for (File folder : PuckGUI.instance().recentFolders()) {
					openRecentFolderMenu.add(new OpenRecentFolderMenuItem(MainWindow.this.frmPuck, MainWindow.this.netGUI, folder));
				}
			}
		});
		mnFile.add(mnOpenRecentFolder);

		this.mntmRevert = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRevert.text"));
		this.mntmRevert.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_R, InputEvent.CTRL_MASK));
		this.mntmRevert.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRevert.toolTipText")); //$NON-NLS-1$ //$NON-NLS-2$
		this.mntmRevert.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Revert.
				try {
					if (MainWindow.this.netGUI.isChanged()) {
						//
						int response = JOptionPane.showConfirmDialog(MainWindow.this.frmPuck, "All changes will be lost. Confirm revert of this corpus?",
								"Revert confirm", JOptionPane.YES_NO_OPTION);

						if (response == JOptionPane.YES_OPTION) {
							//
							MainWindow.this.netGUI.revert();
						}
					} else {
						//
						MainWindow.this.netGUI.revert();
					}

				} catch (final PuckException exception) {
					//
					String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");

					//
					String message;
					switch (PuckExceptions.valueOf(exception.getCode())) {
						case FILE_NOT_FOUND:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.fileNotFound");
						break;
						case BAD_FILE_FORMAT:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.badFileFormat");
						break;
						case UNSUPPORTED_FILE_FORMAT:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedFileFormat");
						break;
						case NOT_A_FILE:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.notAFile");
						break;
						case UNSUPPORTED_ENCODING:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedEncoding");
						break;
						default:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");
					}

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);

				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmOpenEncoding = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmOpenEncoding.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmOpenEncoding.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Open Encoding.
				try {
					//
					String charsetName = OpenEncodingWindow.showDialog();
					logger.debug("charset=[" + charsetName + "]");

					//
					if (charsetName != null) {
						//
						File file = selectFile(MainWindow.this.frmPuck, MainWindow.this.netGUI.getFile().getParentFile());

						//
						openSelectedFile(MainWindow.this.netGUI, MainWindow.this.frmPuck, file, charsetName);
					}

				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnFile.add(mntmOpenEncoding);

		JMenuItem mntmOpenFromKinsources = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmOpenFromKinsources.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmOpenFromKinsources.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Open from Kinsources.
				try {
					//
					CatalogItem criteria = KinsourcesCatalogSelectorDialog.showDialog();

					//
					if (criteria != null) {
						//
						logger.info("Download Kinsources dataset file [{}][{}]", criteria.getId(), criteria.getName());

						Net newNet = KinsourcesFile.load(criteria.getId());

						File newFile = new File(newNet.getLabel());

						//
						if (MainWindow.this.netGUI.isBlank()) {
							//
							MainWindow.this.netGUI.setFile(newFile);
							MainWindow.this.netGUI.setNet(newNet);

						} else {
							//
							PuckGUI.instance().createNetGUI(newFile, newNet);
						}
					}

				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnFile.add(mntmOpenFromKinsources);
		mnFile.add(this.mntmRevert);

		JSeparator separator_4 = new JSeparator();
		mnFile.add(separator_4);

		this.mntmSave = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSave.text"));
		this.mntmSave.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSave.toolTipText")); //$NON-NLS-1$ //$NON-NLS-2$
		this.mntmSave.setEnabled(false);
		this.mntmSave.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_S, InputEvent.CTRL_MASK));
		this.mntmSave.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Save net.
				try {
					File targetFile = MainWindow.this.netGUI.getFile();

					if (ToolBox.getExtension(targetFile) == null) {
						//
						targetFile = CorpusSaveFileSelector.showSelectorDialog(MainWindow.this.frmPuck, targetFile);
					}

					if (targetFile != null) {
						//
						PuckManager.saveNet(targetFile, MainWindow.this.netGUI.getNet());

						//
						MainWindow.this.netGUI.setFile(targetFile);

						//
						MainWindow.this.netGUI.setChanged(false);

						//
						PuckGUI.instance().recentFiles().updateFile(targetFile);
						PuckGUI.instance().recentFolders().updateFolder(targetFile.getParentFile());
					}
				} catch (final PuckException exception) {
					//
					String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.title");

					//
					String message;
					switch (PuckExceptions.valueOf(exception.getCode())) {
						case UNSUPPORTED_FILE_FORMAT:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedFileFormat");
						break;
						case NOT_A_FILE:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.notAFile");
						break;
						case UNSUPPORTED_ENCODING:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedEncoding");
						break;
						default:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.default");
					}

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmFuse = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmFuse.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmFuse.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Fuse.
				try {
					FuseInputWindow window = new FuseInputWindow(MainWindow.this.netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnFile.add(mntmFuse);

		JMenuItem mntmUpdateOverwriting = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmUpdateOverwriting.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmUpdateOverwriting.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Update Overwriting.
				try {
					File file = selectFile(MainWindow.this.frmPuck, null);

					//
					if (file != null) {
						//
						Report report = new Report("Update report");
						Net updatedNet = PuckManager.updateNetOverwriting(MainWindow.this.netGUI.getNet(), file, report);

						//
						NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), updatedNet);
						newNetGui.setChanged(true, "-overwritten");
						if (report.outputs().isNotEmpty()){
							newNetGui.addReportTab(report);
						}
					}
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnFile.add(mntmUpdateOverwriting);

		JMenuItem mntmUpdateAppending = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmUpdateAppending.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmUpdateAppending.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Update Appending.
				try {
					File file = selectFile(MainWindow.this.frmPuck, null);

					//
					if (file != null) {
						//
						Report report = new Report("Update report");
						Net updatedNet = PuckManager.updateNetAppending(MainWindow.this.netGUI.getNet(), file, report);

						//
						NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), updatedNet);
						newNetGui.setChanged(true, "-appended");
						if (report.outputs().isNotEmpty()){
							newNetGui.addReportTab(report);
						}
					}
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnFile.add(mntmUpdateAppending);

		JSeparator separator_5 = new JSeparator();
		mnFile.add(separator_5);

		mnFile.add(this.mntmSave);

		JMenuItem mntmSaveAs = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSaveAs.text"));
		mntmSaveAs.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSaveAs.toolTipText")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmSaveAs.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Save As.
				performSaveAs(MainWindow.this.frmPuck, MainWindow.this.netGUI);
			}
		});

		mnFile.add(mntmSaveAs);

		JMenuItem mntmSaveACopy = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSaveACopy.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmSaveACopy.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSaveACopy.toolTipText")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmSaveACopy.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Save a copy.
				try {
					//
					File targetFile = CorpusSaveFileSelector.showSelectorDialog(MainWindow.this.frmPuck, MainWindow.this.netGUI.getFile());

					if (targetFile != null) {
						//
						PuckManager.saveNet(targetFile, MainWindow.this.netGUI.getNet());

						//
						PuckGUI.instance().recentFiles().updateFile(targetFile);
						PuckGUI.instance().recentFolders().updateFolder(targetFile.getParentFile());
					}
				} catch (final PuckException exception) {
					//
					String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.title");

					//
					String message;
					switch (PuckExceptions.valueOf(exception.getCode())) {
						case UNSUPPORTED_FILE_FORMAT:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedFileFormat");
						break;
						case NOT_A_FILE:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.notAFile");
						break;
						case UNSUPPORTED_ENCODING:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedEncoding");
						break;
						default:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.default");
					}

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);

				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}

			}
		});
		mnFile.add(mntmSaveACopy);

		JMenuItem mntmClose = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmClose.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmClose.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmClose.toolTipText")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmClose.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_W, InputEvent.CTRL_MASK));
		mntmClose.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Perform Close Corpus.
				performCloseCorpus();
			}
		});

		JSeparator separator = new JSeparator();
		mnFile.add(separator);

		JMenuItem mntmExportToPajek = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmExportToPajek.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmExportToPajek.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Export to Pajek.
				// Linking Chains
				try {
					//
					PajekExportCriteria criteria = PajekExportInputDialog.showDialog(MainWindow.this.netGUI.getFile(),
							IndividualValuator.getAttributeLabels(MainWindow.this.netGUI.getNet().individuals()));

					//
					if (criteria != null) {
						PAJFile.exportToPajek(MainWindow.this.netGUI.getNet(), criteria.getTargetFileName(), criteria.getGraphType(),
								criteria.getPartitionLabelsNotBlank());
					}
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmExportBAR = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmExportOds.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmExportBAR.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Export BAR.
				performBARSave();
			}
		});

		JMenuItem mntmImportDat = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmImportDat.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmImportDat.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Import DAT.
				try {
					//
					File file = selectDATFileToLoad(MainWindow.this.frmPuck, MainWindow.this.netGUI.getFile());

					//
					if (file != null) {
						//
						Net net = DAT1File.load(file);

						//
						if (MainWindow.this.netGUI.isBlank()) {
							MainWindow.this.netGUI.setFile(file);
							MainWindow.this.netGUI.setNet(net);
						} else {
							PuckGUI.instance().createNetGUI(file, net);
						}
					}
				} catch (final PuckException exception) {
					exception.printStackTrace();

					//
					String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");

					//
					String message;
					switch (PuckExceptions.valueOf(exception.getCode())) {
						case FILE_NOT_FOUND:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.fileNotFound");
						break;
						case BAD_FILE_FORMAT:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.badFileFormat");
						break;
						case UNSUPPORTED_FILE_FORMAT:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedFileFormat");
						break;
						case NOT_A_FILE:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.notAFile");
						break;
						case UNSUPPORTED_ENCODING:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedEncoding");
						break;
						default:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");
					}

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);

				} catch (final Exception exception) {
					exception.printStackTrace();

					//
					String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");

					String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnFile.add(mntmImportDat);

		JMenuItem mntmImportSelz = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmImportOds.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmImportSelz.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Import Selz.
				try {
					//
					// File file = selectFile(frmPuck, netGUI.getFile());
					File file = selectSelzFileToLoad(MainWindow.this.frmPuck, MainWindow.this.netGUI.getFile());

					//
					if (file != null) {
						//
						Net net = SELZFile.load(file, PuckManager.DEFAULT_CHARSET_NAME);

						//
						if (MainWindow.this.netGUI.isBlank()) {
							MainWindow.this.netGUI.setFile(file);
							MainWindow.this.netGUI.setNet(net);
						} else {
							PuckGUI.instance().createNetGUI(file, net);
						}
					}
				} catch (final PuckException exception) {
					exception.printStackTrace();

					//
					String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");

					//
					String message;
					switch (PuckExceptions.valueOf(exception.getCode())) {
						case FILE_NOT_FOUND:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.fileNotFound");
						break;
						case BAD_FILE_FORMAT:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.badFileFormat");
						break;
						case UNSUPPORTED_FILE_FORMAT:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedFileFormat");
						break;
						case NOT_A_FILE:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.notAFile");
						break;
						case UNSUPPORTED_ENCODING:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedEncoding");
						break;
						default:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");
					}

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);

				} catch (final Exception exception) {
					//
					exception.printStackTrace();

					//
					String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");

					String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnFile.add(mntmImportSelz);
		mnFile.add(mntmExportBAR);
		mnFile.add(mntmExportToPajek);

		JSeparator separator_1 = new JSeparator();
		mnFile.add(separator_1);
		mnFile.add(mntmClose);

		JMenuItem mntmQuit = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmQuit.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmQuit.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmQuit.toolTipText")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmQuit.setMnemonic('Q');
		mntmQuit.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				//
				System.out.println("Quit action.");

				performQuit();
			}
		});

		JSeparator separator_7 = new JSeparator();
		mnFile.add(separator_7);
		mnFile.add(mntmQuit);

		JMenu mnEdit = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnNewMenu.text_1"));
		mnEdit.setMnemonic('E');
		menuBar.add(mnEdit);

		JMenuItem mntmCut = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCut.text"));
		mntmCut.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_CUT, 0));
		mntmCut.setEnabled(false);
		mnEdit.add(mntmCut);

		JMenuItem mntmCopy = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCopy.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmCopy.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_COPY, 0));
		mntmCopy.setEnabled(false);
		mnEdit.add(mntmCopy);

		JMenuItem mntmPaste = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmPaste.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmPaste.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_PASTE, 0));
		mntmPaste.setEnabled(false);
		mnEdit.add(mntmPaste);

		JMenuItem mntmDelete = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmDelete.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmDelete.setEnabled(false);
		mnEdit.add(mntmDelete);

		JSeparator separator_2 = new JSeparator();
		mnEdit.add(separator_2);

		JMenuItem mntmPreferences = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmPreferences.text"));
		mntmPreferences.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Preferences.
				try {
					PreferencesWindow preferences = new PreferencesWindow();
					preferences.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					preferences.setVisible(true);
				} catch (Exception exception) {
					exception.printStackTrace();
				}
			}
		});

		JMenuItem mntmAddIndividual = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAddIndividual.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmAddIndividual.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_I, InputEvent.CTRL_MASK));
		mntmAddIndividual.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Add Individual.
				MainWindow.this.individualsTab.addIndividual();
			}
		});
		mnEdit.add(mntmAddIndividual);

		JMenuItem mntmFind = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmFind.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmFind.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Find.
				switch (MainWindow.this.tabbedPaneCorpus.getSelectedIndex()) {
					case 1:
						MainWindow.this.individualsTab.setFocusOnFind();
					break;
					case 2:
						MainWindow.this.familiesTab.setFocusOnFind();
					break;
					default:
				}
			}
		});

		JMenuItem mntmAddPartner = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAddPartner.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmAddPartner.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_P, InputEvent.CTRL_MASK));
		mntmAddPartner.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Add partner (menu item).
				switch (MainWindow.this.tabbedPaneCorpus.getSelectedIndex()) {
					case 1:
						MainWindow.this.individualsTab.addPartner();
					break;
					default:
				}
			}
		});

		JMenuItem mntmAddOriginFamily = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAddOriginFamily.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmAddOriginFamily.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Add Original Family.
				switch (MainWindow.this.tabbedPaneCorpus.getSelectedIndex()) {
					case 1:
						MainWindow.this.individualsTab.addOriginFamily();
					break;
					default:
				}
			}
		});
		mntmAddOriginFamily.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_U, InputEvent.CTRL_MASK));
		mnEdit.add(mntmAddOriginFamily);
		mnEdit.add(mntmAddPartner);

		JMenuItem mntmAddChild = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAddChild.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmAddChild.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Add child (menu item).
				switch (MainWindow.this.tabbedPaneCorpus.getSelectedIndex()) {
					case 1:
						MainWindow.this.individualsTab.addChild();
					break;
					case 2:
						MainWindow.this.familiesTab.addChild();
					break;
					default:
				}
			}
		});
		mntmAddChild.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_K, InputEvent.CTRL_MASK));
		mnEdit.add(mntmAddChild);

		JMenuItem mntmAddFamily = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAddFamily.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmAddFamily.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Add family.
				MainWindow.this.familiesTab.addFamily();
			}
		});
		mntmAddFamily.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_U, InputEvent.CTRL_MASK | InputEvent.SHIFT_MASK));
		mnEdit.add(mntmAddFamily);

		JMenuItem mntmAddRelationModel = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmNewMenuItem.text_1")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmAddRelationModel.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Add Relation Model.
				try {
					RelationModelInputWindow window = new RelationModelInputWindow(MainWindow.this.netGUI, null);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnEdit.add(mntmAddRelationModel);

		JMenuItem mntmEditGeography = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmEditGeography.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmEditGeography.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Edit geography.
				try {
					GeographyEditorPanel panel = new GeographyEditorPanel(MainWindow.this.netGUI);
					addTab("Geography editor", panel);

				} catch (final Exception exception) {
					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnEdit.add(mntmEditGeography);
		mntmFind.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F, InputEvent.CTRL_MASK));
		mnEdit.add(mntmFind);

		JSeparator separator_9 = new JSeparator();
		mnEdit.add(separator_9);
		mnEdit.add(mntmPreferences);

		JMenu mnCorpus = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnCorpus.text")); //$NON-NLS-1$ //$NON-NLS-2$
		menuBar.add(mnCorpus);

		JMenuItem mntmListById = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListById.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmListById.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				try {
					List<Sorting> sorting = new ArrayList<Sorting>();
					sorting.add(Sorting.ID);
					Report report = StatisticsReporter.reportIndividuals(MainWindow.this.netGUI.getSegmentation(), sorting, null);
					MainWindow.this.netGUI.addReportTab(report);
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnCorpus.add(mntmListById);

		JMenuItem mntmListByFirst = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListByFirst.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmListByFirst.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				try {
					List<Sorting> sorting = new ArrayList<Sorting>();
					sorting.add(Sorting.FIRSTN);
					sorting.add(Sorting.LASTN);
					sorting.add(Sorting.ID);
					Report report = StatisticsReporter.reportIndividuals(MainWindow.this.netGUI.getSegmentation(), sorting, null);
					MainWindow.this.netGUI.addReportTab(report);
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnCorpus.add(mntmListByFirst);

		JMenuItem mntmListByLast = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListByLast.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmListByLast.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				try {
					List<Sorting> sorting = new ArrayList<Sorting>();
					sorting.add(Sorting.LASTN);
					sorting.add(Sorting.FIRSTN);
					sorting.add(Sorting.ID);
					Report report = StatisticsReporter.reportIndividuals(MainWindow.this.netGUI.getSegmentation(), sorting, null);
					MainWindow.this.netGUI.addReportTab(report);
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnCorpus.add(mntmListByLast);

		JMenuItem mntmListByClusters = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListByClusters.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmListByClusters.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				try {
					ListByClusterInputWindow window = new ListByClusterInputWindow(MainWindow.this.netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmListByLast_1 = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListByLast_1.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmListByLast_1.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				try {
					List<String> details = new ArrayList<String>();
					details.add("BAP_DATE");
					details.add("PARENTS");
					details.add("PARTNERS");
					details.add("MARR_DATE");
					details.add("CHILDREN");
					details.add("FIRST_CHILD_BAP_DATE");
					details.add("FIRST_CHILD_FIRST_MARR_DATE");
					List<Sorting> sorting = new ArrayList<Sorting>();
					sorting.add(Sorting.LASTN);
					sorting.add(Sorting.FIRSTN);
					sorting.add(Sorting.ID);
					Report report = StatisticsReporter.reportIndividuals(MainWindow.this.netGUI.getSegmentation(), sorting, details);
					MainWindow.this.netGUI.addReportTab(report);
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnCorpus.add(mntmListByLast_1);
		mnCorpus.add(mntmListByClusters);

		JMenuItem mntmListRelatives = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListRelatives.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmListRelatives.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				try {
					ListRelativesByClusterInputWindow window = new ListRelativesByClusterInputWindow(MainWindow.this.netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnCorpus.add(mntmListRelatives);

		JMenuItem mntmExportFamilyIds = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmExportFamilyIds.text"));
		mntmExportFamilyIds.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Export family Ids by Husband.
				try {
					Report report = StatisticsReporter.reportFamiliesByHusband(MainWindow.this.netGUI.getNet());
					MainWindow.this.netGUI.addReportTab(report);
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmListMissingRelatives = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListMissingRelatives.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmListMissingRelatives.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				try {
					ListMissingRelativesByClusterInputWindow window = new ListMissingRelativesByClusterInputWindow(MainWindow.this.netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnCorpus.add(mntmListMissingRelatives);
		mnCorpus.add(mntmExportFamilyIds);

		JMenuItem mntmListFamiliesBy = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListFamiliesBy.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmListFamiliesBy.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Export family Ids by Wife.
				try {
					Report report = StatisticsReporter.reportFamiliesByWife(MainWindow.this.netGUI.getNet());
					MainWindow.this.netGUI.addReportTab(report);
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnCorpus.add(mntmListFamiliesBy);

		JMenuItem mntmHomonyms = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmHomonyms.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmHomonyms.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// List homonyms.
				try {
					HomonymReportInputWindow window = new HomonymReportInputWindow(MainWindow.this.netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnCorpus.add(mntmHomonyms);

		JMenu mnControls = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnControls.text"));
		mnCorpus.add(mnControls);

		JMenuItem mntmControl = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmControl.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnControls.add(mntmControl);

		JSeparator separator_8 = new JSeparator();
		mnControls.add(separator_8);

		JMenuItem mntmControlSameSex = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmControlSameSex.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnControls.add(mntmControlSameSex);

		JMenuItem mntmControlFemaleFathers = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmControlFemaleFathers.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnControls.add(mntmControlFemaleFathers);

		JMenuItem mntmMultipleFathersOr = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmMultipleFathersOr.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmMultipleFathersOr.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Control Female Fathers or Male Mothers.
				try {
					Report report = ControlReporter.reportMultipleFathersOrMothers(MainWindow.this.netGUI.getSegmentation(),
							ResourceBundle.getBundle("org.tip.puckgui.messages"));

					if (report.status() == 0) {
						//
						String title = "Control special features report";
						String message = "No special features found.";

						//
						JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);
					} else {
						MainWindow.this.netGUI.addReportTab(report);
					}
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnControls.add(mntmMultipleFathersOr);

		JMenuItem mntmControlCyclicDescent = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmControlCyclicDescent.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnControls.add(mntmControlCyclicDescent);

		JMenuItem mntmControlUnknownSex = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmControlUnknownSex.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnControls.add(mntmControlUnknownSex);

		JMenuItem mntmUnknownSexParents = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmUnknownSexParents.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmUnknownSexParents.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Control Unknown Sex Parents or Spouses.
				try {
					Report report = ControlReporter.reportUnknownSexParentsSpouses(MainWindow.this.netGUI.getSegmentation(),
							ResourceBundle.getBundle("org.tip.puckgui.messages"));

					if (report.status() == 0) {
						//
						String title = "Control special features report";
						String message = "No special features found.";

						//
						JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);
					} else {
						MainWindow.this.netGUI.addReportTab(report);
					}
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnControls.add(mntmUnknownSexParents);

		JMenuItem mntmControlNamelessPersons = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmControlNamelessPersons.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnControls.add(mntmControlNamelessPersons);

		JMenuItem mntmControlParentchildMarriages = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmControlParentchildMarriages.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnControls.add(mntmControlParentchildMarriages);

		JMenuItem mntmAutomarriage = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAutomarriage.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmAutomarriage.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Control Auto-marriages.
				try {
					Report report = ControlReporter.reportAutoMarriages(MainWindow.this.netGUI.getSegmentation(),
							ResourceBundle.getBundle("org.tip.puckgui.messages"));

					if (report.status() == 0) {
						//
						String title = "Control special features report";
						String message = "No special features found.";

						//
						JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);
					} else {
						MainWindow.this.netGUI.addReportTab(report);
					}
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnControls.add(mntmAutomarriage);

		JMenuItem mntmInconsistentDates = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmInconsistentDates.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmInconsistentDates.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Control Inconsistent Dates.
				try {
					Report report = ControlReporter.reportInconsistentDates(MainWindow.this.netGUI.getSegmentation(),
							ResourceBundle.getBundle("org.tip.puckgui.messages"));

					if (report.status() == 0) {
						//
						String title = "Control special features report";
						String message = "No special features found.";

						//
						JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);
					} else {
						MainWindow.this.netGUI.addReportTab(report);
					}
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnControls.add(mntmInconsistentDates);

		JMenuItem mntmMissingDatesCompact = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmMissingDates.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmMissingDatesCompact.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Control Missing Dates in Compact Format.
				try {
					Report report = ControlReporter.reportMissingDatesCompact(MainWindow.this.netGUI.getSegmentation(),
							ResourceBundle.getBundle("org.tip.puckgui.messages"));

					if (report.status() == 0) {
						//
						String title = "Control special features report";
						String message = "No special features found.";

						//
						JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);
					} else {
						MainWindow.this.netGUI.addReportTab(report);
					}
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmMissingDates = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmMissingDates_1.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmMissingDates.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Control Missing Dates.
				try {
					Report report = ControlReporter.reportMissingDates(MainWindow.this.netGUI.getSegmentation(),
							ResourceBundle.getBundle("org.tip.puckgui.messages"));

					if (report.status() == 0) {
						//
						String title = "Control special features report";
						String message = "No special features found.";

						//
						JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);
					} else {
						MainWindow.this.netGUI.addReportTab(report);
					}
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnControls.add(mntmMissingDates);
		mnControls.add(mntmMissingDatesCompact);

		mntmControlParentchildMarriages.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Control Parent-Child marriages.
				try {
					Report report = ControlReporter.reportParentChildMarriages(MainWindow.this.netGUI.getSegmentation(),
							ResourceBundle.getBundle("org.tip.puckgui.messages"));

					if (report.status() == 0) {
						//
						String title = "Control special features report";
						String message = "No special features found.";

						//
						JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);
					} else {
						MainWindow.this.netGUI.addReportTab(report);
					}
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmControlNamelessPersons.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Control Nameless persons.
				try {
					Report report = ControlReporter.reportNamelessPersons(MainWindow.this.netGUI.getSegmentation(),
							ResourceBundle.getBundle("org.tip.puckgui.messages"));

					if (report.status() == 0) {
						//
						String title = "Control special features report";
						String message = "No special features found.";

						//
						JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);
					} else {
						MainWindow.this.netGUI.addReportTab(report);
					}
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmControlUnknownSex.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Control Unknown Sex Persons.
				try {
					Report report = ControlReporter.reportUnknownSexPersons(MainWindow.this.netGUI.getSegmentation(),
							ResourceBundle.getBundle("org.tip.puckgui.messages"));

					if (report.status() == 0) {
						//
						String title = "Control special features report";
						String message = "No special features found.";

						//
						JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);
					} else {
						MainWindow.this.netGUI.addReportTab(report);
					}
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmControlCyclicDescent.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Control Cyclic Descent cases.
				try {
					Report report = ControlReporter.reportCyclicDescentCases(MainWindow.this.netGUI.getSegmentation(),
							ResourceBundle.getBundle("org.tip.puckgui.messages"));

					if (report.status() == 0) {
						//
						String title = "Control special features report";
						String message = "No special features found.";

						//
						JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);
					} else {
						MainWindow.this.netGUI.addReportTab(report);
					}
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmControlFemaleFathers.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Control Female Fathers or Male Mothers.
				try {
					Report report = ControlReporter.reportFemaleFathersOrMaleMothers(MainWindow.this.netGUI.getSegmentation(),
							ResourceBundle.getBundle("org.tip.puckgui.messages"));

					if (report.status() == 0) {
						//
						String title = "Control special features report";
						String message = "No special features found.";

						//
						JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);
					} else {
						MainWindow.this.netGUI.addReportTab(report);
					}
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmControlSameSex.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Control Same-Sex persons.
				try {
					Report report = ControlReporter.reportSameSexSpouses(MainWindow.this.netGUI.getSegmentation(),
							ResourceBundle.getBundle("org.tip.puckgui.messages"));

					if (report.status() == 0) {
						//
						String title = "Control special features report";
						String message = "No special features found.";

						//
						JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);
					} else {
						MainWindow.this.netGUI.addReportTab(report);
					}
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmControl.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Control special features.
				try {
					ControlInputWindow window = new ControlInputWindow(MainWindow.this.netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmAttributesStatistics = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAttributesStatistics.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmAttributesStatistics.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Attribute statistics.
				try {
					//
					Report report;
					if (MainWindow.this.netGUI.getSegmentation().isAtTheTop()) {
						report = StatisticsReporter.reportAttributeStatistics(MainWindow.this.netGUI.getNet());
					} else {
						report = StatisticsReporter.reportAttributeStatistics(MainWindow.this.netGUI.getSegmentation());
					}

					//
					MainWindow.this.netGUI.addReportTab(report);

				} catch (final Exception exception) {
					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnCorpus.add(mntmAttributesStatistics);

		JMenuItem mntmSnowballStructure = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSnowballStructure.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmSnowballStructure.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Snowball structure.
				try {
					AttributeDescriptors attributeDescriptors = AttributeWorker.getExogenousAttributeDescriptors(
							MainWindow.this.netGUI.getCurrentIndividuals(), null);

					//
					SnowballCriteria criteria = SnowballStructureInputDialog.showDialog(attributeDescriptors);

					//
					if (criteria != null) {
						//
						logger.debug("criteria=" + criteria.toString());

						//
						Report report = NetReporter.reportSteps(MainWindow.this.netGUI.getSegmentation(), criteria);

						//
						MainWindow.this.netGUI.addReportTab(report);
					}

				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmAttributeValueStatistics = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAttributeValueStatistics.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmAttributeValueStatistics.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				//
				// Attribute value statistics.
				try {
					//
					Report report;
					if (MainWindow.this.netGUI.getSegmentation().isAtTheTop()) {
						report = StatisticsReporter.reportAttributeValueStatistics(MainWindow.this.netGUI.getNet());
					} else {
						report = StatisticsReporter.reportAttributeValueStatistics(MainWindow.this.netGUI.getSegmentation());
					}

					//
					MainWindow.this.netGUI.addReportTab(report);

				} catch (final Exception exception) {
					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}

			}
		});
		mnCorpus.add(mntmAttributeValueStatistics);
		mnCorpus.add(mntmSnowballStructure);

		JSeparator separator_6 = new JSeparator();
		mnCorpus.add(separator_6);

		JMenu mnTransform = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnTransform.text")); //$NON-NLS-1$ //$NON-NLS-2$
		menuBar.add(mnTransform);

		JMenuItem mntmAnonymizeByGender = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAnonymizeByGender.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmAnonymizeByGender.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Copy and anonymize BGI.
				try {
					//
					Net newNet = new Net(MainWindow.this.netGUI.getNet());
					Individuals currentIndividuals = newNet.individuals().getByIds(MainWindow.this.netGUI.getCurrentIndividuals().getIds());

					//
					AttributeWorker.anonymizeByGenderAndId(currentIndividuals);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
					newNetGui.setChanged(true, "-anonymized");
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmAnonymizeByFirst = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAnonymizeByFirst.text_1")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmAnonymizeByFirst.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Copy and anonymize BFN.
				try {
					//
					Net targetNet = new Net(MainWindow.this.netGUI.getNet());
					Individuals currentIndividuals = targetNet.individuals().getByIds(MainWindow.this.netGUI.getCurrentIndividuals().getIds());

					//
					AttributeWorker.anonymizeByFirstName(currentIndividuals);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), targetNet);
					newNetGui.setChanged(true, "-anonymized");
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmAnonymizeByLast = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAnonymizeByLast.text_1")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmAnonymizeByLast.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Copy and anonymize BFN.
				try {
					//
					Net newNet = new Net(MainWindow.this.netGUI.getNet());
					Individuals currentIndividuals = newNet.individuals().getByIds(MainWindow.this.netGUI.getCurrentIndividuals().getIds());

					//
					AttributeWorker.anonymizeByLastName(currentIndividuals);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
					newNetGui.setChanged(true, "-anonymized");
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmToModel = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmToModel.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmToModel.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				try {
					RelationModel model = RelationModelMaker.create(MainWindow.this.netGUI.getNet());
					MainWindow.this.netGUI.addRelationTab(model);
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnTransform.add(mntmToModel);

		JSeparator separator_20 = new JSeparator();
		mnTransform.add(separator_20);

		JMenuItem mntmDuplicate = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmDuplicate.text"));
		mnTransform.add(mntmDuplicate);
		mntmDuplicate.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_D, InputEvent.CTRL_MASK));
		mntmDuplicate.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Duplicate Corpus.
				try {
					//
					PuckGUI.instance().duplicate(MainWindow.this.netGUI);

				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnTransform.add(mntmAnonymizeByFirst);
		mnTransform.add(mntmAnonymizeByLast);
		mnTransform.add(mntmAnonymizeByGender);

		JMenuItem mntmNumberNames_1 = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmNumberNames_1.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmNumberNames_1.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Copy and number names.
				try {
					//
					Net targetNet = MainWindow.this.netGUI.getNet();
					Individuals currentIndividuals = targetNet.individuals().getByIds(MainWindow.this.netGUI.getCurrentIndividuals().getIds());

					//
					NetUtils.numberNames(currentIndividuals);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), targetNet);
					newNetGui.setChanged(true, "-names_numbered");
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnTransform.add(mntmNumberNames_1);

		JMenuItem mntmNamesToAttributes = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmNamesToAttributes.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmNamesToAttributes.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Names to attributes.
				try {
					//
					Net targetNet = MainWindow.this.netGUI.getNet();
					Individuals currentIndividuals = targetNet.individuals().getByIds(MainWindow.this.netGUI.getCurrentIndividuals().getIds());

					//
					NetUtils.namesToAttributes(currentIndividuals);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), targetNet);
					newNetGui.setChanged(true, "-names_as_attributes");
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnTransform.add(mntmNamesToAttributes);

		JSeparator separator_18 = new JSeparator();
		mnTransform.add(separator_18);

		JMenuItem mntmRenameExogenousAttribute = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRenameExogenousAttribute.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmRenameExogenousAttribute.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Rename attribute.
				try {
					//
					List<String> relationModelNames = MainWindow.this.netGUI.getNet().relationModels().sortedNameList();
					AttributeDescriptors attributeDescriptors = AttributeWorker.getExogenousAttributeDescriptors(MainWindow.this.netGUI.getNet(),
							MainWindow.this.netGUI.getSegmentation(), null);
					AttributeRenameCriteria criteria = AttributeRenameInputDialog.showDialog(relationModelNames, attributeDescriptors);

					//
					if (criteria != null) {
						//
						Net newNet = new Net(MainWindow.this.netGUI.getNet());

						//
						Segmentation newSegmentation = new Segmentation(newNet, MainWindow.this.netGUI.getSegmentation());

						//
						long count = AttributeWorker.renameAttribute(newNet, newSegmentation, criteria);

						//
						String title = "Attribute Rename Count";
						String message = "Number of attribute touched: " + count;
						JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);

						//
						if (count > 0) {
							//
							newSegmentation.refresh();
							NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet, newSegmentation);
							newNetGui.setChanged(true, "-attributeRename");
						}
					}
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}

			}
		});
		mnTransform.add(mntmRenameExogenousAttribute);

		JMenuItem mntmValuateExogeneousAttribute = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmValuateExogeneousAttribute.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmValuateExogeneousAttribute.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Valuate Exogeneous Attribute.
				try {
					//
					ValuateExogenousAttributeCriteria criteria = ValuateExogenousAttributeDialog.showDialog();

					//
					if (criteria != null) {
						//
						Net newNet = new Net(MainWindow.this.netGUI.getNet());

						//
						int count = AttributeWorker.valuateExogenousAttribute(newNet.individuals(), criteria.getSourceLabel(), criteria.getTargetLabel(),
								criteria.getValuePrefix());

						//
						String title = "Valuate Exogenous Attribute Count";
						String message = "Number of attribute touched: " + count;
						JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);

						//
						if (count > 0) {
							NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
							newNetGui.setChanged(true, "-attributeValuated");
						}
					}
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmFilterAttribute = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmFilterAttribute.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmFilterAttribute.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Filter attribute.
				try {
					//
					List<String> relationModelNames = MainWindow.this.netGUI.getNet().relationModels().sortedNameList();
					AttributeDescriptors attributeDescriptors = AttributeWorker.getExogenousAttributeDescriptors(MainWindow.this.netGUI.getNet(),
							MainWindow.this.netGUI.getSegmentation(), null);
					AttributeFilter filter = AttributeFilterInputDialog.showDialog(relationModelNames, attributeDescriptors);

					//
					if (filter != null) {
						//
						Net newNet = new Net(MainWindow.this.netGUI.getNet());

						//
						Segmentation newSegmentation = new Segmentation(newNet, MainWindow.this.netGUI.getSegmentation());

						//
						long count = AttributeWorker.filter(newNet, newSegmentation, filter);

						//
						String title = "Filter Attribute Count";
						String message = "Number of attribute touched: " + count;
						JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);

						//
						if (count > 0) {
							NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet, newSegmentation);
							newNetGui.setChanged(true, "-attributeFilter");

						}
					}
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnTransform.add(mntmFilterAttribute);

		JMenuItem mntmReplaceAttributeValue = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmReplaceAttributeValue.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmReplaceAttributeValue.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Replace attribute value.
				try {
					//
					List<String> relationModelNames = MainWindow.this.netGUI.getNet().relationModels().sortedNameList();
					AttributeDescriptors attributeDescriptors = AttributeWorker.getExogenousAttributeDescriptors(MainWindow.this.netGUI.getNet(),
							MainWindow.this.netGUI.getSegmentation(), null);
					AttributeReplaceValueCriteria criteria = AttributeReplaceValueInputDialog.showDialog(relationModelNames, attributeDescriptors);

					//
					if (criteria != null) {
						//
						Net newNet = new Net(MainWindow.this.netGUI.getNet());

						//
						Segmentation newSegmentation = new Segmentation(newNet, MainWindow.this.netGUI.getSegmentation());

						//
						long count = AttributeWorker.replaceAttributeValue(newNet, newSegmentation, criteria);

						//
						String title = "Attribute Replace Count";
						String message = "Number of attribute touched: " + count;
						JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);

						//
						if (count > 0) {
							//
							newSegmentation.refresh();
							NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet, newSegmentation);
							newNetGui.setChanged(true, "-attributeReplace");
						}
					}
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmSetAttributeValue = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSetAttributeValue.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmSetAttributeValue.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Set attribute value.
				try {
					//
					List<String> relationModelNames = MainWindow.this.netGUI.getNet().relationModels().sortedNameList();
					AttributeDescriptors attributeDescriptors = AttributeWorker.getExogenousAttributeDescriptors(MainWindow.this.netGUI.getNet(),
							MainWindow.this.netGUI.getSegmentation(), null);
					AttributeSetValueCriteria criteria = AttributeSetValueInputDialog.showDialog(relationModelNames, attributeDescriptors);

					//
					if (criteria != null) {
						//
						Net newNet = new Net(MainWindow.this.netGUI.getNet());

						//
						Segmentation newSegmentation = new Segmentation(newNet, MainWindow.this.netGUI.getSegmentation());

						//
						long count = AttributeWorker.setAttributeValue(newNet, newSegmentation, criteria);

						//
						String title = "Attribute Set Count";
						String message = "Number of attribute touched: " + count;
						JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);

						//
						if (count > 0) {
							//
							newSegmentation.refresh();
							NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet, newSegmentation);
							newNetGui.setChanged(true, "-attributeSet");
						}
					}
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnTransform.add(mntmSetAttributeValue);
		mnTransform.add(mntmReplaceAttributeValue);
		mnTransform.add(mntmValuateExogeneousAttribute);

		JMenuItem mntmRemoveAllAttributes = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRemoveAllAttributes.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmRemoveAllAttributes.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Remove All Attributes.
				try {
					//
					AttributeRemoveAllInputDialog.Criteria criteria = AttributeRemoveAllInputDialog.showDialog();

					//
					if (criteria != null) {
						//
						Net newNet = new Net(MainWindow.this.netGUI.getNet());

						//
						Segmentation newSegmentation = new Segmentation(newNet, MainWindow.this.netGUI.getSegmentation());

						//
						long count;
						if (criteria == AttributeRemoveAllInputDialog.Criteria.CORPUS_INCLUDED) {
							//
							count = AttributeWorker.removeAllAttributes(newNet);

						} else {
							//
							count = AttributeWorker.removeAllAttributesExceptCorpus(newNet);
						}

						//
						String title = "Attribute Remove Count";
						String message = "Number of removed attributes: " + count;
						JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);

						//
						if (count > 0) {
							//
							newSegmentation.refresh();
							NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet, newSegmentation);
							newNetGui.setChanged(true, "-attributeRemoved");
						}
					}
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}

			}
		});
		mnTransform.add(mntmRemoveAllAttributes);

		JMenuItem mntmTransmitAttributeValues = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmTransmitAttributeValues.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmTransmitAttributeValues.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Transmit attribute values.
				try {
					//
					List<String> labels = IndividualValuator.getAttributeLabels(MainWindow.this.netGUI.getSegmentation().getCurrentIndividuals());

					//
					TransmitAttributeValueCriteria criteria = TransmitAttributeValueInputDialog.showDialog(labels);

					//
					if (criteria != null) {
						//
						Net newNet = new Net(MainWindow.this.netGUI.getNet());

						//
						Segmentation newSegmentation = new Segmentation(newNet, MainWindow.this.netGUI.getSegmentation());

						//
						int count = NetUtils.transmitAttributeValue(newSegmentation.getCurrentIndividuals(), criteria);

						//
						String title = "Transmit Attribute Value Count";
						String message = "Number of attribute transmitted: " + count;
						JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);

						//
						if (count > 0) {
							newSegmentation.refresh();
							NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet, newSegmentation);
							newNetGui.setChanged(true, "-transmittedAttributeValue");
						}
					}

				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnTransform.add(mntmTransmitAttributeValues);

		JSeparator separator_19 = new JSeparator();
		mnTransform.add(separator_19);

		JMenuItem mntmMarryCoparents = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmMarryCoparents.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmMarryCoparents.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Copy without marked double individuals.
				try {
					//
					Net newNet = new Net(MainWindow.this.netGUI.getNet());

					//
					int count = NetUtils.marryCoparents(newNet);

					//
					String title = "Marry co-parents Result";
					String message = "Number of unmarried co-parents married: " + count;
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
					newNetGui.setChanged(true, "-married");
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnTransform.add(mntmMarryCoparents);

		JMenuItem mntmRenumber = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRenumber.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnTransform.add(mntmRenumber);
		mntmRenumber.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Renumberate individual ids.
				try {
					//
					NetUtils.renumberIndividuals(MainWindow.this.netGUI.getNet());

					//
					MainWindow.this.netGUI.setChanged(true, "renumbered");

					// Refresh.
					MainWindow.this.netGUI.updateAll();

				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmRenumber.setEnabled(true);

		JMenuItem mntmRenumberIdsFrom = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRenumberIdsFrom.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmRenumberIdsFrom.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Renumber from ID.
				try {
					//
					int count = NetUtils.renumberFromAttribute(MainWindow.this.netGUI.getNet(), "ID");

					//
					String title = "Renumber ids from ID Result";
					String message = "Number of individuals renumbered: " + count;
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);

					//
					if (count > 0) {
						//
						MainWindow.this.netGUI.setChanged(true, "renumbered");

						// Refresh.
						MainWindow.this.netGUI.updateAll();
					}

				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmRenumberFamilyIds = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRenumberFamilyIds.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmRenumberFamilyIds.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Re-number family ids.
				try {
					//
					NetUtils.renumberFamilies(MainWindow.this.netGUI.getNet());

					//
					MainWindow.this.netGUI.setChanged(true, "renumbered");

					// Refresh.
					MainWindow.this.netGUI.updateAll();

				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmRenumberFamilyIds.setEnabled(true);
		mnTransform.add(mntmRenumberFamilyIds);
		mnTransform.add(mntmRenumberIdsFrom);

		JMenuItem mntmFamiliesAsRelations = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAddEditableFamilies.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmFamiliesAsRelations.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {

				//
				try {
					//
					RelationModel model = NetUtils.createRelationsFromFamilies(MainWindow.this.netGUI.getNet());

					//
					MainWindow.this.netGUI.setChanged(true);

					//
					MainWindow.this.netGUI.addRelationTab(model);

					// Refresh.
					MainWindow.this.netGUI.updateAll();

				} catch (final PuckException exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		
				JMenuItem mntmRenumberIdsFrom_1 = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRenumberIdsFrom_1.text")); //$NON-NLS-1$ //$NON-NLS-2$
				mntmRenumberIdsFrom_1.addActionListener(new ActionListener() {
					@Override
					public void actionPerformed(final ActionEvent event) {
						// Renumber from REFN.
						try {
							//
							int count = NetUtils.renumberFromAttribute(MainWindow.this.netGUI.getNet(), "REFN");

							//
							String title = "Renumber ids from REFN Result";
							String message = "Number of individuals renumbered: " + count;
							JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);

							//
							if (count > 0) {
								//
								MainWindow.this.netGUI.setChanged(true, "re-numbered");

								// Refresh.
								MainWindow.this.netGUI.updateAll();
							}

						} catch (final Exception exception) {

							// Show trace.
							exception.printStackTrace();

							//
							String title = "Error computerum est";
							String message = "Error occured during working: " + exception.getMessage();

							//
							JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
						}
					}
				});
				mnTransform.add(mntmRenumberIdsFrom_1);
		
		JSeparator separator_21 = new JSeparator();
		mnTransform.add(separator_21);
		mnTransform.add(mntmFamiliesAsRelations);

		JMenuItem mntmEnlargeFromAttributes = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmEnlargeFromAttributes.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmEnlargeFromAttributes.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {

				// Interface is missing - labels taken for Xuetas dataset
				
				Map<String, String> husbandLabels = new HashMap<String, String>();
				husbandLabels.put("HUSB_prepar", "prepar");
				husbandLabels.put("HUSB_nompar", "nompar");
				husbandLabels.put("HUSB_premar", "premar");
				husbandLabels.put("HUSB_nommar", "nommar");
				Map<String, String> wifeLabels = new HashMap<String, String>();
				wifeLabels.put("WIFE_prepar", "prepar");
				wifeLabels.put("WIFE_nompar", "nompar");
				wifeLabels.put("WIFE_premar", "premar");
				wifeLabels.put("WIFE_nommar", "nommar");

				try {
					NetUtils.enlargeNetFromAttributes(MainWindow.this.netGUI.getNet(), "prepar", "nompar", "premar", "nommar", "HUSB_prenom", "HUSB_nomnom",
							"WIFE_prenom", "WIFE_nomnom", husbandLabels, wifeLabels, 
							"avipap","avipan","aviapp","aviapn","avimap","aviman","aviamp","aviamn");
				} catch (PuckException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
	
				MainWindow.this.netGUI.setChanged(true);
				// Refresh.
				MainWindow.this.netGUI.updateAll();

			}
		});

		JMenuItem mntmAddLifeEvents = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAddLifeEvents.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmAddLifeEvents.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				//
				try {
					//
					RelationModel model = NetUtils.createLifeEvents(MainWindow.this.netGUI.getNet());

					//
					MainWindow.this.netGUI.setChanged(true);

					//
					MainWindow.this.netGUI.addRelationTab(model);

					// Refresh.
					MainWindow.this.netGUI.updateAll();

				} catch (final PuckException exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmFamiliesFromRelations = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmFamiliesFromRelations.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmFamiliesFromRelations.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				//
				try {

					// Entry mask needed

					String relationLabel = "HOUSEHOLD";
					Map<String, String> labels = new HashMap<String, String>();
					labels.put("husband", "chef");
					labels.put("wife", "femme");
					labels.put("son", "fils");
					labels.put("daughter", "fille");
					labels.put("otherSon", "fils d'autre part");
					labels.put("otherDaughter", "fille d'autre part");
					labels.put("otherWife", "femme d'autre part");
					labels.put("naturalSon", "fils naturel");
					labels.put("naturalDaughter", "fille naturelle");
					labels.put("brother", "fr�re");
					labels.put("sister", "s�ur");
					labels.put("husbandMother", "m�re");

					//
					NetUtils.createFamiliesFromRelations(MainWindow.this.netGUI.getNet(), relationLabel, labels);

					//
					MainWindow.this.netGUI.setChanged(true);

					// Refresh.
					MainWindow.this.netGUI.updateAll();

				} catch (final PuckException exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnTransform.add(mntmFamiliesFromRelations);
		mnTransform.add(mntmAddLifeEvents);

		JMenuItem mntmRelationsFromAttributes = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRelationsFromAttributes.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmRelationsFromAttributes.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				//
				try {

					// Entry mask needed

					String relationLabel = "HOUSEHOLD";
					String roleLabel = "ROLE";

					//
					RelationModel model = NetUtils.createRelationsFromAttributes(MainWindow.this.netGUI.getNet(), relationLabel, roleLabel);

					//
					MainWindow.this.netGUI.setChanged(true);

					//
					MainWindow.this.netGUI.addRelationTab(model);

					// Refresh.
					MainWindow.this.netGUI.updateAll();

				} catch (final PuckException exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnTransform.add(mntmRelationsFromAttributes);
		mnTransform.add(mntmEnlargeFromAttributes);

		JSeparator separator_11 = new JSeparator();
		mnTransform.add(separator_11);

		JMenu mnReduce = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnReduce.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnTransform.add(mnReduce);

		JMenuItem mntmCuttingTails = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCopyCuttingTails.text_1")); //$NON-NLS-1$ //$NON-NLS-2$
		mnReduce.add(mntmCuttingTails);

		JMenuItem mntmCopyWithoutMarked = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCopyWithoutMarked.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnReduce.add(mntmCopyWithoutMarked);

		JMenuItem mntmCopyWithoutStruct = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCopyWithoutStruct.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnReduce.add(mntmCopyWithoutStruct);

		JMenuItem mntmEliminateSingles = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmEliminateSingles.text"));
		mnReduce.add(mntmEliminateSingles);

		JMenuItem mntmCopyWithoutVirtuals = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCopyWithoutVirtuals.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnReduce.add(mntmCopyWithoutVirtuals);
		mntmCopyWithoutVirtuals.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Copy without virtual individuals.
				try {
					//
					Net newNet = MainWindow.this.netGUI.getNet();
					Individuals currentIndividuals = newNet.individuals().getByIds(MainWindow.this.netGUI.getCurrentIndividuals().getIds());

					//
					int count = NetUtils.eliminateVirtuals(newNet, currentIndividuals);

					//
					String title = "Eliminate Virtuals Individuals Result";
					String message = "Number of individuals removed: " + count;
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
					newNetGui.setChanged(true, "-wo_virtuals");
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmEliminateSingles.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Eliminate unmarried.
				try {
					//
					Chronometer chrono = new Chronometer();

					//
					Net newNet = MainWindow.this.netGUI.getNet();
					Individuals currentIndividuals = newNet.individuals().getByIds(MainWindow.this.netGUI.getCurrentIndividuals().getIds());

					//
					int previousIndividualCount = newNet.individuals().size();
					int count = NetUtils.eliminateSingles(newNet, currentIndividuals);

					//
					String title = "Eliminate Unmarried Result";
					String message = String.format("Eliminated singles: %d\nPrevious count: %d\nUpdated count: %d\nTime spent: %d ms", count,
							previousIndividualCount, MainWindow.this.netGUI.getNet().individuals().size(), chrono.stop().interval());
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
					newNetGui.setChanged(true, "-no-singles");
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmCopyWithoutStruct.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Eliminate Structural children.
				try {
					//
					Net newNet = MainWindow.this.netGUI.getNet();
					Individuals currentIndividuals = newNet.individuals().getByIds(MainWindow.this.netGUI.getCurrentIndividuals().getIds());

					//
					int count = NetUtils.eliminateStructuralChildren(newNet, currentIndividuals);

					//
					String title = "Eliminate Structural Children Result";
					String message = "Number of individuals removed: " + count;
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);

					//
					NetGUI newNetGUI = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
					newNetGUI.setChanged(true, "-adults");
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmCopyWithoutMarked.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Copy without marked double individuals.
				try {
					//
					Net newNet = new Net(MainWindow.this.netGUI.getNet());
					Individuals currentIndividuals = newNet.individuals().getByIds(MainWindow.this.netGUI.getCurrentIndividuals().getIds());
					Relations currentRelations = newNet.relations().getByIds(MainWindow.this.netGUI.getCurrentRelations().getIds());
					Report report = new Report("Consolidation report");
					
					//
					NetUtils.eliminateDoubleIndividuals(newNet, currentIndividuals,report);
					report.outputs().appendln();
					NetUtils.eliminateDoubleRelations(newNet, currentRelations,report);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
					newNetGui.setChanged(true, "-univocal");
					if (report.outputs().isNotEmpty()){
						newNetGui.addReportTab(report);
					}
					
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmCuttingTails.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Copy cutting tails.
				try {
					Net newNet = new Net(MainWindow.this.netGUI.getNet());
					int count = HairCutWorker.shave(newNet);

					//
					String title = "Haircut Result";
					String message = "Number of individuals eliminated: " + count;
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
					newNetGui.setChanged(true, "-shaved");
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenu mnExtract = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnExtract.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnTransform.add(mnExtract);

		JMenuItem mntmExtractCurrentSegment = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmExtractCurrentSegment.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnExtract.add(mntmExtractCurrentSegment);
		mntmExtractCurrentSegment.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Extract current segment.
				try {
					//
					Segment segment = MainWindow.this.netGUI.getSegmentation().getCurrentSegment();
					String segmentLabels = MainWindow.this.netGUI.getSegmentation().getSegmentLabels().toStringSeparatedBy("; ");
					Net newNet = NetUtils.extract(MainWindow.this.netGUI.getNet(), segment, segmentLabels);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
					newNetGui.setChanged(true, " " + MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out"));

				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmCurrentCluster = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCurrentCluster.text_1")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmCurrentCluster.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Extract current cluster.
				try {
					//
					Net newNet = NetUtils.extractCurrentCluster(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation());

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
					newNetGui.setChanged(true, " " + MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out"));

				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmCurrentCluster.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_E, InputEvent.CTRL_MASK));
		mnExtract.add(mntmCurrentCluster);

		JMenuItem mntmExtractCore = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmExtractCore.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnExtract.add(mntmExtractCore);

		JMenuItem mntmKernel = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmKernel.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnExtract.add(mntmKernel);

		JMenuItem mntmMaximalBicomponent = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmMaximalBicomponent.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnExtract.add(mntmMaximalBicomponent);
		mntmMaximalBicomponent.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Extract Maximal Bicomponent.
				try {
					Net target = BicomponentWorker.getMaximalBicomponent(MainWindow.this.netGUI.getNet());

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), target);
					newNetGui.setChanged(true, "-maxBicomponent");
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmExtractLargeClusters = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmExtractLargeClusters.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnExtract.add(mntmExtractLargeClusters);

		JMenuItem mntmExtractPositiveCluster = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmExtractPositiveCluster.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnExtract.add(mntmExtractPositiveCluster);
		mntmExtractPositiveCluster.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Extract positive cluster values.
				try {
					ClusterValueExtractionInputWindow window = new ClusterValueExtractionInputWindow(MainWindow.this.netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);

				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmExtractLargeClusters.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Extract large clusters.
				try {
					ClusterSizeExtractionInputWindow window = new ClusterSizeExtractionInputWindow(MainWindow.this.netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmKernel.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Extract Kernel.
				try {
					Net target = BicomponentWorker.getKernel(MainWindow.this.netGUI.getNet());

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), target);
					newNetGui.setChanged(true, "-kernel");
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmExtractCore.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Extract Core
				try {
					Net target = BicomponentWorker.getCore(MainWindow.this.netGUI.getNet());

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), target);
					newNetGui.setChanged(true, "-core");
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JSeparator separator_17 = new JSeparator();
		mnTransform.add(separator_17);

		JMenuItem mntmShufflePgraph = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmShufflePgraph.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmShufflePgraph.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Shuffle P-Graph.
				try {
					//
					ReshufflingNetworkInputWindow window = new ReshufflingNetworkInputWindow(MainWindow.this.netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenu mnNewMenu = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnNewMenu.text_2")); //$NON-NLS-1$ //$NON-NLS-2$
		mnTransform.add(mnNewMenu);

		JMenuItem mntmUniversal = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmUniversal.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmUniversal.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Universal kinship cluster expansion
				try {
					//
					Net newNet = NetUtils.expand(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation().getCurrentIndividuals(),
							MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getLabel(), ExpansionMode.KIN, FiliationType.COGNATIC, 0);
					// Net newNet =
					// NetUtils.expandByKin(MainWindow.this.netGUI.getNet(),
					// MainWindow.this.netGUI.getSegmentation().getCurrentSegment(),
					// null);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
					newNetGui.setChanged(true, " " + MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out")
							+ "_expanded_ALL_KIN");
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmAllRelated = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAllRelated.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmAllRelated.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Universal relation cluster expansion
				try {
					//
					Net newNet = NetUtils.expand(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation().getCurrentIndividuals(),
							MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getLabel(), ExpansionMode.RELATED, null, 0);
					// Net newNet =
					// NetUtils.expandByRelations(MainWindow.this.netGUI.getNet(),
					// MainWindow.this.netGUI.getSegmentation().getCurrentSegment());

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
					newNetGui.setChanged(true, " " + MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out")
							+ "_expanded_RELATIONS");
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmUniversal_1 = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmUniversal_1.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmUniversal_1.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Universal cluster expansion
				try {
					//
					Net newNet = NetUtils.expand(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation().getCurrentIndividuals(),
							MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getLabel(), ExpansionMode.ALL, FiliationType.COGNATIC, 0);
					// Net newNet =
					// NetUtils.expand(MainWindow.this.netGUI.getNet(),
					// MainWindow.this.netGUI.getSegmentation().getCurrentSegment());

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
					newNetGui.setChanged(true, " " + MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out")
							+ "_expanded_ALL");
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmSpecialFeature = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSpecialFeature.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmSpecialFeature.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Expand.
				try {
					//
					ExpandCriteria criteria = ExpandInputDialog.showDialog();

					//
					if (criteria != null) {
						//
						Net newNet = NetUtils.expand(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation().getCurrentIndividuals(),
								MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getLabel(), criteria.getExpansionMode(),
								criteria.getFiliationType(), criteria.getMaxStep());

						//
						NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
						newNetGui.setChanged(true, " " + MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out")
								+ "_" + criteria.getSubTitle());
					}
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnNewMenu.add(mntmSpecialFeature);
		mnNewMenu.add(mntmUniversal_1);
		mnNewMenu.add(mntmAllRelated);
		mnNewMenu.add(mntmUniversal);

		JMenuItem mntmBottomup = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmBottomup.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmBottomup.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Ascending cluster expansion
				try {
					//
					Net newNet = NetUtils.expand(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation().getCurrentIndividuals(),
							MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getLabel(), ExpansionMode.PARENT, FiliationType.COGNATIC, 0);
					// Net newNet =
					// NetUtils.expandByKin(MainWindow.this.netGUI.getNet(),
					// MainWindow.this.netGUI.getSegmentation().getCurrentSegment(),KinType.PARENT);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
					newNetGui.setChanged(true, " " + MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out")
							+ "_expanded_UP");
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnNewMenu.add(mntmBottomup);

		JMenuItem mntmTopdown = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmTopdown.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmTopdown.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Descending cluster expansion
				try {
					//
					Net newNet = NetUtils.expand(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation().getCurrentIndividuals(),
							MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getLabel(), ExpansionMode.CHILD, FiliationType.COGNATIC, 0);
					// Net newNet =
					// NetUtils.expandByKin(MainWindow.this.netGUI.getNet(),
					// MainWindow.this.netGUI.getSegmentation().getCurrentSegment(),KinType.CHILD);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
					newNetGui.setChanged(true, " " + MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out")
							+ "_expanded_DOWN");
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmAscendingagnatic = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAscendingagnatic.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmAscendingagnatic.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Ascending (agnatic) cluster expansion
				try {
					//
					Net newNet = NetUtils.expand(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation().getCurrentIndividuals(),
							MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getLabel(), ExpansionMode.PARENT, FiliationType.AGNATIC, 0);
					// Net newNet =
					// NetUtils.expandByKin(MainWindow.this.netGUI.getNet(),
					// MainWindow.this.netGUI.getSegmentation().getCurrentSegment(),KinType.PARENT);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
					newNetGui.setChanged(true, " " + MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out")
							+ "_expanded_UP_A");
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnNewMenu.add(mntmAscendingagnatic);

		JMenuItem mntmAscendinguterine = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAscendinguterine.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmAscendinguterine.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Ascending (uterine) cluster expansion
				try {
					//
					Net newNet = NetUtils.expand(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation().getCurrentIndividuals(),
							MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getLabel(), ExpansionMode.PARENT, FiliationType.UTERINE, 0);
					// Net newNet =
					// NetUtils.expandByKin(MainWindow.this.netGUI.getNet(),
					// MainWindow.this.netGUI.getSegmentation().getCurrentSegment(),KinType.PARENT);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
					newNetGui.setChanged(true, " " + MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out")
							+ "_expanded_UP");
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnNewMenu.add(mntmAscendinguterine);
		mnNewMenu.add(mntmTopdown);

		JMenuItem mntmConjugal = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmConjugal.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmConjugal.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Horizontal cluster expansion
				try {
					//
					Net newNet = NetUtils.expand(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation().getCurrentIndividuals(),
							MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getLabel(), ExpansionMode.SPOUSE, FiliationType.COGNATIC, 0);
					// Net newNet =
					// NetUtils.expandByKin(MainWindow.this.netGUI.getNet(),
					// MainWindow.this.netGUI.getSegmentation().getCurrentSegment(),KinType.SPOUSE);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
					newNetGui.setChanged(true, " " + MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out")
							+ "_expanded_MARR");
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmDescendingagnatic = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmDescendingagnatic.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmDescendingagnatic.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Descending (agnatic) cluster expansion
				try {
					//
					Net newNet = NetUtils.expand(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation().getCurrentIndividuals(),
							MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getLabel(), ExpansionMode.CHILD, FiliationType.AGNATIC, 0);
					// Net newNet =
					// NetUtils.expandByKin(MainWindow.this.netGUI.getNet(),
					// MainWindow.this.netGUI.getSegmentation().getCurrentSegment(),KinType.CHILD);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
					newNetGui.setChanged(true, " " + MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out")
							+ "_expanded_DOWN_A");
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnNewMenu.add(mntmDescendingagnatic);

		JMenuItem mntmDescendinguterine = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmDescendinguterine.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmDescendinguterine.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Descending (uterine) cluster expansion
				try {
					//
					Net newNet = NetUtils.expand(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation().getCurrentIndividuals(),
							MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getLabel(), ExpansionMode.CHILD, FiliationType.UTERINE, 0);

					//
					NetGUI newNetGui = PuckGUI.instance().createNetGUI(MainWindow.this.netGUI.getFile(), newNet);
					newNetGui.setChanged(true, " " + MainWindow.this.netGUI.getSegmentation().getCurrentSegment().getShortShortLabel().replace("*", "out")
							+ "_expanded_DOWN_U");
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnNewMenu.add(mntmDescendinguterine);
		mnNewMenu.add(mntmConjugal);

		JSeparator separator_15 = new JSeparator();
		mnTransform.add(separator_15);

		JMenu mnShrink = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnShrink.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnTransform.add(mnShrink);

		JMenuItem mntmInterMarriageReport = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmIntermarriageReport.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnShrink.add(mntmInterMarriageReport);

		JMenuItem mntmFlowReport = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmFlowReport_1.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnShrink.add(mntmFlowReport);
		mntmFlowReport.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Flow report 2.
				try {
					FlowNetworkInputWindow window = new FlowNetworkInputWindow(MainWindow.this.netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmInterMarriageReport.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// InterMarriage Report2
				// Reduce Report*.
				try {
					AllianceNetworkInputWindow window = new AllianceNetworkInputWindow(MainWindow.this.netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JSeparator separator_16 = new JSeparator();
		mnTransform.add(separator_16);
		mnTransform.add(mntmShufflePgraph);

		JMenuItem mntmVirtualFieldwork = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmVirtualFieldwork.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmVirtualFieldwork.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				try {
					FieldworkInputWindow window = new FieldworkInputWindow(MainWindow.this.netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnTransform.add(mntmVirtualFieldwork);

		JMenuItem mntmVirtualFieldworkVariations = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmVirtualFieldworkVariations.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmVirtualFieldworkVariations.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				try {
					Report report = RandomNetReporter.reportVirtualFieldworkVariations(MainWindow.this.netGUI.getSegmentation());
					MainWindow.this.netGUI.addReportTab(report);
				} catch (PuckException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		});
		mnTransform.add(mntmVirtualFieldworkVariations);

		JMenu mnCensus = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnCensus.text")); //$NON-NLS-1$ //$NON-NLS-2$
		menuBar.add(mnCensus);

		JMenuItem mntmPedigree = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmPedigree.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmPedigree.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Pedigree.
				try {
					//
					Individual ego = MainWindow.this.netGUI.selectedIndividual();
					if (ego == null) {
						//
						String title = "Information";
						String message = "Please, select an individual on the list.";

						//
						JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
					} else {
						String parameter = JOptionPane.showInputDialog(null, "Maximal generational depth: ", "Pedigree Report", JOptionPane.QUESTION_MESSAGE);

						logger.debug("parameter=[" + parameter + "]");
						if (parameter != null) {
							int maxDepth = Integer.parseInt(parameter);

							Report report = CensusReporter.reportPedigree(MainWindow.this.netGUI.getNet().getLabel(), ego, maxDepth);

							MainWindow.this.netGUI.addReportTab(report);
						}
					}
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnCensus.add(mntmPedigree);

		JMenuItem mntmRelatives = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRelatives.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmRelatives.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Relatives
				try {
					//
					Individual ego = MainWindow.this.netGUI.selectedIndividual();
					if (ego == null) {
						//
						String title = "Information";
						String message = "Please, select an individual on the list.";

						//
						JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
					} else {
						String parameter = JOptionPane.showInputDialog(null, "Enter kinship string (in positional notation): ", "Chains Report",
								JOptionPane.QUESTION_MESSAGE);
						logger.debug("parameter=[" + parameter + "]");

						Report report = CensusReporter.reportRelatives(MainWindow.this.netGUI.getNet().getLabel(), ego, parameter);

						MainWindow.this.netGUI.addReportTab(report);
					}
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmProgeniture = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmProgeniture.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmProgeniture.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Progeniture.
				try {
					//
					Individual ego = MainWindow.this.netGUI.selectedIndividual();
					if (ego == null) {
						//
						String title = "Information";
						String message = "Please, select an individual on the list.";

						//
						JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
					} else {
						String parameter = JOptionPane
								.showInputDialog(null, "Maximal generational depth: ", "Progeniture Report", JOptionPane.QUESTION_MESSAGE);

						logger.debug("parameter=[" + parameter + "]");
						if (parameter != null) {
							int maxDepth = Integer.parseInt(parameter);

							Report report = CensusReporter.reportProgeniture(MainWindow.this.netGUI.getNet().getLabel(), ego, maxDepth);

							MainWindow.this.netGUI.addReportTab(report);
						}
					}
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnCensus.add(mntmProgeniture);
		mnCensus.add(mntmRelatives);

		JMenuItem mntmKinshipChains = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmKinshipChains.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmKinshipChains.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Linking Chains
				try {
					Individual ego = MainWindow.this.netGUI.selectedIndividual();
					if (ego == null) {
						//
						String title = "Information";
						String message = "Please, select an individual on the list.";

						//
						JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
					} else {
						//
						KinshipChainsCriteria criteria = KinshipChainsInputDialog.showDialog();

						//
						if (criteria != null) {
							Individual alter = MainWindow.this.netGUI.getNet().get(criteria.getAlterId());

							Report report = CensusReporter.reportKinshipChains(MainWindow.this.netGUI.getNet().getLabel(), ego, alter,
									criteria.getMaximalDepth(), criteria.getMaximalOrder(), criteria.getChainClassification());

							MainWindow.this.netGUI.addReportTab(report);
						}
					}
				} catch (final Exception exception) {

					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}

			}
		});
		mnCensus.add(mntmKinshipChains);

		JMenuItem mntmFindCircuit2 = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmFindCircuit2.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmFindCircuit2.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_H, InputEvent.CTRL_MASK));
		mntmFindCircuit2.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Find Circuit Report*.
				try {
					CensusInputWindow window = new CensusInputWindow(MainWindow.this.netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmDistances = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmDistances.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmDistances.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Generate distance attribute.
				try {
					//
					DistanceAttributeCriteria criteria = DistanceAttributeInputDialog.showDialog();

					//
					if (criteria != null) {
						//
						Individual ego = MainWindow.this.netGUI.selectedIndividual();

						if (ego == null) {
							//
							throw new IllegalArgumentException("Please, select an individual in tab.");

						} else {
							//
							StatisticsWorker.getDistances(ego, criteria.getMaxDistance(), criteria.getFiliationType());

							//
							MainWindow.this.netGUI.updateAll();
						}
					}
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnCensus.add(mntmDistances);

		JSeparator separator_13 = new JSeparator();
		mnCensus.add(separator_13);

		JMenuItem mntmBasicInformation = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmBasicInformation.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnCensus.add(mntmBasicInformation);
		mntmBasicInformation.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_B, InputEvent.CTRL_MASK));
		mntmBasicInformation.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Statistics.
				try {
					Chronometer chrono = new Chronometer();
					Report report = StatisticsReporter.reportBasicInformation(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation());
					chrono.stop();
					logger.info(String.format("Time spent: %d ms", chrono.interval()));
					MainWindow.this.netGUI.addReportTab(report);
				} catch (final PuckException exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmBasicGraphs = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmBasicGraphs.text"));
		mnCensus.add(mntmBasicGraphs);
		mntmBasicGraphs.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Statistics.
				try {
					StatisticsInputWindow window = new StatisticsInputWindow(MainWindow.this.netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmBasicGraphs.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_G, InputEvent.CTRL_MASK));

		JMenuItem mntmPartitionStatistics = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmPartitionStatistics.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmPartitionStatistics.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Partition Statistics.
				try {
					PartitionStatisticsInputWindow window = new PartitionStatisticsInputWindow(MainWindow.this.netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnCensus.add(mntmPartitionStatistics);

		JSeparator separator_14 = new JSeparator();
		mnCensus.add(separator_14);
		mnCensus.add(mntmFindCircuit2);

		JMenuItem mntmDifferentialCensus = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmDifferentialCensus.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmDifferentialCensus.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Find Circuit Report*.
				try {
					DifferentialCensusInputWindow window = new DifferentialCensusInputWindow(MainWindow.this.netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnCensus.add(mntmDifferentialCensus);

		JSeparator separator_12 = new JSeparator();
		mnCensus.add(separator_12);

		JMenuItem mntmSynopsis = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSynopsis.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmSynopsis.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {

				File file = selectFolder(MainWindow.this.frmPuck, MainWindow.this.netGUI.getFile().getParentFile());

				//
				if (file != null) {
					//
					/*
					 * String pathname =
					 * "C:\\Documents and Settings\\Klaus Hamberger\\Mes Documents\\Testcorpus"
					 * ;
					 */
					String directory = file.getAbsolutePath();
					Report report = StatisticsReporter.reportSynopsis(directory);
					MainWindow.this.netGUI.addReportTab(report);
				}

			}
		});
		mnCensus.add(mntmSynopsis);

		JMenu mnTerms = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnTerms.text")); //$NON-NLS-1$ //$NON-NLS-2$
		menuBar.add(mnTerms);

		JMenuItem mntmListChains = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListChains.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmListChains.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				try {
					Report report = CensusReporter.reportKinshipChainsForTerms(MainWindow.this.netGUI.getSegmentation());
					MainWindow.this.netGUI.addReportTab(report);
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenuItem mntmListWithTypes = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmListWithTypes.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmListWithTypes.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				try {
					Report report = StatisticsReporter.reportTerms(MainWindow.this.netGUI.getSegmentation());
					MainWindow.this.netGUI.addReportTab(report);
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnTerms.add(mntmListWithTypes);
		mnTerms.add(mntmListChains);

		JMenuItem mntmReciprocals = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmReciprocals.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmReciprocals.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				try {
					Report report = CensusReporter.reportReciprocalTerms(MainWindow.this.netGUI.getSegmentation());
					MainWindow.this.netGUI.addReportTab(report);
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnTerms.add(mntmReciprocals);

		JMenuItem mntmProducts = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmProducts.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmProducts.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				try {
					Report report = CensusReporter.reportTermProducts(MainWindow.this.netGUI.getSegmentation());
					MainWindow.this.netGUI.addReportTab(report);
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnTerms.add(mntmProducts);

		JMenuItem mntmTest = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmTest.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmTest.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				try {

					int maxDistance = 10;
					int maxIterations = 2;

					/*					String[] names = {"English","Deutsch","Watsi"};
										
										for (String name : names){
											RelationModel model = RelationModelMaker.create(name,Test.kinTerms(name));
											RelationMaker.applyModel(netGUI.getNet(), netGUI.getSegmentation(), model, maxDistance);

											netGUI.addRelationTab(model);
											
											Report report = new RelationModelReporter(model).reportStatisics();
											MainWindow.this.netGUI.addReportTab(report);

										}*/

					RelationModel model2 = RelationModelMaker.create(MainWindow.this.netGUI.getNet());
					Report report = new RelationModelReporter(model2).reportModel(maxIterations);
					MainWindow.this.netGUI.addReportTab(report);
					// RelationMaker.applyModel(netGUI.getNet(),
					// netGUI.getSegmentation(), model2, maxDistance);

					MainWindow.this.netGUI.addRelationTab(model2);

					//
					MainWindow.this.netGUI.setChanged(true);

					//
					MainWindow.this.netGUI.updateAll();

				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnTerms.add(mntmTest);

		JMenu mnRelations = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnRelations.text")); //$NON-NLS-1$ //$NON-NLS-2$
		menuBar.add(mnRelations);

		JMenuItem mntmAddModel = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAddModel.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmAddModel.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				try {
					RelationModelInputWindow window = new RelationModelInputWindow(MainWindow.this.netGUI, null);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnRelations.add(mntmAddModel);

		JMenuItem mntmImportModel = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmImportModel.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmImportModel.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				try {
					//
					File file = selectRelationModelFileToLoad(MainWindow.this.frmPuck, MainWindow.this.netGUI.getFile());

					//
					if (file != null) {
						//

						StringList list = RelationModelTXTFile.load(file, RelationModelTXTFile.DEFAULT_CHARSET_NAME);

						RelationModel model = RelationModelMaker.create(file.getName(), list);

						MainWindow.this.netGUI.addRelationTab(model);

						//
						MainWindow.this.netGUI.setChanged(true);

						//
						MainWindow.this.netGUI.updateAll();

					}
					/*				} catch (final PuckException exception) {
										exception.printStackTrace();

										//
										String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");

										//
										String message;
										switch (PuckExceptions.valueOf(exception.getCode())) {
											case FILE_NOT_FOUND:
												message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.fileNotFound");
											break;
											case BAD_FILE_FORMAT:
												message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.badFileFormat");
											break;
											case UNSUPPORTED_FILE_FORMAT:
												message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedFileFormat");
											break;
											case NOT_A_FILE:
												message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.notAFile");
											break;
											case UNSUPPORTED_ENCODING:
												message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedEncoding");
											break;
											default:
												message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");
										}

										//
										JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);*/
				} catch (final Exception exception) {
					exception.printStackTrace();

					//
					String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");

					String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnRelations.add(mntmImportModel);

		JMenuItem mntmFromGenealogy = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmFromGenealogy.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmFromGenealogy.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				try {
					RelationModel model = RelationModelMaker.create(MainWindow.this.netGUI.getNet());
					MainWindow.this.netGUI.addRelationTab(model);
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnRelations.add(mntmFromGenealogy);

		JMenu mnSequences = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnSequences.text"));
		menuBar.add(mnSequences);

		JMenu mnReports = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnReports.text_1")); //$NON-NLS-1$ //$NON-NLS-2$
		mnSequences.add(mnReports);

		JMenuItem mntmItineraries = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmItineraries.text_1")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmItineraries.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				try {

					SpaceTimeCriteria criteria = new SpaceTimeCriteria();
					Report report = SequenceReporter.reportSequences(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation(), criteria);
					MainWindow.this.netGUI.addReportTab(report);

				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnReports.add(mntmItineraries);

		JMenuItem mntmSliceReport = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSliceReport.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmSliceReport.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				try {

					SpaceTimeCriteria criteria = new SpaceTimeCriteria();
					criteria.setRelationModelName("RESIDENCE");
					// Report report =
					// SliceReporter.reportSlices(MainWindow.this.netGUI.getSegmentation(),
					// criteria);
					// MainWindow.this.netGUI.addReportTab(report);

				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnReports.add(mntmSliceReport);

		JMenu mnAnalysis = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnAnalysis.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnSequences.add(mnAnalysis);

		JMenu mnSequences_1 = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnSequences_1.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnAnalysis.add(mnSequences_1);

		JMenuItem mntmGeneralSequenceStatistics = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmGeneralSequenceStatistics.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmGeneralSequenceStatistics.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				try {
					Report report = SequenceReporter.reportSequenceCensus(MainWindow.this.netGUI.getSegmentation(), CensusType.GENERAL);
					MainWindow.this.netGUI.addReportTab(report);
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnSequences_1.add(mntmGeneralSequenceStatistics);

		JMenuItem mntmTrajectories = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmTrajectories.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmTrajectories.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				try {
					Report report = SequenceReporter.reportSequenceCensus(MainWindow.this.netGUI.getSegmentation(), CensusType.PARCOURS);
					MainWindow.this.netGUI.addReportTab(report);
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnSequences_1.add(mntmTrajectories);

		JMenuItem menuItem_3 = new JMenuItem("Ego-Networks");
		menuItem_3.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				try {

					Report report = SequenceReporter.reportSequenceCensus(MainWindow.this.netGUI.getSegmentation(), CensusType.EGONETWORKS);
					MainWindow.this.netGUI.addReportTab(report);

					/*					List<String> alterRoleNames = new ArrayList<String>();
										alterRoleNames.add("ALL");
										alterRoleNames.add("HOST");
										alterRoleNames.add("MIG");
										for (String alterRoleName : alterRoleNames) {
											Report report = SequenceReporter.reportEgoNetworks(MainWindow.this.netGUI.getSegmentation(), alterRoleName);
											MainWindow.this.netGUI.addReportTab(report);
										}*/

				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnSequences_1.add(menuItem_3);

		JMenuItem menuItem_4 = new JMenuItem("Parcours-Networks");
		menuItem_4.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				try {
					Report report = SequenceReporter.reportSequenceCensus(MainWindow.this.netGUI.getSegmentation(), CensusType.PARCOURSNETWORKS);
					MainWindow.this.netGUI.addReportTab(report);
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnSequences_1.add(menuItem_4);

		JMenu mnSlices = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnSlices.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnAnalysis.add(mnSlices);

		JMenuItem mntmGeneralSliceStatistics = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmGeneralSliceStatistics.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmGeneralSliceStatistics.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				StatisticsCriteria criteria = new StatisticsCriteria();
				SpaceTimeCriteria censusCriteria = new SpaceTimeCriteria(CensusType.PARCOURS);

				PartitionCriteria placeCriteria = PartitionCriteria.createRaw("BIRT_PLAC");
				placeCriteria.setLabelParameter("Afagnangbleta");

				criteria.getPartitionCriterias().add(placeCriteria);
				criteria.getPartitionCriterias().add(PartitionCriteria.createSizedGrouping("AGE", null, 0., 20., null));
				criteria.getPartitionCriterias().add(PartitionCriteria.createRaw("QUARTER"));
				criteria.getPartitionCriterias().add(PartitionCriteria.createRaw("PATRIL"));
				criteria.getPartitionCriterias().add(PartitionCriteria.createRaw("OCCU"));
				criteria.getPartitionCriterias().add(PartitionCriteria.createRaw("MATRISTATUS"));
				criteria.setPlaceParameter("DEPARTMENT");

				SpaceTimeCriteria sliceCriteria = new SpaceTimeCriteria();
				sliceCriteria.setRelationModelName("RESIDENCE");
				sliceCriteria.setLocalUnitLabel("HOUSE");

				String referentName = censusCriteria.getDefaultReferentRoleName();

				try {

					Relations relations = MainWindow.this.netGUI.getSegmentation().getAllRelations().getByModelName(sliceCriteria.getRelationModelName());
					for (Relation relation : relations) {
						relation.updateReferents(referentName);
					}

					Slices relationCensus = SliceMaker.createSlices(MainWindow.this.netGUI.getSegmentation(), sliceCriteria);

					Report report1 = SliceReporter.reportIndividualStatics(relationCensus, criteria);
					MainWindow.this.netGUI.addReportTab(report1);

					Report report2 = SliceReporter.reportIndividualDynamics(relationCensus, criteria);
					MainWindow.this.netGUI.addReportTab(report2);

				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnSlices.add(mntmGeneralSliceStatistics);

		JMenuItem mntmTrajectoriesgroups = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmTrajectoriesgroups.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmTrajectoriesgroups.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				StatisticsCriteria criteria = new StatisticsCriteria();
				SpaceTimeCriteria censusCriteria = new SpaceTimeCriteria(CensusType.PARCOURS);

				PartitionCriteria placeCriteria = PartitionCriteria.createRaw("BIRT_PLAC");
				placeCriteria.setLabelParameter("Afagnangbleta");

				criteria.getPartitionCriterias().add(placeCriteria);
				criteria.getPartitionCriterias().add(PartitionCriteria.createSizedGrouping("AGE", null, 0., 20., null));
				criteria.getPartitionCriterias().add(PartitionCriteria.createRaw("QUARTER"));
				criteria.getPartitionCriterias().add(PartitionCriteria.createRaw("PATRIL"));
				criteria.getPartitionCriterias().add(PartitionCriteria.createRaw("OCCU"));
				criteria.getPartitionCriterias().add(PartitionCriteria.createRaw("MATRISTATUS"));
				criteria.setPlaceParameter("DEPARTMENT");

				SpaceTimeCriteria sliceCriteria = new SpaceTimeCriteria();
				sliceCriteria.setRelationModelName("RESIDENCE");
				sliceCriteria.setLocalUnitLabel("HOUSE");

				String referentName = censusCriteria.getDefaultReferentRoleName();

				try {

					Relations relations = MainWindow.this.netGUI.getSegmentation().getAllRelations().getByModelName(sliceCriteria.getRelationModelName());
					for (Relation relation : relations) {
						relation.updateReferents(referentName);
					}

					Slices relationCensus = SliceMaker.createSlices(MainWindow.this.netGUI.getSegmentation(), sliceCriteria);

					Report report3 = SliceReporter.reportDevelopmentCycles(relationCensus, criteria);
					MainWindow.this.netGUI.addReportTab(report3);

				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnSlices.add(mntmTrajectoriesgroups);

		JMenuItem mntmEgoNetworks = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmEgoNetworks.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmEgoNetworks.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				StatisticsCriteria criteria = new StatisticsCriteria();
				SpaceTimeCriteria censusCriteria = new SpaceTimeCriteria(CensusType.PARCOURS);

				PartitionCriteria placeCriteria = PartitionCriteria.createRaw("BIRT_PLAC");
				placeCriteria.setLabelParameter("Afagnangbleta");

				criteria.getPartitionCriterias().add(placeCriteria);
				criteria.getPartitionCriterias().add(PartitionCriteria.createSizedGrouping("AGE", null, 0., 20., null));
				criteria.getPartitionCriterias().add(PartitionCriteria.createRaw("QUARTER"));
				criteria.getPartitionCriterias().add(PartitionCriteria.createRaw("PATRIL"));
				criteria.getPartitionCriterias().add(PartitionCriteria.createRaw("OCCU"));
				criteria.getPartitionCriterias().add(PartitionCriteria.createRaw("MATRISTATUS"));
				criteria.setPlaceParameter("DEPARTMENT");

				SpaceTimeCriteria sliceCriteria = new SpaceTimeCriteria();
				sliceCriteria.setRelationModelName("RESIDENCE");
				sliceCriteria.setLocalUnitLabel("HOUSE");
				sliceCriteria.setRelationClassificationTypes(new ArrayList<SpaceTimeCriteria.RelationClassificationType>());
				sliceCriteria.setEgoRoleName("RESIDENT");

				String referentName = censusCriteria.getDefaultReferentRoleName();

				try {

					Relations relations = MainWindow.this.netGUI.getSegmentation().getAllRelations().getByModelName(sliceCriteria.getRelationModelName());
					for (Relation relation : relations) {
						relation.updateReferents(referentName);
					}

					Slices relationCensus = SliceMaker.createSlices(MainWindow.this.netGUI.getSegmentation(), sliceCriteria);

					Report report = SliceReporter.reportEgoNetworks(relationCensus, criteria);
					MainWindow.this.netGUI.addReportTab(report);

				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnSlices.add(mntmEgoNetworks);

		JMenuItem mntmInternalStructures = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmInternalStructures.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmInternalStructures.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {

				SpaceTimeCriteria censusCriteria = new SpaceTimeCriteria(CensusType.PARCOURS);
				censusCriteria.setRelationModelName("MIGEVENT");

				String relationModelName = censusCriteria.getRelationModelName();
				String referentName = censusCriteria.getDefaultReferentRoleName();
				Integer[] times = censusCriteria.getDates();

				times = null;
				// times = new Integer[] { 2004, 2009 };
				boolean reducedTrees = true;

				try {

					Relations relations = MainWindow.this.netGUI.getSegmentation().getAllRelations().getByModelName(relationModelName);
					for (Relation relation : relations) {
						relation.updateReferents(referentName);
					}

					Report report = null;

					if (times == null) {
						report = RelationReporter.reportTreeStructure(MainWindow.this.netGUI.getSegmentation(), censusCriteria, null, reducedTrees);
						MainWindow.this.netGUI.addReportTab(report);

					} else {
						for (int time : times) {
							report = RelationReporter.reportTreeStructure(MainWindow.this.netGUI.getSegmentation(), censusCriteria, time, reducedTrees);
							MainWindow.this.netGUI.addReportTab(report);
						}
					}

				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnAnalysis.add(mntmInternalStructures);

		JMenuItem mntmCircuitCensus = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCircuitCensus.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmCircuitCensus.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {

				SpaceTimeCriteria criteria = new SpaceTimeCriteria();
				// criteria.setRelationModelName("MIGEVENT");
				criteria.setRelationModelName("RESIDENCE");
				// criteria.setEgoRoleName("MIG");
				criteria.setEgoRoleName("RESIDENT");
				criteria.setRoleNames(Arrays.asList(new String[] { "REFERENT" }));
				// criteria.setDates(null);

				try {
					for (Report report3 : RelationReporter.reportRelationCensus(MainWindow.this.netGUI.getSegmentation(), criteria)) {
						MainWindow.this.netGUI.addReportTab(report3);
					}
				} catch (PuckException e) {
					e.printStackTrace();
				}

			}
		});
		mnAnalysis.add(mntmCircuitCensus);

		JMenuItem mntmDifferentialCircuitCensus = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmDifferentialCircuitCensus.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmDifferentialCircuitCensus.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Launch.
				try {
					//
					CensusCriteria criteria = new CensusCriteria();
					SpaceTimeCriteria spaceTimeCriteria = new SpaceTimeCriteria();
					spaceTimeCriteria.setRelationModelName("RESIDENCE");
					// spaceTimeCriteria.setDates(null);

					criteria.setPattern(spaceTimeCriteria.getPattern());
					criteria.setChainClassification(spaceTimeCriteria.getChainClassification());

					//
					PuckGUI.instance().getPreferences().setDifferentialCensusCriteria(criteria);

					Integer[] dates = spaceTimeCriteria.getDates();
					if (dates == null) {
						Report report = CensusReporter.reportDifferentialCensus(MainWindow.this.netGUI.getSegmentation(), spaceTimeCriteria, null, criteria);
						MainWindow.this.netGUI.addReportTab(report);
					} else {
						for (Integer date : dates) {
							Report report = CensusReporter.reportDifferentialCensus(MainWindow.this.netGUI.getSegmentation(), spaceTimeCriteria, date, criteria);
							MainWindow.this.netGUI.addReportTab(report);
						}
					}
					//

				} catch (final PuckException exception) {
					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(null, message, title, JOptionPane.ERROR_MESSAGE);
				}

			}
		});
		mnAnalysis.add(mntmDifferentialCircuitCensus);

		JMenu mnTransform_1 = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnTransform_1.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnSequences.add(mnTransform_1);

		JMenuItem mntmTransform = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCensus.text"));
		mntmTransform.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Add child roles.
				try {
					//
					AttributeDescriptors attributeDescriptors = AttributeWorker.getExogenousAttributeDescriptors(MainWindow.this.netGUI.getSegmentation(), null);

					AddChildRolesCriteria criteria = AddChildRolesInputDialog
							.showDialog(MainWindow.this.netGUI.getNet().relationModels(), attributeDescriptors);

					RelationWorker.addChildRoles(MainWindow.this.netGUI.getNet(), criteria);

					// Refresh.
					MainWindow.this.netGUI.updateAll();

				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnTransform_1.add(mntmTransform);

		JMenu mnControls_1 = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnControls_1.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnSequences.add(mnControls_1);

		JMenuItem mntmUnknownPlaces = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmUnknownPlaces.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnControls_1.add(mntmUnknownPlaces);

		JMenuItem mntmUnknownPlaces_1 = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmUnknownPlaces_1.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmUnknownPlaces_1.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Unknown Places with parameters.
				try {
					StringList relationModelNames = MainWindow.this.netGUI.getNet().relationModels().sortedNameList();

					UnknownPlacesCriteria criteria = UnknownPlacesInputDialog.showDialog(relationModelNames);

					if (criteria != null) {
						//
						Report report = SequenceReporter.reportUnknownPlaces(MainWindow.this.netGUI.getSegmentation(), criteria,
								ResourceBundle.getBundle("org.tip.puckgui.messages"));

						if (report.status() == 0) {
							//
							String title = "Control special features report";
							String message = "No special features found.";

							//
							JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);
						} else {
							MainWindow.this.netGUI.addReportTab(report);
						}
					}
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnControls_1.add(mntmUnknownPlaces_1);

		JMenuItem mntmUncodedPlaces = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmUncodedPlaces.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmUncodedPlaces.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Unknown Places (automatic).
				try {
					Report report = SequenceReporter.reportUncodedPlaces(MainWindow.this.netGUI.getSegmentation(),
							ResourceBundle.getBundle("org.tip.puckgui.messages"));

					if (report.status() == 0) {
						//
						String title = "Control special features report";
						String message = "No special features found.";

						//
						JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);
					} else {
						MainWindow.this.netGUI.addReportTab(report);
					}
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnControls_1.add(mntmUncodedPlaces);

		JMenuItem mntmUnknownRelations = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmUnknownRelations.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmUnknownRelations.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Unknown Places (automatic).
				try {
					//
					AttributeDescriptors attributeDescriptors = AttributeWorker.getExogenousAttributeDescriptors(MainWindow.this.netGUI.getCurrentRelations(),
							null);

					SpaceTimeCriteria criteria = DiscontinuousItinerariesInputDialog.showDialog(MainWindow.this.netGUI.getNet().relationModels(),
							attributeDescriptors);

					// Integrate into dialog!
					criteria.getRelationModelNames().add("RELATIVE");
					criteria.getRelationModelNames().add("APPRENTICESHIP");
					criteria.getRelationModelNames().add("FRIENDSHIP");
					criteria.getRelationModelNames().add("RENT");
					criteria.getRelationModelNames().add("EMPLOYMENT");
					criteria.getRelationModelNames().add("INITIATION");
					criteria.getRelationModelNames().add("UNRELATED");

					/*					criteria.getRoleNames().add("HOST");
										criteria.getRoleNames().add("MIG");
										criteria.getRoleNames().add("FIN");
										criteria.getRoleNames().add("INI");
										criteria.getRoleNames().add("OTHER");*/

					if (criteria != null) {
						//
						Report report = SequenceReporter.reportUnknownRelations(MainWindow.this.netGUI.getSegmentation(), criteria,
								ResourceBundle.getBundle("org.tip.puckgui.messages"));

						if (report.status() == 0) {
							//
							String title = "Control special features report";
							String message = "No special features found.";

							//
							JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);

						} else {
							//
							MainWindow.this.netGUI.addReportTab(report);
						}
					}
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnControls_1.add(mntmUnknownRelations);

		JMenuItem mntmDiscontinuousItineraries = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmDiscontinuousItineraries.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnControls_1.add(mntmDiscontinuousItineraries);

		JMenuItem mntmDiscontinousBiographies = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmDiscontinousBiographies.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmDiscontinousBiographies.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Discontinuous Itineraries report.
				try {
					//
					AttributeDescriptors attributeDescriptors = AttributeWorker.getExogenousAttributeDescriptors(MainWindow.this.netGUI.getCurrentRelations(),
							null);

					SpaceTimeCriteria criteria = DiscontinuousItinerariesInputDialog.showDialog(MainWindow.this.netGUI.getNet().relationModels(),
							attributeDescriptors);

					if (criteria != null) {
						//
						Report report = SequenceReporter.reportDiscontinuousBiographies(MainWindow.this.netGUI.getNet(),
								MainWindow.this.netGUI.getSegmentation(), criteria, ResourceBundle.getBundle("org.tip.puckgui.messages"));

						if (report.status() == 0) {
							//
							String title = "Control special features report";
							String message = "No special features found.";

							//
							JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);

						} else {
							//
							MainWindow.this.netGUI.addReportTab(report);
						}
					}
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnControls_1.add(mntmDiscontinousBiographies);

		JMenuItem mntmMissingWitnesses = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmMissingWitnesses.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnControls_1.add(mntmMissingWitnesses);

		JSeparator separator_22 = new JSeparator();
		mnSequences.add(separator_22);

		JMenuItem mntmRelationAnalysis = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRelationAnalysis.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmRelationAnalysis.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Relation Analysis.
				try {
					//
					AttributeDescriptors attributeDescriptors = AttributeWorker.getExogenousAttributeDescriptors(MainWindow.this.netGUI.getSegmentation()
							.getCurrentRelations(), null);

					SpaceTimeCriteria criteria = RelationAnalysisInputDialog.showDialog(MainWindow.this.netGUI.getNet().relationModels(), attributeDescriptors);

					if (criteria != null) {
						// Referent Trees.
						{
							SpaceTimeCriteria censusCriteria = new SpaceTimeCriteria(CensusType.PARCOURS);

							String relationModelName = censusCriteria.getRelationModelName();
							String referentName = censusCriteria.getDefaultReferentRoleName();
							Relations relations = MainWindow.this.netGUI.getSegmentation().getAllRelations().getByModelName(relationModelName);
							for (Relation relation : relations) {
								relation.updateReferents(referentName);
							}

							boolean reducedTrees = true;
							Report report = RelationReporter.reportTreeStructure(MainWindow.this.netGUI.getSegmentation(), censusCriteria, null, reducedTrees);
							MainWindow.this.netGUI.addReportTab(report);
						}

						// Kinship Circuits.
						{
							// WHY HARD WRITE?
							criteria.setEgoRoleName("RESIDENT");
							criteria.setRoleNames(Arrays.asList(new String[] { "REFERENT" }));

							for (Report report3 : RelationReporter.reportRelationCensus(MainWindow.this.netGUI.getSegmentation(), criteria)) {
								MainWindow.this.netGUI.addReportTab(report3);
							}
						}

						// Differential Circuit Census.
						{
							CensusCriteria censusCriteria = new CensusCriteria();

							censusCriteria.setPattern(criteria.getPattern());
							censusCriteria.setChainClassification(criteria.getChainClassification());

							//
							PuckGUI.instance().getPreferences().setDifferentialCensusCriteria(censusCriteria);

							Integer[] dates = criteria.getDates();
							if (dates == null) {
								Report report = CensusReporter.reportDifferentialCensus(MainWindow.this.netGUI.getSegmentation(), criteria, null,
										censusCriteria);
								MainWindow.this.netGUI.addReportTab(report);
							} else {
								for (Integer date : dates) {
									Report report = CensusReporter.reportDifferentialCensus(MainWindow.this.netGUI.getSegmentation(), criteria, date,
											censusCriteria);
									MainWindow.this.netGUI.addReportTab(report);
								}
							}
						}
					}
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnSequences.add(mntmRelationAnalysis);

		JMenuItem mntmConvertGeography = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmConvertGeographytemp.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmConvertGeography.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Button convert.
				try {
					//
					String targetFileName = "togo.geo.csv";

					File targetFile = GeographyExportFileSelector.showSelectorDialog(MainWindow.this.frmPuck, new File(targetFileName));

					if (targetFile != null) {
						//
						GEOXLSFile.save(targetFile, Geography.getInstance());
					}

				} catch (final PuckException exception) {
					//
					String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.title");

					//
					String message;
					switch (PuckExceptions.valueOf(exception.getCode())) {
						case UNSUPPORTED_FILE_FORMAT:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedFileFormat");
						break;
						case NOT_A_FILE:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.notAFile");
						break;
						case UNSUPPORTED_ENCODING:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedEncoding");
						break;
						default:
							message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.default");
					}

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);

				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}

			}
		});
		mnSequences.add(mntmConvertGeography);

		JMenuItem mntmSpaceTimeAnalysis = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSpaceTimeAnalysis.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmSpaceTimeAnalysis.addActionListener(new ActionListener() {
			/**
			 * 
			 */
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Space-Time Analysis.
				try {
					AttributeDescriptors attributeDescriptors = AttributeWorker.getExogenousAttributeDescriptors(MainWindow.this.netGUI.getSegmentation(), null);

					SpaceTimeCriteria criteria = SpaceTimeAnalysisInputDialog.showDialog(MainWindow.this.netGUI.getSegmentation(), MainWindow.this.netGUI
							.getNet().relationModels(), attributeDescriptors);

					if (criteria != null) {
						//
						ReportList reports = SpaceTimeReporter.reportHugeAnalysis(MainWindow.this.netGUI.getNet(), MainWindow.this.netGUI.getSegmentation(),
								criteria, ResourceBundle.getBundle("org.tip.puckgui.messages"));

						for (Report report : reports) {
							//
							MainWindow.this.netGUI.addReportTab(report);
						}

						if (criteria.getTrajectoriesOperations().contains(TrajectoriesOperation.DRAW)) {

							Graph<Place2> geocodedGraph = SequenceReporter.getTrajectoryGraph2(MainWindow.this.netGUI.getNet().getGeography2(),
									MainWindow.this.netGUI.getSegmentation(), criteria);

							MapPanel2 geographyMap = new MapPanel2(geocodedGraph);
							addTab("Geography", geographyMap);

							/*
							Graph<Place> placeGraph = SequenceReporter.getTrajectoryGraph(MainWindow.this.netGUI.getSegmentation(), criteria);
							ConfigGeocodingDialog dialog = new ConfigGeocodingDialog(MainWindow.this.netGUI, placeGraph);
							dialog.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
							dialog.setVisible(true);
							*/
						}

					}
				} catch (final Exception exception) {
					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		mnSequences.add(mntmSpaceTimeAnalysis);
		mntmMissingWitnesses.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Missing testimonies report.
				try {
					MissingTestimoniesCriteria criteria = MissingTestimoniesInputDialog.showDialog(MainWindow.this.netGUI.getNet().relationModels());

					if (criteria != null) {
						//
						Report report = SequenceReporter.reportMissingTestimonies(MainWindow.this.netGUI.getSegmentation(), criteria,
								ResourceBundle.getBundle("org.tip.puckgui.messages"));

						if (report.status() == 0) {
							//
							String title = "Control special features report";
							String message = "No special features found.";

							//
							JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);

						} else {
							//
							MainWindow.this.netGUI.addReportTab(report);
						}
					}
				} catch (final Exception exception) {
					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		mntmDiscontinuousItineraries.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Discontinuous Itineraries report.
				try {
					//
					AttributeDescriptors attributeDescriptors = AttributeWorker.getExogenousAttributeDescriptors(MainWindow.this.netGUI.getCurrentRelations(),
							null);

					SpaceTimeCriteria criteria = DiscontinuousItinerariesInputDialog.showDialog(MainWindow.this.netGUI.getNet().relationModels(),
							attributeDescriptors);

					if (criteria != null) {
						//
						Report report = SequenceReporter.reportDiscontinuousItineraries(MainWindow.this.netGUI.getSegmentation(), criteria,
								ResourceBundle.getBundle("org.tip.puckgui.messages"));

						if (report.status() == 0) {
							//
							String title = "Control special features report";
							String message = "No special features found.";

							//
							JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);

						} else {
							//
							MainWindow.this.netGUI.addReportTab(report);
						}
					}
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mntmUnknownPlaces.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent arg0) {
				// Unknown Places (automatic).
				try {
					Report report = SequenceReporter.reportUnknownPlaces(MainWindow.this.netGUI.getSegmentation(),
							ResourceBundle.getBundle("org.tip.puckgui.messages"));

					if (report.status() == 0) {
						//
						String title = "Control special features report";
						String message = "No special features found.";

						//
						JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);
					} else {
						MainWindow.this.netGUI.addReportTab(report);
					}
				} catch (final Exception exception) {

					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});

		JMenu mnDraw = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnDraw.text")); //$NON-NLS-1$ //$NON-NLS-2$
		menuBar.add(mnDraw);

		JMenuItem mntmOregraph = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmOregraph.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmOregraph.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Ore-Graph visualization.
				try {
					//
					Graph<Individual> graph = NetUtils.createOreGraph(MainWindow.this.netGUI.getSegmentation());

					//
					VisualizationController vizController = VisualizationController.getSharedInstance();
					VisualizationPanel buildView = vizController.buildView(graph, OreGraph.class);

					addTab("Ore-Graph Draw", buildView);

				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();
				}
			}
		});
		mnDraw.add(mntmOregraph);

		JMenuItem mntmPgraph = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmPgraph.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmPgraph.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// P-Graph visualization.
				try {
					//
					Graph<Individual> graph = NetUtils.createOreGraph(MainWindow.this.netGUI.getSegmentation());

					//
					VisualizationController vizController = VisualizationController.getSharedInstance();
					VisualizationPanel buildView = vizController.buildView(graph, PGraph.class);

					addTab("P-Graph Draw", buildView);

				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();
				}
			}
		});
		mnDraw.add(mntmPgraph);

		JMenuItem mntmFullDiagram = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmFullDiagram.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmFullDiagram.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Draw full diagram.
				Individuals currentIndividuals = MainWindow.this.netGUI.getCurrentIndividuals();
				JPanel diagramPanel = new GlobalDiagramPanel(MainWindow.this.netGUI, currentIndividuals);
				addTab("Full diagram", diagramPanel);
			}
		});

		JMenuItem mntmKinoath = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmKinoath.text"));
		mntmKinoath.setEnabled(false);
		mnDraw.add(mntmKinoath);
		mnDraw.add(mntmFullDiagram);

		JMenuItem mntmComponentDiagrams = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmComponentDiagram.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmComponentDiagrams.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Component Diagram.
				Individuals currentIndividuals = MainWindow.this.netGUI.getCurrentIndividuals();
				IndividualGroups groups = ComponentWorker.searchKinComponents(currentIndividuals);
				JPanel diagramPanel = new IndividualGroupDiagramsPanel(MainWindow.this.netGUI, groups);
				addReportTab("Component diagrams", diagramPanel);
			}
		});

		JMenuItem mntmIndividualDiagrams = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmIndividualDiagram.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmIndividualDiagrams.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Draw individual diagram.
				JPanel diagramPanel = new IndividualDiagramsPanel(MainWindow.this.netGUI);
				((IndividualDiagramsPanel) diagramPanel).update(getIndividualsTab().getSelectedIndividual());
				addReportTab("Ind. diagrams", diagramPanel);
			}
		});
		mnDraw.add(mntmIndividualDiagrams);

		JMenuItem mntmSegmentDiagrams = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmPartitionDiagrams.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmSegmentDiagrams.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Segment diagram.
				IndividualGroups groups = SegmentationWorker.convert(MainWindow.this.netGUI.getSegmentation().getCurrentSegment());
				JPanel diagramPanel = new IndividualGroupDiagramsPanel(MainWindow.this.netGUI, groups);
				addReportTab("Segment diagrams", diagramPanel);
			}
		});
		mnDraw.add(mntmSegmentDiagrams);
		mnDraw.add(mntmComponentDiagrams);

		JMenuItem mntmGeneaquilt = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmGeneaquilt.text"));
		mntmGeneaquilt.setEnabled(false);
		mnDraw.add(mntmGeneaquilt);

		JMenuItem mntmGeneaQuiltViewFull = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmQuiltDiagram.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmGeneaQuiltViewFull.addActionListener(new ActionListener() {
			/**
			 * 
			 */
			@Override
			public void actionPerformed(final ActionEvent event) {
				//
				Network network = GeneaQuiltConvert.convertToGeneaQuilt(MainWindow.this.netGUI.getNet());
				logger.debug("convert done.");
				JPanel geneaQuiltPanel = new GeneaQuiltPanel(MainWindow.this.tabbedPaneCorpus, network);
				logger.debug("panel done.");
				addReportTab("Full quilt", geneaQuiltPanel);
			}
		});
		mnDraw.add(mntmGeneaQuiltViewFull);

		JMenuItem mntmGeneaQuiltSegment = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSegmentQuilt.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmGeneaQuiltSegment.addActionListener(new ActionListener() {
			/**
			 * 
			 */
			@Override
			public void actionPerformed(final ActionEvent event) {
				Network network = GeneaQuiltConvert.convertToGeneaQuilt(MainWindow.this.netGUI.getCurrentIndividuals(),
						MainWindow.this.netGUI.getCurrentFamilies());
				logger.debug("convert done.");
				JPanel geneaQuiltPanel = new GeneaQuiltPanel(MainWindow.this.tabbedPaneCorpus, network);
				logger.debug("panel done.");
				addReportTab("Segment quilt", geneaQuiltPanel);
			}
		});
		mnDraw.add(mntmGeneaQuiltSegment);

		JMenuItem mntmGeneaQuiltSegments = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmSegmentQuilts.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmGeneaQuiltSegments.addActionListener(new ActionListener() {
			/**
			 * 
			 */
			@Override
			public void actionPerformed(final ActionEvent event) {
				//
				IndividualGroups groups = SegmentationWorker.convert(MainWindow.this.netGUI.getSegmentation().getCurrentSegment());
				JPanel diagramPanel = new IndividualGroupQuiltsPanel(MainWindow.this.netGUI, groups);
				addReportTab("Segment quilts", diagramPanel);
			}
		});
		mnDraw.add(mntmGeneaQuiltSegments);

		JMenuItem mntmGeneaQuiltComponents = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmComponentQuilts.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmGeneaQuiltComponents.addActionListener(new ActionListener() {
			/**
			 * 
			 */
			@Override
			public void actionPerformed(final ActionEvent event) {
				//
				Individuals currentIndividuals = MainWindow.this.netGUI.getCurrentIndividuals();
				IndividualGroups groups = ComponentWorker.searchKinComponents(currentIndividuals);
				JPanel quiltPanel = new IndividualGroupQuiltsPanel(MainWindow.this.netGUI, groups);
				addReportTab("Component quilts", quiltPanel);
			}
		});
		mnDraw.add(mntmGeneaQuiltComponents);

		JMenuItem mntmEventquiltViews = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmEventquiltViews.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmEventquiltViews.setEnabled(false);
		mnDraw.add(mntmEventquiltViews);

		JMenuItem mntmEventQuiltFull = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmFullQuilt.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmEventQuiltFull.addActionListener(new ActionListener() {
			/**
			 * 
			 */
			@Override
			public void actionPerformed(final ActionEvent event) {
				//
				Network network = GeneaQuiltConvert.convertToEventQuilt(MainWindow.this.netGUI.getNet());
				logger.debug("convert done.");
				JPanel geneaQuiltPanel = new GeneaQuiltPanel(MainWindow.this.tabbedPaneCorpus, network, VertexComparator.Sorting.DATERANGE_START);
				logger.debug("panel done.");
				addReportTab("Full event quilt", geneaQuiltPanel);
			}
		});
		mnDraw.add(mntmEventQuiltFull);

		JMenuItem mntmEventQuiltComponents = new JMenuItem("Component quilts");
		mntmEventQuiltComponents.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				//
				Individuals currentIndividuals = MainWindow.this.netGUI.getCurrentIndividuals();
				IndividualGroups groups = ComponentWorker.searchComponents(currentIndividuals);
				JPanel quiltPanel = new IndividualGroupEventQuiltsPanel(MainWindow.this.netGUI, groups);
				addReportTab("Component event quilts", quiltPanel);
			}
		});

		JMenuItem mntmEvenQuiltSegment = new JMenuItem("Segment quilt");
		mntmEvenQuiltSegment.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				//
				Network network = GeneaQuiltConvert.convertToEventQuilt(MainWindow.this.netGUI.getCurrentIndividuals(),
						MainWindow.this.netGUI.getCurrentFamilies(), MainWindow.this.netGUI.getCurrentRelations());
				logger.debug("convert done.");
				JPanel geneaQuiltPanel = new GeneaQuiltPanel(MainWindow.this.tabbedPaneCorpus, network, VertexComparator.Sorting.DATERANGE_START);
				logger.debug("panel done.");
				addReportTab("Segment event quilt", geneaQuiltPanel);

			}
		});
		mnDraw.add(mntmEvenQuiltSegment);

		JMenuItem mntmEventQuiltSegments = new JMenuItem("Segment quilts");
		mntmEventQuiltSegments.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				//
				IndividualGroups groups = SegmentationWorker.convert(MainWindow.this.netGUI.getSegmentation().getCurrentSegment());
				JPanel diagramPanel = new IndividualGroupEventQuiltsPanel(MainWindow.this.netGUI, groups);
				addReportTab("Segment event quilts", diagramPanel);
			}
		});
		mnDraw.add(mntmEventQuiltSegments);
		mnDraw.add(mntmEventQuiltComponents);

		JMenuItem mntmGeoViews = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmGeoViews.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmGeoViews.setEnabled(false);
		mnDraw.add(mntmGeoViews);

		JMenuItem mntmNetPlaces = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmNetPlaces.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmNetPlaces.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Geo views : Net Places.
				try {
					GeoPlaceNetCriteria criteria = GeoPlaceNetDialog.showDialog(MainWindow.this.netGUI.getNet().relationModels().nameList());

					if (criteria != null) {
						//
						StringSet toponyms = AttributeWorker.getExogenousAttributeValues(MainWindow.this.netGUI.getNet(), criteria.getScopes(), "^.*_PLAC.*$");

						double weightStep;
						if (criteria.isWeight()) {
							weightStep = 1;
						} else {
							weightStep = 0;
						}

						Graph<Place2> geocodedGraph = GeocodingWorker.geocodeToponymStrings(MainWindow.this.netGUI.getNet().getGeography2(), toponyms,
								weightStep);

						MapPanel2 geographyMap = new MapPanel2(geocodedGraph);

						addTab("Geography", geographyMap);

						//
						String title = "Information";
						StringList buffer = new StringList();
						buffer.append("Toponym count   =").appendln(toponyms.size());
						buffer.append("Graph node count=").appendln(geocodedGraph.nodeCount());
						String message = buffer.toString();
						JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.INFORMATION_MESSAGE);
					}
				} catch (final Exception exception) {
					//
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnDraw.add(mntmNetPlaces);

		JMenu mnTools = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnTools.text")); //$NON-NLS-1$ //$NON-NLS-2$
		menuBar.add(mnTools);

		JMenuItem mntmCalculator = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmCalculator.text"));
		mntmCalculator.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Call calculator.
				try {
					CalculatorWindow window = new CalculatorWindow(MainWindow.this.netGUI);
					window.getJFrame().setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.getJFrame().setVisible(true);
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnTools.add(mntmCalculator);

		JMenuItem mntmFlatdbgeonames = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmFlatdbgeonames.text"));
		mntmFlatdbgeonames.setHorizontalAlignment(SwingConstants.CENTER);
		mntmFlatdbgeonames.setEnabled(false);
		mnTools.add(mntmFlatdbgeonames);

		JMenuItem mntmDownloadFlatdbgeonamesDatabase = new JMenuItem(ResourceBundle
				.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmDownloadFlatdbgeonamesDatabase.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmDownloadFlatdbgeonamesDatabase.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// FlatDB4GeoNames : Download database.
				try {
					//
					DownloadDatabaseDialog.showDialog();

				} catch (final Exception exception) {
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(null, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnTools.add(mntmDownloadFlatdbgeonamesDatabase);

		JMenuItem mntmRequest = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRequest.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmRequest.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// FlatDB4GeoNames : request.
				try {
					//
					addTab("FlatDB4GeoNames", new FlatDB4GeoNamesRequestPanel());

				} catch (final Exception exception) {
					exception.printStackTrace();

					//
					String title = "Error computerum est";
					String message = "Error occured during working: " + exception.getMessage();

					//
					JOptionPane.showMessageDialog(null, message, title, JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		mnTools.add(mntmRequest);

		JMenu mnWindows = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnWindows.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnWindows.addMenuListener(new MenuListener() {
			@Override
			public void menuCanceled(final MenuEvent event) {
			}

			@Override
			public void menuDeselected(final MenuEvent event) {
				// Windows menu cleaning.
				JMenu windowsMenu = (JMenu) event.getSource();
				windowsMenu.removeAll();
			}

			@Override
			public void menuSelected(final MenuEvent event) {
				// Windows menu updating.
				JMenu windowsMenu = (JMenu) event.getSource();
				for (WindowGUI windowGUI : PuckGUI.instance().windowGUIs()) {
					windowsMenu.add(new WindowMenuItem(windowGUI));
				}
			}
		});

		menuBar.add(mnWindows);

		JMenu mnHelp = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnHelp.text"));
		mnHelp.setMnemonic('H');
		menuBar.add(mnHelp);

		JMenuItem mntmOfficialWebSite = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmOfficialWebSite.text"));
		mntmOfficialWebSite.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent event) {
				// Puck Help.
				callPuckHelp((JMenuItem) event.getSource());
			}
		});
		mnHelp.add(mntmOfficialWebSite);

		JMenuItem mntmAboutPuck = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmAboutPuck.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmAboutPuck.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// About Puck.
				try {
					AboutPopup dialog = new AboutPopup();
					dialog.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					dialog.setVisible(true);
				} catch (Exception exception) {
					exception.printStackTrace();
				}
			}
		});

		JSeparator separator_3 = new JSeparator();
		mnHelp.add(separator_3);
		mnHelp.add(mntmAboutPuck);

		JMenu mnFoo = new JMenu(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mnFoo.text"));
		mnFoo.setVisible(false);
		mnFoo.setEnabled(false);
		menuBar.add(mnFoo);

		JMenuItem mntmFooworker = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmFooworker.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnFoo.add(mntmFooworker);

		JMenuItem mntmTestDev = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmTestDev.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mnFoo.add(mntmTestDev);
		mntmTestDev.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {

				// Test dev.
				// Launch.
				try {

					GraphReporter.test();
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();
				}

			}
		});
		mntmTestDev.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_T, InputEvent.CTRL_MASK));

		JMenuItem mntmVisualizationTest = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmVisualizationTdev.text")); //$NON-NLS-1$ //$NON-NLS-2$
		mntmVisualizationTest.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Visualization test.
				try {
					org.tip.puckgui.views.visualization.Test.test(MainWindow.this.netGUI);
				} catch (final Exception exception) {
					// Show trace.
					exception.printStackTrace();
				}
			}
		});
		mntmVisualizationTest.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_E, InputEvent.CTRL_MASK | InputEvent.SHIFT_MASK));
		mnFoo.add(mntmVisualizationTest);
		mntmFooworker.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(final ActionEvent e) {
				// Preferences.
				try {
					FooReporterInputWindow window = new FooReporterInputWindow(MainWindow.this.netGUI);
					window.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					window.setVisible(true);
				} catch (Exception exception) {
					exception.printStackTrace();
				}
			}
		});
		this.frmPuck.getContentPane().setLayout(new BoxLayout(this.frmPuck.getContentPane(), BoxLayout.Y_AXIS));

		this.segmentationPanel = new SegmentationPanel(this.netGUI);
		this.frmPuck.getContentPane().add(this.segmentationPanel);

		this.tabbedPaneCorpus = new JTabbedPane(JTabbedPane.TOP);
		this.frmPuck.getContentPane().add(this.tabbedPaneCorpus);

		this.corpusTab = new CorpusPanel(this.netGUI);
		this.tabbedPaneCorpus.addTab(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.corpusTab.title"), null, this.corpusTab, null); //$NON-NLS-1$ //$NON-NLS-2$

		this.individualsTab = new IndividualsPanel(this.netGUI);
		this.tabbedPaneCorpus.addTab(
				ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.individualsPanel.title"), null, this.individualsTab, null); //$NON-NLS-1$ //$NON-NLS-2$

		this.familiesTab = new FamiliesPanel(this.netGUI);
		this.tabbedPaneCorpus.addTab(
				ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.familiesPanel.title"), null, this.familiesTab, null); //$NON-NLS-1$ //$NON-NLS-2$
	}

	/**
	 * Performs a save as BAR action.
	 * 
	 * @param displayFileChooser
	 *            Flag to display a file chooser.
	 * 
	 * @param persistFileName
	 *            Flag to persist the file name in the current netGUI.
	 */
	protected void performBARSave() {
		// Save As.
		try {
			//
			File targetFile = ExportBARFileSelector.showSelectorDialog(this.frmPuck, MainWindow.this.netGUI.getFile());

			if (targetFile != null) {
				//
				BARFile.save(targetFile, this.netGUI.getNet());
			}
		} catch (final PuckException exception) {
			//
			String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.title");

			//
			String message;
			switch (PuckExceptions.valueOf(exception.getCode())) {
				case UNSUPPORTED_FILE_FORMAT:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedFileFormat");
				break;
				case NOT_A_FILE:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.notAFile");
				break;
				case UNSUPPORTED_ENCODING:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedEncoding");
				break;
				default:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.default");
			}

			//
			JOptionPane.showMessageDialog(this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);

		} catch (final Exception exception) {
			// Show trace.
			exception.printStackTrace();

			//
			String title = "Error computerum est";
			String message = "Error occured during working: " + exception.getMessage();

			//
			JOptionPane.showMessageDialog(MainWindow.this.frmPuck, message, title, JOptionPane.ERROR_MESSAGE);
		}
	}

	/**
	 * 
	 */
	private void performCloseCorpus() {
		//
		if ((!this.netGUI.isChanged()) || ((this.netGUI.isChanged()) && (ConfirmMainWindowCloseDialog.showDialog(this.frmPuck, this.netGUI)))) {
			//
			if (PuckGUI.instance().windowGUIs().size() == 1) {
				//
				if (!this.netGUI.isBlank()) {
					this.netGUI.setBlank();
				}
			} else {
				//
				PuckGUI.instance().close(this.netGUI);
				this.frmPuck.dispose();
			}
		}
	}

	/**
	 * 
	 */
	private void performCloseWindow() {
		//
		if ((!this.netGUI.isChanged()) || ((this.netGUI.isChanged()) && (ConfirmMainWindowCloseDialog.showDialog(this.frmPuck, this.netGUI)))) {
			//
			if (PuckGUI.instance().windowGUIs().size() == 1) {
				//
				if (this.netGUI.isBlank()) {
					//
					PuckGUI.instance().exit();
				} else {
					//
					this.netGUI.setBlank();
				}
			} else {
				//
				PuckGUI.instance().close(this.netGUI);
				this.frmPuck.dispose();
			}
		}
	}

	/**
	 * 
	 */
	private void performQuit() {
		//
		if ((!PuckGUI.instance().existsUnsavedChanges()) || ((PuckGUI.instance().existsUnsavedChanges()) && (ConfirmQuitDialog.showDialog(this.frmPuck)))) {
			//
			PuckGUI.instance().exit();
		}
	}

	/**
	 * 
	 * @param family
	 */
	public void selectFamiliesTab(final Family family) {
		this.tabbedPaneCorpus.setSelectedIndex(2);
		this.familiesTab.select(family);
	}

	/**
	 * 
	 */
	public void selectIndividualsTab() {
		this.tabbedPaneCorpus.setSelectedIndex(1);
	}

	/**
	 * 
	 */
	public void selectIndividualsTab(final Individual individual) {
		this.tabbedPaneCorpus.setSelectedIndex(1);
		this.individualsTab.select(individual);
	}

	/**
	 * 
	 * @param relation
	 */
	public void selectRelationTab(final Relation relation) {
		int tabIndex = getRelationTabIndex(relation.getModel());
		if (tabIndex != -1) {
			this.tabbedPaneCorpus.setSelectedIndex(tabIndex);
			RelationsPanel tab = (RelationsPanel) this.tabbedPaneCorpus.getComponent(tabIndex);
			tab.select(relation);
		}
	}

	/**
	 * 
	 * @param tabIndex
	 */
	public void selectTab(final int tabIndex) {
		this.tabbedPaneCorpus.setSelectedIndex(tabIndex);
	}

	/**
	 * 
	 */
	public void setIndividualsTab(final Individual individual) {
		this.individualsTab.select(individual);
	}

	public void toFront() {
		this.frmPuck.toFront();
	}

	/**
	 * 
	 * @param locale
	 */
	public void updateLocale(final Locale locale) {
		this.frmPuck.setLocale(locale);
		// initialize();
	}

	/**
	 * 
	 */
	public void updateMenuItems() {
		//
		if (this.netGUI.isChanged()) {
			//
			this.mntmSave.setEnabled(true);

			//
			if (this.netGUI.getFile() == null) {
				//
				this.mntmRevert.setEnabled(false);

			} else {
				//
				this.mntmRevert.setEnabled(this.netGUI.getFile().exists());
			}
			this.mntmRevert.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRevert.text"));

		} else {
			//
			this.mntmSave.setEnabled(false);

			if (this.netGUI.getFile() == null) {
				//
				this.mntmRevert.setEnabled(false);
				this.mntmRevert.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmRevert.text"));

			} else {
				//
				this.mntmRevert.setEnabled(this.netGUI.getFile().exists());
				this.mntmRevert.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.mntmReload.text"));
			}
		}
	}

	/**
	 * 
	 */
	public void updateTitle() {
		String changeToken;
		if (this.netGUI.isChanged()) {
			changeToken = "*";

			// Set MAC OS X feature.
			this.frmPuck.getRootPane().putClientProperty("Window.documentModified", Boolean.TRUE);
		} else {
			changeToken = "";

			// Set MAC OS X feature.
			this.frmPuck.getRootPane().putClientProperty("Window.documentModified", Boolean.FALSE);
		}

		this.frmPuck.setTitle(changeToken + this.netGUI.getFile().getName() + "-" + this.netGUI.getId() + " - Puck");
	}

	/**
	 * 
	 */
	public static void callPuckHelp(final JMenuItem source) {
		String HELP_URL = "http://www.kintip.net/puck-aide-mainmenu-24";
		try {
			if (Desktop.isDesktopSupported()) {
				Desktop desktop = Desktop.getDesktop();
				if (desktop.isSupported(Desktop.Action.BROWSE)) {
					//
					java.net.URI uri = new java.net.URI(HELP_URL);
					desktop.browse(uri);
				} else if (source != null) {
					source.setEnabled(false);
				}
			} else if (source != null) {
				source.setEnabled(false);
			}
		} catch (java.io.IOException ioe) {
			ioe.printStackTrace();
			System.err.println("The system cannot find the URL specified: [" + HELP_URL + "]");
			JOptionPane.showMessageDialog(null, "Sorry, browser call failed.", "Error", JOptionPane.ERROR_MESSAGE);
		} catch (java.net.URISyntaxException use) {
			use.printStackTrace();
			System.out.println("Illegal character in path [" + HELP_URL + "]");
			JOptionPane.showMessageDialog(null, "Sorry, browser call failed.", "Error", JOptionPane.ERROR_MESSAGE);
		}
	}

	/**
	 * 
	 */
	public static int getDesktopHeight() {
		int result;

		Toolkit toolkit = Toolkit.getDefaultToolkit();

		// Get default screen size.
		Dimension dim = toolkit.getScreenSize();

		// Get default screen configuration.
		GraphicsConfiguration gconf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();

		// Get screen insets.
		Insets insets = toolkit.getScreenInsets(gconf);

		// Compute the desktop height.
		result = (int) (dim.getHeight() - insets.bottom - insets.top);

		//
		return result;
	}

	/**
	 * 
	 * @param netGUI
	 * @param parentPanel
	 * @param file
	 * @param charsetName
	 */
	public static void openConflictingFile(final NetGUI netGUI, final JFrame parentPanel, final File file, final String charsetName) {
		//
		try {
			// Request arbitration.
			Object[] options = { "IUR", "BAR", "Cancel" }; // Order is reversed
															// in dialog.
			int choice = JOptionPane.showOptionDialog(parentPanel, "Puck can not determine the file format. Please, speficy it.", "BAR or IUR?",
					JOptionPane.YES_NO_CANCEL_OPTION, JOptionPane.QUESTION_MESSAGE, null, options, null);

			//
			if (choice != 2) {
				//
				Net net;
				if (choice == 1) {
					net = BARFile.load(file, charsetName);
				} else {
					net = IURFile.load(file, charsetName);
				}

				//
				PuckGUI.instance().recentFiles().updateFile(file);
				PuckGUI.instance().recentFolders().updateFolder(file.getParentFile());

				//
				if (netGUI.isBlank()) {
					//
					netGUI.updateFile(file, net);
				} else {
					//
					PuckGUI.instance().createNetGUI(file, net);
				}
			}
		} catch (final PuckException exception) {
			//
			exception.printStackTrace();

			//
			String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");

			//
			String message;
			switch (PuckExceptions.valueOf(exception.getCode())) {
				case FILE_NOT_FOUND:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.fileNotFound");
					JOptionPane.showMessageDialog(parentPanel, message, title, JOptionPane.ERROR_MESSAGE);
				break;
				case BAD_FILE_FORMAT:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.badFileFormat");
					JOptionPane.showMessageDialog(parentPanel, message, title, JOptionPane.ERROR_MESSAGE);
				break;
				case UNSUPPORTED_FILE_FORMAT:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedFileFormat");
					JOptionPane.showMessageDialog(parentPanel, message, title, JOptionPane.ERROR_MESSAGE);
				break;
				case NOT_A_FILE:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.notAFile");
					JOptionPane.showMessageDialog(parentPanel, message, title, JOptionPane.ERROR_MESSAGE);
				break;
				case UNSUPPORTED_ENCODING:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedEncoding");
					JOptionPane.showMessageDialog(parentPanel, message, title, JOptionPane.ERROR_MESSAGE);
				break;
				default:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");
					JOptionPane.showMessageDialog(parentPanel, message, title, JOptionPane.ERROR_MESSAGE);
			}

			//

		} catch (final Exception exception) {
			//
			exception.printStackTrace();

			//
			String subtitle = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");
			String submessage = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");

			//
			JOptionPane.showMessageDialog(parentPanel, submessage, subtitle, JOptionPane.ERROR_MESSAGE);
		}
	}

	/**
	 * This classes is a static one to be called by OpenRecentMenuItem.java
	 * 
	 * 
	 * @param netGUI
	 * @param parentPanel
	 * @param folder
	 */
	public static void openSelectedFile(final NetGUI netGUI, final JFrame parentPanel, final File file, final String charsetName) {
		//
		try {
			//
			if (file != null) {
				//
				if (netGUI.isBlank()) {
					//
					netGUI.updateFile(file, charsetName);
				} else {
					//
					PuckGUI.instance().createNetGUI(file, charsetName);
				}

				//
				PuckGUI.instance().recentFiles().updateFile(file);
				PuckGUI.instance().recentFolders().updateFolder(file.getParentFile());
			}
		} catch (final PuckException exception) {
			//
			exception.printStackTrace();

			//
			String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");

			//
			String message;
			switch (PuckExceptions.valueOf(exception.getCode())) {
				case FILE_NOT_FOUND:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.fileNotFound");
					JOptionPane.showMessageDialog(parentPanel, message, title, JOptionPane.ERROR_MESSAGE);
				break;
				case BAD_FILE_FORMAT:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.badFileFormat");
					JOptionPane.showMessageDialog(parentPanel, message, title, JOptionPane.ERROR_MESSAGE);
				break;
				case UNSUPPORTED_FILE_FORMAT:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedFileFormat");
					JOptionPane.showMessageDialog(parentPanel, message, title, JOptionPane.ERROR_MESSAGE);
				break;
				case NOT_A_FILE:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.notAFile");
					JOptionPane.showMessageDialog(parentPanel, message, title, JOptionPane.ERROR_MESSAGE);
				break;
				case UNSUPPORTED_ENCODING:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedEncoding");
					JOptionPane.showMessageDialog(parentPanel, message, title, JOptionPane.ERROR_MESSAGE);
				break;
				case FORMAT_CONFLICT:
					openConflictingFile(netGUI, parentPanel, file, charsetName);
				break;
				default:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");
					JOptionPane.showMessageDialog(parentPanel, message, title, JOptionPane.ERROR_MESSAGE);
			}

		} catch (final Exception exception) {
			//
			exception.printStackTrace();

			// Try to load GEDCOM file with long IDs.
			try {
				if (IdShrinker.containsLongId(file)) {
					JOptionPane.showMessageDialog(parentPanel,
							"GEDCOM file with long ids detected.\nWill try to load it with shrinked ids.\nWarning: new file will be created.",
							"GEDCOM Long IDs detected.", JOptionPane.WARNING_MESSAGE);
					File fixedfile = IdShrinker.shrink(file);

					//
					if (netGUI.isBlank()) {
						netGUI.updateFile(fixedfile, charsetName);
					} else {
						PuckGUI.instance().createNetGUI(fixedfile, charsetName);
					}

				} else {
					//
					String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");

					String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");

					//
					JOptionPane.showMessageDialog(parentPanel, message, title, JOptionPane.ERROR_MESSAGE);
				}
			} catch (Exception subException) {
				subException.printStackTrace();

				//
				String subtitle = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");
				String submessage = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");

				//
				JOptionPane.showMessageDialog(parentPanel, submessage, subtitle, JOptionPane.ERROR_MESSAGE);
			}
		}
	}

	/**
	 * 
	 * @param parent
	 * @param netgui
	 * @return
	 */
	public static boolean performSaveAs(final Component parent, final NetGUI netGUI) {
		boolean result;

		// Save As.
		try {
			//
			File targetFile = CorpusSaveFileSelector.showSelectorDialog(parent, netGUI.getFile());

			if (targetFile == null) {
				//
				result = false;

			} else {
				//
				PuckManager.saveNet(targetFile, netGUI.getNet());

				//
				netGUI.setFile(targetFile);

				//
				netGUI.setChanged(false);

				//
				PuckGUI.instance().recentFiles().updateFile(targetFile);
				PuckGUI.instance().recentFolders().updateFolder(targetFile.getParentFile());

				//
				result = true;
			}
		} catch (final PuckException exception) {
			//
			String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.title");

			//
			String message;
			switch (PuckExceptions.valueOf(exception.getCode())) {
				case UNSUPPORTED_FILE_FORMAT:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedFileFormat");
				break;
				case NOT_A_FILE:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.notAFile");
				break;
				case UNSUPPORTED_ENCODING:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedEncoding");
				break;
				default:
					message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.default");
			}

			//
			JOptionPane.showMessageDialog(parent, message, title, JOptionPane.ERROR_MESSAGE);

			//
			result = false;

		} catch (final Exception exception) {
			// Show trace.
			exception.printStackTrace();

			//
			String title = "Error computerum est";
			String message = "Error occured during working: " + exception.getMessage();

			//
			JOptionPane.showMessageDialog(parent, message, title, JOptionPane.ERROR_MESSAGE);

			//
			result = false;
		}

		//
		return result;
	}

	/**
	 * 
	 * 
	 * @param netGUI
	 * @param parentPanel
	 * @param folder
	 */
	public static File selectDATFileToLoad(final Component parentPanel, final File targetFile) {
		File result;

		//
		JFileChooser chooser = new JFileChooser();

		if ((targetFile != null) && (StringUtils.isNotBlank(targetFile.getAbsolutePath()))) {
			chooser.setSelectedFile(ToolBox.setExtension(targetFile, ".dat"));
		}
		chooser.setDialogTitle("Import DAT");
		chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
		chooser.setAcceptAllFileFilterUsed(false);
		GenericFileFilter defaultFileFilter = new GenericFileFilter("DAT (*.dat)", "dat");
		chooser.addChoosableFileFilter(defaultFileFilter);
		chooser.setFileFilter(defaultFileFilter);

		//
		if (chooser.showOpenDialog(parentPanel) == JFileChooser.APPROVE_OPTION) {
			System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
			System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
			result = chooser.getSelectedFile();
		} else {
			result = null;
		}

		//
		return result;
	}

	/**
	 * This classes is a static one to be called by OpenRecentMenuItem.java
	 * 
	 * 
	 * @param netGUI
	 * @param parentPanel
	 * @param folder
	 */
	public static File selectFile(final JFrame parentPanel, final File folder) {
		File result;

		//
		JFileChooser chooser = new JFileChooser();
		if ((folder != null) && (folder.exists()) && (folder.isDirectory())) {
			chooser.setCurrentDirectory(folder);
		} else if (PuckGUI.instance().recentFolders().isEmpty()) {
			chooser.setCurrentDirectory(new java.io.File("."));
		} else {
			chooser.setCurrentDirectory(PuckGUI.instance().recentFolders().getMoreRecent());
		}

		chooser.setDialogTitle(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.openFileChooser.text"));
		chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
		chooser.setAcceptAllFileFilterUsed(true);
		GenericFileFilter defaultFileFilter = new GenericFileFilter("Genealogic files (*.ged, *.ods, *.paj, *.pl, *.puc, *.tip, *.txt, *.xls, *.xml)", "ged",
				"ods", "paj", "pl", "puc", "tip", "txt", "xls", "xml");
		chooser.addChoosableFileFilter(defaultFileFilter);
		chooser.addChoosableFileFilter(new GenericFileFilter("GEDCOM (*.ged)", "ged"));
		chooser.addChoosableFileFilter(new GenericFileFilter("OpenDocumentFormat Spreadsheet (*.ods)", "ods"));
		chooser.addChoosableFileFilter(new GenericFileFilter("Pajek Network (*.paj)", "paj"));
		chooser.addChoosableFileFilter(new GenericFileFilter("Prolog (*.pl)", "pl"));
		chooser.addChoosableFileFilter(new GenericFileFilter("PUCK (*.puc)", "puc"));
		chooser.addChoosableFileFilter(new GenericFileFilter("TIP (*.tip)", "tip"));
		chooser.addChoosableFileFilter(new GenericFileFilter("Text BAR/IUR (*.txt)", "txt"));
		chooser.addChoosableFileFilter(new GenericFileFilter("Microsoft Excel (*.xls)", "xls"));
		chooser.addChoosableFileFilter(new GenericFileFilter("Extensible Markup Language (*.xml)", "xml"));
		chooser.setFileFilter(defaultFileFilter);

		//
		if (chooser.showOpenDialog(parentPanel) == JFileChooser.APPROVE_OPTION) {
			System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
			System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
			result = chooser.getSelectedFile();
		} else {
			logger.debug("No Selection ");
			result = null;
		}

		//
		return result;
	}

	/**
	 * This classes is a static one to be called by OpenRecentMenuItem.java
	 * 
	 * 
	 * @param netGUI
	 * @param parentPanel
	 * @param folder
	 */
	public static File selectFolder(final JFrame parentPanel, final File folder) {
		File result;

		//
		JFileChooser chooser = new JFileChooser();
		if ((folder != null) && (folder.exists()) && (folder.isDirectory())) {
			chooser.setCurrentDirectory(folder);
		} else if (PuckGUI.instance().recentFolders().isEmpty()) {
			chooser.setCurrentDirectory(new java.io.File("."));
		} else {
			chooser.setCurrentDirectory(PuckGUI.instance().recentFolders().getMoreRecent());
		}

		chooser.setDialogTitle(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.openFileChooser.text"));
		chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		chooser.setAcceptAllFileFilterUsed(true);

		//
		if (chooser.showOpenDialog(parentPanel) == JFileChooser.APPROVE_OPTION) {
			System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
			System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
			result = chooser.getSelectedFile();
		} else {
			logger.debug("No Selection ");
			result = null;
		}

		//
		return result;
	}

	/**
	 * 
	 * 
	 * @param netGUI
	 * @param parentPanel
	 * @param folder
	 */
	public static File selectRelationModelFileToLoad(final Component parentPanel, final File targetFile) {
		File result;

		//
		JFileChooser chooser = new JFileChooser();

		if ((targetFile != null) && (StringUtils.isNotBlank(targetFile.getAbsolutePath()))) {
			chooser.setSelectedFile(ToolBox.setExtension(targetFile, ".txt"));
		}
		chooser.setDialogTitle("Import Relation Model");
		chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
		chooser.setAcceptAllFileFilterUsed(false);
		GenericFileFilter defaultFileFilter = new GenericFileFilter("TXT (*.txt)", "txt");
		chooser.addChoosableFileFilter(defaultFileFilter);
		chooser.setFileFilter(defaultFileFilter);

		//
		if (chooser.showOpenDialog(parentPanel) == JFileChooser.APPROVE_OPTION) {
			System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
			System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
			result = chooser.getSelectedFile();
		} else {
			result = null;
		}

		//
		return result;
	}

	/**
	 * 
	 * 
	 * @param netGUI
	 * @param parentPanel
	 * @param folder
	 */
	public static File selectSelzFileToLoad(final Component parentPanel, final File targetFile) {
		File result;

		//
		JFileChooser chooser = new JFileChooser();

		if ((targetFile != null) && (StringUtils.isNotBlank(targetFile.getAbsolutePath()))) {
			chooser.setSelectedFile(ToolBox.setExtension(targetFile, ".txt"));
		}
		chooser.setDialogTitle("Import Selz");
		chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
		chooser.setAcceptAllFileFilterUsed(false);
		GenericFileFilter defaultFileFilter = new GenericFileFilter("Selz files (*.ods, *.txt, *.xls)", "ods", "txt", "xls");
		chooser.addChoosableFileFilter(defaultFileFilter);
		chooser.addChoosableFileFilter(new GenericFileFilter("OpenDocumentFormat Spreadsheet (*.ods)", "ods"));
		chooser.addChoosableFileFilter(new GenericFileFilter("Text (*.txt)", "txt"));
		chooser.addChoosableFileFilter(new GenericFileFilter("Microsoft Excel (*.xls)", "xls"));
		chooser.setFileFilter(defaultFileFilter);

		//
		if (chooser.showOpenDialog(parentPanel) == JFileChooser.APPROVE_OPTION) {
			logger.debug("getCurrentDirectory(): {}", chooser.getCurrentDirectory());
			logger.debug("getSelectedFile(): {}", chooser.getSelectedFile());
			result = chooser.getSelectedFile();
		} else {
			result = null;
		}

		//
		return result;
	}
}
