package org.tip.puck.spacetime.workers;

import java.util.ResourceBundle;

import org.tip.puck.PuckException;
import org.tip.puck.net.Net;
import org.tip.puck.net.workers.AttributeDescriptors;
import org.tip.puck.net.workers.AttributeWorker;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportList;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.spacetime.Slices;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria.CensusType;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria.SliceGeneralStatistics;
import org.tip.puck.statistics.StatisticsCriteria;

import fr.devinsy.util.StringList;

/**
 * 
 * @author Klaus Hamberger
 * @author TIP
 */
public class SpaceTimeReporter {

	/**
	 * Builds many report from a large criteria object:
	 * 
	 * <ul>
	 * <li>Report - Sequence Report</li>
	 * <li>Report - Slice Report</li>
	 * <li>Analysis - Sequences - General Sequence Statistics</li>
	 * <li>Analysis - Sequences - Trajectories</li>
	 * <li>Analysis - Sequences - Ego-Networks</li>
	 * <li>Analysis - Sequences - Parcours Networks</li>
	 * <li>Analysis - Slices - General Slices Statistics</li>
	 * <li>Analysis - Slices - Trajectories</li>
	 * <li>Analysis - Slices - EgoNetworks</li>
	 * </ul>
	 * 
	 * @param criteria
	 * @return
	 * @throws PuckException
	 */
	public static ReportList reportHugeAnalysis(final Net net, final Segmentation segmentation, final SpaceTimeCriteria criteria, final ResourceBundle bundle)
			throws PuckException {
		ReportList result;

		result = new ReportList();

		if (criteria != null) {
			//
			StringList relationModelNames = net.relationModels().sortedNameList();
			AttributeDescriptors attributeDescriptors = AttributeWorker.getExogenousAttributeDescriptors(segmentation, null);

			//
			if (criteria.isSequenceAnalysis()) {
				//
				
				// Reports
				if (!criteria.getSequenceReportTypes().isEmpty()){
					
					Report sequenceReport = SequenceReporter.reportSequences(net, segmentation, criteria);
					result.add(sequenceReport);

				}
				
				if (!criteria.getSequenceGeneralStatistics().isEmpty()){
					Report sequenceCensusReport = SequenceReporter.reportGeneralSequenceCensus(segmentation, criteria);
					result.add(sequenceCensusReport);
				}
				
				if (!criteria.getEgoNetworksOperations().isEmpty()){
					Report egoNetworkReport = SequenceReporter.reportEgoNetworksCensus(segmentation, criteria);
					result.add(egoNetworkReport);
				}
				
				if (!criteria.getParcoursNetworksOperations().isEmpty()){
					Report parcoursNetworkReport = SequenceReporter.reportParcoursNetworksCensus(segmentation, criteria);
					result.add(parcoursNetworkReport);
				}
				
				if (!criteria.getTrajectoriesOperations().isEmpty()){
					Report trajectoriesReport = SequenceReporter.reportTrajectoriesCensus(segmentation, criteria);
					result.add(trajectoriesReport);

				}
				
				
				
				
				
				

			} else {
				//
				
				StatisticsCriteria statisticsCriteria = new StatisticsCriteria();

				PartitionCriteria placeCriteria = PartitionCriteria.createRaw("BIRT_PLAC");
				placeCriteria.setLabelParameter("Afagnangbleta");

				statisticsCriteria.getPartitionCriterias().add(placeCriteria);
				statisticsCriteria.getPartitionCriterias().add(PartitionCriteria.createSizedGrouping("AGE", null, 0., 20., null));
				statisticsCriteria.getPartitionCriterias().add(PartitionCriteria.createRaw("QUARTER"));
				statisticsCriteria.getPartitionCriterias().add(PartitionCriteria.createRaw("PATRIL"));
				statisticsCriteria.getPartitionCriterias().add(PartitionCriteria.createRaw("OCCU"));
				statisticsCriteria.getPartitionCriterias().add(PartitionCriteria.createRaw("MATRISTATUS"));
				statisticsCriteria.setPlaceParameter("DEPARTMENT");
				
				Slices slices = SliceMaker.createSlices(segmentation, criteria);
				
				if (!criteria.getSliceReportTypes().isEmpty()){
					Report sliceReport = SliceReporter.reportSlices(slices, criteria);
					result.add(sliceReport);
				}
				
				if (criteria.getSliceGeneralStatistics().contains(SliceGeneralStatistics.STATICS)){
					Report sliceStaticsReport = SliceReporter.reportIndividualStatics(slices, statisticsCriteria);
					result.add(sliceStaticsReport);
				}
				
				if (criteria.getSliceGeneralStatistics().contains(SliceGeneralStatistics.DYNAMICS)){
					Report sliceDynamicsReport = SliceReporter.reportIndividualDynamics(slices, statisticsCriteria);
					result.add(sliceDynamicsReport);
				}
				
				if (!criteria.getEgoNetworksOperations().isEmpty()){
					Report egoNetworkReport = SliceReporter.reportEgoNetworks(slices, statisticsCriteria, criteria);
					result.add(egoNetworkReport);
				}
				
				if (!criteria.getTrajectoriesOperations().isEmpty()){
					Report trajectoriesReport = SliceReporter.reportDevelopmentCycles(slices, statisticsCriteria);
					result.add(trajectoriesReport);

				}
				

				
				
				
			}
		}

		//
		return result;
	}

}
