package org.tip.puck.spacetime.workers;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import org.apache.commons.lang3.StringUtils;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.graphs.GraphProfile;
import org.tip.puck.graphs.Node;
import org.tip.puck.io.paj.PAJFile;
import org.tip.puck.matrix.MatrixStatistics.Indicator;
import org.tip.puck.matrix.MatrixStatistics.Mode;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.IndividualComparator.Sorting;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Actors;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.RelationValuator;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.partitions.PartitionCriteria.PartitionType;
import org.tip.puck.partitions.PartitionCriteria.SizeFilter;
import org.tip.puck.partitions.PartitionCriteria.ValueFilter;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportChart;
import org.tip.puck.report.ReportRawData;
import org.tip.puck.report.ReportTable;
import org.tip.puck.report.ReportChart.GraphType;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.spacetime.CorrelationMatrix;
import org.tip.puck.spacetime.Sequence;
import org.tip.puck.spacetime.Slice;
import org.tip.puck.spacetime.Slices;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria.CensusType;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria.RelationClassificationType;
import org.tip.puck.statistics.StatisticsCriteria;
import org.tip.puck.statistics.StatisticsReporter;
import org.tip.puck.util.Chronometer;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.NumberedValues;
import org.tip.puck.util.PuckUtils;
import org.tip.puck.util.ToolBox;
import org.tip.puck.util.Value;

import fr.devinsy.util.StringList;

public class SliceReporter {

	
	private static String getStatus(Slices slices, Individual individual, int time){
		String result;

		result = "";
		Slice slice = slices.getById(time);
		
		if (slice!=null){

			Relation relation = slice.relationsByIndividuals().get(individual);
			
			if (relation!=null){

				if (relation.getAttributeValue(slices.idLabel())!=null){
					result += relation.getAttributeValue(slices.idLabel());
				} else if (relation.getAttributeValue(slices.placeLabel())!=null){
					result += relation.getAttributeValue(slices.placeLabel());
				}
				
				Actors actors = relation.actors().getById(individual.getId());
				if (actors.size()>0){

					Actor actor = actors.get(0);
					
					if (actor.getAttributeValue("MODE")!=null){
						result += " "+actor.getAttributeValue("MODE");
					}

					result+="\t";

					if (actor.getAttributeValue(slices.startDateLabel())!=null){
						result += actor.getAttributeValue(slices.startDateLabel());
					}
					if (actor.getAttributeValue(slices.endDateLabel())!=null){
						result += "-"+actor.getAttributeValue(slices.endDateLabel());
					}
					if (actor.getAttributeValue("NOTE")!=null){
						result += " ["+actor.getAttributeValue("NOTE")+"]";
					}
				}
			}
		}
		
		//
		return result;
	}
	
	public static Report reportSlices(Slices slices, SpaceTimeCriteria criteria){
		Report result;
		
		result = new Report(criteria.getRelationModelName()+" Slices");
				
		StringList list = new StringList();

		for (String houseId : slices.idValues()){
			list.appendln(houseId);
			list.appendln();
			
			List<Individual> members = slices.membersByRelationId().get(houseId).toSortedList(Sorting.BIRT_YEAR);
			for (Individual member : members){
				list.append(member.signature()+" ("+IndividualValuator.lifeStatusAtYear(member, 2015)+")\t");
				for (Integer id : slices.ids()){
					String status = getStatus(slices, member, id);
//					String status = slices.getById(id).statusByIndividuals().get(member);
					if (status!=null){
						list.append(status+"\t");
					} else {
						Integer deathYear = IndividualValuator.getDeathYear(member);
						Integer birthYear = IndividualValuator.getBirthYear(member);
						
						if (deathYear!=null && deathYear<=id){
							list.append("+"+deathYear+"\t\t");
						} else if (birthYear!=null && birthYear>=id){
							list.append("*"+birthYear+"\t\t");
						} else {
							list.append("?\t\t");
						}
					}
				}
				list.appendln();
				
			}
			list.appendln();
		}
		result.outputs().append(list);
		
		//
		return result;
		
	}
	

	public static Report reportDevelopmentCycles(final Slices slices, final StatisticsCriteria criteria) throws PuckException{
			Report result;
			
			if ((slices == null) || (criteria == null)) {
				throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.");
			} else {
				result = new Report("Development Cycles "+slices.relationModelName());
				Chronometer chrono = new Chronometer();
	
				result.setOrigin("Space reporter");
				
				SpaceTimeCriteria censusCriteria = new SpaceTimeCriteria();
				
				censusCriteria.setCensusType(CensusType.PARCOURS);
				censusCriteria.addNetworkTitle("Event Type Network");
				censusCriteria.getMainRelationClassificationTypes().add(RelationClassificationType.TREES);
				censusCriteria.getEventTypes().add(RelationClassificationType.TREES);
				
				for (RelationClassificationType relationClassificationType : censusCriteria.getMainRelationClassificationTypes()){
					censusCriteria.getCensusOperationLabels().add("PROFILE_"+relationClassificationType);
					censusCriteria.getCensusOperationLabels().add("SUPPORT_"+relationClassificationType);
				}
	
				SequencesCensus census = new SequencesCensus(slices.groupSequences(), censusCriteria);
				CensusType censusType = censusCriteria.getCensusType();
				
				// Create Reports
				Report overallReport = new Report("Survey");
				Report diagramReport = new Report("Diagrams");
				Report detailReport = new Report("Details");
				Report componentReport = new Report("Components");
				Report treeReport = new Report("Trees");
						
				// Create Partition charts and tables
				List<ReportChart> charts = new ArrayList<ReportChart>();
				List<ReportTable> tables = new ArrayList<ReportTable>();
					
				// Make overall report and diagrams
				overallReport.outputs().appendln("Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");
	
				// Set partition criteria 
				for (String label : censusCriteria.getCensusOperationLabels()){
					
					PartitionCriteria partitionCriteria = new PartitionCriteria(label);
					
					ReportChart chart = null;
					
					if (!label.contains("ALTERS") && !label.contains("PROFILE")){
						NumberedValues values = census.getValues(label);
						
						Partition<Relation> partition = PartitionMaker.create(label, slices.relations(slices.ids().get(0)), values, partitionCriteria);
					
						PartitionCriteria splitCriteria = new PartitionCriteria(censusCriteria.getPartitionLabel());
						chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, null);
	
						overallReport.outputs().append(label+"\t");
							String sum = "";
							if (label.startsWith("NR")){
								sum = new Double(values.sum()).intValue()+"";
							}
							overallReport.outputs().append(MathUtils.round(values.average(),2)+"\t"+MathUtils.round(values.averagePositives(),2)+"\t"+values.median()+"\t"+values.max()+"\t"+sum+"\t");
						overallReport.outputs().appendln();
						
					}
				
					if (chart != null) {
						charts.add(chart);
							ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
							tables.add(table);
							if (!label.contains("EVENTS_") && !label.contains("RELATIONS")){
								tables.add(ReportTable.normalize(table));
							}
	
					}
				
				}
				overallReport.outputs().appendln();
				
				// Create detailed report
				detailReport.outputs().append("Nr\tEgo\tGender");
				for (String partitionLabel : censusCriteria.getCensusOperationLabels()){
						detailReport.outputs().append("\t"+partitionLabel);
				}
				
				detailReport.outputs().appendln();
				for (Sequence sequence: slices.groupSequences()){
					
					Individual ego = sequence.getEgo();
					
					if ((((censusType==CensusType.GENERAL) || (censusType==CensusType.PARCOURS)))) {
						detailReport.outputs().append(ego.getId()+"\t"+ego);
						for (String label : censusCriteria.getCensusOperationLabels()){
							if (label.contains("SIMILARITY")){
								Value value = census.getValues(label).get(ego.getId());
								Map<Value,Double[]> indiSimilaritiesMap = (Map<Value,Double[]>)value.mapValue();
								String[] keys = new String[]{"PARENT","CHILD","SIBLING","SPOUSE"};
								for (String key : keys){
									Double[] sim = indiSimilaritiesMap.get(new Value(key));
									if (sim!=null){
										detailReport.outputs().append("\t"+MathUtils.round(sim[4], 2));
									}
								}
							} else {
								detailReport.outputs().append("\t"+census.getValues(label).get(ego.getId()));
							}
						}
						detailReport.outputs().appendln();
					}
					
				}
				
				
				// SequenceAnalysis
				
				if (censusType == CensusType.PARCOURS){
					
					for (RelationClassificationType relationClassificationType : censusCriteria.getMainRelationClassificationTypes()){
						
						if (censusCriteria.getNetworkTitles().contains("Event Type Network")){
	
							CorrelationMatrix eventSequenceMatrix = census.getEventSequenceMatrix(relationClassificationType.toString());
							
							if (eventSequenceMatrix!=null){
								eventSequenceMatrix.setUngendered(true);
								for (ReportChart chart : eventSequenceMatrix.getCharts()){
									charts.add(chart);
								}
								tables.add(eventSequenceMatrix.getTable("Event Type Sequences"));
							}
							
							overallReport.outputs().appendln();
							overallReport.outputs().appendln("Sequence Network Statistics "+relationClassificationType);
							overallReport.outputs().appendln("\tDensity\tInertia\t(Divergence)\tConcentration\t(Divergence)\tSymmetry\t(Divergence)\tCentral nodes");
							
							for (Gender gender : Gender.values()){
								GraphProfile<Cluster<String>> profile = eventSequenceMatrix.getProfile(gender);
	
								String centralReferents = "";
								for (Cluster<String> centralReferent : profile.getCentralReferents()){
									centralReferents+=centralReferent.getValue()+" ";
								}
								double maxBetweenness = profile.getMaxBetweenness();
								double density = profile.density();
								double endo = MathUtils.round(profile.getStatistics(Indicator.LOOPS, Mode.NORMALIZED),2);
								double endoExp = MathUtils.round(profile.getStatistics(Indicator.LOOPS, Mode.DIVERGENCE_NORMALIZED),2);
								double conc = MathUtils.round(profile.getStatistics(Indicator.CONCENTRATION, Mode.SIMPLE),2);
								double concExp = MathUtils.round(profile.getStatistics(Indicator.CONCENTRATION, Mode.DIVERGENCE),2);
								double sym = MathUtils.round(profile.getStatistics(Indicator.SYMMETRY, Mode.SIMPLE),2);
								double symExp = MathUtils.round(profile.getStatistics(Indicator.SYMMETRY, Mode.DIVERGENCE),2);
	
								overallReport.outputs().appendln(gender+"\t"+density+"\t"+endo+"\t"+endoExp+"\t"+conc+"\t"+concExp+"\t"+sym+"\t"+symExp+"\t"+centralReferents +"("+maxBetweenness+") betweenness centrality");
							}
							overallReport.outputs().appendln();
	
						}
						
						if (censusCriteria.getNetworkTitles().contains("Sequence Type Network")){
	
							CorrelationMatrix subSequenceMatrix = census.getSubSequenceMatrix(relationClassificationType.toString());
							
							if (subSequenceMatrix!=null){
								charts.add(subSequenceMatrix.getRamificationChart());
							}
						}
						
						
	//					reportSequencePartition(overallReport,"",census.getEventPartition(eventTypeName),census.getEventPairPartition(eventTypeName),census.nrSequences(),census.nrEvents());
	//					reportSequenceTree(treeReport,"",census.getSequenceTypeNetwork(eventTypeName));
						
		/*				int maxPositions = census.getNrValues(eventType,eventType.toString());
								
						ReportChart diversityChart = StatisticsReporter.createDiversityChart(census.getDepthPartition(eventType.toString()), maxPositions);
						charts.add(diversityChart);*/
					}
				}
				
				// Manage the number of chart by line.
				for (int chartIndex = 0; chartIndex < charts.size(); chartIndex++) {
					diagramReport.outputs().append(charts.get(chartIndex));
					if (chartIndex % 4 == 3) {
						diagramReport.outputs().appendln();
					}
				}
				
				// Add chart tables.
				for (ReportTable table : tables) {
					diagramReport.outputs().appendln(table.getTitle());
					diagramReport.outputs().appendln(table);
				}
				
				// Finalize reports
				result.outputs().append(overallReport);
				result.outputs().append(diagramReport);
				result.outputs().append(detailReport);
				
				if (censusType == CensusType.EGONETWORKS || censusType ==CensusType.PARCOURSNETWORKS){
					result.outputs().append(componentReport);
				}
				if (censusType == CensusType.PARCOURS) {
					result.outputs().append(treeReport);
				}
				
				//addPajekData
				
				Map<String,StringList> pajekBuffers = census.getPajekBuffers();
				
				for (String title : pajekBuffers.keySet()){
					
					StringList pajekBuffer = pajekBuffers.get(title);
					if (pajekBuffer.length() != 0) {
						File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(slices.relationModelName()), "-"+title), ".paj");
						ReportRawData rawData = new ReportRawData("Export "+title+"s to Pajek", "Pajek", "paj", targetFile);
						rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));
	
						result.outputs().appendln();
						result.outputs().append(rawData);
					}
				}
	
							
				
				result.setTimeSpent(chrono.stop().interval());
	
			}
				
	
			
			//
			return result;
		}

	public static Report reportIndividualStatics(final Slices slices, final StatisticsCriteria criteria) throws PuckException{
			Report result;
			
			if (criteria == null) {
				throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.");
			} else {
				result = new Report("Population Statics "+slices.relationModelName());
				Chronometer chrono = new Chronometer();
	
				result.setOrigin("Relation reporter");
	//			result.setTarget(spaces.getLabel());
	
				// Compute charts and tables.
				for (PartitionCriteria partitionCriteria : criteria.getPartitionCriterias()) {
	
					if (StringUtils.isEmpty(partitionCriteria.getLabel())) {
						continue;
					}
	
					List<ReportChart> charts = new ArrayList<ReportChart>(20);
					List<ReportTable> tables = new ArrayList<ReportTable>(20);
	
					for (Integer time : slices.ids()){
						
						if (partitionCriteria.getLabel().equals("AGE") || partitionCriteria.getLabel().equals("MATRISTATUS")){
							partitionCriteria.setLabelParameter(time+"");
						}
						
						Relations relations = slices.relations(time);
						String label = slices.relationModelName()+" "+time;
	
						//
						Partition<Individual> partition = PartitionMaker.create(label, relations.getIndividuals(), relations, partitionCriteria);
	
						ReportChart chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, criteria.getSplitCriteria());
						charts.add(chart);
						
						ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
						tables.add(table);
	
					}
					
					int nr = Math.min(4, slices.size());
					
					// Manage the number of chart by line.
					for (int chartIndex = 0; chartIndex < charts.size(); chartIndex++) {
						result.outputs().append(charts.get(chartIndex));
						if (chartIndex % nr == nr-1) {
							result.outputs().appendln();
						}
					}
	
					// Add chart tables.
					for (ReportTable table : tables) {
						result.outputs().appendln(table);
					}
				}
	
				result.setTimeSpent(chrono.stop().interval());
			}
	
			//
			return result;
		}
	
	public static Report reportEgoNetworks (Slices slices, final StatisticsCriteria criteria, final SpaceTimeCriteria censusCriteria) throws PuckException{
		Report result;
		
		if ((slices == null) || (criteria == null)) {
			throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.");
		} else {
			result = new Report("Ego Networks "+slices.relationModelName());
			Chronometer chrono = new Chronometer();

			result.setOrigin("Space reporter");
			
			SequencesCensus census = new SequencesCensus(slices.indiSequences(), censusCriteria);
			Individuals members = slices.members();
			
			// Create Reports
			Report overallReport = new Report("Survey");
			Report diagramReport = new Report("Diagrams");
			Report detailReport = new Report("Details");
			Report componentReport = new Report("Components");
					
			// Create Partition charts and tables
			List<ReportChart> charts = new ArrayList<ReportChart>();
			List<ReportTable> tables = new ArrayList<ReportTable>();
				
			// Make overall report and diagrams
			overallReport.outputs().appendln("Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");

			// Set partition criteria 
			for (String label : censusCriteria.getCensusOperationLabels()){
				
				PartitionCriteria partitionCriteria = new PartitionCriteria(label);
				
				ReportChart chart = null;
				
				if (!label.contains("ALTERS") && !label.contains("PROFILE")){
					NumberedValues values = census.getValues(label);
					
					Partition<Relation> partition = PartitionMaker.create(label, slices.relations(slices.ids().get(0)), values, partitionCriteria);
				
					PartitionCriteria splitCriteria = new PartitionCriteria(censusCriteria.getPartitionLabel());
					chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, null);

					overallReport.outputs().append(label+"\t");
					String sum = "";
					if (label.startsWith("NR")){
						sum = new Double(values.sum()).intValue()+"";
					}
					overallReport.outputs().append(MathUtils.round(values.average(),2)+"\t"+MathUtils.round(values.averagePositives(),2)+"\t"+values.median()+"\t"+values.max()+"\t"+sum+"\t");
					overallReport.outputs().appendln();
				}
			
				if (chart != null) {
					charts.add(chart);
					ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
					tables.add(table);
					if (!label.contains("EVENTS_") && !label.contains("RELATIONS")){
						tables.add(ReportTable.normalize(table));
					}
				}
			}
		
			overallReport.outputs().appendln();
		
			
		// Make overall report and diagrams
		overallReport.outputs().appendln("Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");

		// Set partition criteria 
		for (String label : censusCriteria.getCensusOperationLabels()){
			
			PartitionCriteria partitionCriteria = new PartitionCriteria(label);
//			partitionCriteria.setValueFilter(ValueFilter.NULL);
			
/*			if (label.contains("PROFILE")){
				partitionCriteria.setType(PartitionType.PARTIALIZATION);
			} */
			
			if (label.equals("NREVENTS")){
				partitionCriteria.setType(PartitionType.RAW);
//				partitionCriteria.setCumulationType(CumulationType.DESCENDANT);
			} else if (label.contains("AGEFIRST")){
				partitionCriteria.setType(PartitionType.SIZED_GROUPING);
				partitionCriteria.setStart(0.);
				partitionCriteria.setSize(5.);
			} else if (label.equals("ECCENTRICITY")){
				partitionCriteria.setType(PartitionType.SIZED_GROUPING);
				partitionCriteria.setStart(-100.);
				partitionCriteria.setSize(20.);
			} else if (label.contains("COVERAGE") || label.contains("SAME")|| label.contains("NORM")|| label.contains("DENSITY")|| label.contains("BETWEENNESS") || label.contains("EFFICIENCY")|| label.contains("CONCENTRATION")){
				partitionCriteria.setType(PartitionType.SIZED_GROUPING);
				partitionCriteria.setStart(0.);
				partitionCriteria.setSize(20.);
			} else if (label.contains("MEAN") || label.contains("COVERAGE") || label.contains("PEREVENT") || label.contains("BETWEENNESS")|| label.contains("BROKERAGE")|| label.contains("EFFICIENT_SIZE")){
				partitionCriteria.setType(PartitionType.SIZED_GROUPING);
				partitionCriteria.setStart(0.);
				partitionCriteria.setSize(1.);
			} else {
				partitionCriteria.setType(PartitionType.RAW);
			}
			
			ReportChart chart = null;
			
			if (!label.contains("ALTERS") && !label.contains("PROFILE")){
				NumberedValues values = census.getValues(label);
				
				Partition<Individual> partition = PartitionMaker.create(label, members, values, partitionCriteria);
			
				PartitionCriteria splitCriteria = new PartitionCriteria(censusCriteria.getPartitionLabel());
				chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, splitCriteria);

				if (label.substring(0, 3).equals("AGE")){
					
					partitionCriteria.setType(PartitionType.RAW);
					partitionCriteria.setSizeFilter(SizeFilter.HOLES);
					partitionCriteria.setValueFilter(ValueFilter.NULL);
				
					partition = PartitionMaker.create(label, members, values, partitionCriteria);
					
					if (partition.maxValue()!=null){
						ReportChart survivalChart = StatisticsReporter.createSurvivalChart(partition, splitCriteria);
						charts.add(survivalChart);
					} else {
						System.err.println(label+" no max value");
					}
				}
				
				NumberedValues[] genderedValues = PuckUtils.getGenderedNumberedValues(values, members);
				
				overallReport.outputs().append(label+"\t");
				for (int gender=0;gender<3;gender++){
					String sum = "";
					if (label.startsWith("NR")){
						sum = new Double(genderedValues[gender].sum()).intValue()+"";
					}
					overallReport.outputs().append(MathUtils.round(genderedValues[gender].average(),2)+"\t"+MathUtils.round(genderedValues[gender].averagePositives(),2)+"\t"+values.median()+"\t"+genderedValues[gender].max()+"\t"+sum+"\t");
				}
				overallReport.outputs().appendln();
				
			}
		
			if (chart != null) {
				charts.add(chart);
					ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
					tables.add(table);
					if (!label.contains("EVENTS_") && !label.contains("RELATIONS")){
						tables.add(ReportTable.normalize(table));
					}
				

			}
		
		}
		overallReport.outputs().appendln();
		
		// Create detailed report
		detailReport.outputs().append("Nr\tEgo\tGender");
		for (String partitionLabel : censusCriteria.getCensusOperationLabels()){
				detailReport.outputs().append("\t"+partitionLabel);
		}
		
		Map<String,Map<String,Double>> componentChartMap = new TreeMap<String,Map<String,Double>>();
		
		detailReport.outputs().appendln();
		for (Individual ego : members.toSortedList()){
						
			if (census.getValues("SIZE").get(ego.getId())!=null) {
				detailReport.outputs().append(ego.getId()+"\t"+ego+"\t"+ego.getGender());
				for (String label : censusCriteria.getCensusOperationLabels()){
						detailReport.outputs().append("\t"+census.getValues(label).get(ego.getId()));
				}
				detailReport.outputs().appendln();
			}
							
				for (String networkTitle : censusCriteria.getNetworkTitles()){
					Map<Integer,Partition<Node<Individual>>> componentsMap = census.getComponents(networkTitle);
					if (componentsMap!=null){
						Partition<Node<Individual>> components = componentsMap.get(ego.getId());
						
						componentReport.outputs().appendln("Components "+networkTitle);
						componentReport.outputs().appendln(ego+"\t"+components.size());
						int i=1;
						for (Cluster<Node<Individual>> cluster : components.getClusters().toListSortedByValue()){
							componentReport.outputs().appendln("\t"+i+"\t"+cluster.getValue()+"\t("+cluster.size()+")\t"+cluster.getItemsAsString());
							i++;
						}
						componentReport.outputs().appendln();
						
						for (Value value : components.getValues()){
							String label = value.toString();
							Map<String,Double> map = componentChartMap.get(label);
							if (map==null){
								map = new TreeMap<String,Double>();
								for (Gender gender : Gender.values()){
									map.put(gender.toString(), 0.);
								}
								componentChartMap.put(label, map);
							}
							map.put(ego.getGender().toString(), map.get(ego.getGender().toString())+1);
						}
					}
				}
			}
		
		
			ReportChart componentChart = StatisticsReporter.createChart("COMPONENTS", componentChartMap);
			charts.add(componentChart);
			tables.add(ReportTable.transpose(componentChart.createReportTableWithSum()));
		
			if (census.getRelationConnectionMatrix()!=null){
				for (ReportChart chart : census.getRelationConnectionMatrix().getCharts()){
					charts.add(chart);
				}
				tables.add(census.getRelationConnectionMatrix().getTable("Component Connections"));
			}
		
		
		// Manage the number of chart by line.
		for (int chartIndex = 0; chartIndex < charts.size(); chartIndex++) {
			diagramReport.outputs().append(charts.get(chartIndex));
			if (chartIndex % 4 == 3) {
				diagramReport.outputs().appendln();
			}
		}
		
		// Add chart tables.
		for (ReportTable table : tables) {
			diagramReport.outputs().appendln(table.getTitle());
			diagramReport.outputs().appendln(table);
		}
		
		// Finalize reports
		result.outputs().append(overallReport);
		result.outputs().append(diagramReport);
		result.outputs().append(detailReport);
		
		result.outputs().append(componentReport);
		
		//addPajekData
		
		Map<String,StringList> pajekBuffers = census.getPajekBuffers();
		
		for (String title : pajekBuffers.keySet()){
			
			StringList pajekBuffer = pajekBuffers.get(title);
			if (pajekBuffer.length() != 0) {
				File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(slices.relationModelName()), "-"+title), ".paj");
				ReportRawData rawData = new ReportRawData("Export "+title+"s to Pajek", "Pajek", "paj", targetFile);
				rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));

				result.outputs().appendln();
				result.outputs().append(rawData);
			}
		}
		

		//
		result.setTimeSpent(chrono.stop().interval());
		}

		//
		return result;
	}

	
	public static Report reportEgoNetworks (Slices slices, final StatisticsCriteria criteria) throws PuckException{
		Report result;
		
		if ((slices == null) || (criteria == null)) {
			throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.");
		} else {
			result = new Report("Ego Networks "+slices.relationModelName());
			Chronometer chrono = new Chronometer();

			result.setOrigin("Space reporter");
			
			SpaceTimeCriteria censusCriteria = new SpaceTimeCriteria(CensusType.EGONETWORKS);
			censusCriteria.setRelationModelName("RESIDENCE");
			censusCriteria.setEgoRoleName("RESIDENT");
			censusCriteria.setAlterFilterRoleName("ALL");


			SequencesCensus census = new SequencesCensus(slices.indiSequences(), censusCriteria);
			CensusType censusType = censusCriteria.getCensusType();
			Individuals members = slices.members();
			
			// Create Reports
			Report overallReport = new Report("Survey");
			Report diagramReport = new Report("Diagrams");
			Report detailReport = new Report("Details");
			Report componentReport = new Report("Components");
			Report treeReport = new Report("Trees");
					
			// Create Partition charts and tables
			List<ReportChart> charts = new ArrayList<ReportChart>();
			List<ReportTable> tables = new ArrayList<ReportTable>();
				
			// Make overall report and diagrams
			overallReport.outputs().appendln("Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");

			// Set partition criteria 
			for (String label : censusCriteria.getCensusOperationLabels()){
				
				PartitionCriteria partitionCriteria = new PartitionCriteria(label);
				
				ReportChart chart = null;
				
				if (!label.contains("ALTERS") && !label.contains("PROFILE")){
					NumberedValues values = census.getValues(label);
					
					Partition<Relation> partition = PartitionMaker.create(label, slices.relations(slices.ids().get(0)), values, partitionCriteria);
				
					PartitionCriteria splitCriteria = new PartitionCriteria(censusCriteria.getPartitionLabel());
					chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, null);

					overallReport.outputs().append(label+"\t");
					String sum = "";
					if (label.startsWith("NR")){
						sum = new Double(values.sum()).intValue()+"";
					}
					overallReport.outputs().append(MathUtils.round(values.average(),2)+"\t"+MathUtils.round(values.averagePositives(),2)+"\t"+values.median()+"\t"+values.max()+"\t"+sum+"\t");
					overallReport.outputs().appendln();
				}
			
				if (chart != null) {
					charts.add(chart);
					ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
					tables.add(table);
					if (!label.contains("EVENTS_") && !label.contains("RELATIONS")){
						tables.add(ReportTable.normalize(table));
					}
				}
			}
		
			overallReport.outputs().appendln();
		
			
		// Make overall report and diagrams
		overallReport.outputs().appendln("Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");

		// Set partition criteria 
		for (String label : censusCriteria.getCensusOperationLabels()){
			
			PartitionCriteria partitionCriteria = new PartitionCriteria(label);
//			partitionCriteria.setValueFilter(ValueFilter.NULL);
			
/*			if (label.contains("PROFILE")){
				partitionCriteria.setType(PartitionType.PARTIALIZATION);
			} */
			
			if (label.equals("NREVENTS")){
				partitionCriteria.setType(PartitionType.RAW);
//				partitionCriteria.setCumulationType(CumulationType.DESCENDANT);
			} else if (label.contains("AGEFIRST")){
				partitionCriteria.setType(PartitionType.SIZED_GROUPING);
				partitionCriteria.setStart(0.);
				partitionCriteria.setSize(5.);
			} else if (label.equals("ECCENTRICITY")){
				partitionCriteria.setType(PartitionType.SIZED_GROUPING);
				partitionCriteria.setStart(-100.);
				partitionCriteria.setSize(20.);
			} else if (label.contains("COVERAGE") || label.contains("SAME")|| label.contains("NORM")|| label.contains("DENSITY")|| label.contains("BETWEENNESS") || label.contains("EFFICIENCY")|| label.contains("CONCENTRATION")){
				partitionCriteria.setType(PartitionType.SIZED_GROUPING);
				partitionCriteria.setStart(0.);
				partitionCriteria.setSize(20.);
			} else if (label.contains("MEAN") || label.contains("COVERAGE") || label.contains("PEREVENT") || label.contains("BETWEENNESS")|| label.contains("BROKERAGE")|| label.contains("EFFICIENT_SIZE")){
				partitionCriteria.setType(PartitionType.SIZED_GROUPING);
				partitionCriteria.setStart(0.);
				partitionCriteria.setSize(1.);
			} else {
				partitionCriteria.setType(PartitionType.RAW);
			}
			
			ReportChart chart = null;
			
			if (label.contains("SIMILARITY")){
				RelationClassificationType relationClassificationType = RelationClassificationType.valueOf(label.substring(label.lastIndexOf("_")+1));
				Map<Value,Double[]> similaritiesMap = census.getSimilaritiesMap(relationClassificationType);
				chart = StatisticsReporter.createMapChart(similaritiesMap, label, new String[]{"HH", "FH", "HF", "FF","All"},GraphType.LINES);
				
				for (Value key : similaritiesMap.keySet()){
					overallReport.outputs().appendln(label+"_"+key+"\t"+MathUtils.percent(similaritiesMap.get(key)[4],100));
				}
				
				
			} else if (!label.contains("ALTERS") && !label.contains("PROFILE")){
				NumberedValues values = census.getValues(label);
				
				Partition<Individual> partition = PartitionMaker.create(label, members, values, partitionCriteria);
			
				PartitionCriteria splitCriteria = new PartitionCriteria(censusCriteria.getPartitionLabel());
				chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, splitCriteria);

				if (label.substring(0, 3).equals("AGE")){
					
					partitionCriteria.setType(PartitionType.RAW);
					partitionCriteria.setSizeFilter(SizeFilter.HOLES);
					partitionCriteria.setValueFilter(ValueFilter.NULL);
				
					partition = PartitionMaker.create(label, members, values, partitionCriteria);
					
					if (partition.maxValue()!=null){
						ReportChart survivalChart = StatisticsReporter.createSurvivalChart(partition, splitCriteria);
						charts.add(survivalChart);
					} else {
						System.err.println(label+" no max value");
					}
				}
				
				NumberedValues[] genderedValues = PuckUtils.getGenderedNumberedValues(values, members);
				
				overallReport.outputs().append(label+"\t");
				for (int gender=0;gender<3;gender++){
					String sum = "";
					if (label.startsWith("NR")){
						sum = new Double(genderedValues[gender].sum()).intValue()+"";
					}
					overallReport.outputs().append(MathUtils.round(genderedValues[gender].average(),2)+"\t"+MathUtils.round(genderedValues[gender].averagePositives(),2)+"\t"+values.median()+"\t"+genderedValues[gender].max()+"\t"+sum+"\t");
				}
				overallReport.outputs().appendln();
				
			}
		
			if (chart != null) {
				charts.add(chart);
				if (label.equals("SIMILARITY")){
					tables.add(ReportTable.transpose(chart.createReportTable()));
				} else {
					ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
					tables.add(table);
					if (!label.contains("EVENTS_") && !label.contains("RELATIONS")){
						tables.add(ReportTable.normalize(table));
					}
				}

			}
		
		}
		overallReport.outputs().appendln();
		
		// Create detailed report
		detailReport.outputs().append("Nr\tEgo\tGender");
		for (String partitionLabel : censusCriteria.getCensusOperationLabels()){
			if (partitionLabel.contains("SIMILARITY")){
				RelationClassificationType relationClassificationType = RelationClassificationType.valueOf(partitionLabel.substring(partitionLabel.lastIndexOf("_")+1));
				detailReport.outputs().append("\tSIMILARITY_PARENT_"+relationClassificationType+"\tSIMILARITY_CHILD_"+relationClassificationType+"\tSIMILARITY_SIBLING_"+relationClassificationType+"\tSIMILARITY_SPOUSE_"+relationClassificationType);
			} else {
				detailReport.outputs().append("\t"+partitionLabel);
			}
		}
		
		Map<String,Map<String,Double>> componentChartMap = new TreeMap<String,Map<String,Double>>();
		
		detailReport.outputs().appendln();
		for (Individual ego : members.toSortedList()){
			
			if ((((censusType==CensusType.GENERAL) || (censusType==CensusType.PARCOURS) || (censusType==CensusType.PARCOURSNETWORKS) ) && (census.getValues("NREVENTS").get(ego.getId())!=null)) || ((censusType == CensusType.EGONETWORKS) && (census.getValues("SIZE").get(ego.getId())!=null))) {
				detailReport.outputs().append(ego.getId()+"\t"+ego+"\t"+ego.getGender());
				for (String label : censusCriteria.getCensusOperationLabels()){
					if (label.contains("SIMILARITY")){
						Value value = census.getValues(label).get(ego.getId());
						Map<Value,Double[]> indiSimilaritiesMap = (Map<Value,Double[]>)value.mapValue();
						String[] keys = new String[]{"PARENT","CHILD","SIBLING","SPOUSE"};
						for (String key : keys){
							Double[] sim = indiSimilaritiesMap.get(new Value(key));
							if (sim!=null){
								detailReport.outputs().append("\t"+MathUtils.round(sim[4], 2));
							}
						}
					} else {
						detailReport.outputs().append("\t"+census.getValues(label).get(ego.getId()));
					}
				}
				detailReport.outputs().appendln();
			}
			
			if ((censusType==CensusType.EGONETWORKS || censusType ==CensusType.PARCOURSNETWORKS)){
				
				for (String networkTitle : censusCriteria.getNetworkTitles()){
					Map<Integer,Partition<Node<Individual>>> componentsMap = census.getComponents(networkTitle);
					if (componentsMap!=null){
						Partition<Node<Individual>> components = componentsMap.get(ego.getId());
						
						componentReport.outputs().appendln("Components "+networkTitle);
						componentReport.outputs().appendln(ego+"\t"+components.size());
						int i=1;
						for (Cluster<Node<Individual>> cluster : components.getClusters().toListSortedByValue()){
							componentReport.outputs().appendln("\t"+i+"\t"+cluster.getValue()+"\t("+cluster.size()+")\t"+cluster.getItemsAsString());
							i++;
						}
						componentReport.outputs().appendln();
						
						for (Value value : components.getValues()){
							String label = value.toString();
							Map<String,Double> map = componentChartMap.get(label);
							if (map==null){
								map = new TreeMap<String,Double>();
								for (Gender gender : Gender.values()){
									map.put(gender.toString(), 0.);
								}
								componentChartMap.put(label, map);
							}
							map.put(ego.getGender().toString(), map.get(ego.getGender().toString())+1);
						}
					}
				}
			}
		}
		
		if ((censusType==CensusType.EGONETWORKS || censusType ==CensusType.PARCOURSNETWORKS)){
			ReportChart componentChart = StatisticsReporter.createChart("COMPONENTS", componentChartMap);
			charts.add(componentChart);
			tables.add(ReportTable.transpose(componentChart.createReportTableWithSum()));
		
			if (census.getRelationConnectionMatrix()!=null){
				for (ReportChart chart : census.getRelationConnectionMatrix().getCharts()){
					charts.add(chart);
				}
				tables.add(census.getRelationConnectionMatrix().getTable("Component Connections"));
			}
		
		}

		
		// SequenceAnalysis
		
		if (censusType == CensusType.PARCOURS){
			
			for (RelationClassificationType relationClassificationType : censusCriteria.getMainRelationClassificationTypes()){
				
				if (censusCriteria.getNetworkTitles().contains("Event Type Network")){

					CorrelationMatrix eventSequenceMatrix = census.getEventSequenceMatrix(relationClassificationType.toString());
					
					if (eventSequenceMatrix!=null){
						for (ReportChart chart : eventSequenceMatrix.getCharts()){
							charts.add(chart);
						}
						tables.add(eventSequenceMatrix.getTable("Event Type Sequences"));
					}
					
					overallReport.outputs().appendln();
					overallReport.outputs().appendln("Sequence Network Statistics "+relationClassificationType);
					overallReport.outputs().appendln("\tDensity\tInertia\t(Divergence)\tConcentration\t(Divergence)\tSymmetry\t(Divergence)\tCentral nodes");
					
					for (Gender gender : Gender.values()){
						GraphProfile<Cluster<String>> profile = eventSequenceMatrix.getProfile(gender);

						String centralReferents = "";
						for (Cluster<String> centralReferent : profile.getCentralReferents()){
							centralReferents+=centralReferent.getValue()+" ";
						}
						double maxBetweenness = profile.getMaxBetweenness();
						double density = profile.density();
						double endo = MathUtils.round(profile.getStatistics(Indicator.LOOPS, Mode.NORMALIZED),2);
						double endoExp = MathUtils.round(profile.getStatistics(Indicator.LOOPS, Mode.DIVERGENCE_NORMALIZED),2);
						double conc = MathUtils.round(profile.getStatistics(Indicator.CONCENTRATION, Mode.SIMPLE),2);
						double concExp = MathUtils.round(profile.getStatistics(Indicator.CONCENTRATION, Mode.DIVERGENCE),2);
						double sym = MathUtils.round(profile.getStatistics(Indicator.SYMMETRY, Mode.SIMPLE),2);
						double symExp = MathUtils.round(profile.getStatistics(Indicator.SYMMETRY, Mode.DIVERGENCE),2);

						overallReport.outputs().appendln(gender+"\t"+density+"\t"+endo+"\t"+endoExp+"\t"+conc+"\t"+concExp+"\t"+sym+"\t"+symExp+"\t"+centralReferents +"("+maxBetweenness+") betweenness centrality");
					}
					overallReport.outputs().appendln();

				}
				
				if (censusCriteria.getNetworkTitles().contains("Sequence Type Network")){

					CorrelationMatrix subSequenceMatrix = census.getSubSequenceMatrix(relationClassificationType.toString());
					
					if (subSequenceMatrix!=null){
						charts.add(subSequenceMatrix.getRamificationChart());
					}
				}
			}
		}
		
		// Manage the number of chart by line.
		for (int chartIndex = 0; chartIndex < charts.size(); chartIndex++) {
			diagramReport.outputs().append(charts.get(chartIndex));
			if (chartIndex % 4 == 3) {
				diagramReport.outputs().appendln();
			}
		}
		
		// Add chart tables.
		for (ReportTable table : tables) {
			diagramReport.outputs().appendln(table.getTitle());
			diagramReport.outputs().appendln(table);
		}
		
		// Finalize reports
		result.outputs().append(overallReport);
		result.outputs().append(diagramReport);
		result.outputs().append(detailReport);
		
		if (censusType == CensusType.EGONETWORKS || censusType ==CensusType.PARCOURSNETWORKS){
			result.outputs().append(componentReport);
		}
		if (censusType == CensusType.PARCOURS) {
			result.outputs().append(treeReport);
		}
		
		//addPajekData
		
		Map<String,StringList> pajekBuffers = census.getPajekBuffers();
		
		for (String title : pajekBuffers.keySet()){
			
			StringList pajekBuffer = pajekBuffers.get(title);
			if (pajekBuffer.length() != 0) {
				File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(slices.relationModelName()), "-"+title), ".paj");
				ReportRawData rawData = new ReportRawData("Export "+title+"s to Pajek", "Pajek", "paj", targetFile);
				rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));

				result.outputs().appendln();
				result.outputs().append(rawData);
			}
		}
		

		//
		result.setTimeSpent(chrono.stop().interval());
		}

		//
		return result;
	}


	public static Report reportIndividualDynamics(final Slices slices, final StatisticsCriteria criteria) throws PuckException{
			Report result;
			
			if ((slices == null) || (criteria == null)) {
				throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.");
			} else {
				result = new Report("Population Dynamics "+slices.relationModelName());
				Chronometer chrono = new Chronometer();
	
				result.setOrigin("Space reporter");
				
				List<Integer> times = slices.ids();
				
				List<ReportChart> charts = new ArrayList<ReportChart>(20);
				List<ReportTable> tables = new ArrayList<ReportTable>(20);
	
				for (int i=0;i<times.size()-1;i++){
					
					int startTime = times.get(i);
					int endTime = times.get(i+1);
					
					Relations totalStartSpace = slices.allRelations(startTime);
					Relations totalEndSpace = slices.allRelations(endTime);
					Relations filteredStartSpace = slices.relations(startTime);
					Relations filteredEndSpace = slices.relations(endTime);
					
					Partition<Individual> partition = new Partition<Individual>();
					partition.setLabel(slices.relationModelName()+" "+startTime+"-"+endTime);
					
					PartitionCriteria partitionCriteria = new PartitionCriteria();
					partitionCriteria.setLabel(partition.getLabel());
					
					Individuals totalStartPopulation = totalStartSpace.getIndividuals();
					Individuals totalEndPopulation = totalEndSpace.getIndividuals();
					Individuals filteredStartPopulation = filteredStartSpace.getIndividuals();
					Individuals filteredEndPopulation = filteredEndSpace.getIndividuals();
					
					// Forward 
					
					Partition<Individual> destinations = new Partition<Individual>();
					destinations.setLabel("Destinations "+startTime+"/"+endTime);
					
					for (Individual individual : filteredStartSpace.getIndividuals().toSortedList()){
						if (IndividualValuator.lifeStatusAtYear(individual, endTime).equals("DEAD")){
							partition.put(individual, new Value("DIED"));
						} else if (!totalEndPopulation.contains(individual)){
							partition.put(individual, new Value("UNKNOWN DESTINATION"));
						} else if (!filteredEndPopulation.contains(individual)){
							partition.put(individual, new Value("LEFT"));
							for (Relation destination : totalEndSpace.getByIndividual(individual)){
								destinations.put(individual,RelationValuator.get(destination,"PLACE",criteria.getPlaceParameter()));
							}
						} else if (!filteredEndSpace.getByIndividual(individual).equals(filteredStartSpace.getByIndividual(individual))){
							partition.put(individual, new Value("INTERNAL CHANGE"));
						} else {
							partition.put(individual, new Value("UNCHANGED"));
						}
					}
					
					// Backward 
					
					Partition<Individual> origins = new Partition<Individual>();
					origins.setLabel("Origins "+startTime+"/"+endTime);
	
					for (Individual individual : filteredEndSpace.getIndividuals().toSortedList()){
						if (IndividualValuator.lifeStatusAtYear(individual, startTime).equals("UNBORN")){
							partition.put(individual, new Value("NEWBORN"));
						} else if (!totalStartPopulation.contains(individual)){
							partition.put(individual, new Value("UNKNOWN ORIGIN"));
						} else if (!filteredStartPopulation.contains(individual)){
							partition.put(individual, new Value("ENTERED"));
							for (Relation origin : totalStartSpace.getByIndividual(individual)){
								origins.put(individual,RelationValuator.get(origin,"PLACE",criteria.getPlaceParameter()));
							}
						} else if (!filteredStartSpace.getByIndividual(individual).equals(filteredEndSpace.getByIndividual(individual))){
	//						partition.put(individual, new Value("INTERNAL CHANGE2"));
						} else {
	//						partition.put(individual, new Value("UNCHANGED2"));
						}
					}
	
					ReportChart chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, criteria.getSplitCriteria());
					charts.add(chart);
					
					ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
					tables.add(table);
					
					ReportChart chartDestinations = StatisticsReporter.createPartitionChart(destinations, partitionCriteria, criteria.getSplitCriteria());
					charts.add(chartDestinations);
					
					ReportTable tableDestinations = ReportTable.transpose(chartDestinations.createReportTableWithSum());
					tables.add(tableDestinations);
					
					ReportChart chartOrigins = StatisticsReporter.createPartitionChart(origins, partitionCriteria, criteria.getSplitCriteria());
					charts.add(chartOrigins);
					
					ReportTable tableOrigins = ReportTable.transpose(chartOrigins.createReportTableWithSum());
					tables.add(tableOrigins);
	
				}
				
				int nr = Math.min(4, 2*times.size());
				
				// Manage the number of chart by line.
				for (int chartIndex = 0; chartIndex < charts.size(); chartIndex++) {
					result.outputs().append(charts.get(chartIndex));
					if (chartIndex % nr == nr-1) {
						result.outputs().appendln();
					}
				}
	
				// Add chart tables.
				for (ReportTable table : tables) {
					result.outputs().appendln(table);
	
				}
				
				result.setTimeSpent(chrono.stop().interval());
			}
	
			//
			return result;
		}
	
	
/*	public static Report reportResidenceSequence(Segmentation segmentation, SpaceTimeCriteria criteria){
		Report result;
		
		Integer[] dates = criteria.getDates();
		String dateLabel = criteria.getDateLabel();
		String idLabel = criteria.getConstantAttributeLabel();
		String modelName = criteria.getRelationModelName();
		String placeLabel = criteria.getPlaceLabel();
		String startDateLabel = criteria.getStartDateLabel();
		String endDateLabel = criteria.getEndDateLabel();
				
		result = new Report(modelName+" Sequence");
		
		Relations relations = segmentation.getAllRelations().getByModelName(modelName);
		
		Slices slices = SliceMaker.createSlices(segmentation, criteria);
		
		Map<Integer,Map<Individual,String>> relationsByIndividuals = new TreeMap<Integer,Map<Individual,String>>();
		Map<Integer,Individuals> relationsByAttributeValues = new TreeMap<Integer,Individuals>();
		
		for (Relation relation : relations){
			
			String dateAsString = relation.getAttributeValue(dateLabel);
			
			if (dateAsString!=null){
	
				Integer date = Integer.parseInt(dateAsString);
				if (relationsByIndividuals.get(date)==null){
					relationsByIndividuals.put(date, new TreeMap<Individual,String>());
				}
				
				for (Actor actor : relation.actors()){
					
					Individual member = actor.getIndividual();
					
					String status = "";
					
					if (relation.getAttributeValue(idLabel)!=null){
						status += relation.getAttributeValue(idLabel);
					} else if (relation.getAttributeValue(placeLabel)!=null){
						status += relation.getAttributeValue(placeLabel);
					}
					if (actor.getAttributeValue("MODE")!=null){
						status += " "+actor.getAttributeValue("MODE");
					}
	
					status+="\t";
	
					if (actor.getAttributeValue(startDateLabel)!=null){
						status += actor.getAttributeValue(startDateLabel);
					}
					if (actor.getAttributeValue(endDateLabel)!=null){
						status += "-"+actor.getAttributeValue(endDateLabel);
					}
					if (actor.getAttributeValue("NOTE")!=null){
						status += " ["+actor.getAttributeValue("NOTE")+"]";
					}
					
					relationsByIndividuals.get(date).put(member, status);
					
					String idValue = relation.getAttributeValue(idLabel);
					if (idValue!=null && Arrays.asList(dates).contains(date)){
						Integer houseId = Integer.parseInt(idValue);
						Individuals individuals = relationsByAttributeValues.get(houseId);
						if (individuals == null){
							individuals = new Individuals();
							relationsByAttributeValues.put(houseId, individuals);
						}
						individuals.put(member);
					}
				}
			}
		}
		
		StringList list = new StringList();
		
		for (Integer houseId : relationsByAttributeValues.keySet()){
			list.appendln(houseId);
			list.appendln();
			
			List<Individual> individuals = relationsByAttributeValues.get(houseId).toSortedList(Sorting.BIRT_YEAR);
			for (Individual individual : individuals){
				list.append(individual.signature()+" ("+IndividualValuator.lifeStatusAtYear(individual, 2015)+")\t");
				for (Integer date : dates){
					String value = relationsByIndividuals.get(date).get(individual);
					if (value!=null){
						list.append(value+"\t");
					} else {
						Integer deathYear = IndividualValuator.getDeathYear(individual);
						Integer birthYear = IndividualValuator.getBirthYear(individual);
						
						if (deathYear!=null && deathYear<=date){
							list.append("+"+deathYear+"\t\t");
						} else if (birthYear!=null && birthYear>=date){
							list.append("*"+birthYear+"\t\t");
						} else {
							list.append("?\t\t");
						}
					}
				}
				list.appendln();
				
			}
			list.appendln();
		}
		result.outputs().append(list);
		
		//
		return result;
		
	}*/

	
	
	
}
