package org.tip.puck.spacetime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.workers.RelationValuator;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria;
import org.tip.puck.util.NumberablesHashMap;
import org.tip.puck.util.Value;

public class Slices extends NumberablesHashMap<Slice> {

	private String idLabel;
	private String dateLabel;
	private String placeLabel;
	private String startDateLabel;
	private String endDateLabel;
	
	Map<String,Individuals> membersByRelationId;
	
	private String relationModelName;
	private Relations relations;
	private Relations allRelations;
	private Sequences groupSequences;
	private Sequences indiSequences;

	public Slices(SpaceTimeCriteria criteria){
		
		membersByRelationId = new TreeMap<String,Individuals>();
		groupSequences = new Sequences();
		indiSequences = new Sequences();

		relationModelName = criteria.getRelationModelName();
		dateLabel = criteria.getDateLabel();
		idLabel = criteria.getLocalUnitLabel();
		placeLabel = criteria.getPlaceLabel();
		startDateLabel = criteria.getStartDateLabel();
		endDateLabel = criteria.getEndDateLabel();

	}
	
	public Slice getByOrdinal(Ordinal ordinal){
		Slice result;
		
		result = null;
		if (ordinal !=null){
			result = getById(ordinal.getYear());
		}
		//
		return result;
		
	}

	public Map<String, Individuals> membersByRelationId() {
		return membersByRelationId;
	}
	
	public List<String> idValues(){
		List<String> result;
		
		result = new ArrayList<String>(membersByRelationId.keySet());
		Collections.sort(result);
		
		//
		return result;
	}
	
	public List<Integer> ids (){
		List<Integer> result;
		
		result = new ArrayList<Integer>(data.keySet());
		Collections.sort(result);
		
		//
		return result;
	}

	public String idLabel() {
		return idLabel;
	}

	public void setIdLabel(String idLabel) {
		this.idLabel = idLabel;
	}

	public String relationModelName() {
		return relationModelName;
	}

	public void setRelationModelName(String relationModelName) {
		this.relationModelName = relationModelName;
	}

	public Relations relations() {
		return relations;
	}

	public void setRelations(Relations relations) {
		this.relations = relations;
	}

	public Relations allRelations() {
		return allRelations;
	}

	public void setAllRelations(Relations allRelations) {
		this.allRelations = allRelations;
	}

	public Sequences groupSequences() {
		return groupSequences;
	}

	public void setGroupSequences(Sequences sequences) {
		this.groupSequences = sequences;
	}
	
	
	
	
	public Sequences indiSequences() {
		return indiSequences;
	}

	public void setIndiSequences(Sequences indiSequences) {
		this.indiSequences = indiSequences;
	}

	public Relations relations(int time){
		Relations result;

		result = null;
		
		Slice slice = getById(time);
		
		if (slice!=null){
			result = slice.relations();
		}
		
		return result;
	}
	
	public Relations allRelations(int time){
		Relations result;
		
		result = new Relations();
		for (Relation relation : allRelations){
			String dateValue = relation.getAttributeValue(dateLabel);
			
			if (StringUtils.isNumeric(dateValue) && Integer.parseInt(dateValue)==time){
				result.put(relation);
			}
		}
		
		//
		return result;
		
	}

	public String dateLabel() {
		return dateLabel;
	}

	public void setDateLabel(String dateLabel) {
		this.dateLabel = dateLabel;
	}

	public String placeLabel() {
		return placeLabel;
	}

	public void setPlaceLabel(String placeLabel) {
		this.placeLabel = placeLabel;
	}

	public String startDateLabel() {
		return startDateLabel;
	}

	public void setStartDateLabel(String startDateLabel) {
		this.startDateLabel = startDateLabel;
	}

	public String endDateLabel() {
		return endDateLabel;
	}

	public void setEndDateLabel(String endDateLabel) {
		this.endDateLabel = endDateLabel;
	}
	
	public Integer time(Relation relation){
		Integer result;
		
		Value timeValue = RelationValuator.get(relation, dateLabel);
		if (timeValue!=null) {
			result = timeValue.intValue();
		} else {
			result = null;
		}
		//
		return result;
	}
	
	public Individuals members(){
		Individuals result;
		
		result = new Individuals();
		
		for (Slice slice : this){
			result.add(slice.members());
		}
		//
		return result;
	}
	

	
}
